/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance's Amazon EBS volume.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Volume implements SdkPojo, Serializable, ToCopyableBuilder<Volume.Builder, Volume> {
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeId").getter(getter(Volume::volumeId)).setter(setter(Builder::volumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()).build();

    private static final SdkField<String> EC2_VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ec2VolumeId").getter(getter(Volume::ec2VolumeId)).setter(setter(Builder::ec2VolumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2VolumeId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Volume::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> RAID_ARRAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RaidArrayId").getter(getter(Volume::raidArrayId)).setter(setter(Builder::raidArrayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RaidArrayId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(Volume::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Volume::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Integer> SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Size")
            .getter(getter(Volume::size)).setter(setter(Builder::size))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()).build();

    private static final SdkField<String> DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Device")
            .getter(getter(Volume::device)).setter(setter(Builder::device))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Device").build()).build();

    private static final SdkField<String> MOUNT_POINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MountPoint").getter(getter(Volume::mountPoint)).setter(setter(Builder::mountPoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MountPoint").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(Volume::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(Volume::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VolumeType").getter(getter(Volume::volumeType)).setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(Volume::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Encrypted").getter(getter(Volume::encrypted)).setter(setter(Builder::encrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_ID_FIELD,
            EC2_VOLUME_ID_FIELD, NAME_FIELD, RAID_ARRAY_ID_FIELD, INSTANCE_ID_FIELD, STATUS_FIELD, SIZE_FIELD, DEVICE_FIELD,
            MOUNT_POINT_FIELD, REGION_FIELD, AVAILABILITY_ZONE_FIELD, VOLUME_TYPE_FIELD, IOPS_FIELD, ENCRYPTED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String volumeId;

    private final String ec2VolumeId;

    private final String name;

    private final String raidArrayId;

    private final String instanceId;

    private final String status;

    private final Integer size;

    private final String device;

    private final String mountPoint;

    private final String region;

    private final String availabilityZone;

    private final String volumeType;

    private final Integer iops;

    private final Boolean encrypted;

    private Volume(BuilderImpl builder) {
        this.volumeId = builder.volumeId;
        this.ec2VolumeId = builder.ec2VolumeId;
        this.name = builder.name;
        this.raidArrayId = builder.raidArrayId;
        this.instanceId = builder.instanceId;
        this.status = builder.status;
        this.size = builder.size;
        this.device = builder.device;
        this.mountPoint = builder.mountPoint;
        this.region = builder.region;
        this.availabilityZone = builder.availabilityZone;
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
        this.encrypted = builder.encrypted;
    }

    /**
     * <p>
     * The volume ID.
     * </p>
     * 
     * @return The volume ID.
     */
    public String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * The Amazon EC2 volume ID.
     * </p>
     * 
     * @return The Amazon EC2 volume ID.
     */
    public String ec2VolumeId() {
        return ec2VolumeId;
    }

    /**
     * <p>
     * The volume name.
     * </p>
     * 
     * @return The volume name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The RAID array ID.
     * </p>
     * 
     * @return The RAID array ID.
     */
    public String raidArrayId() {
        return raidArrayId;
    }

    /**
     * <p>
     * The instance ID.
     * </p>
     * 
     * @return The instance ID.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The value returned by <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeVolumes.html"
     * >DescribeVolumes</a>.
     * </p>
     * 
     * @return The value returned by <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeVolumes.html"
     *         >DescribeVolumes</a>.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The volume size.
     * </p>
     * 
     * @return The volume size.
     */
    public Integer size() {
        return size;
    }

    /**
     * <p>
     * The device name.
     * </p>
     * 
     * @return The device name.
     */
    public String device() {
        return device;
    }

    /**
     * <p>
     * The volume mount point. For example, "/mnt/disk1".
     * </p>
     * 
     * @return The volume mount point. For example, "/mnt/disk1".
     */
    public String mountPoint() {
        return mountPoint;
    }

    /**
     * <p>
     * The AWS region. For more information about AWS regions, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     * </p>
     * 
     * @return The AWS region. For more information about AWS regions, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * The volume Availability Zone. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     * </p>
     * 
     * @return The volume Availability Zone. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The volume type. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html"> Amazon EBS Volume Types</a>.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of 1024
     * GiB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size of
     * 16384 GiB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a maximum
     * size of 16384 GiB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a
     * minimum size of 500 GiB and a maximum size of 16384 GiB.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384
     * GiB.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The volume type. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html"> Amazon EBS Volume
     *         Types</a>.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size
     *         of 1024 GiB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum
     *         size of 16384 GiB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a
     *         maximum size of 16384 GiB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have
     *         a minimum size of 500 GiB and a maximum size of 16384 GiB.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of
     *         16384 GiB.
     *         </p>
     *         </li>
     */
    public String volumeType() {
        return volumeType;
    }

    /**
     * <p>
     * For PIOPS volumes, the IOPS per disk.
     * </p>
     * 
     * @return For PIOPS volumes, the IOPS per disk.
     */
    public Integer iops() {
        return iops;
    }

    /**
     * <p>
     * Specifies whether an Amazon EBS volume is encrypted. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>.
     * </p>
     * 
     * @return Specifies whether an Amazon EBS volume is encrypted. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(ec2VolumeId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(raidArrayId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(size());
        hashCode = 31 * hashCode + Objects.hashCode(device());
        hashCode = 31 * hashCode + Objects.hashCode(mountPoint());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(encrypted());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume) obj;
        return Objects.equals(volumeId(), other.volumeId()) && Objects.equals(ec2VolumeId(), other.ec2VolumeId())
                && Objects.equals(name(), other.name()) && Objects.equals(raidArrayId(), other.raidArrayId())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(status(), other.status())
                && Objects.equals(size(), other.size()) && Objects.equals(device(), other.device())
                && Objects.equals(mountPoint(), other.mountPoint()) && Objects.equals(region(), other.region())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(volumeType(), other.volumeType()) && Objects.equals(iops(), other.iops())
                && Objects.equals(encrypted(), other.encrypted());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Volume").add("VolumeId", volumeId()).add("Ec2VolumeId", ec2VolumeId()).add("Name", name())
                .add("RaidArrayId", raidArrayId()).add("InstanceId", instanceId()).add("Status", status()).add("Size", size())
                .add("Device", device()).add("MountPoint", mountPoint()).add("Region", region())
                .add("AvailabilityZone", availabilityZone()).add("VolumeType", volumeType()).add("Iops", iops())
                .add("Encrypted", encrypted()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeId":
            return Optional.ofNullable(clazz.cast(volumeId()));
        case "Ec2VolumeId":
            return Optional.ofNullable(clazz.cast(ec2VolumeId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RaidArrayId":
            return Optional.ofNullable(clazz.cast(raidArrayId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Size":
            return Optional.ofNullable(clazz.cast(size()));
        case "Device":
            return Optional.ofNullable(clazz.cast(device()));
        case "MountPoint":
            return Optional.ofNullable(clazz.cast(mountPoint()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeType()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "Encrypted":
            return Optional.ofNullable(clazz.cast(encrypted()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Volume, T> g) {
        return obj -> g.apply((Volume) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Volume> {
        /**
         * <p>
         * The volume ID.
         * </p>
         * 
         * @param volumeId
         *        The volume ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * The Amazon EC2 volume ID.
         * </p>
         * 
         * @param ec2VolumeId
         *        The Amazon EC2 volume ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2VolumeId(String ec2VolumeId);

        /**
         * <p>
         * The volume name.
         * </p>
         * 
         * @param name
         *        The volume name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The RAID array ID.
         * </p>
         * 
         * @param raidArrayId
         *        The RAID array ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder raidArrayId(String raidArrayId);

        /**
         * <p>
         * The instance ID.
         * </p>
         * 
         * @param instanceId
         *        The instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The value returned by <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeVolumes.html"
         * >DescribeVolumes</a>.
         * </p>
         * 
         * @param status
         *        The value returned by <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/APIReference/ApiReference-query-DescribeVolumes.html"
         *        >DescribeVolumes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The volume size.
         * </p>
         * 
         * @param size
         *        The volume size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * The device name.
         * </p>
         * 
         * @param device
         *        The device name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(String device);

        /**
         * <p>
         * The volume mount point. For example, "/mnt/disk1".
         * </p>
         * 
         * @param mountPoint
         *        The volume mount point. For example, "/mnt/disk1".
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mountPoint(String mountPoint);

        /**
         * <p>
         * The AWS region. For more information about AWS regions, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * </p>
         * 
         * @param region
         *        The AWS region. For more information about AWS regions, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The volume Availability Zone. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * </p>
         * 
         * @param availabilityZone
         *        The volume Availability Zone. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The volume type. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html"> Amazon EBS Volume Types</a>.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum size of
         * 1024 GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a maximum size
         * of 16384 GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB and a
         * maximum size of 16384 GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must have a
         * minimum size of 500 GiB and a maximum size of 16384 GiB.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size of 16384
         * GiB.
         * </p>
         * </li>
         * </ul>
         * 
         * @param volumeType
         *        The volume type. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html"> Amazon EBS Volume
         *        Types</a>.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>standard</code> - Magnetic. Magnetic volumes must have a minimum size of 1 GiB and a maximum
         *        size of 1024 GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>io1</code> - Provisioned IOPS (SSD). PIOPS volumes must have a minimum size of 4 GiB and a
         *        maximum size of 16384 GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>gp2</code> - General Purpose (SSD). General purpose volumes must have a minimum size of 1 GiB
         *        and a maximum size of 16384 GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>st1</code> - Throughput Optimized hard disk drive (HDD). Throughput optimized HDD volumes must
         *        have a minimum size of 500 GiB and a maximum size of 16384 GiB.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>sc1</code> - Cold HDD. Cold HDD volumes must have a minimum size of 500 GiB and a maximum size
         *        of 16384 GiB.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * For PIOPS volumes, the IOPS per disk.
         * </p>
         * 
         * @param iops
         *        For PIOPS volumes, the IOPS per disk.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * Specifies whether an Amazon EBS volume is encrypted. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>.
         * </p>
         * 
         * @param encrypted
         *        Specifies whether an Amazon EBS volume is encrypted. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS
         *        Encryption</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);
    }

    static final class BuilderImpl implements Builder {
        private String volumeId;

        private String ec2VolumeId;

        private String name;

        private String raidArrayId;

        private String instanceId;

        private String status;

        private Integer size;

        private String device;

        private String mountPoint;

        private String region;

        private String availabilityZone;

        private String volumeType;

        private Integer iops;

        private Boolean encrypted;

        private BuilderImpl() {
        }

        private BuilderImpl(Volume model) {
            volumeId(model.volumeId);
            ec2VolumeId(model.ec2VolumeId);
            name(model.name);
            raidArrayId(model.raidArrayId);
            instanceId(model.instanceId);
            status(model.status);
            size(model.size);
            device(model.device);
            mountPoint(model.mountPoint);
            region(model.region);
            availabilityZone(model.availabilityZone);
            volumeType(model.volumeType);
            iops(model.iops);
            encrypted(model.encrypted);
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final String getEc2VolumeId() {
            return ec2VolumeId;
        }

        @Override
        public final Builder ec2VolumeId(String ec2VolumeId) {
            this.ec2VolumeId = ec2VolumeId;
            return this;
        }

        public final void setEc2VolumeId(String ec2VolumeId) {
            this.ec2VolumeId = ec2VolumeId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRaidArrayId() {
            return raidArrayId;
        }

        @Override
        public final Builder raidArrayId(String raidArrayId) {
            this.raidArrayId = raidArrayId;
            return this;
        }

        public final void setRaidArrayId(String raidArrayId) {
            this.raidArrayId = raidArrayId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Integer getSize() {
            return size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getDevice() {
            return device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        public final String getMountPoint() {
            return mountPoint;
        }

        @Override
        public final Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public final void setMountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        public Volume build() {
            return new Volume(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
