/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.services.opsworks.model.ServiceError;
import software.amazon.awssdk.services.opsworks.model.ServiceErrorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServiceErrorsResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeServiceErrorsResponse> {
    private static final SdkField<List<ServiceError>> SERVICE_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceErrors").getter(DescribeServiceErrorsResponse.getter(DescribeServiceErrorsResponse::serviceErrors)).setter(DescribeServiceErrorsResponse.setter(Builder::serviceErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ERRORS_FIELD));
    private final List<ServiceError> serviceErrors;

    private DescribeServiceErrorsResponse(BuilderImpl builder) {
        super(builder);
        this.serviceErrors = builder.serviceErrors;
    }

    public boolean hasServiceErrors() {
        return this.serviceErrors != null && !(this.serviceErrors instanceof SdkAutoConstructList);
    }

    public List<ServiceError> serviceErrors() {
        return this.serviceErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceErrors() ? this.serviceErrors() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceErrorsResponse)) {
            return false;
        }
        DescribeServiceErrorsResponse other = (DescribeServiceErrorsResponse)((Object)obj);
        return this.hasServiceErrors() == other.hasServiceErrors() && Objects.equals(this.serviceErrors(), other.serviceErrors());
    }

    public String toString() {
        return ToString.builder((String)"DescribeServiceErrorsResponse").add("ServiceErrors", this.hasServiceErrors() ? this.serviceErrors() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceErrors": {
                return Optional.ofNullable(clazz.cast(this.serviceErrors()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceErrorsResponse, T> g) {
        return obj -> g.apply((DescribeServiceErrorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<ServiceError> serviceErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceErrorsResponse model) {
            super(model);
            this.serviceErrors(model.serviceErrors);
        }

        public final Collection<ServiceError.Builder> getServiceErrors() {
            if (this.serviceErrors instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceErrors != null ? (Collection)this.serviceErrors.stream().map(ServiceError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceErrors(Collection<ServiceError> serviceErrors) {
            this.serviceErrors = ServiceErrorsCopier.copy(serviceErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceErrors(ServiceError ... serviceErrors) {
            this.serviceErrors(Arrays.asList(serviceErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceErrors(Consumer<ServiceError.Builder> ... serviceErrors) {
            this.serviceErrors(Stream.of(serviceErrors).map(c -> (ServiceError)((ServiceError.Builder)ServiceError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServiceErrors(Collection<ServiceError.BuilderImpl> serviceErrors) {
            this.serviceErrors = ServiceErrorsCopier.copyFromBuilder(serviceErrors);
        }

        @Override
        public DescribeServiceErrorsResponse build() {
            return new DescribeServiceErrorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServiceErrorsResponse> {
        public Builder serviceErrors(Collection<ServiceError> var1);

        public Builder serviceErrors(ServiceError ... var1);

        public Builder serviceErrors(Consumer<ServiceError.Builder> ... var1);
    }
}

