/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains a description of an Amazon EC2 instance from the Amazon EC2 metadata service. For more information, see <a
 * href="https://docs.aws.amazon.com/sdkfornet/latest/apidocs/Index.html">Instance Metadata and User Data</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceIdentity implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceIdentity.Builder, InstanceIdentity> {
    private static final SdkField<String> DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Document").getter(getter(InstanceIdentity::document)).setter(setter(Builder::document))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Document").build()).build();

    private static final SdkField<String> SIGNATURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Signature").getter(getter(InstanceIdentity::signature)).setter(setter(Builder::signature))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Signature").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_FIELD,
            SIGNATURE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String document;

    private final String signature;

    private InstanceIdentity(BuilderImpl builder) {
        this.document = builder.document;
        this.signature = builder.signature;
    }

    /**
     * <p>
     * A JSON document that contains the metadata.
     * </p>
     * 
     * @return A JSON document that contains the metadata.
     */
    public String document() {
        return document;
    }

    /**
     * <p>
     * A signature that can be used to verify the document's accuracy and authenticity.
     * </p>
     * 
     * @return A signature that can be used to verify the document's accuracy and authenticity.
     */
    public String signature() {
        return signature;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(document());
        hashCode = 31 * hashCode + Objects.hashCode(signature());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceIdentity)) {
            return false;
        }
        InstanceIdentity other = (InstanceIdentity) obj;
        return Objects.equals(document(), other.document()) && Objects.equals(signature(), other.signature());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InstanceIdentity").add("Document", document()).add("Signature", signature()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Document":
            return Optional.ofNullable(clazz.cast(document()));
        case "Signature":
            return Optional.ofNullable(clazz.cast(signature()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceIdentity, T> g) {
        return obj -> g.apply((InstanceIdentity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceIdentity> {
        /**
         * <p>
         * A JSON document that contains the metadata.
         * </p>
         * 
         * @param document
         *        A JSON document that contains the metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder document(String document);

        /**
         * <p>
         * A signature that can be used to verify the document's accuracy and authenticity.
         * </p>
         * 
         * @param signature
         *        A signature that can be used to verify the document's accuracy and authenticity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signature(String signature);
    }

    static final class BuilderImpl implements Builder {
        private String document;

        private String signature;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceIdentity model) {
            document(model.document);
            signature(model.signature);
        }

        public final String getDocument() {
            return document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        public final String getSignature() {
            return signature;
        }

        @Override
        public final Builder signature(String signature) {
            this.signature = signature;
            return this;
        }

        public final void setSignature(String signature) {
            this.signature = signature;
        }

        @Override
        public InstanceIdentity build() {
            return new InstanceIdentity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
