/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAppsRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeAppsRequest.Builder, DescribeAppsRequest> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackId").getter(getter(DescribeAppsRequest::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<List<String>> APP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AppIds")
            .getter(getter(DescribeAppsRequest::appIds))
            .setter(setter(Builder::appIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(STACK_ID_FIELD, APP_IDS_FIELD));

    private final String stackId;

    private final List<String> appIds;

    private DescribeAppsRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.appIds = builder.appIds;
    }

    /**
     * <p>
     * The app stack ID. If you use this parameter, <code>DescribeApps</code> returns a description of the apps in the
     * specified stack.
     * </p>
     * 
     * @return The app stack ID. If you use this parameter, <code>DescribeApps</code> returns a description of the apps
     *         in the specified stack.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * Returns true if the AppIds property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAppIds() {
        return appIds != null && !(appIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code> returns a
     * description of the specified apps. Otherwise, it returns a description of every app.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAppIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code>
     *         returns a description of the specified apps. Otherwise, it returns a description of every app.
     */
    public List<String> appIds() {
        return appIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAppIds() ? appIds() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppsRequest)) {
            return false;
        }
        DescribeAppsRequest other = (DescribeAppsRequest) obj;
        return Objects.equals(stackId(), other.stackId()) && hasAppIds() == other.hasAppIds()
                && Objects.equals(appIds(), other.appIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAppsRequest").add("StackId", stackId()).add("AppIds", hasAppIds() ? appIds() : null)
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "AppIds":
            return Optional.ofNullable(clazz.cast(appIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppsRequest, T> g) {
        return obj -> g.apply((DescribeAppsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAppsRequest> {
        /**
         * <p>
         * The app stack ID. If you use this parameter, <code>DescribeApps</code> returns a description of the apps in
         * the specified stack.
         * </p>
         * 
         * @param stackId
         *        The app stack ID. If you use this parameter, <code>DescribeApps</code> returns a description of the
         *        apps in the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code>
         * returns a description of the specified apps. Otherwise, it returns a description of every app.
         * </p>
         * 
         * @param appIds
         *        An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code>
         *        returns a description of the specified apps. Otherwise, it returns a description of every app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appIds(Collection<String> appIds);

        /**
         * <p>
         * An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code>
         * returns a description of the specified apps. Otherwise, it returns a description of every app.
         * </p>
         * 
         * @param appIds
         *        An array of app IDs for the apps to be described. If you use this parameter, <code>DescribeApps</code>
         *        returns a description of the specified apps. Otherwise, it returns a description of every app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appIds(String... appIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String stackId;

        private List<String> appIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppsRequest model) {
            super(model);
            stackId(model.stackId);
            appIds(model.appIds);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getAppIds() {
            if (appIds instanceof SdkAutoConstructList) {
                return null;
            }
            return appIds;
        }

        @Override
        public final Builder appIds(Collection<String> appIds) {
            this.appIds = StringsCopier.copy(appIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appIds(String... appIds) {
            appIds(Arrays.asList(appIds));
            return this;
        }

        public final void setAppIds(Collection<String> appIds) {
            this.appIds = StringsCopier.copy(appIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAppsRequest build() {
            return new DescribeAppsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
