/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.AgentVersion;
import software.amazon.awssdk.services.opsworks.model.AgentVersionsCopier;
import software.amazon.awssdk.services.opsworks.model.OpsWorksResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAgentVersionsResponse
extends OpsWorksResponse
implements ToCopyableBuilder<Builder, DescribeAgentVersionsResponse> {
    private static final SdkField<List<AgentVersion>> AGENT_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AgentVersions").getter(DescribeAgentVersionsResponse.getter(DescribeAgentVersionsResponse::agentVersions)).setter(DescribeAgentVersionsResponse.setter(Builder::agentVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AgentVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_VERSIONS_FIELD));
    private final List<AgentVersion> agentVersions;

    private DescribeAgentVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.agentVersions = builder.agentVersions;
    }

    public boolean hasAgentVersions() {
        return this.agentVersions != null && !(this.agentVersions instanceof SdkAutoConstructList);
    }

    public List<AgentVersion> agentVersions() {
        return this.agentVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAgentVersions() ? this.agentVersions() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgentVersionsResponse)) {
            return false;
        }
        DescribeAgentVersionsResponse other = (DescribeAgentVersionsResponse)((Object)obj);
        return this.hasAgentVersions() == other.hasAgentVersions() && Objects.equals(this.agentVersions(), other.agentVersions());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAgentVersionsResponse").add("AgentVersions", this.hasAgentVersions() ? this.agentVersions() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AgentVersions": {
                return Optional.ofNullable(clazz.cast(this.agentVersions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAgentVersionsResponse, T> g) {
        return obj -> g.apply((DescribeAgentVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksResponse.BuilderImpl
    implements Builder {
        private List<AgentVersion> agentVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgentVersionsResponse model) {
            super(model);
            this.agentVersions(model.agentVersions);
        }

        public final Collection<AgentVersion.Builder> getAgentVersions() {
            if (this.agentVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.agentVersions != null ? (Collection)this.agentVersions.stream().map(AgentVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder agentVersions(Collection<AgentVersion> agentVersions) {
            this.agentVersions = AgentVersionsCopier.copy(agentVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentVersions(AgentVersion ... agentVersions) {
            this.agentVersions(Arrays.asList(agentVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentVersions(Consumer<AgentVersion.Builder> ... agentVersions) {
            this.agentVersions(Stream.of(agentVersions).map(c -> (AgentVersion)((AgentVersion.Builder)AgentVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAgentVersions(Collection<AgentVersion.BuilderImpl> agentVersions) {
            this.agentVersions = AgentVersionsCopier.copyFromBuilder(agentVersions);
        }

        @Override
        public DescribeAgentVersionsResponse build() {
            return new DescribeAgentVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAgentVersionsResponse> {
        public Builder agentVersions(Collection<AgentVersion> var1);

        public Builder agentVersions(AgentVersion ... var1);

        public Builder agentVersions(Consumer<AgentVersion.Builder> ... var1);
    }
}

