/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SetLoadBasedAutoScalingRequest extends OpsWorksRequest implements
        ToCopyableBuilder<SetLoadBasedAutoScalingRequest.Builder, SetLoadBasedAutoScalingRequest> {
    private static final SdkField<String> LAYER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LayerId").getter(getter(SetLoadBasedAutoScalingRequest::layerId)).setter(setter(Builder::layerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerId").build()).build();

    private static final SdkField<Boolean> ENABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enable").getter(getter(SetLoadBasedAutoScalingRequest::enable)).setter(setter(Builder::enable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enable").build()).build();

    private static final SdkField<AutoScalingThresholds> UP_SCALING_FIELD = SdkField
            .<AutoScalingThresholds> builder(MarshallingType.SDK_POJO).memberName("UpScaling")
            .getter(getter(SetLoadBasedAutoScalingRequest::upScaling)).setter(setter(Builder::upScaling))
            .constructor(AutoScalingThresholds::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpScaling").build()).build();

    private static final SdkField<AutoScalingThresholds> DOWN_SCALING_FIELD = SdkField
            .<AutoScalingThresholds> builder(MarshallingType.SDK_POJO).memberName("DownScaling")
            .getter(getter(SetLoadBasedAutoScalingRequest::downScaling)).setter(setter(Builder::downScaling))
            .constructor(AutoScalingThresholds::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DownScaling").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_ID_FIELD, ENABLE_FIELD,
            UP_SCALING_FIELD, DOWN_SCALING_FIELD));

    private final String layerId;

    private final Boolean enable;

    private final AutoScalingThresholds upScaling;

    private final AutoScalingThresholds downScaling;

    private SetLoadBasedAutoScalingRequest(BuilderImpl builder) {
        super(builder);
        this.layerId = builder.layerId;
        this.enable = builder.enable;
        this.upScaling = builder.upScaling;
        this.downScaling = builder.downScaling;
    }

    /**
     * <p>
     * The layer ID.
     * </p>
     * 
     * @return The layer ID.
     */
    public String layerId() {
        return layerId;
    }

    /**
     * <p>
     * Enables load-based auto scaling for the layer.
     * </p>
     * 
     * @return Enables load-based auto scaling for the layer.
     */
    public Boolean enable() {
        return enable;
    }

    /**
     * <p>
     * An <code>AutoScalingThresholds</code> object with the upscaling threshold configuration. If the load exceeds
     * these thresholds for a specified amount of time, AWS OpsWorks Stacks starts a specified number of instances.
     * </p>
     * 
     * @return An <code>AutoScalingThresholds</code> object with the upscaling threshold configuration. If the load
     *         exceeds these thresholds for a specified amount of time, AWS OpsWorks Stacks starts a specified number of
     *         instances.
     */
    public AutoScalingThresholds upScaling() {
        return upScaling;
    }

    /**
     * <p>
     * An <code>AutoScalingThresholds</code> object with the downscaling threshold configuration. If the load falls
     * below these thresholds for a specified amount of time, AWS OpsWorks Stacks stops a specified number of instances.
     * </p>
     * 
     * @return An <code>AutoScalingThresholds</code> object with the downscaling threshold configuration. If the load
     *         falls below these thresholds for a specified amount of time, AWS OpsWorks Stacks stops a specified number
     *         of instances.
     */
    public AutoScalingThresholds downScaling() {
        return downScaling;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(layerId());
        hashCode = 31 * hashCode + Objects.hashCode(enable());
        hashCode = 31 * hashCode + Objects.hashCode(upScaling());
        hashCode = 31 * hashCode + Objects.hashCode(downScaling());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetLoadBasedAutoScalingRequest)) {
            return false;
        }
        SetLoadBasedAutoScalingRequest other = (SetLoadBasedAutoScalingRequest) obj;
        return Objects.equals(layerId(), other.layerId()) && Objects.equals(enable(), other.enable())
                && Objects.equals(upScaling(), other.upScaling()) && Objects.equals(downScaling(), other.downScaling());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SetLoadBasedAutoScalingRequest").add("LayerId", layerId()).add("Enable", enable())
                .add("UpScaling", upScaling()).add("DownScaling", downScaling()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LayerId":
            return Optional.ofNullable(clazz.cast(layerId()));
        case "Enable":
            return Optional.ofNullable(clazz.cast(enable()));
        case "UpScaling":
            return Optional.ofNullable(clazz.cast(upScaling()));
        case "DownScaling":
            return Optional.ofNullable(clazz.cast(downScaling()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetLoadBasedAutoScalingRequest, T> g) {
        return obj -> g.apply((SetLoadBasedAutoScalingRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, SetLoadBasedAutoScalingRequest> {
        /**
         * <p>
         * The layer ID.
         * </p>
         * 
         * @param layerId
         *        The layer ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerId(String layerId);

        /**
         * <p>
         * Enables load-based auto scaling for the layer.
         * </p>
         * 
         * @param enable
         *        Enables load-based auto scaling for the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enable(Boolean enable);

        /**
         * <p>
         * An <code>AutoScalingThresholds</code> object with the upscaling threshold configuration. If the load exceeds
         * these thresholds for a specified amount of time, AWS OpsWorks Stacks starts a specified number of instances.
         * </p>
         * 
         * @param upScaling
         *        An <code>AutoScalingThresholds</code> object with the upscaling threshold configuration. If the load
         *        exceeds these thresholds for a specified amount of time, AWS OpsWorks Stacks starts a specified number
         *        of instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upScaling(AutoScalingThresholds upScaling);

        /**
         * <p>
         * An <code>AutoScalingThresholds</code> object with the upscaling threshold configuration. If the load exceeds
         * these thresholds for a specified amount of time, AWS OpsWorks Stacks starts a specified number of instances.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoScalingThresholds.Builder} avoiding the need
         * to create one manually via {@link AutoScalingThresholds#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingThresholds.Builder#build()} is called immediately and
         * its result is passed to {@link #upScaling(AutoScalingThresholds)}.
         * 
         * @param upScaling
         *        a consumer that will call methods on {@link AutoScalingThresholds.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #upScaling(AutoScalingThresholds)
         */
        default Builder upScaling(Consumer<AutoScalingThresholds.Builder> upScaling) {
            return upScaling(AutoScalingThresholds.builder().applyMutation(upScaling).build());
        }

        /**
         * <p>
         * An <code>AutoScalingThresholds</code> object with the downscaling threshold configuration. If the load falls
         * below these thresholds for a specified amount of time, AWS OpsWorks Stacks stops a specified number of
         * instances.
         * </p>
         * 
         * @param downScaling
         *        An <code>AutoScalingThresholds</code> object with the downscaling threshold configuration. If the load
         *        falls below these thresholds for a specified amount of time, AWS OpsWorks Stacks stops a specified
         *        number of instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder downScaling(AutoScalingThresholds downScaling);

        /**
         * <p>
         * An <code>AutoScalingThresholds</code> object with the downscaling threshold configuration. If the load falls
         * below these thresholds for a specified amount of time, AWS OpsWorks Stacks stops a specified number of
         * instances.
         * </p>
         * This is a convenience that creates an instance of the {@link AutoScalingThresholds.Builder} avoiding the need
         * to create one manually via {@link AutoScalingThresholds#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutoScalingThresholds.Builder#build()} is called immediately and
         * its result is passed to {@link #downScaling(AutoScalingThresholds)}.
         * 
         * @param downScaling
         *        a consumer that will call methods on {@link AutoScalingThresholds.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #downScaling(AutoScalingThresholds)
         */
        default Builder downScaling(Consumer<AutoScalingThresholds.Builder> downScaling) {
            return downScaling(AutoScalingThresholds.builder().applyMutation(downScaling).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String layerId;

        private Boolean enable;

        private AutoScalingThresholds upScaling;

        private AutoScalingThresholds downScaling;

        private BuilderImpl() {
        }

        private BuilderImpl(SetLoadBasedAutoScalingRequest model) {
            super(model);
            layerId(model.layerId);
            enable(model.enable);
            upScaling(model.upScaling);
            downScaling(model.downScaling);
        }

        public final String getLayerId() {
            return layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        public final Boolean getEnable() {
            return enable;
        }

        @Override
        public final Builder enable(Boolean enable) {
            this.enable = enable;
            return this;
        }

        public final void setEnable(Boolean enable) {
            this.enable = enable;
        }

        public final AutoScalingThresholds.Builder getUpScaling() {
            return upScaling != null ? upScaling.toBuilder() : null;
        }

        @Override
        public final Builder upScaling(AutoScalingThresholds upScaling) {
            this.upScaling = upScaling;
            return this;
        }

        public final void setUpScaling(AutoScalingThresholds.BuilderImpl upScaling) {
            this.upScaling = upScaling != null ? upScaling.build() : null;
        }

        public final AutoScalingThresholds.Builder getDownScaling() {
            return downScaling != null ? downScaling.toBuilder() : null;
        }

        @Override
        public final Builder downScaling(AutoScalingThresholds downScaling) {
            this.downScaling = downScaling;
            return this;
        }

        public final void setDownScaling(AutoScalingThresholds.BuilderImpl downScaling) {
            this.downScaling = downScaling != null ? downScaling.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetLoadBasedAutoScalingRequest build() {
            return new SetLoadBasedAutoScalingRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
