/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.CloudWatchLogsLogStream;
import software.amazon.awssdk.services.opsworks.model.CloudWatchLogsLogStreamsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudWatchLogsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudWatchLogsConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Enabled").getter(CloudWatchLogsConfiguration.getter(CloudWatchLogsConfiguration::enabled)).setter(CloudWatchLogsConfiguration.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()}).build();
    private static final SdkField<List<CloudWatchLogsLogStream>> LOG_STREAMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LogStreams").getter(CloudWatchLogsConfiguration.getter(CloudWatchLogsConfiguration::logStreams)).setter(CloudWatchLogsConfiguration.setter(Builder::logStreams)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStreams").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CloudWatchLogsLogStream::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, LOG_STREAMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean enabled;
    private final List<CloudWatchLogsLogStream> logStreams;

    private CloudWatchLogsConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.logStreams = builder.logStreams;
    }

    public Boolean enabled() {
        return this.enabled;
    }

    public boolean hasLogStreams() {
        return this.logStreams != null && !(this.logStreams instanceof SdkAutoConstructList);
    }

    public List<CloudWatchLogsLogStream> logStreams() {
        return this.logStreams;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogStreams() ? this.logStreams() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogsConfiguration)) {
            return false;
        }
        CloudWatchLogsConfiguration other = (CloudWatchLogsConfiguration)obj;
        return Objects.equals(this.enabled(), other.enabled()) && this.hasLogStreams() == other.hasLogStreams() && Objects.equals(this.logStreams(), other.logStreams());
    }

    public String toString() {
        return ToString.builder((String)"CloudWatchLogsConfiguration").add("Enabled", (Object)this.enabled()).add("LogStreams", this.hasLogStreams() ? this.logStreams() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Enabled": {
                return Optional.ofNullable(clazz.cast(this.enabled()));
            }
            case "LogStreams": {
                return Optional.ofNullable(clazz.cast(this.logStreams()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLogsConfiguration, T> g) {
        return obj -> g.apply((CloudWatchLogsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean enabled;
        private List<CloudWatchLogsLogStream> logStreams = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogsConfiguration model) {
            this.enabled(model.enabled);
            this.logStreams(model.logStreams);
        }

        public final Boolean getEnabled() {
            return this.enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Collection<CloudWatchLogsLogStream.Builder> getLogStreams() {
            if (this.logStreams instanceof SdkAutoConstructList) {
                return null;
            }
            return this.logStreams != null ? (Collection)this.logStreams.stream().map(CloudWatchLogsLogStream::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder logStreams(Collection<CloudWatchLogsLogStream> logStreams) {
            this.logStreams = CloudWatchLogsLogStreamsCopier.copy(logStreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreams(CloudWatchLogsLogStream ... logStreams) {
            this.logStreams(Arrays.asList(logStreams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreams(Consumer<CloudWatchLogsLogStream.Builder> ... logStreams) {
            this.logStreams(Stream.of(logStreams).map(c -> (CloudWatchLogsLogStream)((CloudWatchLogsLogStream.Builder)CloudWatchLogsLogStream.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLogStreams(Collection<CloudWatchLogsLogStream.BuilderImpl> logStreams) {
            this.logStreams = CloudWatchLogsLogStreamsCopier.copyFromBuilder(logStreams);
        }

        public CloudWatchLogsConfiguration build() {
            return new CloudWatchLogsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudWatchLogsConfiguration> {
        public Builder enabled(Boolean var1);

        public Builder logStreams(Collection<CloudWatchLogsLogStream> var1);

        public Builder logStreams(CloudWatchLogsLogStream ... var1);

        public Builder logStreams(Consumer<CloudWatchLogsLogStream.Builder> ... var1);
    }
}

