/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a user's SSH information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SelfUserProfile implements SdkPojo, Serializable, ToCopyableBuilder<SelfUserProfile.Builder, SelfUserProfile> {
    private static final SdkField<String> IAM_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamUserArn").getter(getter(SelfUserProfile::iamUserArn)).setter(setter(Builder::iamUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamUserArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SelfUserProfile::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SSH_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SshUsername").getter(getter(SelfUserProfile::sshUsername)).setter(setter(Builder::sshUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshUsername").build()).build();

    private static final SdkField<String> SSH_PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SshPublicKey").getter(getter(SelfUserProfile::sshPublicKey)).setter(setter(Builder::sshPublicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshPublicKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_USER_ARN_FIELD,
            NAME_FIELD, SSH_USERNAME_FIELD, SSH_PUBLIC_KEY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String iamUserArn;

    private final String name;

    private final String sshUsername;

    private final String sshPublicKey;

    private SelfUserProfile(BuilderImpl builder) {
        this.iamUserArn = builder.iamUserArn;
        this.name = builder.name;
        this.sshUsername = builder.sshUsername;
        this.sshPublicKey = builder.sshPublicKey;
    }

    /**
     * <p>
     * The user's IAM ARN.
     * </p>
     * 
     * @return The user's IAM ARN.
     */
    public final String iamUserArn() {
        return iamUserArn;
    }

    /**
     * <p>
     * The user's name.
     * </p>
     * 
     * @return The user's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The user's SSH user name.
     * </p>
     * 
     * @return The user's SSH user name.
     */
    public final String sshUsername() {
        return sshUsername;
    }

    /**
     * <p>
     * The user's SSH public key.
     * </p>
     * 
     * @return The user's SSH public key.
     */
    public final String sshPublicKey() {
        return sshPublicKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(sshUsername());
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SelfUserProfile)) {
            return false;
        }
        SelfUserProfile other = (SelfUserProfile) obj;
        return Objects.equals(iamUserArn(), other.iamUserArn()) && Objects.equals(name(), other.name())
                && Objects.equals(sshUsername(), other.sshUsername()) && Objects.equals(sshPublicKey(), other.sshPublicKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SelfUserProfile").add("IamUserArn", iamUserArn()).add("Name", name())
                .add("SshUsername", sshUsername()).add("SshPublicKey", sshPublicKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamUserArn":
            return Optional.ofNullable(clazz.cast(iamUserArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "SshUsername":
            return Optional.ofNullable(clazz.cast(sshUsername()));
        case "SshPublicKey":
            return Optional.ofNullable(clazz.cast(sshPublicKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SelfUserProfile, T> g) {
        return obj -> g.apply((SelfUserProfile) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SelfUserProfile> {
        /**
         * <p>
         * The user's IAM ARN.
         * </p>
         * 
         * @param iamUserArn
         *        The user's IAM ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArn(String iamUserArn);

        /**
         * <p>
         * The user's name.
         * </p>
         * 
         * @param name
         *        The user's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The user's SSH user name.
         * </p>
         * 
         * @param sshUsername
         *        The user's SSH user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshUsername(String sshUsername);

        /**
         * <p>
         * The user's SSH public key.
         * </p>
         * 
         * @param sshPublicKey
         *        The user's SSH public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKey(String sshPublicKey);
    }

    static final class BuilderImpl implements Builder {
        private String iamUserArn;

        private String name;

        private String sshUsername;

        private String sshPublicKey;

        private BuilderImpl() {
        }

        private BuilderImpl(SelfUserProfile model) {
            iamUserArn(model.iamUserArn);
            name(model.name);
            sshUsername(model.sshUsername);
            sshPublicKey(model.sshPublicKey);
        }

        public final String getIamUserArn() {
            return iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getSshUsername() {
            return sshUsername;
        }

        @Override
        public final Builder sshUsername(String sshUsername) {
            this.sshUsername = sshUsername;
            return this;
        }

        public final void setSshUsername(String sshUsername) {
            this.sshUsername = sshUsername;
        }

        public final String getSshPublicKey() {
            return sshPublicKey;
        }

        @Override
        public final Builder sshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(String sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
        }

        @Override
        public SelfUserProfile build() {
            return new SelfUserProfile(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
