/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an app's SSL configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SslConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SslConfiguration.Builder, SslConfiguration> {
    private static final SdkField<String> CERTIFICATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Certificate").getter(getter(SslConfiguration::certificate)).setter(setter(Builder::certificate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Certificate").build()).build();

    private static final SdkField<String> PRIVATE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateKey").getter(getter(SslConfiguration::privateKey)).setter(setter(Builder::privateKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKey").build()).build();

    private static final SdkField<String> CHAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Chain")
            .getter(getter(SslConfiguration::chain)).setter(setter(Builder::chain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Chain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_FIELD,
            PRIVATE_KEY_FIELD, CHAIN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String certificate;

    private final String privateKey;

    private final String chain;

    private SslConfiguration(BuilderImpl builder) {
        this.certificate = builder.certificate;
        this.privateKey = builder.privateKey;
        this.chain = builder.chain;
    }

    /**
     * <p>
     * The contents of the certificate's domain.crt file.
     * </p>
     * 
     * @return The contents of the certificate's domain.crt file.
     */
    public final String certificate() {
        return certificate;
    }

    /**
     * <p>
     * The private key; the contents of the certificate's domain.kex file.
     * </p>
     * 
     * @return The private key; the contents of the certificate's domain.kex file.
     */
    public final String privateKey() {
        return privateKey;
    }

    /**
     * <p>
     * Optional. Can be used to specify an intermediate certificate authority key or client authentication.
     * </p>
     * 
     * @return Optional. Can be used to specify an intermediate certificate authority key or client authentication.
     */
    public final String chain() {
        return chain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificate());
        hashCode = 31 * hashCode + Objects.hashCode(privateKey());
        hashCode = 31 * hashCode + Objects.hashCode(chain());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SslConfiguration)) {
            return false;
        }
        SslConfiguration other = (SslConfiguration) obj;
        return Objects.equals(certificate(), other.certificate()) && Objects.equals(privateKey(), other.privateKey())
                && Objects.equals(chain(), other.chain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SslConfiguration").add("Certificate", certificate()).add("PrivateKey", privateKey())
                .add("Chain", chain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Certificate":
            return Optional.ofNullable(clazz.cast(certificate()));
        case "PrivateKey":
            return Optional.ofNullable(clazz.cast(privateKey()));
        case "Chain":
            return Optional.ofNullable(clazz.cast(chain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SslConfiguration, T> g) {
        return obj -> g.apply((SslConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SslConfiguration> {
        /**
         * <p>
         * The contents of the certificate's domain.crt file.
         * </p>
         * 
         * @param certificate
         *        The contents of the certificate's domain.crt file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificate(String certificate);

        /**
         * <p>
         * The private key; the contents of the certificate's domain.kex file.
         * </p>
         * 
         * @param privateKey
         *        The private key; the contents of the certificate's domain.kex file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKey(String privateKey);

        /**
         * <p>
         * Optional. Can be used to specify an intermediate certificate authority key or client authentication.
         * </p>
         * 
         * @param chain
         *        Optional. Can be used to specify an intermediate certificate authority key or client authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chain(String chain);
    }

    static final class BuilderImpl implements Builder {
        private String certificate;

        private String privateKey;

        private String chain;

        private BuilderImpl() {
        }

        private BuilderImpl(SslConfiguration model) {
            certificate(model.certificate);
            privateKey(model.privateKey);
            chain(model.chain);
        }

        public final String getCertificate() {
            return certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public final String getPrivateKey() {
            return privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public final String getChain() {
            return chain;
        }

        @Override
        public final Builder chain(String chain) {
            this.chain = chain;
            return this;
        }

        public final void setChain(String chain) {
            this.chain = chain;
        }

        @Override
        public SslConfiguration build() {
            return new SslConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
