/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ChefConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ChefConfiguration> {
    private static final SdkField<Boolean> MANAGE_BERKSHELF_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ManageBerkshelf").getter(ChefConfiguration.getter(ChefConfiguration::manageBerkshelf)).setter(ChefConfiguration.setter(Builder::manageBerkshelf)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManageBerkshelf").build()}).build();
    private static final SdkField<String> BERKSHELF_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BerkshelfVersion").getter(ChefConfiguration.getter(ChefConfiguration::berkshelfVersion)).setter(ChefConfiguration.setter(Builder::berkshelfVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BerkshelfVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANAGE_BERKSHELF_FIELD, BERKSHELF_VERSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean manageBerkshelf;
    private final String berkshelfVersion;

    private ChefConfiguration(BuilderImpl builder) {
        this.manageBerkshelf = builder.manageBerkshelf;
        this.berkshelfVersion = builder.berkshelfVersion;
    }

    public final Boolean manageBerkshelf() {
        return this.manageBerkshelf;
    }

    public final String berkshelfVersion() {
        return this.berkshelfVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.manageBerkshelf());
        hashCode = 31 * hashCode + Objects.hashCode(this.berkshelfVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChefConfiguration)) {
            return false;
        }
        ChefConfiguration other = (ChefConfiguration)obj;
        return Objects.equals(this.manageBerkshelf(), other.manageBerkshelf()) && Objects.equals(this.berkshelfVersion(), other.berkshelfVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ChefConfiguration").add("ManageBerkshelf", (Object)this.manageBerkshelf()).add("BerkshelfVersion", (Object)this.berkshelfVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ManageBerkshelf": {
                return Optional.ofNullable(clazz.cast(this.manageBerkshelf()));
            }
            case "BerkshelfVersion": {
                return Optional.ofNullable(clazz.cast(this.berkshelfVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ChefConfiguration, T> g) {
        return obj -> g.apply((ChefConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean manageBerkshelf;
        private String berkshelfVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ChefConfiguration model) {
            this.manageBerkshelf(model.manageBerkshelf);
            this.berkshelfVersion(model.berkshelfVersion);
        }

        public final Boolean getManageBerkshelf() {
            return this.manageBerkshelf;
        }

        @Override
        public final Builder manageBerkshelf(Boolean manageBerkshelf) {
            this.manageBerkshelf = manageBerkshelf;
            return this;
        }

        public final void setManageBerkshelf(Boolean manageBerkshelf) {
            this.manageBerkshelf = manageBerkshelf;
        }

        public final String getBerkshelfVersion() {
            return this.berkshelfVersion;
        }

        @Override
        public final Builder berkshelfVersion(String berkshelfVersion) {
            this.berkshelfVersion = berkshelfVersion;
            return this;
        }

        public final void setBerkshelfVersion(String berkshelfVersion) {
            this.berkshelfVersion = berkshelfVersion;
        }

        public ChefConfiguration build() {
            return new ChefConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ChefConfiguration> {
        public Builder manageBerkshelf(Boolean var1);

        public Builder berkshelfVersion(String var1);
    }
}

