/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeAgentVersions</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAgentVersionsResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeAgentVersionsResponse.Builder, DescribeAgentVersionsResponse> {
    private static final SdkField<List<AgentVersion>> AGENT_VERSIONS_FIELD = SdkField
            .<List<AgentVersion>> builder(MarshallingType.LIST)
            .memberName("AgentVersions")
            .getter(getter(DescribeAgentVersionsResponse::agentVersions))
            .setter(setter(Builder::agentVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgentVersion> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgentVersion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_VERSIONS_FIELD));

    private final List<AgentVersion> agentVersions;

    private DescribeAgentVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.agentVersions = builder.agentVersions;
    }

    /**
     * Returns true if the AgentVersions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAgentVersions() {
        return agentVersions != null && !(agentVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The agent versions for the specified stack or configuration manager. Note that this value is the complete version
     * number, not the abbreviated number used by the console.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAgentVersions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The agent versions for the specified stack or configuration manager. Note that this value is the complete
     *         version number, not the abbreviated number used by the console.
     */
    public final List<AgentVersion> agentVersions() {
        return agentVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentVersions() ? agentVersions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgentVersionsResponse)) {
            return false;
        }
        DescribeAgentVersionsResponse other = (DescribeAgentVersionsResponse) obj;
        return hasAgentVersions() == other.hasAgentVersions() && Objects.equals(agentVersions(), other.agentVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAgentVersionsResponse")
                .add("AgentVersions", hasAgentVersions() ? agentVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgentVersions":
            return Optional.ofNullable(clazz.cast(agentVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAgentVersionsResponse, T> g) {
        return obj -> g.apply((DescribeAgentVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAgentVersionsResponse> {
        /**
         * <p>
         * The agent versions for the specified stack or configuration manager. Note that this value is the complete
         * version number, not the abbreviated number used by the console.
         * </p>
         * 
         * @param agentVersions
         *        The agent versions for the specified stack or configuration manager. Note that this value is the
         *        complete version number, not the abbreviated number used by the console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersions(Collection<AgentVersion> agentVersions);

        /**
         * <p>
         * The agent versions for the specified stack or configuration manager. Note that this value is the complete
         * version number, not the abbreviated number used by the console.
         * </p>
         * 
         * @param agentVersions
         *        The agent versions for the specified stack or configuration manager. Note that this value is the
         *        complete version number, not the abbreviated number used by the console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersions(AgentVersion... agentVersions);

        /**
         * <p>
         * The agent versions for the specified stack or configuration manager. Note that this value is the complete
         * version number, not the abbreviated number used by the console.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AgentVersion>.Builder} avoiding the need to
         * create one manually via {@link List<AgentVersion>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AgentVersion>.Builder#build()} is called immediately and its
         * result is passed to {@link #agentVersions(List<AgentVersion>)}.
         * 
         * @param agentVersions
         *        a consumer that will call methods on {@link List<AgentVersion>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentVersions(List<AgentVersion>)
         */
        Builder agentVersions(Consumer<AgentVersion.Builder>... agentVersions);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<AgentVersion> agentVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgentVersionsResponse model) {
            super(model);
            agentVersions(model.agentVersions);
        }

        public final Collection<AgentVersion.Builder> getAgentVersions() {
            if (agentVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return agentVersions != null ? agentVersions.stream().map(AgentVersion::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder agentVersions(Collection<AgentVersion> agentVersions) {
            this.agentVersions = AgentVersionsCopier.copy(agentVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentVersions(AgentVersion... agentVersions) {
            agentVersions(Arrays.asList(agentVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentVersions(Consumer<AgentVersion.Builder>... agentVersions) {
            agentVersions(Stream.of(agentVersions).map(c -> AgentVersion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAgentVersions(Collection<AgentVersion.BuilderImpl> agentVersions) {
            this.agentVersions = AgentVersionsCopier.copyFromBuilder(agentVersions);
        }

        @Override
        public DescribeAgentVersionsResponse build() {
            return new DescribeAgentVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
