/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeEcsClustersRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, DescribeEcsClustersRequest> {
    private static final SdkField<List<String>> ECS_CLUSTER_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EcsClusterArns").getter(DescribeEcsClustersRequest.getter(DescribeEcsClustersRequest::ecsClusterArns)).setter(DescribeEcsClustersRequest.setter(Builder::ecsClusterArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EcsClusterArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(DescribeEcsClustersRequest.getter(DescribeEcsClustersRequest::stackId)).setter(DescribeEcsClustersRequest.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeEcsClustersRequest.getter(DescribeEcsClustersRequest::nextToken)).setter(DescribeEcsClustersRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeEcsClustersRequest.getter(DescribeEcsClustersRequest::maxResults)).setter(DescribeEcsClustersRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECS_CLUSTER_ARNS_FIELD, STACK_ID_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private final List<String> ecsClusterArns;
    private final String stackId;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeEcsClustersRequest(BuilderImpl builder) {
        super(builder);
        this.ecsClusterArns = builder.ecsClusterArns;
        this.stackId = builder.stackId;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final boolean hasEcsClusterArns() {
        return this.ecsClusterArns != null && !(this.ecsClusterArns instanceof SdkAutoConstructList);
    }

    public final List<String> ecsClusterArns() {
        return this.ecsClusterArns;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEcsClusterArns() ? this.ecsClusterArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEcsClustersRequest)) {
            return false;
        }
        DescribeEcsClustersRequest other = (DescribeEcsClustersRequest)((Object)obj);
        return this.hasEcsClusterArns() == other.hasEcsClusterArns() && Objects.equals(this.ecsClusterArns(), other.ecsClusterArns()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeEcsClustersRequest").add("EcsClusterArns", this.hasEcsClusterArns() ? this.ecsClusterArns() : null).add("StackId", (Object)this.stackId()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EcsClusterArns": {
                return Optional.ofNullable(clazz.cast(this.ecsClusterArns()));
            }
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEcsClustersRequest, T> g) {
        return obj -> g.apply((DescribeEcsClustersRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private List<String> ecsClusterArns = DefaultSdkAutoConstructList.getInstance();
        private String stackId;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEcsClustersRequest model) {
            super(model);
            this.ecsClusterArns(model.ecsClusterArns);
            this.stackId(model.stackId);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final Collection<String> getEcsClusterArns() {
            if (this.ecsClusterArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ecsClusterArns;
        }

        @Override
        public final Builder ecsClusterArns(Collection<String> ecsClusterArns) {
            this.ecsClusterArns = StringsCopier.copy(ecsClusterArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsClusterArns(String ... ecsClusterArns) {
            this.ecsClusterArns(Arrays.asList(ecsClusterArns));
            return this;
        }

        public final void setEcsClusterArns(Collection<String> ecsClusterArns) {
            this.ecsClusterArns = StringsCopier.copy(ecsClusterArns);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEcsClustersRequest build() {
            return new DescribeEcsClustersRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeEcsClustersRequest> {
        public Builder ecsClusterArns(Collection<String> var1);

        public Builder ecsClusterArns(String ... var1);

        public Builder stackId(String var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

