/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeStacks</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeStacksResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeStacksResponse.Builder, DescribeStacksResponse> {
    private static final SdkField<List<Stack>> STACKS_FIELD = SdkField
            .<List<Stack>> builder(MarshallingType.LIST)
            .memberName("Stacks")
            .getter(getter(DescribeStacksResponse::stacks))
            .setter(setter(Builder::stacks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stacks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Stack> builder(MarshallingType.SDK_POJO)
                                            .constructor(Stack::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACKS_FIELD));

    private final List<Stack> stacks;

    private DescribeStacksResponse(BuilderImpl builder) {
        super(builder);
        this.stacks = builder.stacks;
    }

    /**
     * Returns true if the Stacks property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasStacks() {
        return stacks != null && !(stacks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Stack</code> objects that describe the stacks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStacks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>Stack</code> objects that describe the stacks.
     */
    public final List<Stack> stacks() {
        return stacks;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasStacks() ? stacks() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStacksResponse)) {
            return false;
        }
        DescribeStacksResponse other = (DescribeStacksResponse) obj;
        return hasStacks() == other.hasStacks() && Objects.equals(stacks(), other.stacks());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeStacksResponse").add("Stacks", hasStacks() ? stacks() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Stacks":
            return Optional.ofNullable(clazz.cast(stacks()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeStacksResponse, T> g) {
        return obj -> g.apply((DescribeStacksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeStacksResponse> {
        /**
         * <p>
         * An array of <code>Stack</code> objects that describe the stacks.
         * </p>
         * 
         * @param stacks
         *        An array of <code>Stack</code> objects that describe the stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stacks(Collection<Stack> stacks);

        /**
         * <p>
         * An array of <code>Stack</code> objects that describe the stacks.
         * </p>
         * 
         * @param stacks
         *        An array of <code>Stack</code> objects that describe the stacks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stacks(Stack... stacks);

        /**
         * <p>
         * An array of <code>Stack</code> objects that describe the stacks.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Stack>.Builder} avoiding the need to create
         * one manually via {@link List<Stack>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Stack>.Builder#build()} is called immediately and its result
         * is passed to {@link #stacks(List<Stack>)}.
         * 
         * @param stacks
         *        a consumer that will call methods on {@link List<Stack>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stacks(List<Stack>)
         */
        Builder stacks(Consumer<Stack.Builder>... stacks);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<Stack> stacks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStacksResponse model) {
            super(model);
            stacks(model.stacks);
        }

        public final Collection<Stack.Builder> getStacks() {
            if (stacks instanceof SdkAutoConstructList) {
                return null;
            }
            return stacks != null ? stacks.stream().map(Stack::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder stacks(Collection<Stack> stacks) {
            this.stacks = StacksCopier.copy(stacks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stacks(Stack... stacks) {
            stacks(Arrays.asList(stacks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stacks(Consumer<Stack.Builder>... stacks) {
            stacks(Stream.of(stacks).map(c -> Stack.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStacks(Collection<Stack.BuilderImpl> stacks) {
            this.stacks = StacksCopier.copyFromBuilder(stacks);
        }

        @Override
        public DescribeStacksResponse build() {
            return new DescribeStacksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
