/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Permission
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Permission> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(Permission.getter(Permission::stackId)).setter(Permission.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> IAM_USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamUserArn").getter(Permission.getter(Permission::iamUserArn)).setter(Permission.setter(Builder::iamUserArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamUserArn").build()}).build();
    private static final SdkField<Boolean> ALLOW_SSH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowSsh").getter(Permission.getter(Permission::allowSsh)).setter(Permission.setter(Builder::allowSsh)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowSsh").build()}).build();
    private static final SdkField<Boolean> ALLOW_SUDO_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowSudo").getter(Permission.getter(Permission::allowSudo)).setter(Permission.setter(Builder::allowSudo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowSudo").build()}).build();
    private static final SdkField<String> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Level").getter(Permission.getter(Permission::level)).setter(Permission.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Level").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, IAM_USER_ARN_FIELD, ALLOW_SSH_FIELD, ALLOW_SUDO_FIELD, LEVEL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stackId;
    private final String iamUserArn;
    private final Boolean allowSsh;
    private final Boolean allowSudo;
    private final String level;

    private Permission(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.iamUserArn = builder.iamUserArn;
        this.allowSsh = builder.allowSsh;
        this.allowSudo = builder.allowSudo;
        this.level = builder.level;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final String iamUserArn() {
        return this.iamUserArn;
    }

    public final Boolean allowSsh() {
        return this.allowSsh;
    }

    public final Boolean allowSudo() {
        return this.allowSudo;
    }

    public final String level() {
        return this.level;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowSsh());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowSudo());
        hashCode = 31 * hashCode + Objects.hashCode(this.level());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission)obj;
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.iamUserArn(), other.iamUserArn()) && Objects.equals(this.allowSsh(), other.allowSsh()) && Objects.equals(this.allowSudo(), other.allowSudo()) && Objects.equals(this.level(), other.level());
    }

    public final String toString() {
        return ToString.builder((String)"Permission").add("StackId", (Object)this.stackId()).add("IamUserArn", (Object)this.iamUserArn()).add("AllowSsh", (Object)this.allowSsh()).add("AllowSudo", (Object)this.allowSudo()).add("Level", (Object)this.level()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "IamUserArn": {
                return Optional.ofNullable(clazz.cast(this.iamUserArn()));
            }
            case "AllowSsh": {
                return Optional.ofNullable(clazz.cast(this.allowSsh()));
            }
            case "AllowSudo": {
                return Optional.ofNullable(clazz.cast(this.allowSudo()));
            }
            case "Level": {
                return Optional.ofNullable(clazz.cast(this.level()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Permission, T> g) {
        return obj -> g.apply((Permission)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String iamUserArn;
        private Boolean allowSsh;
        private Boolean allowSudo;
        private String level;

        private BuilderImpl() {
        }

        private BuilderImpl(Permission model) {
            this.stackId(model.stackId);
            this.iamUserArn(model.iamUserArn);
            this.allowSsh(model.allowSsh);
            this.allowSudo(model.allowSudo);
            this.level(model.level);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getIamUserArn() {
            return this.iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final Boolean getAllowSsh() {
            return this.allowSsh;
        }

        @Override
        public final Builder allowSsh(Boolean allowSsh) {
            this.allowSsh = allowSsh;
            return this;
        }

        public final void setAllowSsh(Boolean allowSsh) {
            this.allowSsh = allowSsh;
        }

        public final Boolean getAllowSudo() {
            return this.allowSudo;
        }

        @Override
        public final Builder allowSudo(Boolean allowSudo) {
            this.allowSudo = allowSudo;
            return this;
        }

        public final void setAllowSudo(Boolean allowSudo) {
            this.allowSudo = allowSudo;
        }

        public final String getLevel() {
            return this.level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        public Permission build() {
            return new Permission(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Permission> {
        public Builder stackId(String var1);

        public Builder iamUserArn(String var1);

        public Builder allowSsh(Boolean var1);

        public Builder allowSudo(Boolean var1);

        public Builder level(String var1);
    }
}

