/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a time-based instance's auto scaling schedule. The schedule consists of a set of key-value pairs.
 * </p>
 * <ul>
 * <li>
 * <p>
 * The key is the time period (a UTC hour) and must be an integer from 0 - 23.
 * </p>
 * </li>
 * <li>
 * <p>
 * The value indicates whether the instance should be online or offline for the specified period, and must be set to
 * "on" or "off"
 * </p>
 * </li>
 * </ul>
 * <p>
 * The default setting for all time periods is off, so you use the following parameters primarily to specify the online
 * periods. You don't have to explicitly specify offline periods unless you want to change an online period to an
 * offline period.
 * </p>
 * <p>
 * The following example specifies that the instance should be online for four hours, from UTC 1200 - 1600. It will be
 * off for the remainder of the day.
 * </p>
 * <p>
 * <code> { "12":"on", "13":"on", "14":"on", "15":"on" } </code>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WeeklyAutoScalingSchedule implements SdkPojo, Serializable,
        ToCopyableBuilder<WeeklyAutoScalingSchedule.Builder, WeeklyAutoScalingSchedule> {
    private static final SdkField<Map<String, String>> MONDAY_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Monday")
            .getter(getter(WeeklyAutoScalingSchedule::monday))
            .setter(setter(Builder::monday))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Monday").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TUESDAY_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tuesday")
            .getter(getter(WeeklyAutoScalingSchedule::tuesday))
            .setter(setter(Builder::tuesday))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tuesday").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> WEDNESDAY_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Wednesday")
            .getter(getter(WeeklyAutoScalingSchedule::wednesday))
            .setter(setter(Builder::wednesday))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Wednesday").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> THURSDAY_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Thursday")
            .getter(getter(WeeklyAutoScalingSchedule::thursday))
            .setter(setter(Builder::thursday))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Thursday").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> FRIDAY_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Friday")
            .getter(getter(WeeklyAutoScalingSchedule::friday))
            .setter(setter(Builder::friday))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Friday").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> SATURDAY_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Saturday")
            .getter(getter(WeeklyAutoScalingSchedule::saturday))
            .setter(setter(Builder::saturday))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Saturday").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> SUNDAY_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Sunday")
            .getter(getter(WeeklyAutoScalingSchedule::sunday))
            .setter(setter(Builder::sunday))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sunday").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONDAY_FIELD, TUESDAY_FIELD,
            WEDNESDAY_FIELD, THURSDAY_FIELD, FRIDAY_FIELD, SATURDAY_FIELD, SUNDAY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Map<String, String> monday;

    private final Map<String, String> tuesday;

    private final Map<String, String> wednesday;

    private final Map<String, String> thursday;

    private final Map<String, String> friday;

    private final Map<String, String> saturday;

    private final Map<String, String> sunday;

    private WeeklyAutoScalingSchedule(BuilderImpl builder) {
        this.monday = builder.monday;
        this.tuesday = builder.tuesday;
        this.wednesday = builder.wednesday;
        this.thursday = builder.thursday;
        this.friday = builder.friday;
        this.saturday = builder.saturday;
        this.sunday = builder.sunday;
    }

    /**
     * For responses, this returns true if the service returned a value for the Monday property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMonday() {
        return monday != null && !(monday instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The schedule for Monday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMonday} method.
     * </p>
     * 
     * @return The schedule for Monday.
     */
    public final Map<String, String> monday() {
        return monday;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tuesday property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTuesday() {
        return tuesday != null && !(tuesday instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The schedule for Tuesday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTuesday} method.
     * </p>
     * 
     * @return The schedule for Tuesday.
     */
    public final Map<String, String> tuesday() {
        return tuesday;
    }

    /**
     * For responses, this returns true if the service returned a value for the Wednesday property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWednesday() {
        return wednesday != null && !(wednesday instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The schedule for Wednesday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWednesday} method.
     * </p>
     * 
     * @return The schedule for Wednesday.
     */
    public final Map<String, String> wednesday() {
        return wednesday;
    }

    /**
     * For responses, this returns true if the service returned a value for the Thursday property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasThursday() {
        return thursday != null && !(thursday instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The schedule for Thursday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThursday} method.
     * </p>
     * 
     * @return The schedule for Thursday.
     */
    public final Map<String, String> thursday() {
        return thursday;
    }

    /**
     * For responses, this returns true if the service returned a value for the Friday property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFriday() {
        return friday != null && !(friday instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The schedule for Friday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFriday} method.
     * </p>
     * 
     * @return The schedule for Friday.
     */
    public final Map<String, String> friday() {
        return friday;
    }

    /**
     * For responses, this returns true if the service returned a value for the Saturday property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSaturday() {
        return saturday != null && !(saturday instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The schedule for Saturday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSaturday} method.
     * </p>
     * 
     * @return The schedule for Saturday.
     */
    public final Map<String, String> saturday() {
        return saturday;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sunday property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSunday() {
        return sunday != null && !(sunday instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The schedule for Sunday.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSunday} method.
     * </p>
     * 
     * @return The schedule for Sunday.
     */
    public final Map<String, String> sunday() {
        return sunday;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasMonday() ? monday() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTuesday() ? tuesday() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWednesday() ? wednesday() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasThursday() ? thursday() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFriday() ? friday() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSaturday() ? saturday() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSunday() ? sunday() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WeeklyAutoScalingSchedule)) {
            return false;
        }
        WeeklyAutoScalingSchedule other = (WeeklyAutoScalingSchedule) obj;
        return hasMonday() == other.hasMonday() && Objects.equals(monday(), other.monday()) && hasTuesday() == other.hasTuesday()
                && Objects.equals(tuesday(), other.tuesday()) && hasWednesday() == other.hasWednesday()
                && Objects.equals(wednesday(), other.wednesday()) && hasThursday() == other.hasThursday()
                && Objects.equals(thursday(), other.thursday()) && hasFriday() == other.hasFriday()
                && Objects.equals(friday(), other.friday()) && hasSaturday() == other.hasSaturday()
                && Objects.equals(saturday(), other.saturday()) && hasSunday() == other.hasSunday()
                && Objects.equals(sunday(), other.sunday());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WeeklyAutoScalingSchedule").add("Monday", hasMonday() ? monday() : null)
                .add("Tuesday", hasTuesday() ? tuesday() : null).add("Wednesday", hasWednesday() ? wednesday() : null)
                .add("Thursday", hasThursday() ? thursday() : null).add("Friday", hasFriday() ? friday() : null)
                .add("Saturday", hasSaturday() ? saturday() : null).add("Sunday", hasSunday() ? sunday() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Monday":
            return Optional.ofNullable(clazz.cast(monday()));
        case "Tuesday":
            return Optional.ofNullable(clazz.cast(tuesday()));
        case "Wednesday":
            return Optional.ofNullable(clazz.cast(wednesday()));
        case "Thursday":
            return Optional.ofNullable(clazz.cast(thursday()));
        case "Friday":
            return Optional.ofNullable(clazz.cast(friday()));
        case "Saturday":
            return Optional.ofNullable(clazz.cast(saturday()));
        case "Sunday":
            return Optional.ofNullable(clazz.cast(sunday()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WeeklyAutoScalingSchedule, T> g) {
        return obj -> g.apply((WeeklyAutoScalingSchedule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WeeklyAutoScalingSchedule> {
        /**
         * <p>
         * The schedule for Monday.
         * </p>
         * 
         * @param monday
         *        The schedule for Monday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monday(Map<String, String> monday);

        /**
         * <p>
         * The schedule for Tuesday.
         * </p>
         * 
         * @param tuesday
         *        The schedule for Tuesday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tuesday(Map<String, String> tuesday);

        /**
         * <p>
         * The schedule for Wednesday.
         * </p>
         * 
         * @param wednesday
         *        The schedule for Wednesday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wednesday(Map<String, String> wednesday);

        /**
         * <p>
         * The schedule for Thursday.
         * </p>
         * 
         * @param thursday
         *        The schedule for Thursday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thursday(Map<String, String> thursday);

        /**
         * <p>
         * The schedule for Friday.
         * </p>
         * 
         * @param friday
         *        The schedule for Friday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder friday(Map<String, String> friday);

        /**
         * <p>
         * The schedule for Saturday.
         * </p>
         * 
         * @param saturday
         *        The schedule for Saturday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder saturday(Map<String, String> saturday);

        /**
         * <p>
         * The schedule for Sunday.
         * </p>
         * 
         * @param sunday
         *        The schedule for Sunday.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sunday(Map<String, String> sunday);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> monday = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tuesday = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> wednesday = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> thursday = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> friday = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> saturday = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> sunday = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(WeeklyAutoScalingSchedule model) {
            monday(model.monday);
            tuesday(model.tuesday);
            wednesday(model.wednesday);
            thursday(model.thursday);
            friday(model.friday);
            saturday(model.saturday);
            sunday(model.sunday);
        }

        public final Map<String, String> getMonday() {
            if (monday instanceof SdkAutoConstructMap) {
                return null;
            }
            return monday;
        }

        public final void setMonday(Map<String, String> monday) {
            this.monday = DailyAutoScalingScheduleCopier.copy(monday);
        }

        @Override
        @Transient
        public final Builder monday(Map<String, String> monday) {
            this.monday = DailyAutoScalingScheduleCopier.copy(monday);
            return this;
        }

        public final Map<String, String> getTuesday() {
            if (tuesday instanceof SdkAutoConstructMap) {
                return null;
            }
            return tuesday;
        }

        public final void setTuesday(Map<String, String> tuesday) {
            this.tuesday = DailyAutoScalingScheduleCopier.copy(tuesday);
        }

        @Override
        @Transient
        public final Builder tuesday(Map<String, String> tuesday) {
            this.tuesday = DailyAutoScalingScheduleCopier.copy(tuesday);
            return this;
        }

        public final Map<String, String> getWednesday() {
            if (wednesday instanceof SdkAutoConstructMap) {
                return null;
            }
            return wednesday;
        }

        public final void setWednesday(Map<String, String> wednesday) {
            this.wednesday = DailyAutoScalingScheduleCopier.copy(wednesday);
        }

        @Override
        @Transient
        public final Builder wednesday(Map<String, String> wednesday) {
            this.wednesday = DailyAutoScalingScheduleCopier.copy(wednesday);
            return this;
        }

        public final Map<String, String> getThursday() {
            if (thursday instanceof SdkAutoConstructMap) {
                return null;
            }
            return thursday;
        }

        public final void setThursday(Map<String, String> thursday) {
            this.thursday = DailyAutoScalingScheduleCopier.copy(thursday);
        }

        @Override
        @Transient
        public final Builder thursday(Map<String, String> thursday) {
            this.thursday = DailyAutoScalingScheduleCopier.copy(thursday);
            return this;
        }

        public final Map<String, String> getFriday() {
            if (friday instanceof SdkAutoConstructMap) {
                return null;
            }
            return friday;
        }

        public final void setFriday(Map<String, String> friday) {
            this.friday = DailyAutoScalingScheduleCopier.copy(friday);
        }

        @Override
        @Transient
        public final Builder friday(Map<String, String> friday) {
            this.friday = DailyAutoScalingScheduleCopier.copy(friday);
            return this;
        }

        public final Map<String, String> getSaturday() {
            if (saturday instanceof SdkAutoConstructMap) {
                return null;
            }
            return saturday;
        }

        public final void setSaturday(Map<String, String> saturday) {
            this.saturday = DailyAutoScalingScheduleCopier.copy(saturday);
        }

        @Override
        @Transient
        public final Builder saturday(Map<String, String> saturday) {
            this.saturday = DailyAutoScalingScheduleCopier.copy(saturday);
            return this;
        }

        public final Map<String, String> getSunday() {
            if (sunday instanceof SdkAutoConstructMap) {
                return null;
            }
            return sunday;
        }

        public final void setSunday(Map<String, String> sunday) {
            this.sunday = DailyAutoScalingScheduleCopier.copy(sunday);
        }

        @Override
        @Transient
        public final Builder sunday(Map<String, String> sunday) {
            this.sunday = DailyAutoScalingScheduleCopier.copy(sunday);
            return this;
        }

        @Override
        public WeeklyAutoScalingSchedule build() {
            return new WeeklyAutoScalingSchedule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
