/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeElasticIps</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeElasticIpsResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeElasticIpsResponse.Builder, DescribeElasticIpsResponse> {
    private static final SdkField<List<ElasticIp>> ELASTIC_IPS_FIELD = SdkField
            .<List<ElasticIp>> builder(MarshallingType.LIST)
            .memberName("ElasticIps")
            .getter(getter(DescribeElasticIpsResponse::elasticIps))
            .setter(setter(Builder::elasticIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticIps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ElasticIp> builder(MarshallingType.SDK_POJO)
                                            .constructor(ElasticIp::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELASTIC_IPS_FIELD));

    private final List<ElasticIp> elasticIps;

    private DescribeElasticIpsResponse(BuilderImpl builder) {
        super(builder);
        this.elasticIps = builder.elasticIps;
    }

    /**
     * For responses, this returns true if the service returned a value for the ElasticIps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasElasticIps() {
        return elasticIps != null && !(elasticIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasElasticIps} method.
     * </p>
     * 
     * @return An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
     */
    public final List<ElasticIp> elasticIps() {
        return elasticIps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasElasticIps() ? elasticIps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticIpsResponse)) {
            return false;
        }
        DescribeElasticIpsResponse other = (DescribeElasticIpsResponse) obj;
        return hasElasticIps() == other.hasElasticIps() && Objects.equals(elasticIps(), other.elasticIps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeElasticIpsResponse").add("ElasticIps", hasElasticIps() ? elasticIps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticIps":
            return Optional.ofNullable(clazz.cast(elasticIps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeElasticIpsResponse, T> g) {
        return obj -> g.apply((DescribeElasticIpsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeElasticIpsResponse> {
        /**
         * <p>
         * An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
         * </p>
         * 
         * @param elasticIps
         *        An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticIps(Collection<ElasticIp> elasticIps);

        /**
         * <p>
         * An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
         * </p>
         * 
         * @param elasticIps
         *        An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticIps(ElasticIp... elasticIps);

        /**
         * <p>
         * An <code>ElasticIps</code> object that describes the specified Elastic IP addresses.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ElasticIp>.Builder} avoiding the need to
         * create one manually via {@link List<ElasticIp>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ElasticIp>.Builder#build()} is called immediately and its
         * result is passed to {@link #elasticIps(List<ElasticIp>)}.
         * 
         * @param elasticIps
         *        a consumer that will call methods on {@link List<ElasticIp>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticIps(List<ElasticIp>)
         */
        Builder elasticIps(Consumer<ElasticIp.Builder>... elasticIps);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<ElasticIp> elasticIps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticIpsResponse model) {
            super(model);
            elasticIps(model.elasticIps);
        }

        public final List<ElasticIp.Builder> getElasticIps() {
            List<ElasticIp.Builder> result = ElasticIpsCopier.copyToBuilder(this.elasticIps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElasticIps(Collection<ElasticIp.BuilderImpl> elasticIps) {
            this.elasticIps = ElasticIpsCopier.copyFromBuilder(elasticIps);
        }

        @Override
        @Transient
        public final Builder elasticIps(Collection<ElasticIp> elasticIps) {
            this.elasticIps = ElasticIpsCopier.copy(elasticIps);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder elasticIps(ElasticIp... elasticIps) {
            elasticIps(Arrays.asList(elasticIps));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder elasticIps(Consumer<ElasticIp.Builder>... elasticIps) {
            elasticIps(Stream.of(elasticIps).map(c -> ElasticIp.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeElasticIpsResponse build() {
            return new DescribeElasticIpsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
