/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeElasticLoadBalancers</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeElasticLoadBalancersResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeElasticLoadBalancersResponse.Builder, DescribeElasticLoadBalancersResponse> {
    private static final SdkField<List<ElasticLoadBalancer>> ELASTIC_LOAD_BALANCERS_FIELD = SdkField
            .<List<ElasticLoadBalancer>> builder(MarshallingType.LIST)
            .memberName("ElasticLoadBalancers")
            .getter(getter(DescribeElasticLoadBalancersResponse::elasticLoadBalancers))
            .setter(setter(Builder::elasticLoadBalancers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticLoadBalancers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ElasticLoadBalancer> builder(MarshallingType.SDK_POJO)
                                            .constructor(ElasticLoadBalancer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ELASTIC_LOAD_BALANCERS_FIELD));

    private final List<ElasticLoadBalancer> elasticLoadBalancers;

    private DescribeElasticLoadBalancersResponse(BuilderImpl builder) {
        super(builder);
        this.elasticLoadBalancers = builder.elasticLoadBalancers;
    }

    /**
     * Returns true if the ElasticLoadBalancers property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasElasticLoadBalancers() {
        return elasticLoadBalancers != null && !(elasticLoadBalancers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <code>ElasticLoadBalancer</code> objects that describe the specified Elastic Load Balancing instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasElasticLoadBalancers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <code>ElasticLoadBalancer</code> objects that describe the specified Elastic Load Balancing
     *         instances.
     */
    public final List<ElasticLoadBalancer> elasticLoadBalancers() {
        return elasticLoadBalancers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasElasticLoadBalancers() ? elasticLoadBalancers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticLoadBalancersResponse)) {
            return false;
        }
        DescribeElasticLoadBalancersResponse other = (DescribeElasticLoadBalancersResponse) obj;
        return hasElasticLoadBalancers() == other.hasElasticLoadBalancers()
                && Objects.equals(elasticLoadBalancers(), other.elasticLoadBalancers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeElasticLoadBalancersResponse")
                .add("ElasticLoadBalancers", hasElasticLoadBalancers() ? elasticLoadBalancers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticLoadBalancers":
            return Optional.ofNullable(clazz.cast(elasticLoadBalancers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeElasticLoadBalancersResponse, T> g) {
        return obj -> g.apply((DescribeElasticLoadBalancersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeElasticLoadBalancersResponse> {
        /**
         * <p>
         * A list of <code>ElasticLoadBalancer</code> objects that describe the specified Elastic Load Balancing
         * instances.
         * </p>
         * 
         * @param elasticLoadBalancers
         *        A list of <code>ElasticLoadBalancer</code> objects that describe the specified Elastic Load Balancing
         *        instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticLoadBalancers(Collection<ElasticLoadBalancer> elasticLoadBalancers);

        /**
         * <p>
         * A list of <code>ElasticLoadBalancer</code> objects that describe the specified Elastic Load Balancing
         * instances.
         * </p>
         * 
         * @param elasticLoadBalancers
         *        A list of <code>ElasticLoadBalancer</code> objects that describe the specified Elastic Load Balancing
         *        instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticLoadBalancers(ElasticLoadBalancer... elasticLoadBalancers);

        /**
         * <p>
         * A list of <code>ElasticLoadBalancer</code> objects that describe the specified Elastic Load Balancing
         * instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ElasticLoadBalancer>.Builder} avoiding the
         * need to create one manually via {@link List<ElasticLoadBalancer>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ElasticLoadBalancer>.Builder#build()} is called immediately
         * and its result is passed to {@link #elasticLoadBalancers(List<ElasticLoadBalancer>)}.
         * 
         * @param elasticLoadBalancers
         *        a consumer that will call methods on {@link List<ElasticLoadBalancer>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #elasticLoadBalancers(List<ElasticLoadBalancer>)
         */
        Builder elasticLoadBalancers(Consumer<ElasticLoadBalancer.Builder>... elasticLoadBalancers);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<ElasticLoadBalancer> elasticLoadBalancers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticLoadBalancersResponse model) {
            super(model);
            elasticLoadBalancers(model.elasticLoadBalancers);
        }

        public final List<ElasticLoadBalancer.Builder> getElasticLoadBalancers() {
            List<ElasticLoadBalancer.Builder> result = ElasticLoadBalancersCopier.copyToBuilder(this.elasticLoadBalancers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setElasticLoadBalancers(Collection<ElasticLoadBalancer.BuilderImpl> elasticLoadBalancers) {
            this.elasticLoadBalancers = ElasticLoadBalancersCopier.copyFromBuilder(elasticLoadBalancers);
        }

        @Override
        @Transient
        public final Builder elasticLoadBalancers(Collection<ElasticLoadBalancer> elasticLoadBalancers) {
            this.elasticLoadBalancers = ElasticLoadBalancersCopier.copy(elasticLoadBalancers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder elasticLoadBalancers(ElasticLoadBalancer... elasticLoadBalancers) {
            elasticLoadBalancers(Arrays.asList(elasticLoadBalancers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder elasticLoadBalancers(Consumer<ElasticLoadBalancer.Builder>... elasticLoadBalancers) {
            elasticLoadBalancers(Stream.of(elasticLoadBalancers).map(c -> ElasticLoadBalancer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeElasticLoadBalancersResponse build() {
            return new DescribeElasticLoadBalancersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
