/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Elastic Load Balancing instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ElasticLoadBalancer implements SdkPojo, Serializable,
        ToCopyableBuilder<ElasticLoadBalancer.Builder, ElasticLoadBalancer> {
    private static final SdkField<String> ELASTIC_LOAD_BALANCER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ElasticLoadBalancerName").getter(getter(ElasticLoadBalancer::elasticLoadBalancerName))
            .setter(setter(Builder::elasticLoadBalancerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticLoadBalancerName").build())
            .build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(ElasticLoadBalancer::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> DNS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DnsName").getter(getter(ElasticLoadBalancer::dnsName)).setter(setter(Builder::dnsName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").build()).build();

    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackId").getter(getter(ElasticLoadBalancer::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> LAYER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LayerId").getter(getter(ElasticLoadBalancer::layerId)).setter(setter(Builder::layerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerId").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(ElasticLoadBalancer::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<List<String>> AVAILABILITY_ZONES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AvailabilityZones")
            .getter(getter(ElasticLoadBalancer::availabilityZones))
            .setter(setter(Builder::availabilityZones))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZones").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(ElasticLoadBalancer::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EC2_INSTANCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Ec2InstanceIds")
            .getter(getter(ElasticLoadBalancer::ec2InstanceIds))
            .setter(setter(Builder::ec2InstanceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ELASTIC_LOAD_BALANCER_NAME_FIELD, REGION_FIELD, DNS_NAME_FIELD, STACK_ID_FIELD, LAYER_ID_FIELD, VPC_ID_FIELD,
            AVAILABILITY_ZONES_FIELD, SUBNET_IDS_FIELD, EC2_INSTANCE_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String elasticLoadBalancerName;

    private final String region;

    private final String dnsName;

    private final String stackId;

    private final String layerId;

    private final String vpcId;

    private final List<String> availabilityZones;

    private final List<String> subnetIds;

    private final List<String> ec2InstanceIds;

    private ElasticLoadBalancer(BuilderImpl builder) {
        this.elasticLoadBalancerName = builder.elasticLoadBalancerName;
        this.region = builder.region;
        this.dnsName = builder.dnsName;
        this.stackId = builder.stackId;
        this.layerId = builder.layerId;
        this.vpcId = builder.vpcId;
        this.availabilityZones = builder.availabilityZones;
        this.subnetIds = builder.subnetIds;
        this.ec2InstanceIds = builder.ec2InstanceIds;
    }

    /**
     * <p>
     * The Elastic Load Balancing instance's name.
     * </p>
     * 
     * @return The Elastic Load Balancing instance's name.
     */
    public final String elasticLoadBalancerName() {
        return elasticLoadBalancerName;
    }

    /**
     * <p>
     * The instance's AWS region.
     * </p>
     * 
     * @return The instance's AWS region.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The instance's public DNS name.
     * </p>
     * 
     * @return The instance's public DNS name.
     */
    public final String dnsName() {
        return dnsName;
    }

    /**
     * <p>
     * The ID of the stack that the instance is associated with.
     * </p>
     * 
     * @return The ID of the stack that the instance is associated with.
     */
    public final String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The ID of the layer that the instance is attached to.
     * </p>
     * 
     * @return The ID of the layer that the instance is attached to.
     */
    public final String layerId() {
        return layerId;
    }

    /**
     * <p>
     * The VPC ID.
     * </p>
     * 
     * @return The VPC ID.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * Returns true if the AvailabilityZones property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAvailabilityZones() {
        return availabilityZones != null && !(availabilityZones instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of Availability Zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAvailabilityZones()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of Availability Zones.
     */
    public final List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * Returns true if the SubnetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of subnet IDs, if the stack is running in a VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of subnet IDs, if the stack is running in a VPC.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * Returns true if the Ec2InstanceIds property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasEc2InstanceIds() {
        return ec2InstanceIds != null && !(ec2InstanceIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEc2InstanceIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.
     */
    public final List<String> ec2InstanceIds() {
        return ec2InstanceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(elasticLoadBalancerName());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(layerId());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAvailabilityZones() ? availabilityZones() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEc2InstanceIds() ? ec2InstanceIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticLoadBalancer)) {
            return false;
        }
        ElasticLoadBalancer other = (ElasticLoadBalancer) obj;
        return Objects.equals(elasticLoadBalancerName(), other.elasticLoadBalancerName())
                && Objects.equals(region(), other.region()) && Objects.equals(dnsName(), other.dnsName())
                && Objects.equals(stackId(), other.stackId()) && Objects.equals(layerId(), other.layerId())
                && Objects.equals(vpcId(), other.vpcId()) && hasAvailabilityZones() == other.hasAvailabilityZones()
                && Objects.equals(availabilityZones(), other.availabilityZones()) && hasSubnetIds() == other.hasSubnetIds()
                && Objects.equals(subnetIds(), other.subnetIds()) && hasEc2InstanceIds() == other.hasEc2InstanceIds()
                && Objects.equals(ec2InstanceIds(), other.ec2InstanceIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ElasticLoadBalancer").add("ElasticLoadBalancerName", elasticLoadBalancerName())
                .add("Region", region()).add("DnsName", dnsName()).add("StackId", stackId()).add("LayerId", layerId())
                .add("VpcId", vpcId()).add("AvailabilityZones", hasAvailabilityZones() ? availabilityZones() : null)
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null)
                .add("Ec2InstanceIds", hasEc2InstanceIds() ? ec2InstanceIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticLoadBalancerName":
            return Optional.ofNullable(clazz.cast(elasticLoadBalancerName()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "DnsName":
            return Optional.ofNullable(clazz.cast(dnsName()));
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "LayerId":
            return Optional.ofNullable(clazz.cast(layerId()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "AvailabilityZones":
            return Optional.ofNullable(clazz.cast(availabilityZones()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "Ec2InstanceIds":
            return Optional.ofNullable(clazz.cast(ec2InstanceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ElasticLoadBalancer, T> g) {
        return obj -> g.apply((ElasticLoadBalancer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ElasticLoadBalancer> {
        /**
         * <p>
         * The Elastic Load Balancing instance's name.
         * </p>
         * 
         * @param elasticLoadBalancerName
         *        The Elastic Load Balancing instance's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticLoadBalancerName(String elasticLoadBalancerName);

        /**
         * <p>
         * The instance's AWS region.
         * </p>
         * 
         * @param region
         *        The instance's AWS region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The instance's public DNS name.
         * </p>
         * 
         * @param dnsName
         *        The instance's public DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);

        /**
         * <p>
         * The ID of the stack that the instance is associated with.
         * </p>
         * 
         * @param stackId
         *        The ID of the stack that the instance is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The ID of the layer that the instance is attached to.
         * </p>
         * 
         * @param layerId
         *        The ID of the layer that the instance is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerId(String layerId);

        /**
         * <p>
         * The VPC ID.
         * </p>
         * 
         * @param vpcId
         *        The VPC ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * A list of Availability Zones.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * A list of Availability Zones.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * A list of subnet IDs, if the stack is running in a VPC.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet IDs, if the stack is running in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * A list of subnet IDs, if the stack is running in a VPC.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet IDs, if the stack is running in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.
         * </p>
         * 
         * @param ec2InstanceIds
         *        A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceIds(Collection<String> ec2InstanceIds);

        /**
         * <p>
         * A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.
         * </p>
         * 
         * @param ec2InstanceIds
         *        A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceIds(String... ec2InstanceIds);
    }

    static final class BuilderImpl implements Builder {
        private String elasticLoadBalancerName;

        private String region;

        private String dnsName;

        private String stackId;

        private String layerId;

        private String vpcId;

        private List<String> availabilityZones = DefaultSdkAutoConstructList.getInstance();

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> ec2InstanceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticLoadBalancer model) {
            elasticLoadBalancerName(model.elasticLoadBalancerName);
            region(model.region);
            dnsName(model.dnsName);
            stackId(model.stackId);
            layerId(model.layerId);
            vpcId(model.vpcId);
            availabilityZones(model.availabilityZones);
            subnetIds(model.subnetIds);
            ec2InstanceIds(model.ec2InstanceIds);
        }

        public final String getElasticLoadBalancerName() {
            return elasticLoadBalancerName;
        }

        public final void setElasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
        }

        @Override
        @Transient
        public final Builder elasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        @Transient
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getDnsName() {
            return dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        @Transient
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final String getStackId() {
            return stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        @Transient
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getLayerId() {
            return layerId;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        @Override
        @Transient
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final Collection<String> getAvailabilityZones() {
            if (availabilityZones instanceof SdkAutoConstructList) {
                return null;
            }
            return availabilityZones;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringsCopier.copy(availabilityZones);
        }

        @Override
        @Transient
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringsCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
        }

        @Override
        @Transient
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Collection<String> getEc2InstanceIds() {
            if (ec2InstanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return ec2InstanceIds;
        }

        public final void setEc2InstanceIds(Collection<String> ec2InstanceIds) {
            this.ec2InstanceIds = StringsCopier.copy(ec2InstanceIds);
        }

        @Override
        @Transient
        public final Builder ec2InstanceIds(Collection<String> ec2InstanceIds) {
            this.ec2InstanceIds = StringsCopier.copy(ec2InstanceIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ec2InstanceIds(String... ec2InstanceIds) {
            ec2InstanceIds(Arrays.asList(ec2InstanceIds));
            return this;
        }

        @Override
        public ElasticLoadBalancer build() {
            return new ElasticLoadBalancer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
