/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeLayers</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLayersResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeLayersResponse.Builder, DescribeLayersResponse> {
    private static final SdkField<List<Layer>> LAYERS_FIELD = SdkField
            .<List<Layer>> builder(MarshallingType.LIST)
            .memberName("Layers")
            .getter(getter(DescribeLayersResponse::layers))
            .setter(setter(Builder::layers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Layers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Layer> builder(MarshallingType.SDK_POJO)
                                            .constructor(Layer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYERS_FIELD));

    private final List<Layer> layers;

    private DescribeLayersResponse(BuilderImpl builder) {
        super(builder);
        this.layers = builder.layers;
    }

    /**
     * Returns true if the Layers property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLayers() {
        return layers != null && !(layers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Layer</code> objects that describe the layers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLayers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <code>Layer</code> objects that describe the layers.
     */
    public final List<Layer> layers() {
        return layers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasLayers() ? layers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLayersResponse)) {
            return false;
        }
        DescribeLayersResponse other = (DescribeLayersResponse) obj;
        return hasLayers() == other.hasLayers() && Objects.equals(layers(), other.layers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLayersResponse").add("Layers", hasLayers() ? layers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Layers":
            return Optional.ofNullable(clazz.cast(layers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLayersResponse, T> g) {
        return obj -> g.apply((DescribeLayersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLayersResponse> {
        /**
         * <p>
         * An array of <code>Layer</code> objects that describe the layers.
         * </p>
         * 
         * @param layers
         *        An array of <code>Layer</code> objects that describe the layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(Collection<Layer> layers);

        /**
         * <p>
         * An array of <code>Layer</code> objects that describe the layers.
         * </p>
         * 
         * @param layers
         *        An array of <code>Layer</code> objects that describe the layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(Layer... layers);

        /**
         * <p>
         * An array of <code>Layer</code> objects that describe the layers.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Layer>.Builder} avoiding the need to create
         * one manually via {@link List<Layer>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Layer>.Builder#build()} is called immediately and its result
         * is passed to {@link #layers(List<Layer>)}.
         * 
         * @param layers
         *        a consumer that will call methods on {@link List<Layer>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #layers(List<Layer>)
         */
        Builder layers(Consumer<Layer.Builder>... layers);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<Layer> layers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLayersResponse model) {
            super(model);
            layers(model.layers);
        }

        public final List<Layer.Builder> getLayers() {
            List<Layer.Builder> result = LayersCopier.copyToBuilder(this.layers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLayers(Collection<Layer.BuilderImpl> layers) {
            this.layers = LayersCopier.copyFromBuilder(layers);
        }

        @Override
        @Transient
        public final Builder layers(Collection<Layer> layers) {
            this.layers = LayersCopier.copy(layers);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder layers(Layer... layers) {
            layers(Arrays.asList(layers));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder layers(Consumer<Layer.Builder>... layers) {
            layers(Stream.of(layers).map(c -> Layer.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeLayersResponse build() {
            return new DescribeLayersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
