/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeDeployments</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDeploymentsResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeDeploymentsResponse.Builder, DescribeDeploymentsResponse> {
    private static final SdkField<List<Deployment>> DEPLOYMENTS_FIELD = SdkField
            .<List<Deployment>> builder(MarshallingType.LIST)
            .memberName("Deployments")
            .getter(getter(DescribeDeploymentsResponse::deployments))
            .setter(setter(Builder::deployments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deployments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Deployment> builder(MarshallingType.SDK_POJO)
                                            .constructor(Deployment::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENTS_FIELD));

    private final List<Deployment> deployments;

    private DescribeDeploymentsResponse(BuilderImpl builder) {
        super(builder);
        this.deployments = builder.deployments;
    }

    /**
     * For responses, this returns true if the service returned a value for the Deployments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDeployments() {
        return deployments != null && !(deployments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Deployment</code> objects that describe the deployments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDeployments} method.
     * </p>
     * 
     * @return An array of <code>Deployment</code> objects that describe the deployments.
     */
    public final List<Deployment> deployments() {
        return deployments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDeployments() ? deployments() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeploymentsResponse)) {
            return false;
        }
        DescribeDeploymentsResponse other = (DescribeDeploymentsResponse) obj;
        return hasDeployments() == other.hasDeployments() && Objects.equals(deployments(), other.deployments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDeploymentsResponse").add("Deployments", hasDeployments() ? deployments() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Deployments":
            return Optional.ofNullable(clazz.cast(deployments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeploymentsResponse, T> g) {
        return obj -> g.apply((DescribeDeploymentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDeploymentsResponse> {
        /**
         * <p>
         * An array of <code>Deployment</code> objects that describe the deployments.
         * </p>
         * 
         * @param deployments
         *        An array of <code>Deployment</code> objects that describe the deployments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployments(Collection<Deployment> deployments);

        /**
         * <p>
         * An array of <code>Deployment</code> objects that describe the deployments.
         * </p>
         * 
         * @param deployments
         *        An array of <code>Deployment</code> objects that describe the deployments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployments(Deployment... deployments);

        /**
         * <p>
         * An array of <code>Deployment</code> objects that describe the deployments.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Deployment>.Builder} avoiding the need to
         * create one manually via {@link List<Deployment>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Deployment>.Builder#build()} is called immediately and its
         * result is passed to {@link #deployments(List<Deployment>)}.
         * 
         * @param deployments
         *        a consumer that will call methods on {@link List<Deployment>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deployments(List<Deployment>)
         */
        Builder deployments(Consumer<Deployment.Builder>... deployments);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<Deployment> deployments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeploymentsResponse model) {
            super(model);
            deployments(model.deployments);
        }

        public final List<Deployment.Builder> getDeployments() {
            List<Deployment.Builder> result = DeploymentsCopier.copyToBuilder(this.deployments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeployments(Collection<Deployment.BuilderImpl> deployments) {
            this.deployments = DeploymentsCopier.copyFromBuilder(deployments);
        }

        @Override
        @Transient
        public final Builder deployments(Collection<Deployment> deployments) {
            this.deployments = DeploymentsCopier.copy(deployments);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder deployments(Deployment... deployments) {
            deployments(Arrays.asList(deployments));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder deployments(Consumer<Deployment.Builder>... deployments) {
            deployments(Stream.of(deployments).map(c -> Deployment.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeDeploymentsResponse build() {
            return new DescribeDeploymentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
