/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLayersRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeLayersRequest.Builder, DescribeLayersRequest> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackId").getter(getter(DescribeLayersRequest::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<List<String>> LAYER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LayerIds")
            .getter(getter(DescribeLayersRequest::layerIds))
            .setter(setter(Builder::layerIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD,
            LAYER_IDS_FIELD));

    private final String stackId;

    private final List<String> layerIds;

    private DescribeLayersRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.layerIds = builder.layerIds;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public final String stackId() {
        return stackId;
    }

    /**
     * For responses, this returns true if the service returned a value for the LayerIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLayerIds() {
        return layerIds != null && !(layerIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of layer IDs that specify the layers to be described. If you omit this parameter,
     * <code>DescribeLayers</code> returns a description of every layer in the specified stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLayerIds} method.
     * </p>
     * 
     * @return An array of layer IDs that specify the layers to be described. If you omit this parameter,
     *         <code>DescribeLayers</code> returns a description of every layer in the specified stack.
     */
    public final List<String> layerIds() {
        return layerIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLayerIds() ? layerIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLayersRequest)) {
            return false;
        }
        DescribeLayersRequest other = (DescribeLayersRequest) obj;
        return Objects.equals(stackId(), other.stackId()) && hasLayerIds() == other.hasLayerIds()
                && Objects.equals(layerIds(), other.layerIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeLayersRequest").add("StackId", stackId())
                .add("LayerIds", hasLayerIds() ? layerIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "LayerIds":
            return Optional.ofNullable(clazz.cast(layerIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLayersRequest, T> g) {
        return obj -> g.apply((DescribeLayersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeLayersRequest> {
        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * An array of layer IDs that specify the layers to be described. If you omit this parameter,
         * <code>DescribeLayers</code> returns a description of every layer in the specified stack.
         * </p>
         * 
         * @param layerIds
         *        An array of layer IDs that specify the layers to be described. If you omit this parameter,
         *        <code>DescribeLayers</code> returns a description of every layer in the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerIds(Collection<String> layerIds);

        /**
         * <p>
         * An array of layer IDs that specify the layers to be described. If you omit this parameter,
         * <code>DescribeLayers</code> returns a description of every layer in the specified stack.
         * </p>
         * 
         * @param layerIds
         *        An array of layer IDs that specify the layers to be described. If you omit this parameter,
         *        <code>DescribeLayers</code> returns a description of every layer in the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerIds(String... layerIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String stackId;

        private List<String> layerIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLayersRequest model) {
            super(model);
            stackId(model.stackId);
            layerIds(model.layerIds);
        }

        public final String getStackId() {
            return stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        @Transient
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final Collection<String> getLayerIds() {
            if (layerIds instanceof SdkAutoConstructList) {
                return null;
            }
            return layerIds;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        @Override
        @Transient
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder layerIds(String... layerIds) {
            layerIds(Arrays.asList(layerIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeLayersRequest build() {
            return new DescribeLayersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
