/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeRdsDbInstances</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRdsDbInstancesResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeRdsDbInstancesResponse.Builder, DescribeRdsDbInstancesResponse> {
    private static final SdkField<List<RdsDbInstance>> RDS_DB_INSTANCES_FIELD = SdkField
            .<List<RdsDbInstance>> builder(MarshallingType.LIST)
            .memberName("RdsDbInstances")
            .getter(getter(DescribeRdsDbInstancesResponse::rdsDbInstances))
            .setter(setter(Builder::rdsDbInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsDbInstances").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RdsDbInstance> builder(MarshallingType.SDK_POJO)
                                            .constructor(RdsDbInstance::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RDS_DB_INSTANCES_FIELD));

    private final List<RdsDbInstance> rdsDbInstances;

    private DescribeRdsDbInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.rdsDbInstances = builder.rdsDbInstances;
    }

    /**
     * For responses, this returns true if the service returned a value for the RdsDbInstances property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRdsDbInstances() {
        return rdsDbInstances != null && !(rdsDbInstances instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An a array of <code>RdsDbInstance</code> objects that describe the instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRdsDbInstances} method.
     * </p>
     * 
     * @return An a array of <code>RdsDbInstance</code> objects that describe the instances.
     */
    public final List<RdsDbInstance> rdsDbInstances() {
        return rdsDbInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRdsDbInstances() ? rdsDbInstances() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRdsDbInstancesResponse)) {
            return false;
        }
        DescribeRdsDbInstancesResponse other = (DescribeRdsDbInstancesResponse) obj;
        return hasRdsDbInstances() == other.hasRdsDbInstances() && Objects.equals(rdsDbInstances(), other.rdsDbInstances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRdsDbInstancesResponse")
                .add("RdsDbInstances", hasRdsDbInstances() ? rdsDbInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RdsDbInstances":
            return Optional.ofNullable(clazz.cast(rdsDbInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeRdsDbInstancesResponse, T> g) {
        return obj -> g.apply((DescribeRdsDbInstancesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRdsDbInstancesResponse> {
        /**
         * <p>
         * An a array of <code>RdsDbInstance</code> objects that describe the instances.
         * </p>
         * 
         * @param rdsDbInstances
         *        An a array of <code>RdsDbInstance</code> objects that describe the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbInstances(Collection<RdsDbInstance> rdsDbInstances);

        /**
         * <p>
         * An a array of <code>RdsDbInstance</code> objects that describe the instances.
         * </p>
         * 
         * @param rdsDbInstances
         *        An a array of <code>RdsDbInstance</code> objects that describe the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbInstances(RdsDbInstance... rdsDbInstances);

        /**
         * <p>
         * An a array of <code>RdsDbInstance</code> objects that describe the instances.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<RdsDbInstance>.Builder} avoiding the
         * need to create one manually via {@link List<RdsDbInstance>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RdsDbInstance>.Builder#build()} is called immediately and
         * its result is passed to {@link #rdsDbInstances(List<RdsDbInstance>)}.
         * 
         * @param rdsDbInstances
         *        a consumer that will call methods on {@link List<RdsDbInstance>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rdsDbInstances(List<RdsDbInstance>)
         */
        Builder rdsDbInstances(Consumer<RdsDbInstance.Builder>... rdsDbInstances);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<RdsDbInstance> rdsDbInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRdsDbInstancesResponse model) {
            super(model);
            rdsDbInstances(model.rdsDbInstances);
        }

        public final List<RdsDbInstance.Builder> getRdsDbInstances() {
            List<RdsDbInstance.Builder> result = RdsDbInstancesCopier.copyToBuilder(this.rdsDbInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRdsDbInstances(Collection<RdsDbInstance.BuilderImpl> rdsDbInstances) {
            this.rdsDbInstances = RdsDbInstancesCopier.copyFromBuilder(rdsDbInstances);
        }

        @Override
        public final Builder rdsDbInstances(Collection<RdsDbInstance> rdsDbInstances) {
            this.rdsDbInstances = RdsDbInstancesCopier.copy(rdsDbInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rdsDbInstances(RdsDbInstance... rdsDbInstances) {
            rdsDbInstances(Arrays.asList(rdsDbInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rdsDbInstances(Consumer<RdsDbInstance.Builder>... rdsDbInstances) {
            rdsDbInstances(Stream.of(rdsDbInstances).map(c -> RdsDbInstance.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeRdsDbInstancesResponse build() {
            return new DescribeRdsDbInstancesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
