/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribePermissions</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePermissionsResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribePermissionsResponse.Builder, DescribePermissionsResponse> {
    private static final SdkField<List<Permission>> PERMISSIONS_FIELD = SdkField
            .<List<Permission>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(DescribePermissionsResponse::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Permission> builder(MarshallingType.SDK_POJO)
                                            .constructor(Permission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERMISSIONS_FIELD));

    private final List<Permission> permissions;

    private DescribePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.permissions = builder.permissions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Permission</code> objects that describe the stack permissions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If the request object contains only a stack ID, the array contains a <code>Permission</code> object with
     * permissions for each of the stack IAM ARNs.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object with
     * permissions for each of the user's stack IDs.
     * </p>
     * </li>
     * <li>
     * <p>
     * If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code> object
     * with permissions for the specified stack and IAM ARN.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return An array of <code>Permission</code> objects that describe the stack permissions.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If the request object contains only a stack ID, the array contains a <code>Permission</code> object with
     *         permissions for each of the stack IAM ARNs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object with
     *         permissions for each of the user's stack IDs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code>
     *         object with permissions for the specified stack and IAM ARN.
     *         </p>
     *         </li>
     */
    public final List<Permission> permissions() {
        return permissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePermissionsResponse)) {
            return false;
        }
        DescribePermissionsResponse other = (DescribePermissionsResponse) obj;
        return hasPermissions() == other.hasPermissions() && Objects.equals(permissions(), other.permissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePermissionsResponse").add("Permissions", hasPermissions() ? permissions() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePermissionsResponse, T> g) {
        return obj -> g.apply((DescribePermissionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePermissionsResponse> {
        /**
         * <p>
         * An array of <code>Permission</code> objects that describe the stack permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the request object contains only a stack ID, the array contains a <code>Permission</code> object with
         * permissions for each of the stack IAM ARNs.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object with
         * permissions for each of the user's stack IDs.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code> object
         * with permissions for the specified stack and IAM ARN.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permissions
         *        An array of <code>Permission</code> objects that describe the stack permissions.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the request object contains only a stack ID, the array contains a <code>Permission</code> object
         *        with permissions for each of the stack IAM ARNs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object
         *        with permissions for each of the user's stack IDs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code>
         *        object with permissions for the specified stack and IAM ARN.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<Permission> permissions);

        /**
         * <p>
         * An array of <code>Permission</code> objects that describe the stack permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the request object contains only a stack ID, the array contains a <code>Permission</code> object with
         * permissions for each of the stack IAM ARNs.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object with
         * permissions for each of the user's stack IDs.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code> object
         * with permissions for the specified stack and IAM ARN.
         * </p>
         * </li>
         * </ul>
         * 
         * @param permissions
         *        An array of <code>Permission</code> objects that describe the stack permissions.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If the request object contains only a stack ID, the array contains a <code>Permission</code> object
         *        with permissions for each of the stack IAM ARNs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object
         *        with permissions for each of the user's stack IDs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code>
         *        object with permissions for the specified stack and IAM ARN.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Permission... permissions);

        /**
         * <p>
         * An array of <code>Permission</code> objects that describe the stack permissions.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If the request object contains only a stack ID, the array contains a <code>Permission</code> object with
         * permissions for each of the stack IAM ARNs.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the request object contains only an IAM ARN, the array contains a <code>Permission</code> object with
         * permissions for each of the user's stack IDs.
         * </p>
         * </li>
         * <li>
         * <p>
         * If the request contains a stack ID and an IAM ARN, the array contains a single <code>Permission</code> object
         * with permissions for the specified stack and IAM ARN.
         * </p>
         * </li>
         * </ul>
         * This is a convenience method that creates an instance of the {@link List<Permission>.Builder} avoiding the
         * need to create one manually via {@link List<Permission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Permission>.Builder#build()} is called immediately and its
         * result is passed to {@link #permissions(List<Permission>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on {@link List<Permission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(List<Permission>)
         */
        Builder permissions(Consumer<Permission.Builder>... permissions);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<Permission> permissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePermissionsResponse model) {
            super(model);
            permissions(model.permissions);
        }

        public final List<Permission.Builder> getPermissions() {
            List<Permission.Builder> result = PermissionsCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<Permission.BuilderImpl> permissions) {
            this.permissions = PermissionsCopier.copyFromBuilder(permissions);
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionsCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<Permission.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> Permission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribePermissionsResponse build() {
            return new DescribePermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
