/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.opsworks.OpsWorksAsyncClient;
import software.amazon.awssdk.services.opsworks.model.DescribeEcsClustersRequest;
import software.amazon.awssdk.services.opsworks.model.DescribeEcsClustersResponse;
import software.amazon.awssdk.services.opsworks.model.EcsCluster;

public class DescribeEcsClustersPublisher
implements SdkPublisher<DescribeEcsClustersResponse> {
    private final OpsWorksAsyncClient client;
    private final DescribeEcsClustersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeEcsClustersPublisher(OpsWorksAsyncClient client, DescribeEcsClustersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeEcsClustersPublisher(OpsWorksAsyncClient client, DescribeEcsClustersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeEcsClustersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeEcsClustersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EcsCluster> ecsClusters() {
        Function<DescribeEcsClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.ecsClusters() != null) {
                return response.ecsClusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeEcsClustersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeEcsClustersResponseFetcher
    implements AsyncPageFetcher<DescribeEcsClustersResponse> {
        private DescribeEcsClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeEcsClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeEcsClustersResponse> nextPage(DescribeEcsClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeEcsClustersPublisher.this.client.describeEcsClusters(DescribeEcsClustersPublisher.this.firstRequest);
            }
            return DescribeEcsClustersPublisher.this.client.describeEcsClusters((DescribeEcsClustersRequest)((Object)DescribeEcsClustersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

