/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Instance implements SdkPojo, Serializable, ToCopyableBuilder<Instance.Builder, Instance> {
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentVersion").getter(getter(Instance::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersion").build()).build();

    private static final SdkField<String> AMI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AmiId")
            .getter(getter(Instance::amiId)).setter(setter(Builder::amiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiId").build()).build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Architecture").getter(getter(Instance::architectureAsString)).setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Instance::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> AUTO_SCALING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingType").getter(getter(Instance::autoScalingTypeAsString))
            .setter(setter(Builder::autoScalingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingType").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(Instance::availabilityZone)).setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<BlockDeviceMapping>> builder(MarshallingType.LIST)
            .memberName("BlockDeviceMappings")
            .getter(getter(Instance::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedAt").getter(getter(Instance::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimized").getter(getter(Instance::ebsOptimized)).setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").build()).build();

    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ec2InstanceId").getter(getter(Instance::ec2InstanceId)).setter(setter(Builder::ec2InstanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2InstanceId").build()).build();

    private static final SdkField<String> ECS_CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EcsClusterArn").getter(getter(Instance::ecsClusterArn)).setter(setter(Builder::ecsClusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EcsClusterArn").build()).build();

    private static final SdkField<String> ECS_CONTAINER_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EcsContainerInstanceArn").getter(getter(Instance::ecsContainerInstanceArn))
            .setter(setter(Builder::ecsContainerInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EcsContainerInstanceArn").build())
            .build();

    private static final SdkField<String> ELASTIC_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ElasticIp").getter(getter(Instance::elasticIp)).setter(setter(Builder::elasticIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticIp").build()).build();

    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Hostname").getter(getter(Instance::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hostname").build()).build();

    private static final SdkField<String> INFRASTRUCTURE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InfrastructureClass").getter(getter(Instance::infrastructureClass))
            .setter(setter(Builder::infrastructureClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfrastructureClass").build())
            .build();

    private static final SdkField<Boolean> INSTALL_UPDATES_ON_BOOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InstallUpdatesOnBoot").getter(getter(Instance::installUpdatesOnBoot))
            .setter(setter(Builder::installUpdatesOnBoot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstallUpdatesOnBoot").build())
            .build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(Instance::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> INSTANCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceProfileArn").getter(getter(Instance::instanceProfileArn))
            .setter(setter(Builder::instanceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileArn").build())
            .build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(Instance::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> LAST_SERVICE_ERROR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastServiceErrorId").getter(getter(Instance::lastServiceErrorId))
            .setter(setter(Builder::lastServiceErrorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastServiceErrorId").build())
            .build();

    private static final SdkField<List<String>> LAYER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LayerIds")
            .getter(getter(Instance::layerIds))
            .setter(setter(Builder::layerIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Os")
            .getter(getter(Instance::os)).setter(setter(Builder::os))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Os").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Platform").getter(getter(Instance::platform)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()).build();

    private static final SdkField<String> PRIVATE_DNS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateDns").getter(getter(Instance::privateDns)).setter(setter(Builder::privateDns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateDns").build()).build();

    private static final SdkField<String> PRIVATE_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrivateIp").getter(getter(Instance::privateIp)).setter(setter(Builder::privateIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIp").build()).build();

    private static final SdkField<String> PUBLIC_DNS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicDns").getter(getter(Instance::publicDns)).setter(setter(Builder::publicDns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicDns").build()).build();

    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicIp").getter(getter(Instance::publicIp)).setter(setter(Builder::publicIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp").build()).build();

    private static final SdkField<String> REGISTERED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegisteredBy").getter(getter(Instance::registeredBy)).setter(setter(Builder::registeredBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredBy").build()).build();

    private static final SdkField<String> REPORTED_AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReportedAgentVersion").getter(getter(Instance::reportedAgentVersion))
            .setter(setter(Builder::reportedAgentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportedAgentVersion").build())
            .build();

    private static final SdkField<ReportedOs> REPORTED_OS_FIELD = SdkField.<ReportedOs> builder(MarshallingType.SDK_POJO)
            .memberName("ReportedOs").getter(getter(Instance::reportedOs)).setter(setter(Builder::reportedOs))
            .constructor(ReportedOs::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportedOs").build()).build();

    private static final SdkField<String> ROOT_DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RootDeviceType").getter(getter(Instance::rootDeviceTypeAsString))
            .setter(setter(Builder::rootDeviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDeviceType").build()).build();

    private static final SdkField<String> ROOT_DEVICE_VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RootDeviceVolumeId").getter(getter(Instance::rootDeviceVolumeId))
            .setter(setter(Builder::rootDeviceVolumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDeviceVolumeId").build())
            .build();

    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SecurityGroupIds")
            .getter(getter(Instance::securityGroupIds))
            .setter(setter(Builder::securityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SSH_HOST_DSA_KEY_FINGERPRINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SshHostDsaKeyFingerprint").getter(getter(Instance::sshHostDsaKeyFingerprint))
            .setter(setter(Builder::sshHostDsaKeyFingerprint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshHostDsaKeyFingerprint").build())
            .build();

    private static final SdkField<String> SSH_HOST_RSA_KEY_FINGERPRINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SshHostRsaKeyFingerprint").getter(getter(Instance::sshHostRsaKeyFingerprint))
            .setter(setter(Builder::sshHostRsaKeyFingerprint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshHostRsaKeyFingerprint").build())
            .build();

    private static final SdkField<String> SSH_KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SshKeyName").getter(getter(Instance::sshKeyName)).setter(setter(Builder::sshKeyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshKeyName").build()).build();

    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackId").getter(getter(Instance::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(Instance::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(Instance::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> TENANCY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tenancy")
            .getter(getter(Instance::tenancy)).setter(setter(Builder::tenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").build()).build();

    private static final SdkField<String> VIRTUALIZATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VirtualizationType").getter(getter(Instance::virtualizationTypeAsString))
            .setter(setter(Builder::virtualizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualizationType").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_VERSION_FIELD,
            AMI_ID_FIELD, ARCHITECTURE_FIELD, ARN_FIELD, AUTO_SCALING_TYPE_FIELD, AVAILABILITY_ZONE_FIELD,
            BLOCK_DEVICE_MAPPINGS_FIELD, CREATED_AT_FIELD, EBS_OPTIMIZED_FIELD, EC2_INSTANCE_ID_FIELD, ECS_CLUSTER_ARN_FIELD,
            ECS_CONTAINER_INSTANCE_ARN_FIELD, ELASTIC_IP_FIELD, HOSTNAME_FIELD, INFRASTRUCTURE_CLASS_FIELD,
            INSTALL_UPDATES_ON_BOOT_FIELD, INSTANCE_ID_FIELD, INSTANCE_PROFILE_ARN_FIELD, INSTANCE_TYPE_FIELD,
            LAST_SERVICE_ERROR_ID_FIELD, LAYER_IDS_FIELD, OS_FIELD, PLATFORM_FIELD, PRIVATE_DNS_FIELD, PRIVATE_IP_FIELD,
            PUBLIC_DNS_FIELD, PUBLIC_IP_FIELD, REGISTERED_BY_FIELD, REPORTED_AGENT_VERSION_FIELD, REPORTED_OS_FIELD,
            ROOT_DEVICE_TYPE_FIELD, ROOT_DEVICE_VOLUME_ID_FIELD, SECURITY_GROUP_IDS_FIELD, SSH_HOST_DSA_KEY_FINGERPRINT_FIELD,
            SSH_HOST_RSA_KEY_FINGERPRINT_FIELD, SSH_KEY_NAME_FIELD, STACK_ID_FIELD, STATUS_FIELD, SUBNET_ID_FIELD, TENANCY_FIELD,
            VIRTUALIZATION_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String agentVersion;

    private final String amiId;

    private final String architecture;

    private final String arn;

    private final String autoScalingType;

    private final String availabilityZone;

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final String createdAt;

    private final Boolean ebsOptimized;

    private final String ec2InstanceId;

    private final String ecsClusterArn;

    private final String ecsContainerInstanceArn;

    private final String elasticIp;

    private final String hostname;

    private final String infrastructureClass;

    private final Boolean installUpdatesOnBoot;

    private final String instanceId;

    private final String instanceProfileArn;

    private final String instanceType;

    private final String lastServiceErrorId;

    private final List<String> layerIds;

    private final String os;

    private final String platform;

    private final String privateDns;

    private final String privateIp;

    private final String publicDns;

    private final String publicIp;

    private final String registeredBy;

    private final String reportedAgentVersion;

    private final ReportedOs reportedOs;

    private final String rootDeviceType;

    private final String rootDeviceVolumeId;

    private final List<String> securityGroupIds;

    private final String sshHostDsaKeyFingerprint;

    private final String sshHostRsaKeyFingerprint;

    private final String sshKeyName;

    private final String stackId;

    private final String status;

    private final String subnetId;

    private final String tenancy;

    private final String virtualizationType;

    private Instance(BuilderImpl builder) {
        this.agentVersion = builder.agentVersion;
        this.amiId = builder.amiId;
        this.architecture = builder.architecture;
        this.arn = builder.arn;
        this.autoScalingType = builder.autoScalingType;
        this.availabilityZone = builder.availabilityZone;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.createdAt = builder.createdAt;
        this.ebsOptimized = builder.ebsOptimized;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.ecsClusterArn = builder.ecsClusterArn;
        this.ecsContainerInstanceArn = builder.ecsContainerInstanceArn;
        this.elasticIp = builder.elasticIp;
        this.hostname = builder.hostname;
        this.infrastructureClass = builder.infrastructureClass;
        this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
        this.instanceId = builder.instanceId;
        this.instanceProfileArn = builder.instanceProfileArn;
        this.instanceType = builder.instanceType;
        this.lastServiceErrorId = builder.lastServiceErrorId;
        this.layerIds = builder.layerIds;
        this.os = builder.os;
        this.platform = builder.platform;
        this.privateDns = builder.privateDns;
        this.privateIp = builder.privateIp;
        this.publicDns = builder.publicDns;
        this.publicIp = builder.publicIp;
        this.registeredBy = builder.registeredBy;
        this.reportedAgentVersion = builder.reportedAgentVersion;
        this.reportedOs = builder.reportedOs;
        this.rootDeviceType = builder.rootDeviceType;
        this.rootDeviceVolumeId = builder.rootDeviceVolumeId;
        this.securityGroupIds = builder.securityGroupIds;
        this.sshHostDsaKeyFingerprint = builder.sshHostDsaKeyFingerprint;
        this.sshHostRsaKeyFingerprint = builder.sshHostRsaKeyFingerprint;
        this.sshKeyName = builder.sshKeyName;
        this.stackId = builder.stackId;
        this.status = builder.status;
        this.subnetId = builder.subnetId;
        this.tenancy = builder.tenancy;
        this.virtualizationType = builder.virtualizationType;
    }

    /**
     * <p>
     * The agent version. This parameter is set to <code>INHERIT</code> if the instance inherits the default stack
     * setting or to a a version number for a fixed agent version.
     * </p>
     * 
     * @return The agent version. This parameter is set to <code>INHERIT</code> if the instance inherits the default
     *         stack setting or to a a version number for a fixed agent version.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * <p>
     * A custom AMI ID to be used to create the instance. For more information, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Instances</a>
     * </p>
     * 
     * @return A custom AMI ID to be used to create the instance. For more information, see <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html"
     *         >Instances</a>
     */
    public final String amiId() {
        return amiId;
    }

    /**
     * <p>
     * The instance architecture: "i386" or "x86_64".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The instance architecture: "i386" or "x86_64".
     * @see Architecture
     */
    public final Architecture architecture() {
        return Architecture.fromValue(architecture);
    }

    /**
     * <p>
     * The instance architecture: "i386" or "x86_64".
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The instance architecture: "i386" or "x86_64".
     * @see Architecture
     */
    public final String architectureAsString() {
        return architecture;
    }

    /**
     * <p>
     * The instance's Amazon Resource Number (ARN).
     * </p>
     * 
     * @return The instance's Amazon Resource Number (ARN).
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * For load-based or time-based instances, the type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoScalingType}
     * will return {@link AutoScalingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoScalingTypeAsString}.
     * </p>
     * 
     * @return For load-based or time-based instances, the type.
     * @see AutoScalingType
     */
    public final AutoScalingType autoScalingType() {
        return AutoScalingType.fromValue(autoScalingType);
    }

    /**
     * <p>
     * For load-based or time-based instances, the type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoScalingType}
     * will return {@link AutoScalingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoScalingTypeAsString}.
     * </p>
     * 
     * @return For load-based or time-based instances, the type.
     * @see AutoScalingType
     */
    public final String autoScalingTypeAsString() {
        return autoScalingType;
    }

    /**
     * <p>
     * The instance Availability Zone. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     * </p>
     * 
     * @return The instance Availability Zone. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockDeviceMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>BlockDeviceMapping</code> objects that specify the instance's block device mappings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockDeviceMappings} method.
     * </p>
     * 
     * @return An array of <code>BlockDeviceMapping</code> objects that specify the instance's block device mappings.
     */
    public final List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * The time that the instance was created.
     * </p>
     * 
     * @return The time that the instance was created.
     */
    public final String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Whether this is an Amazon EBS-optimized instance.
     * </p>
     * 
     * @return Whether this is an Amazon EBS-optimized instance.
     */
    public final Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The ID of the associated Amazon EC2 instance.
     * </p>
     * 
     * @return The ID of the associated Amazon EC2 instance.
     */
    public final String ec2InstanceId() {
        return ec2InstanceId;
    }

    /**
     * <p>
     * For container instances, the Amazon ECS cluster's ARN.
     * </p>
     * 
     * @return For container instances, the Amazon ECS cluster's ARN.
     */
    public final String ecsClusterArn() {
        return ecsClusterArn;
    }

    /**
     * <p>
     * For container instances, the instance's ARN.
     * </p>
     * 
     * @return For container instances, the instance's ARN.
     */
    public final String ecsContainerInstanceArn() {
        return ecsContainerInstanceArn;
    }

    /**
     * <p>
     * The instance <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic
     * IP address </a>.
     * </p>
     * 
     * @return The instance <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
     *         address </a>.
     */
    public final String elasticIp() {
        return elasticIp;
    }

    /**
     * <p>
     * The instance host name.
     * </p>
     * 
     * @return The instance host name.
     */
    public final String hostname() {
        return hostname;
    }

    /**
     * <p>
     * For registered instances, the infrastructure class: <code>ec2</code> or <code>on-premises</code>.
     * </p>
     * 
     * @return For registered instances, the infrastructure class: <code>ec2</code> or <code>on-premises</code>.
     */
    public final String infrastructureClass() {
        return infrastructureClass;
    }

    /**
     * <p>
     * Whether to install operating system and package updates when the instance boots. The default value is
     * <code>true</code>. If this value is set to <code>false</code>, you must then update your instances manually by
     * using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by manually running
     * <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
     * </p>
     * <note>
     * <p>
     * We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the latest
     * security updates.
     * </p>
     * </note>
     * 
     * @return Whether to install operating system and package updates when the instance boots. The default value is
     *         <code>true</code>. If this value is set to <code>false</code>, you must then update your instances
     *         manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by
     *         manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p>
     *         <note>
     *         <p>
     *         We strongly recommend using the default value of <code>true</code>, to ensure that your instances have
     *         the latest security updates.
     *         </p>
     */
    public final Boolean installUpdatesOnBoot() {
        return installUpdatesOnBoot;
    }

    /**
     * <p>
     * The instance ID.
     * </p>
     * 
     * @return The instance ID.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The ARN of the instance's IAM profile. For more information about IAM ARNs, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     * </p>
     * 
     * @return The ARN of the instance's IAM profile. For more information about IAM ARNs, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     */
    public final String instanceProfileArn() {
        return instanceProfileArn;
    }

    /**
     * <p>
     * The instance type, such as <code>t2.micro</code>.
     * </p>
     * 
     * @return The instance type, such as <code>t2.micro</code>.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the last service error. For more information, call <a>DescribeServiceErrors</a>.
     * </p>
     * 
     * @return The ID of the last service error. For more information, call <a>DescribeServiceErrors</a>.
     */
    public final String lastServiceErrorId() {
        return lastServiceErrorId;
    }

    /**
     * For responses, this returns true if the service returned a value for the LayerIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLayerIds() {
        return layerIds != null && !(layerIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing the instance layer IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLayerIds} method.
     * </p>
     * 
     * @return An array containing the instance layer IDs.
     */
    public final List<String> layerIds() {
        return layerIds;
    }

    /**
     * <p>
     * The instance's operating system.
     * </p>
     * 
     * @return The instance's operating system.
     */
    public final String os() {
        return os;
    }

    /**
     * <p>
     * The instance's platform.
     * </p>
     * 
     * @return The instance's platform.
     */
    public final String platform() {
        return platform;
    }

    /**
     * <p>
     * The instance's private DNS name.
     * </p>
     * 
     * @return The instance's private DNS name.
     */
    public final String privateDns() {
        return privateDns;
    }

    /**
     * <p>
     * The instance's private IP address.
     * </p>
     * 
     * @return The instance's private IP address.
     */
    public final String privateIp() {
        return privateIp;
    }

    /**
     * <p>
     * The instance public DNS name.
     * </p>
     * 
     * @return The instance public DNS name.
     */
    public final String publicDns() {
        return publicDns;
    }

    /**
     * <p>
     * The instance public IP address.
     * </p>
     * 
     * @return The instance public IP address.
     */
    public final String publicIp() {
        return publicIp;
    }

    /**
     * <p>
     * For registered instances, who performed the registration.
     * </p>
     * 
     * @return For registered instances, who performed the registration.
     */
    public final String registeredBy() {
        return registeredBy;
    }

    /**
     * <p>
     * The instance's reported AWS OpsWorks Stacks agent version.
     * </p>
     * 
     * @return The instance's reported AWS OpsWorks Stacks agent version.
     */
    public final String reportedAgentVersion() {
        return reportedAgentVersion;
    }

    /**
     * <p>
     * For registered instances, the reported operating system.
     * </p>
     * 
     * @return For registered instances, the reported operating system.
     */
    public final ReportedOs reportedOs() {
        return reportedOs;
    }

    /**
     * <p>
     * The instance's root device type. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
     * >Storage for the Root Device</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootDeviceType}
     * will return {@link RootDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rootDeviceTypeAsString}.
     * </p>
     * 
     * @return The instance's root device type. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
     *         >Storage for the Root Device</a>.
     * @see RootDeviceType
     */
    public final RootDeviceType rootDeviceType() {
        return RootDeviceType.fromValue(rootDeviceType);
    }

    /**
     * <p>
     * The instance's root device type. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
     * >Storage for the Root Device</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootDeviceType}
     * will return {@link RootDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rootDeviceTypeAsString}.
     * </p>
     * 
     * @return The instance's root device type. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
     *         >Storage for the Root Device</a>.
     * @see RootDeviceType
     */
    public final String rootDeviceTypeAsString() {
        return rootDeviceType;
    }

    /**
     * <p>
     * The root device volume ID.
     * </p>
     * 
     * @return The root device volume ID.
     */
    public final String rootDeviceVolumeId() {
        return rootDeviceVolumeId;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityGroupIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSecurityGroupIds() {
        return securityGroupIds != null && !(securityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing the instance security group IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityGroupIds} method.
     * </p>
     * 
     * @return An array containing the instance security group IDs.
     */
    public final List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The SSH key's Deep Security Agent (DSA) fingerprint.
     * </p>
     * 
     * @return The SSH key's Deep Security Agent (DSA) fingerprint.
     */
    public final String sshHostDsaKeyFingerprint() {
        return sshHostDsaKeyFingerprint;
    }

    /**
     * <p>
     * The SSH key's RSA fingerprint.
     * </p>
     * 
     * @return The SSH key's RSA fingerprint.
     */
    public final String sshHostRsaKeyFingerprint() {
        return sshHostRsaKeyFingerprint;
    }

    /**
     * <p>
     * The instance's Amazon EC2 key-pair name.
     * </p>
     * 
     * @return The instance's Amazon EC2 key-pair name.
     */
    public final String sshKeyName() {
        return sshKeyName;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public final String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The instance status:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>booting</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>connection_lost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>online</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rebooting</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requested</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>running_setup</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>setup_failed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>shutting_down</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>start_failed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stop_failed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stopped</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stopping</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>terminated</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>terminating</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The instance status:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>booting</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>connection_lost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>online</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rebooting</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requested</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>running_setup</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>setup_failed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>shutting_down</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>start_failed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stop_failed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stopped</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stopping</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>terminated</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>terminating</code>
     *         </p>
     *         </li>
     */
    public final String status() {
        return status;
    }

    /**
     * <p>
     * The instance's subnet ID; applicable only if the stack is running in a VPC.
     * </p>
     * 
     * @return The instance's subnet ID; applicable only if the stack is running in a VPC.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The instance's tenancy option, such as <code>dedicated</code> or <code>host</code>.
     * </p>
     * 
     * @return The instance's tenancy option, such as <code>dedicated</code> or <code>host</code>.
     */
    public final String tenancy() {
        return tenancy;
    }

    /**
     * <p>
     * The instance's virtualization type: <code>paravirtual</code> or <code>hvm</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #virtualizationType} will return {@link VirtualizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #virtualizationTypeAsString}.
     * </p>
     * 
     * @return The instance's virtualization type: <code>paravirtual</code> or <code>hvm</code>.
     * @see VirtualizationType
     */
    public final VirtualizationType virtualizationType() {
        return VirtualizationType.fromValue(virtualizationType);
    }

    /**
     * <p>
     * The instance's virtualization type: <code>paravirtual</code> or <code>hvm</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #virtualizationType} will return {@link VirtualizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #virtualizationTypeAsString}.
     * </p>
     * 
     * @return The instance's virtualization type: <code>paravirtual</code> or <code>hvm</code>.
     * @see VirtualizationType
     */
    public final String virtualizationTypeAsString() {
        return virtualizationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(amiId());
        hashCode = 31 * hashCode + Objects.hashCode(architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappings() ? blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceId());
        hashCode = 31 * hashCode + Objects.hashCode(ecsClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(ecsContainerInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(elasticIp());
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(infrastructureClass());
        hashCode = 31 * hashCode + Objects.hashCode(installUpdatesOnBoot());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(lastServiceErrorId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLayerIds() ? layerIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(os());
        hashCode = 31 * hashCode + Objects.hashCode(platform());
        hashCode = 31 * hashCode + Objects.hashCode(privateDns());
        hashCode = 31 * hashCode + Objects.hashCode(privateIp());
        hashCode = 31 * hashCode + Objects.hashCode(publicDns());
        hashCode = 31 * hashCode + Objects.hashCode(publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(registeredBy());
        hashCode = 31 * hashCode + Objects.hashCode(reportedAgentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(reportedOs());
        hashCode = 31 * hashCode + Objects.hashCode(rootDeviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rootDeviceVolumeId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityGroupIds() ? securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sshHostDsaKeyFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(sshHostRsaKeyFingerprint());
        hashCode = 31 * hashCode + Objects.hashCode(sshKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(tenancy());
        hashCode = 31 * hashCode + Objects.hashCode(virtualizationTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance) obj;
        return Objects.equals(agentVersion(), other.agentVersion()) && Objects.equals(amiId(), other.amiId())
                && Objects.equals(architectureAsString(), other.architectureAsString()) && Objects.equals(arn(), other.arn())
                && Objects.equals(autoScalingTypeAsString(), other.autoScalingTypeAsString())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && hasBlockDeviceMappings() == other.hasBlockDeviceMappings()
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(ebsOptimized(), other.ebsOptimized())
                && Objects.equals(ec2InstanceId(), other.ec2InstanceId())
                && Objects.equals(ecsClusterArn(), other.ecsClusterArn())
                && Objects.equals(ecsContainerInstanceArn(), other.ecsContainerInstanceArn())
                && Objects.equals(elasticIp(), other.elasticIp()) && Objects.equals(hostname(), other.hostname())
                && Objects.equals(infrastructureClass(), other.infrastructureClass())
                && Objects.equals(installUpdatesOnBoot(), other.installUpdatesOnBoot())
                && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(instanceProfileArn(), other.instanceProfileArn())
                && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(lastServiceErrorId(), other.lastServiceErrorId()) && hasLayerIds() == other.hasLayerIds()
                && Objects.equals(layerIds(), other.layerIds()) && Objects.equals(os(), other.os())
                && Objects.equals(platform(), other.platform()) && Objects.equals(privateDns(), other.privateDns())
                && Objects.equals(privateIp(), other.privateIp()) && Objects.equals(publicDns(), other.publicDns())
                && Objects.equals(publicIp(), other.publicIp()) && Objects.equals(registeredBy(), other.registeredBy())
                && Objects.equals(reportedAgentVersion(), other.reportedAgentVersion())
                && Objects.equals(reportedOs(), other.reportedOs())
                && Objects.equals(rootDeviceTypeAsString(), other.rootDeviceTypeAsString())
                && Objects.equals(rootDeviceVolumeId(), other.rootDeviceVolumeId())
                && hasSecurityGroupIds() == other.hasSecurityGroupIds()
                && Objects.equals(securityGroupIds(), other.securityGroupIds())
                && Objects.equals(sshHostDsaKeyFingerprint(), other.sshHostDsaKeyFingerprint())
                && Objects.equals(sshHostRsaKeyFingerprint(), other.sshHostRsaKeyFingerprint())
                && Objects.equals(sshKeyName(), other.sshKeyName()) && Objects.equals(stackId(), other.stackId())
                && Objects.equals(status(), other.status()) && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(tenancy(), other.tenancy())
                && Objects.equals(virtualizationTypeAsString(), other.virtualizationTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Instance").add("AgentVersion", agentVersion()).add("AmiId", amiId())
                .add("Architecture", architectureAsString()).add("Arn", arn()).add("AutoScalingType", autoScalingTypeAsString())
                .add("AvailabilityZone", availabilityZone())
                .add("BlockDeviceMappings", hasBlockDeviceMappings() ? blockDeviceMappings() : null)
                .add("CreatedAt", createdAt()).add("EbsOptimized", ebsOptimized()).add("Ec2InstanceId", ec2InstanceId())
                .add("EcsClusterArn", ecsClusterArn()).add("EcsContainerInstanceArn", ecsContainerInstanceArn())
                .add("ElasticIp", elasticIp()).add("Hostname", hostname()).add("InfrastructureClass", infrastructureClass())
                .add("InstallUpdatesOnBoot", installUpdatesOnBoot()).add("InstanceId", instanceId())
                .add("InstanceProfileArn", instanceProfileArn()).add("InstanceType", instanceType())
                .add("LastServiceErrorId", lastServiceErrorId()).add("LayerIds", hasLayerIds() ? layerIds() : null)
                .add("Os", os()).add("Platform", platform()).add("PrivateDns", privateDns()).add("PrivateIp", privateIp())
                .add("PublicDns", publicDns()).add("PublicIp", publicIp()).add("RegisteredBy", registeredBy())
                .add("ReportedAgentVersion", reportedAgentVersion()).add("ReportedOs", reportedOs())
                .add("RootDeviceType", rootDeviceTypeAsString()).add("RootDeviceVolumeId", rootDeviceVolumeId())
                .add("SecurityGroupIds", hasSecurityGroupIds() ? securityGroupIds() : null)
                .add("SshHostDsaKeyFingerprint", sshHostDsaKeyFingerprint())
                .add("SshHostRsaKeyFingerprint", sshHostRsaKeyFingerprint()).add("SshKeyName", sshKeyName())
                .add("StackId", stackId()).add("Status", status()).add("SubnetId", subnetId()).add("Tenancy", tenancy())
                .add("VirtualizationType", virtualizationTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AgentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "AmiId":
            return Optional.ofNullable(clazz.cast(amiId()));
        case "Architecture":
            return Optional.ofNullable(clazz.cast(architectureAsString()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "AutoScalingType":
            return Optional.ofNullable(clazz.cast(autoScalingTypeAsString()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "Ec2InstanceId":
            return Optional.ofNullable(clazz.cast(ec2InstanceId()));
        case "EcsClusterArn":
            return Optional.ofNullable(clazz.cast(ecsClusterArn()));
        case "EcsContainerInstanceArn":
            return Optional.ofNullable(clazz.cast(ecsContainerInstanceArn()));
        case "ElasticIp":
            return Optional.ofNullable(clazz.cast(elasticIp()));
        case "Hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "InfrastructureClass":
            return Optional.ofNullable(clazz.cast(infrastructureClass()));
        case "InstallUpdatesOnBoot":
            return Optional.ofNullable(clazz.cast(installUpdatesOnBoot()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "InstanceProfileArn":
            return Optional.ofNullable(clazz.cast(instanceProfileArn()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "LastServiceErrorId":
            return Optional.ofNullable(clazz.cast(lastServiceErrorId()));
        case "LayerIds":
            return Optional.ofNullable(clazz.cast(layerIds()));
        case "Os":
            return Optional.ofNullable(clazz.cast(os()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platform()));
        case "PrivateDns":
            return Optional.ofNullable(clazz.cast(privateDns()));
        case "PrivateIp":
            return Optional.ofNullable(clazz.cast(privateIp()));
        case "PublicDns":
            return Optional.ofNullable(clazz.cast(publicDns()));
        case "PublicIp":
            return Optional.ofNullable(clazz.cast(publicIp()));
        case "RegisteredBy":
            return Optional.ofNullable(clazz.cast(registeredBy()));
        case "ReportedAgentVersion":
            return Optional.ofNullable(clazz.cast(reportedAgentVersion()));
        case "ReportedOs":
            return Optional.ofNullable(clazz.cast(reportedOs()));
        case "RootDeviceType":
            return Optional.ofNullable(clazz.cast(rootDeviceTypeAsString()));
        case "RootDeviceVolumeId":
            return Optional.ofNullable(clazz.cast(rootDeviceVolumeId()));
        case "SecurityGroupIds":
            return Optional.ofNullable(clazz.cast(securityGroupIds()));
        case "SshHostDsaKeyFingerprint":
            return Optional.ofNullable(clazz.cast(sshHostDsaKeyFingerprint()));
        case "SshHostRsaKeyFingerprint":
            return Optional.ofNullable(clazz.cast(sshHostRsaKeyFingerprint()));
        case "SshKeyName":
            return Optional.ofNullable(clazz.cast(sshKeyName()));
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "Tenancy":
            return Optional.ofNullable(clazz.cast(tenancy()));
        case "VirtualizationType":
            return Optional.ofNullable(clazz.cast(virtualizationTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Instance, T> g) {
        return obj -> g.apply((Instance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Instance> {
        /**
         * <p>
         * The agent version. This parameter is set to <code>INHERIT</code> if the instance inherits the default stack
         * setting or to a a version number for a fixed agent version.
         * </p>
         * 
         * @param agentVersion
         *        The agent version. This parameter is set to <code>INHERIT</code> if the instance inherits the default
         *        stack setting or to a a version number for a fixed agent version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * A custom AMI ID to be used to create the instance. For more information, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Instances</a>
         * </p>
         * 
         * @param amiId
         *        A custom AMI ID to be used to create the instance. For more information, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html"
         *        >Instances</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiId(String amiId);

        /**
         * <p>
         * The instance architecture: "i386" or "x86_64".
         * </p>
         * 
         * @param architecture
         *        The instance architecture: "i386" or "x86_64".
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The instance architecture: "i386" or "x86_64".
         * </p>
         * 
         * @param architecture
         *        The instance architecture: "i386" or "x86_64".
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(Architecture architecture);

        /**
         * <p>
         * The instance's Amazon Resource Number (ARN).
         * </p>
         * 
         * @param arn
         *        The instance's Amazon Resource Number (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * For load-based or time-based instances, the type.
         * </p>
         * 
         * @param autoScalingType
         *        For load-based or time-based instances, the type.
         * @see AutoScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingType
         */
        Builder autoScalingType(String autoScalingType);

        /**
         * <p>
         * For load-based or time-based instances, the type.
         * </p>
         * 
         * @param autoScalingType
         *        For load-based or time-based instances, the type.
         * @see AutoScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingType
         */
        Builder autoScalingType(AutoScalingType autoScalingType);

        /**
         * <p>
         * The instance Availability Zone. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * </p>
         * 
         * @param availabilityZone
         *        The instance Availability Zone. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * An array of <code>BlockDeviceMapping</code> objects that specify the instance's block device mappings.
         * </p>
         * 
         * @param blockDeviceMappings
         *        An array of <code>BlockDeviceMapping</code> objects that specify the instance's block device mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * An array of <code>BlockDeviceMapping</code> objects that specify the instance's block device mappings.
         * </p>
         * 
         * @param blockDeviceMappings
         *        An array of <code>BlockDeviceMapping</code> objects that specify the instance's block device mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * An array of <code>BlockDeviceMapping</code> objects that specify the instance's block device mappings.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<BlockDeviceMapping>.Builder}
         * avoiding the need to create one manually via {@link List<BlockDeviceMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<BlockDeviceMapping>.Builder#build()} is called immediately
         * and its result is passed to {@link #blockDeviceMappings(List<BlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on {@link List<BlockDeviceMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(List<BlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * The time that the instance was created.
         * </p>
         * 
         * @param createdAt
         *        The time that the instance was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * Whether this is an Amazon EBS-optimized instance.
         * </p>
         * 
         * @param ebsOptimized
         *        Whether this is an Amazon EBS-optimized instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The ID of the associated Amazon EC2 instance.
         * </p>
         * 
         * @param ec2InstanceId
         *        The ID of the associated Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceId(String ec2InstanceId);

        /**
         * <p>
         * For container instances, the Amazon ECS cluster's ARN.
         * </p>
         * 
         * @param ecsClusterArn
         *        For container instances, the Amazon ECS cluster's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsClusterArn(String ecsClusterArn);

        /**
         * <p>
         * For container instances, the instance's ARN.
         * </p>
         * 
         * @param ecsContainerInstanceArn
         *        For container instances, the instance's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsContainerInstanceArn(String ecsContainerInstanceArn);

        /**
         * <p>
         * The instance <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address
         * </a>.
         * </p>
         * 
         * @param elasticIp
         *        The instance <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
         *        address </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticIp(String elasticIp);

        /**
         * <p>
         * The instance host name.
         * </p>
         * 
         * @param hostname
         *        The instance host name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * For registered instances, the infrastructure class: <code>ec2</code> or <code>on-premises</code>.
         * </p>
         * 
         * @param infrastructureClass
         *        For registered instances, the infrastructure class: <code>ec2</code> or <code>on-premises</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infrastructureClass(String infrastructureClass);

        /**
         * <p>
         * Whether to install operating system and package updates when the instance boots. The default value is
         * <code>true</code>. If this value is set to <code>false</code>, you must then update your instances manually
         * by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by manually
         * running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
         * </p>
         * <note>
         * <p>
         * We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the
         * latest security updates.
         * </p>
         * </note>
         * 
         * @param installUpdatesOnBoot
         *        Whether to install operating system and package updates when the instance boots. The default value is
         *        <code>true</code>. If this value is set to <code>false</code>, you must then update your instances
         *        manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or
         *        by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
         *        </p> <note>
         *        <p>
         *        We strongly recommend using the default value of <code>true</code>, to ensure that your instances have
         *        the latest security updates.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot);

        /**
         * <p>
         * The instance ID.
         * </p>
         * 
         * @param instanceId
         *        The instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The ARN of the instance's IAM profile. For more information about IAM ARNs, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * </p>
         * 
         * @param instanceProfileArn
         *        The ARN of the instance's IAM profile. For more information about IAM ARNs, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileArn(String instanceProfileArn);

        /**
         * <p>
         * The instance type, such as <code>t2.micro</code>.
         * </p>
         * 
         * @param instanceType
         *        The instance type, such as <code>t2.micro</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ID of the last service error. For more information, call <a>DescribeServiceErrors</a>.
         * </p>
         * 
         * @param lastServiceErrorId
         *        The ID of the last service error. For more information, call <a>DescribeServiceErrors</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastServiceErrorId(String lastServiceErrorId);

        /**
         * <p>
         * An array containing the instance layer IDs.
         * </p>
         * 
         * @param layerIds
         *        An array containing the instance layer IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerIds(Collection<String> layerIds);

        /**
         * <p>
         * An array containing the instance layer IDs.
         * </p>
         * 
         * @param layerIds
         *        An array containing the instance layer IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerIds(String... layerIds);

        /**
         * <p>
         * The instance's operating system.
         * </p>
         * 
         * @param os
         *        The instance's operating system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder os(String os);

        /**
         * <p>
         * The instance's platform.
         * </p>
         * 
         * @param platform
         *        The instance's platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The instance's private DNS name.
         * </p>
         * 
         * @param privateDns
         *        The instance's private DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDns(String privateDns);

        /**
         * <p>
         * The instance's private IP address.
         * </p>
         * 
         * @param privateIp
         *        The instance's private IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIp(String privateIp);

        /**
         * <p>
         * The instance public DNS name.
         * </p>
         * 
         * @param publicDns
         *        The instance public DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicDns(String publicDns);

        /**
         * <p>
         * The instance public IP address.
         * </p>
         * 
         * @param publicIp
         *        The instance public IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * For registered instances, who performed the registration.
         * </p>
         * 
         * @param registeredBy
         *        For registered instances, who performed the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredBy(String registeredBy);

        /**
         * <p>
         * The instance's reported AWS OpsWorks Stacks agent version.
         * </p>
         * 
         * @param reportedAgentVersion
         *        The instance's reported AWS OpsWorks Stacks agent version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportedAgentVersion(String reportedAgentVersion);

        /**
         * <p>
         * For registered instances, the reported operating system.
         * </p>
         * 
         * @param reportedOs
         *        For registered instances, the reported operating system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportedOs(ReportedOs reportedOs);

        /**
         * <p>
         * For registered instances, the reported operating system.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReportedOs.Builder} avoiding the need to
         * create one manually via {@link ReportedOs#builder()}.
         *
         * When the {@link Consumer} completes, {@link ReportedOs.Builder#build()} is called immediately and its result
         * is passed to {@link #reportedOs(ReportedOs)}.
         * 
         * @param reportedOs
         *        a consumer that will call methods on {@link ReportedOs.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reportedOs(ReportedOs)
         */
        default Builder reportedOs(Consumer<ReportedOs.Builder> reportedOs) {
            return reportedOs(ReportedOs.builder().applyMutation(reportedOs).build());
        }

        /**
         * <p>
         * The instance's root device type. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         * >Storage for the Root Device</a>.
         * </p>
         * 
         * @param rootDeviceType
         *        The instance's root device type. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         *        >Storage for the Root Device</a>.
         * @see RootDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootDeviceType
         */
        Builder rootDeviceType(String rootDeviceType);

        /**
         * <p>
         * The instance's root device type. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         * >Storage for the Root Device</a>.
         * </p>
         * 
         * @param rootDeviceType
         *        The instance's root device type. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         *        >Storage for the Root Device</a>.
         * @see RootDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootDeviceType
         */
        Builder rootDeviceType(RootDeviceType rootDeviceType);

        /**
         * <p>
         * The root device volume ID.
         * </p>
         * 
         * @param rootDeviceVolumeId
         *        The root device volume ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDeviceVolumeId(String rootDeviceVolumeId);

        /**
         * <p>
         * An array containing the instance security group IDs.
         * </p>
         * 
         * @param securityGroupIds
         *        An array containing the instance security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * An array containing the instance security group IDs.
         * </p>
         * 
         * @param securityGroupIds
         *        An array containing the instance security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The SSH key's Deep Security Agent (DSA) fingerprint.
         * </p>
         * 
         * @param sshHostDsaKeyFingerprint
         *        The SSH key's Deep Security Agent (DSA) fingerprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshHostDsaKeyFingerprint(String sshHostDsaKeyFingerprint);

        /**
         * <p>
         * The SSH key's RSA fingerprint.
         * </p>
         * 
         * @param sshHostRsaKeyFingerprint
         *        The SSH key's RSA fingerprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshHostRsaKeyFingerprint(String sshHostRsaKeyFingerprint);

        /**
         * <p>
         * The instance's Amazon EC2 key-pair name.
         * </p>
         * 
         * @param sshKeyName
         *        The instance's Amazon EC2 key-pair name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshKeyName(String sshKeyName);

        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The instance status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>booting</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>connection_lost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>online</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rebooting</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requested</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>running_setup</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>setup_failed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>shutting_down</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start_failed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stop_failed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stopped</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stopping</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>terminated</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>terminating</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The instance status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>booting</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>connection_lost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>online</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rebooting</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requested</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>running_setup</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>setup_failed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>shutting_down</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start_failed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stop_failed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stopped</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stopping</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>terminated</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>terminating</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The instance's subnet ID; applicable only if the stack is running in a VPC.
         * </p>
         * 
         * @param subnetId
         *        The instance's subnet ID; applicable only if the stack is running in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The instance's tenancy option, such as <code>dedicated</code> or <code>host</code>.
         * </p>
         * 
         * @param tenancy
         *        The instance's tenancy option, such as <code>dedicated</code> or <code>host</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * The instance's virtualization type: <code>paravirtual</code> or <code>hvm</code>.
         * </p>
         * 
         * @param virtualizationType
         *        The instance's virtualization type: <code>paravirtual</code> or <code>hvm</code>.
         * @see VirtualizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualizationType
         */
        Builder virtualizationType(String virtualizationType);

        /**
         * <p>
         * The instance's virtualization type: <code>paravirtual</code> or <code>hvm</code>.
         * </p>
         * 
         * @param virtualizationType
         *        The instance's virtualization type: <code>paravirtual</code> or <code>hvm</code>.
         * @see VirtualizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualizationType
         */
        Builder virtualizationType(VirtualizationType virtualizationType);
    }

    static final class BuilderImpl implements Builder {
        private String agentVersion;

        private String amiId;

        private String architecture;

        private String arn;

        private String autoScalingType;

        private String availabilityZone;

        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private String createdAt;

        private Boolean ebsOptimized;

        private String ec2InstanceId;

        private String ecsClusterArn;

        private String ecsContainerInstanceArn;

        private String elasticIp;

        private String hostname;

        private String infrastructureClass;

        private Boolean installUpdatesOnBoot;

        private String instanceId;

        private String instanceProfileArn;

        private String instanceType;

        private String lastServiceErrorId;

        private List<String> layerIds = DefaultSdkAutoConstructList.getInstance();

        private String os;

        private String platform;

        private String privateDns;

        private String privateIp;

        private String publicDns;

        private String publicIp;

        private String registeredBy;

        private String reportedAgentVersion;

        private ReportedOs reportedOs;

        private String rootDeviceType;

        private String rootDeviceVolumeId;

        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String sshHostDsaKeyFingerprint;

        private String sshHostRsaKeyFingerprint;

        private String sshKeyName;

        private String stackId;

        private String status;

        private String subnetId;

        private String tenancy;

        private String virtualizationType;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            agentVersion(model.agentVersion);
            amiId(model.amiId);
            architecture(model.architecture);
            arn(model.arn);
            autoScalingType(model.autoScalingType);
            availabilityZone(model.availabilityZone);
            blockDeviceMappings(model.blockDeviceMappings);
            createdAt(model.createdAt);
            ebsOptimized(model.ebsOptimized);
            ec2InstanceId(model.ec2InstanceId);
            ecsClusterArn(model.ecsClusterArn);
            ecsContainerInstanceArn(model.ecsContainerInstanceArn);
            elasticIp(model.elasticIp);
            hostname(model.hostname);
            infrastructureClass(model.infrastructureClass);
            installUpdatesOnBoot(model.installUpdatesOnBoot);
            instanceId(model.instanceId);
            instanceProfileArn(model.instanceProfileArn);
            instanceType(model.instanceType);
            lastServiceErrorId(model.lastServiceErrorId);
            layerIds(model.layerIds);
            os(model.os);
            platform(model.platform);
            privateDns(model.privateDns);
            privateIp(model.privateIp);
            publicDns(model.publicDns);
            publicIp(model.publicIp);
            registeredBy(model.registeredBy);
            reportedAgentVersion(model.reportedAgentVersion);
            reportedOs(model.reportedOs);
            rootDeviceType(model.rootDeviceType);
            rootDeviceVolumeId(model.rootDeviceVolumeId);
            securityGroupIds(model.securityGroupIds);
            sshHostDsaKeyFingerprint(model.sshHostDsaKeyFingerprint);
            sshHostRsaKeyFingerprint(model.sshHostRsaKeyFingerprint);
            sshKeyName(model.sshKeyName);
            stackId(model.stackId);
            status(model.status);
            subnetId(model.subnetId);
            tenancy(model.tenancy);
            virtualizationType(model.virtualizationType);
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getAmiId() {
            return amiId;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final String getArchitecture() {
            return architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getAutoScalingType() {
            return autoScalingType;
        }

        public final void setAutoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
        }

        @Override
        public final Builder autoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
            return this;
        }

        @Override
        public final Builder autoScalingType(AutoScalingType autoScalingType) {
            this.autoScalingType(autoScalingType == null ? null : autoScalingType.toString());
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final List<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<BlockDeviceMapping.Builder> result = BlockDeviceMappingsCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> BlockDeviceMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final String getEc2InstanceId() {
            return ec2InstanceId;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final String getEcsClusterArn() {
            return ecsClusterArn;
        }

        public final void setEcsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
        }

        @Override
        public final Builder ecsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
            return this;
        }

        public final String getEcsContainerInstanceArn() {
            return ecsContainerInstanceArn;
        }

        public final void setEcsContainerInstanceArn(String ecsContainerInstanceArn) {
            this.ecsContainerInstanceArn = ecsContainerInstanceArn;
        }

        @Override
        public final Builder ecsContainerInstanceArn(String ecsContainerInstanceArn) {
            this.ecsContainerInstanceArn = ecsContainerInstanceArn;
            return this;
        }

        public final String getElasticIp() {
            return elasticIp;
        }

        public final void setElasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
        }

        @Override
        public final Builder elasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        public final String getHostname() {
            return hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getInfrastructureClass() {
            return infrastructureClass;
        }

        public final void setInfrastructureClass(String infrastructureClass) {
            this.infrastructureClass = infrastructureClass;
        }

        @Override
        public final Builder infrastructureClass(String infrastructureClass) {
            this.infrastructureClass = infrastructureClass;
            return this;
        }

        public final Boolean getInstallUpdatesOnBoot() {
            return installUpdatesOnBoot;
        }

        public final void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
        }

        @Override
        public final Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getInstanceProfileArn() {
            return instanceProfileArn;
        }

        public final void setInstanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
        }

        @Override
        public final Builder instanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getLastServiceErrorId() {
            return lastServiceErrorId;
        }

        public final void setLastServiceErrorId(String lastServiceErrorId) {
            this.lastServiceErrorId = lastServiceErrorId;
        }

        @Override
        public final Builder lastServiceErrorId(String lastServiceErrorId) {
            this.lastServiceErrorId = lastServiceErrorId;
            return this;
        }

        public final Collection<String> getLayerIds() {
            if (layerIds instanceof SdkAutoConstructList) {
                return null;
            }
            return layerIds;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        @Override
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerIds(String... layerIds) {
            layerIds(Arrays.asList(layerIds));
            return this;
        }

        public final String getOs() {
            return os;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        @Override
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final String getPrivateDns() {
            return privateDns;
        }

        public final void setPrivateDns(String privateDns) {
            this.privateDns = privateDns;
        }

        @Override
        public final Builder privateDns(String privateDns) {
            this.privateDns = privateDns;
            return this;
        }

        public final String getPrivateIp() {
            return privateIp;
        }

        public final void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        @Override
        public final Builder privateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public final String getPublicDns() {
            return publicDns;
        }

        public final void setPublicDns(String publicDns) {
            this.publicDns = publicDns;
        }

        @Override
        public final Builder publicDns(String publicDns) {
            this.publicDns = publicDns;
            return this;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final String getRegisteredBy() {
            return registeredBy;
        }

        public final void setRegisteredBy(String registeredBy) {
            this.registeredBy = registeredBy;
        }

        @Override
        public final Builder registeredBy(String registeredBy) {
            this.registeredBy = registeredBy;
            return this;
        }

        public final String getReportedAgentVersion() {
            return reportedAgentVersion;
        }

        public final void setReportedAgentVersion(String reportedAgentVersion) {
            this.reportedAgentVersion = reportedAgentVersion;
        }

        @Override
        public final Builder reportedAgentVersion(String reportedAgentVersion) {
            this.reportedAgentVersion = reportedAgentVersion;
            return this;
        }

        public final ReportedOs.Builder getReportedOs() {
            return reportedOs != null ? reportedOs.toBuilder() : null;
        }

        public final void setReportedOs(ReportedOs.BuilderImpl reportedOs) {
            this.reportedOs = reportedOs != null ? reportedOs.build() : null;
        }

        @Override
        public final Builder reportedOs(ReportedOs reportedOs) {
            this.reportedOs = reportedOs;
            return this;
        }

        public final String getRootDeviceType() {
            return rootDeviceType;
        }

        public final void setRootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
        }

        @Override
        public final Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        @Override
        public final Builder rootDeviceType(RootDeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType == null ? null : rootDeviceType.toString());
            return this;
        }

        public final String getRootDeviceVolumeId() {
            return rootDeviceVolumeId;
        }

        public final void setRootDeviceVolumeId(String rootDeviceVolumeId) {
            this.rootDeviceVolumeId = rootDeviceVolumeId;
        }

        @Override
        public final Builder rootDeviceVolumeId(String rootDeviceVolumeId) {
            this.rootDeviceVolumeId = rootDeviceVolumeId;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getSshHostDsaKeyFingerprint() {
            return sshHostDsaKeyFingerprint;
        }

        public final void setSshHostDsaKeyFingerprint(String sshHostDsaKeyFingerprint) {
            this.sshHostDsaKeyFingerprint = sshHostDsaKeyFingerprint;
        }

        @Override
        public final Builder sshHostDsaKeyFingerprint(String sshHostDsaKeyFingerprint) {
            this.sshHostDsaKeyFingerprint = sshHostDsaKeyFingerprint;
            return this;
        }

        public final String getSshHostRsaKeyFingerprint() {
            return sshHostRsaKeyFingerprint;
        }

        public final void setSshHostRsaKeyFingerprint(String sshHostRsaKeyFingerprint) {
            this.sshHostRsaKeyFingerprint = sshHostRsaKeyFingerprint;
        }

        @Override
        public final Builder sshHostRsaKeyFingerprint(String sshHostRsaKeyFingerprint) {
            this.sshHostRsaKeyFingerprint = sshHostRsaKeyFingerprint;
            return this;
        }

        public final String getSshKeyName() {
            return sshKeyName;
        }

        public final void setSshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
        }

        @Override
        public final Builder sshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
            return this;
        }

        public final String getStackId() {
            return stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getTenancy() {
            return tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        public final String getVirtualizationType() {
            return virtualizationType;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        @Override
        public final Builder virtualizationType(VirtualizationType virtualizationType) {
            this.virtualizationType(virtualizationType == null ? null : virtualizationType.toString());
            return this;
        }

        @Override
        public Instance build() {
            return new Instance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
