/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRdsDbInstanceRequest extends OpsWorksRequest implements
        ToCopyableBuilder<UpdateRdsDbInstanceRequest.Builder, UpdateRdsDbInstanceRequest> {
    private static final SdkField<String> RDS_DB_INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RdsDbInstanceArn").getter(getter(UpdateRdsDbInstanceRequest::rdsDbInstanceArn))
            .setter(setter(Builder::rdsDbInstanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RdsDbInstanceArn").build()).build();

    private static final SdkField<String> DB_USER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DbUser")
            .getter(getter(UpdateRdsDbInstanceRequest::dbUser)).setter(setter(Builder::dbUser))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbUser").build()).build();

    private static final SdkField<String> DB_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbPassword").getter(getter(UpdateRdsDbInstanceRequest::dbPassword)).setter(setter(Builder::dbPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbPassword").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RDS_DB_INSTANCE_ARN_FIELD,
            DB_USER_FIELD, DB_PASSWORD_FIELD));

    private final String rdsDbInstanceArn;

    private final String dbUser;

    private final String dbPassword;

    private UpdateRdsDbInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.rdsDbInstanceArn = builder.rdsDbInstanceArn;
        this.dbUser = builder.dbUser;
        this.dbPassword = builder.dbPassword;
    }

    /**
     * <p>
     * The Amazon RDS instance's ARN.
     * </p>
     * 
     * @return The Amazon RDS instance's ARN.
     */
    public final String rdsDbInstanceArn() {
        return rdsDbInstanceArn;
    }

    /**
     * <p>
     * The master user name.
     * </p>
     * 
     * @return The master user name.
     */
    public final String dbUser() {
        return dbUser;
    }

    /**
     * <p>
     * The database password.
     * </p>
     * 
     * @return The database password.
     */
    public final String dbPassword() {
        return dbPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(rdsDbInstanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(dbUser());
        hashCode = 31 * hashCode + Objects.hashCode(dbPassword());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRdsDbInstanceRequest)) {
            return false;
        }
        UpdateRdsDbInstanceRequest other = (UpdateRdsDbInstanceRequest) obj;
        return Objects.equals(rdsDbInstanceArn(), other.rdsDbInstanceArn()) && Objects.equals(dbUser(), other.dbUser())
                && Objects.equals(dbPassword(), other.dbPassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRdsDbInstanceRequest").add("RdsDbInstanceArn", rdsDbInstanceArn()).add("DbUser", dbUser())
                .add("DbPassword", dbPassword()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RdsDbInstanceArn":
            return Optional.ofNullable(clazz.cast(rdsDbInstanceArn()));
        case "DbUser":
            return Optional.ofNullable(clazz.cast(dbUser()));
        case "DbPassword":
            return Optional.ofNullable(clazz.cast(dbPassword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateRdsDbInstanceRequest, T> g) {
        return obj -> g.apply((UpdateRdsDbInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRdsDbInstanceRequest> {
        /**
         * <p>
         * The Amazon RDS instance's ARN.
         * </p>
         * 
         * @param rdsDbInstanceArn
         *        The Amazon RDS instance's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbInstanceArn(String rdsDbInstanceArn);

        /**
         * <p>
         * The master user name.
         * </p>
         * 
         * @param dbUser
         *        The master user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbUser(String dbUser);

        /**
         * <p>
         * The database password.
         * </p>
         * 
         * @param dbPassword
         *        The database password.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbPassword(String dbPassword);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String rdsDbInstanceArn;

        private String dbUser;

        private String dbPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRdsDbInstanceRequest model) {
            super(model);
            rdsDbInstanceArn(model.rdsDbInstanceArn);
            dbUser(model.dbUser);
            dbPassword(model.dbPassword);
        }

        public final String getRdsDbInstanceArn() {
            return rdsDbInstanceArn;
        }

        public final void setRdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
        }

        @Override
        @Transient
        public final Builder rdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
            return this;
        }

        public final String getDbUser() {
            return dbUser;
        }

        public final void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        @Override
        @Transient
        public final Builder dbUser(String dbUser) {
            this.dbUser = dbUser;
            return this;
        }

        public final String getDbPassword() {
            return dbPassword;
        }

        public final void setDbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
        }

        @Override
        @Transient
        public final Builder dbPassword(String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRdsDbInstanceRequest build() {
            return new UpdateRdsDbInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
