/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Amazon CloudWatch logs configuration for a layer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchLogsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchLogsConfiguration.Builder, CloudWatchLogsConfiguration> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(CloudWatchLogsConfiguration::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<List<CloudWatchLogsLogStream>> LOG_STREAMS_FIELD = SdkField
            .<List<CloudWatchLogsLogStream>> builder(MarshallingType.LIST)
            .memberName("LogStreams")
            .getter(getter(CloudWatchLogsConfiguration::logStreams))
            .setter(setter(Builder::logStreams))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogStreams").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CloudWatchLogsLogStream> builder(MarshallingType.SDK_POJO)
                                            .constructor(CloudWatchLogsLogStream::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            LOG_STREAMS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final List<CloudWatchLogsLogStream> logStreams;

    private CloudWatchLogsConfiguration(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.logStreams = builder.logStreams;
    }

    /**
     * <p>
     * Whether CloudWatch Logs is enabled for a layer.
     * </p>
     * 
     * @return Whether CloudWatch Logs is enabled for a layer.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * Returns true if the LogStreams property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasLogStreams() {
        return logStreams != null && !(logStreams instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of configuration options for CloudWatch Logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasLogStreams()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of configuration options for CloudWatch Logs.
     */
    public final List<CloudWatchLogsLogStream> logStreams() {
        return logStreams;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(hasLogStreams() ? logStreams() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogsConfiguration)) {
            return false;
        }
        CloudWatchLogsConfiguration other = (CloudWatchLogsConfiguration) obj;
        return Objects.equals(enabled(), other.enabled()) && hasLogStreams() == other.hasLogStreams()
                && Objects.equals(logStreams(), other.logStreams());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudWatchLogsConfiguration").add("Enabled", enabled())
                .add("LogStreams", hasLogStreams() ? logStreams() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "LogStreams":
            return Optional.ofNullable(clazz.cast(logStreams()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchLogsConfiguration, T> g) {
        return obj -> g.apply((CloudWatchLogsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchLogsConfiguration> {
        /**
         * <p>
         * Whether CloudWatch Logs is enabled for a layer.
         * </p>
         * 
         * @param enabled
         *        Whether CloudWatch Logs is enabled for a layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * A list of configuration options for CloudWatch Logs.
         * </p>
         * 
         * @param logStreams
         *        A list of configuration options for CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreams(Collection<CloudWatchLogsLogStream> logStreams);

        /**
         * <p>
         * A list of configuration options for CloudWatch Logs.
         * </p>
         * 
         * @param logStreams
         *        A list of configuration options for CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logStreams(CloudWatchLogsLogStream... logStreams);

        /**
         * <p>
         * A list of configuration options for CloudWatch Logs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CloudWatchLogsLogStream>.Builder} avoiding
         * the need to create one manually via {@link List<CloudWatchLogsLogStream>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CloudWatchLogsLogStream>.Builder#build()} is called
         * immediately and its result is passed to {@link #logStreams(List<CloudWatchLogsLogStream>)}.
         * 
         * @param logStreams
         *        a consumer that will call methods on {@link List<CloudWatchLogsLogStream>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logStreams(List<CloudWatchLogsLogStream>)
         */
        Builder logStreams(Consumer<CloudWatchLogsLogStream.Builder>... logStreams);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private List<CloudWatchLogsLogStream> logStreams = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogsConfiguration model) {
            enabled(model.enabled);
            logStreams(model.logStreams);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final List<CloudWatchLogsLogStream.Builder> getLogStreams() {
            List<CloudWatchLogsLogStream.Builder> result = CloudWatchLogsLogStreamsCopier.copyToBuilder(this.logStreams);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder logStreams(Collection<CloudWatchLogsLogStream> logStreams) {
            this.logStreams = CloudWatchLogsLogStreamsCopier.copy(logStreams);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreams(CloudWatchLogsLogStream... logStreams) {
            logStreams(Arrays.asList(logStreams));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder logStreams(Consumer<CloudWatchLogsLogStream.Builder>... logStreams) {
            logStreams(Stream.of(logStreams).map(c -> CloudWatchLogsLogStream.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setLogStreams(Collection<CloudWatchLogsLogStream.BuilderImpl> logStreams) {
            this.logStreams = CloudWatchLogsLogStreamsCopier.copyFromBuilder(logStreams);
        }

        @Override
        public CloudWatchLogsConfiguration build() {
            return new CloudWatchLogsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
