/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUserProfilesRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeUserProfilesRequest.Builder, DescribeUserProfilesRequest> {
    private static final SdkField<List<String>> IAM_USER_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("IamUserArns")
            .getter(getter(DescribeUserProfilesRequest::iamUserArns))
            .setter(setter(Builder::iamUserArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamUserArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IAM_USER_ARNS_FIELD));

    private final List<String> iamUserArns;

    private DescribeUserProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.iamUserArns = builder.iamUserArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the IamUserArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIamUserArns() {
        return iamUserArns != null && !(iamUserArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of IAM or federated user ARNs that identify the users to be described.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIamUserArns} method.
     * </p>
     * 
     * @return An array of IAM or federated user ARNs that identify the users to be described.
     */
    public final List<String> iamUserArns() {
        return iamUserArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIamUserArns() ? iamUserArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserProfilesRequest)) {
            return false;
        }
        DescribeUserProfilesRequest other = (DescribeUserProfilesRequest) obj;
        return hasIamUserArns() == other.hasIamUserArns() && Objects.equals(iamUserArns(), other.iamUserArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeUserProfilesRequest").add("IamUserArns", hasIamUserArns() ? iamUserArns() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IamUserArns":
            return Optional.ofNullable(clazz.cast(iamUserArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserProfilesRequest, T> g) {
        return obj -> g.apply((DescribeUserProfilesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeUserProfilesRequest> {
        /**
         * <p>
         * An array of IAM or federated user ARNs that identify the users to be described.
         * </p>
         * 
         * @param iamUserArns
         *        An array of IAM or federated user ARNs that identify the users to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArns(Collection<String> iamUserArns);

        /**
         * <p>
         * An array of IAM or federated user ARNs that identify the users to be described.
         * </p>
         * 
         * @param iamUserArns
         *        An array of IAM or federated user ARNs that identify the users to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArns(String... iamUserArns);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private List<String> iamUserArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserProfilesRequest model) {
            super(model);
            iamUserArns(model.iamUserArns);
        }

        public final Collection<String> getIamUserArns() {
            if (iamUserArns instanceof SdkAutoConstructList) {
                return null;
            }
            return iamUserArns;
        }

        public final void setIamUserArns(Collection<String> iamUserArns) {
            this.iamUserArns = StringsCopier.copy(iamUserArns);
        }

        @Override
        @Transient
        public final Builder iamUserArns(Collection<String> iamUserArns) {
            this.iamUserArns = StringsCopier.copy(iamUserArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder iamUserArns(String... iamUserArns) {
            iamUserArns(Arrays.asList(iamUserArns));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeUserProfilesRequest build() {
            return new DescribeUserProfilesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
