/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetPermissionRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, SetPermissionRequest> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(SetPermissionRequest.getter(SetPermissionRequest::stackId)).setter(SetPermissionRequest.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> IAM_USER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamUserArn").getter(SetPermissionRequest.getter(SetPermissionRequest::iamUserArn)).setter(SetPermissionRequest.setter(Builder::iamUserArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamUserArn").build()}).build();
    private static final SdkField<Boolean> ALLOW_SSH_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowSsh").getter(SetPermissionRequest.getter(SetPermissionRequest::allowSsh)).setter(SetPermissionRequest.setter(Builder::allowSsh)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowSsh").build()}).build();
    private static final SdkField<Boolean> ALLOW_SUDO_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowSudo").getter(SetPermissionRequest.getter(SetPermissionRequest::allowSudo)).setter(SetPermissionRequest.setter(Builder::allowSudo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowSudo").build()}).build();
    private static final SdkField<String> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Level").getter(SetPermissionRequest.getter(SetPermissionRequest::level)).setter(SetPermissionRequest.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Level").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, IAM_USER_ARN_FIELD, ALLOW_SSH_FIELD, ALLOW_SUDO_FIELD, LEVEL_FIELD));
    private final String stackId;
    private final String iamUserArn;
    private final Boolean allowSsh;
    private final Boolean allowSudo;
    private final String level;

    private SetPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.iamUserArn = builder.iamUserArn;
        this.allowSsh = builder.allowSsh;
        this.allowSudo = builder.allowSudo;
        this.level = builder.level;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final String iamUserArn() {
        return this.iamUserArn;
    }

    public final Boolean allowSsh() {
        return this.allowSsh;
    }

    public final Boolean allowSudo() {
        return this.allowSudo;
    }

    public final String level() {
        return this.level;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowSsh());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowSudo());
        hashCode = 31 * hashCode + Objects.hashCode(this.level());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetPermissionRequest)) {
            return false;
        }
        SetPermissionRequest other = (SetPermissionRequest)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.iamUserArn(), other.iamUserArn()) && Objects.equals(this.allowSsh(), other.allowSsh()) && Objects.equals(this.allowSudo(), other.allowSudo()) && Objects.equals(this.level(), other.level());
    }

    public final String toString() {
        return ToString.builder((String)"SetPermissionRequest").add("StackId", (Object)this.stackId()).add("IamUserArn", (Object)this.iamUserArn()).add("AllowSsh", (Object)this.allowSsh()).add("AllowSudo", (Object)this.allowSudo()).add("Level", (Object)this.level()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "IamUserArn": {
                return Optional.ofNullable(clazz.cast(this.iamUserArn()));
            }
            case "AllowSsh": {
                return Optional.ofNullable(clazz.cast(this.allowSsh()));
            }
            case "AllowSudo": {
                return Optional.ofNullable(clazz.cast(this.allowSudo()));
            }
            case "Level": {
                return Optional.ofNullable(clazz.cast(this.level()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetPermissionRequest, T> g) {
        return obj -> g.apply((SetPermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String stackId;
        private String iamUserArn;
        private Boolean allowSsh;
        private Boolean allowSudo;
        private String level;

        private BuilderImpl() {
        }

        private BuilderImpl(SetPermissionRequest model) {
            super(model);
            this.stackId(model.stackId);
            this.iamUserArn(model.iamUserArn);
            this.allowSsh(model.allowSsh);
            this.allowSudo(model.allowSudo);
            this.level(model.level);
        }

        public final String getStackId() {
            return this.stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getIamUserArn() {
            return this.iamUserArn;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final Boolean getAllowSsh() {
            return this.allowSsh;
        }

        public final void setAllowSsh(Boolean allowSsh) {
            this.allowSsh = allowSsh;
        }

        @Override
        public final Builder allowSsh(Boolean allowSsh) {
            this.allowSsh = allowSsh;
            return this;
        }

        public final Boolean getAllowSudo() {
            return this.allowSudo;
        }

        public final void setAllowSudo(Boolean allowSudo) {
            this.allowSudo = allowSudo;
        }

        @Override
        public final Builder allowSudo(Boolean allowSudo) {
            this.allowSudo = allowSudo;
            return this;
        }

        public final String getLevel() {
            return this.level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetPermissionRequest build() {
            return new SetPermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetPermissionRequest> {
        public Builder stackId(String var1);

        public Builder iamUserArn(String var1);

        public Builder allowSsh(Boolean var1);

        public Builder allowSudo(Boolean var1);

        public Builder level(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

