/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.opsworks.DefaultOpsWorksAsyncClient;
import software.amazon.awssdk.services.opsworks.DefaultOpsWorksBaseClientBuilder;
import software.amazon.awssdk.services.opsworks.OpsWorksAsyncClient;
import software.amazon.awssdk.services.opsworks.OpsWorksAsyncClientBuilder;
import software.amazon.awssdk.services.opsworks.OpsWorksServiceClientConfiguration;
import software.amazon.awssdk.services.opsworks.endpoints.OpsWorksEndpointProvider;

@SdkInternalApi
final class DefaultOpsWorksAsyncClientBuilder
extends DefaultOpsWorksBaseClientBuilder<OpsWorksAsyncClientBuilder, OpsWorksAsyncClient>
implements OpsWorksAsyncClientBuilder {
    DefaultOpsWorksAsyncClientBuilder() {
    }

    @Override
    public DefaultOpsWorksAsyncClientBuilder endpointProvider(OpsWorksEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final OpsWorksAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultOpsWorksAsyncClientBuilder.validateClientOptions(clientConfiguration);
        OpsWorksServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultOpsWorksAsyncClient client = new DefaultOpsWorksAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private OpsWorksServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return OpsWorksServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

