/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a layer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Layer implements SdkPojo, Serializable, ToCopyableBuilder<Layer.Builder, Layer> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Layer::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackId").getter(getter(Layer::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> LAYER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LayerId").getter(getter(Layer::layerId)).setter(setter(Builder::layerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Layer::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Layer::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SHORTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Shortname").getter(getter(Layer::shortname)).setter(setter(Builder::shortname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Shortname").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Attributes")
            .getter(getter(Layer::attributesAsStrings))
            .setter(setter(Builder::attributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<CloudWatchLogsConfiguration> CLOUD_WATCH_LOGS_CONFIGURATION_FIELD = SdkField
            .<CloudWatchLogsConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CloudWatchLogsConfiguration")
            .getter(getter(Layer::cloudWatchLogsConfiguration))
            .setter(setter(Builder::cloudWatchLogsConfiguration))
            .constructor(CloudWatchLogsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsConfiguration")
                    .build()).build();

    private static final SdkField<String> CUSTOM_INSTANCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomInstanceProfileArn").getter(getter(Layer::customInstanceProfileArn))
            .setter(setter(Builder::customInstanceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomInstanceProfileArn").build())
            .build();

    private static final SdkField<String> CUSTOM_JSON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CustomJson").getter(getter(Layer::customJson)).setter(setter(Builder::customJson))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomJson").build()).build();

    private static final SdkField<List<String>> CUSTOM_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CustomSecurityGroupIds")
            .getter(getter(Layer::customSecurityGroupIds))
            .setter(setter(Builder::customSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DEFAULT_SECURITY_GROUP_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DefaultSecurityGroupNames")
            .getter(getter(Layer::defaultSecurityGroupNames))
            .setter(setter(Builder::defaultSecurityGroupNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSecurityGroupNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PACKAGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Packages")
            .getter(getter(Layer::packages))
            .setter(setter(Builder::packages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Packages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<VolumeConfiguration>> VOLUME_CONFIGURATIONS_FIELD = SdkField
            .<List<VolumeConfiguration>> builder(MarshallingType.LIST)
            .memberName("VolumeConfigurations")
            .getter(getter(Layer::volumeConfigurations))
            .setter(setter(Builder::volumeConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VolumeConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(VolumeConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_AUTO_HEALING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableAutoHealing").getter(getter(Layer::enableAutoHealing)).setter(setter(Builder::enableAutoHealing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableAutoHealing").build()).build();

    private static final SdkField<Boolean> AUTO_ASSIGN_ELASTIC_IPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoAssignElasticIps").getter(getter(Layer::autoAssignElasticIps))
            .setter(setter(Builder::autoAssignElasticIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAssignElasticIps").build())
            .build();

    private static final SdkField<Boolean> AUTO_ASSIGN_PUBLIC_IPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoAssignPublicIps").getter(getter(Layer::autoAssignPublicIps))
            .setter(setter(Builder::autoAssignPublicIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAssignPublicIps").build())
            .build();

    private static final SdkField<Recipes> DEFAULT_RECIPES_FIELD = SdkField.<Recipes> builder(MarshallingType.SDK_POJO)
            .memberName("DefaultRecipes").getter(getter(Layer::defaultRecipes)).setter(setter(Builder::defaultRecipes))
            .constructor(Recipes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRecipes").build()).build();

    private static final SdkField<Recipes> CUSTOM_RECIPES_FIELD = SdkField.<Recipes> builder(MarshallingType.SDK_POJO)
            .memberName("CustomRecipes").getter(getter(Layer::customRecipes)).setter(setter(Builder::customRecipes))
            .constructor(Recipes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomRecipes").build()).build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedAt").getter(getter(Layer::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Boolean> INSTALL_UPDATES_ON_BOOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InstallUpdatesOnBoot").getter(getter(Layer::installUpdatesOnBoot))
            .setter(setter(Builder::installUpdatesOnBoot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstallUpdatesOnBoot").build())
            .build();

    private static final SdkField<Boolean> USE_EBS_OPTIMIZED_INSTANCES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("UseEbsOptimizedInstances")
            .getter(getter(Layer::useEbsOptimizedInstances)).setter(setter(Builder::useEbsOptimizedInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseEbsOptimizedInstances").build())
            .build();

    private static final SdkField<LifecycleEventConfiguration> LIFECYCLE_EVENT_CONFIGURATION_FIELD = SdkField
            .<LifecycleEventConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("LifecycleEventConfiguration")
            .getter(getter(Layer::lifecycleEventConfiguration))
            .setter(setter(Builder::lifecycleEventConfiguration))
            .constructor(LifecycleEventConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleEventConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, STACK_ID_FIELD,
            LAYER_ID_FIELD, TYPE_FIELD, NAME_FIELD, SHORTNAME_FIELD, ATTRIBUTES_FIELD, CLOUD_WATCH_LOGS_CONFIGURATION_FIELD,
            CUSTOM_INSTANCE_PROFILE_ARN_FIELD, CUSTOM_JSON_FIELD, CUSTOM_SECURITY_GROUP_IDS_FIELD,
            DEFAULT_SECURITY_GROUP_NAMES_FIELD, PACKAGES_FIELD, VOLUME_CONFIGURATIONS_FIELD, ENABLE_AUTO_HEALING_FIELD,
            AUTO_ASSIGN_ELASTIC_IPS_FIELD, AUTO_ASSIGN_PUBLIC_IPS_FIELD, DEFAULT_RECIPES_FIELD, CUSTOM_RECIPES_FIELD,
            CREATED_AT_FIELD, INSTALL_UPDATES_ON_BOOT_FIELD, USE_EBS_OPTIMIZED_INSTANCES_FIELD,
            LIFECYCLE_EVENT_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String stackId;

    private final String layerId;

    private final String type;

    private final String name;

    private final String shortname;

    private final Map<String, String> attributes;

    private final CloudWatchLogsConfiguration cloudWatchLogsConfiguration;

    private final String customInstanceProfileArn;

    private final String customJson;

    private final List<String> customSecurityGroupIds;

    private final List<String> defaultSecurityGroupNames;

    private final List<String> packages;

    private final List<VolumeConfiguration> volumeConfigurations;

    private final Boolean enableAutoHealing;

    private final Boolean autoAssignElasticIps;

    private final Boolean autoAssignPublicIps;

    private final Recipes defaultRecipes;

    private final Recipes customRecipes;

    private final String createdAt;

    private final Boolean installUpdatesOnBoot;

    private final Boolean useEbsOptimizedInstances;

    private final LifecycleEventConfiguration lifecycleEventConfiguration;

    private Layer(BuilderImpl builder) {
        this.arn = builder.arn;
        this.stackId = builder.stackId;
        this.layerId = builder.layerId;
        this.type = builder.type;
        this.name = builder.name;
        this.shortname = builder.shortname;
        this.attributes = builder.attributes;
        this.cloudWatchLogsConfiguration = builder.cloudWatchLogsConfiguration;
        this.customInstanceProfileArn = builder.customInstanceProfileArn;
        this.customJson = builder.customJson;
        this.customSecurityGroupIds = builder.customSecurityGroupIds;
        this.defaultSecurityGroupNames = builder.defaultSecurityGroupNames;
        this.packages = builder.packages;
        this.volumeConfigurations = builder.volumeConfigurations;
        this.enableAutoHealing = builder.enableAutoHealing;
        this.autoAssignElasticIps = builder.autoAssignElasticIps;
        this.autoAssignPublicIps = builder.autoAssignPublicIps;
        this.defaultRecipes = builder.defaultRecipes;
        this.customRecipes = builder.customRecipes;
        this.createdAt = builder.createdAt;
        this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
        this.useEbsOptimizedInstances = builder.useEbsOptimizedInstances;
        this.lifecycleEventConfiguration = builder.lifecycleEventConfiguration;
    }

    /**
     * <p>
     * The Amazon Resource Number (ARN) of a layer.
     * </p>
     * 
     * @return The Amazon Resource Number (ARN) of a layer.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The layer stack ID.
     * </p>
     * 
     * @return The layer stack ID.
     */
    public final String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The layer ID.
     * </p>
     * 
     * @return The layer ID.
     */
    public final String layerId() {
        return layerId;
    }

    /**
     * <p>
     * The layer type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LayerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The layer type.
     * @see LayerType
     */
    public final LayerType type() {
        return LayerType.fromValue(type);
    }

    /**
     * <p>
     * The layer type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LayerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The layer type.
     * @see LayerType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The layer name. Layer names can be a maximum of 32 characters.
     * </p>
     * 
     * @return The layer name. Layer names can be a maximum of 32 characters.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The layer short name.
     * </p>
     * 
     * @return The layer short name.
     */
    public final String shortname() {
        return shortname;
    }

    /**
     * <p>
     * The layer attributes.
     * </p>
     * <p>
     * For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and <code>GangliaPassword</code>
     * attributes, OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value
     * </p>
     * <p>
     * For an ECS Cluster layer, OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the cluster's ARN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The layer attributes.</p>
     *         <p>
     *         For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and
     *         <code>GangliaPassword</code> attributes, OpsWorks Stacks returns <code>*****FILTERED*****</code> instead
     *         of the actual value
     *         </p>
     *         <p>
     *         For an ECS Cluster layer, OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the
     *         cluster's ARN.
     */
    public final Map<LayerAttributesKeys, String> attributes() {
        return LayerAttributesCopier.copyStringToEnum(attributes);
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The layer attributes.
     * </p>
     * <p>
     * For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and <code>GangliaPassword</code>
     * attributes, OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value
     * </p>
     * <p>
     * For an ECS Cluster layer, OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the cluster's ARN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The layer attributes.</p>
     *         <p>
     *         For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and
     *         <code>GangliaPassword</code> attributes, OpsWorks Stacks returns <code>*****FILTERED*****</code> instead
     *         of the actual value
     *         </p>
     *         <p>
     *         For an ECS Cluster layer, OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the
     *         cluster's ARN.
     */
    public final Map<String, String> attributesAsStrings() {
        return attributes;
    }

    /**
     * <p>
     * The Amazon CloudWatch Logs configuration settings for the layer.
     * </p>
     * 
     * @return The Amazon CloudWatch Logs configuration settings for the layer.
     */
    public final CloudWatchLogsConfiguration cloudWatchLogsConfiguration() {
        return cloudWatchLogsConfiguration;
    }

    /**
     * <p>
     * The ARN of the default IAM profile to be used for the layer's EC2 instances. For more information about IAM ARNs,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     * </p>
     * 
     * @return The ARN of the default IAM profile to be used for the layer's EC2 instances. For more information about
     *         IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
     *         Identifiers</a>.
     */
    public final String customInstanceProfileArn() {
        return customInstanceProfileArn;
    }

    /**
     * <p>
     * A JSON formatted string containing the layer's custom stack configuration and deployment attributes.
     * </p>
     * 
     * @return A JSON formatted string containing the layer's custom stack configuration and deployment attributes.
     */
    public final String customJson() {
        return customJson;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomSecurityGroupIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCustomSecurityGroupIds() {
        return customSecurityGroupIds != null && !(customSecurityGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing the layer's custom security group IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomSecurityGroupIds} method.
     * </p>
     * 
     * @return An array containing the layer's custom security group IDs.
     */
    public final List<String> customSecurityGroupIds() {
        return customSecurityGroupIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the DefaultSecurityGroupNames property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDefaultSecurityGroupNames() {
        return defaultSecurityGroupNames != null && !(defaultSecurityGroupNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing the layer's security group names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDefaultSecurityGroupNames} method.
     * </p>
     * 
     * @return An array containing the layer's security group names.
     */
    public final List<String> defaultSecurityGroupNames() {
        return defaultSecurityGroupNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the Packages property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPackages() {
        return packages != null && !(packages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>Package</code> objects that describe the layer's packages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPackages} method.
     * </p>
     * 
     * @return An array of <code>Package</code> objects that describe the layer's packages.
     */
    public final List<String> packages() {
        return packages;
    }

    /**
     * For responses, this returns true if the service returned a value for the VolumeConfigurations property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVolumeConfigurations() {
        return volumeConfigurations != null && !(volumeConfigurations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVolumeConfigurations} method.
     * </p>
     * 
     * @return A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
     */
    public final List<VolumeConfiguration> volumeConfigurations() {
        return volumeConfigurations;
    }

    /**
     * <p>
     * Whether auto healing is disabled for the layer.
     * </p>
     * 
     * @return Whether auto healing is disabled for the layer.
     */
    public final Boolean enableAutoHealing() {
        return enableAutoHealing;
    }

    /**
     * <p>
     * Whether to automatically assign an <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address</a>
     * to the layer's instances. For more information, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     * Layer</a>.
     * </p>
     * 
     * @return Whether to automatically assign an <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
     *         address</a> to the layer's instances. For more information, see <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     *         Layer</a>.
     */
    public final Boolean autoAssignElasticIps() {
        return autoAssignElasticIps;
    }

    /**
     * <p>
     * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's
     * instances. For more information, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     * Layer</a>.
     * </p>
     * 
     * @return For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's
     *         instances. For more information, see <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     *         Layer</a>.
     */
    public final Boolean autoAssignPublicIps() {
        return autoAssignPublicIps;
    }

    /**
     * <p>
     * OpsWorks Stacks supports five lifecycle events: <b>setup</b>, <b>configuration</b>, <b>deploy</b>,
     * <b>undeploy</b>, and <b>shutdown</b>. For each layer, OpsWorks Stacks runs a set of standard recipes for each
     * event. You can also provide custom recipes for any or all layers and events. OpsWorks Stacks runs custom event
     * recipes after the standard recipes. <code>LayerCustomRecipes</code> specifies the custom recipes for a particular
     * layer to be run in response to each of the five events.
     * </p>
     * <p>
     * To specify a recipe, use the cookbook's directory name in the repository followed by two colons and the recipe
     * name, which is the recipe's file name without the <code>.rb</code> extension. For example:
     * <code>phpapp2::dbsetup</code> specifies the <code>dbsetup.rb</code> recipe in the repository's
     * <code>phpapp2</code> folder.
     * </p>
     * 
     * @return OpsWorks Stacks supports five lifecycle events: <b>setup</b>, <b>configuration</b>, <b>deploy</b>,
     *         <b>undeploy</b>, and <b>shutdown</b>. For each layer, OpsWorks Stacks runs a set of standard recipes for
     *         each event. You can also provide custom recipes for any or all layers and events. OpsWorks Stacks runs
     *         custom event recipes after the standard recipes. <code>LayerCustomRecipes</code> specifies the custom
     *         recipes for a particular layer to be run in response to each of the five events.</p>
     *         <p>
     *         To specify a recipe, use the cookbook's directory name in the repository followed by two colons and the
     *         recipe name, which is the recipe's file name without the <code>.rb</code> extension. For example:
     *         <code>phpapp2::dbsetup</code> specifies the <code>dbsetup.rb</code> recipe in the repository's
     *         <code>phpapp2</code> folder.
     */
    public final Recipes defaultRecipes() {
        return defaultRecipes;
    }

    /**
     * <p>
     * A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.
     * </p>
     * 
     * @return A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.
     */
    public final Recipes customRecipes() {
        return customRecipes;
    }

    /**
     * <p>
     * Date when the layer was created.
     * </p>
     * 
     * @return Date when the layer was created.
     */
    public final String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Whether to install operating system and package updates when the instance boots. The default value is
     * <code>true</code>. If this value is set to <code>false</code>, you must then update your instances manually by
     * using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or manually running
     * <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
     * </p>
     * <note>
     * <p>
     * We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the latest
     * security updates.
     * </p>
     * </note>
     * 
     * @return Whether to install operating system and package updates when the instance boots. The default value is
     *         <code>true</code>. If this value is set to <code>false</code>, you must then update your instances
     *         manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or
     *         manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p>
     *         <note>
     *         <p>
     *         We strongly recommend using the default value of <code>true</code>, to ensure that your instances have
     *         the latest security updates.
     *         </p>
     */
    public final Boolean installUpdatesOnBoot() {
        return installUpdatesOnBoot;
    }

    /**
     * <p>
     * Whether the layer uses Amazon EBS-optimized instances.
     * </p>
     * 
     * @return Whether the layer uses Amazon EBS-optimized instances.
     */
    public final Boolean useEbsOptimizedInstances() {
        return useEbsOptimizedInstances;
    }

    /**
     * <p>
     * A <code>LifeCycleEventConfiguration</code> object that specifies the Shutdown event configuration.
     * </p>
     * 
     * @return A <code>LifeCycleEventConfiguration</code> object that specifies the Shutdown event configuration.
     */
    public final LifecycleEventConfiguration lifecycleEventConfiguration() {
        return lifecycleEventConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(layerId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(shortname());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(customInstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(customJson());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomSecurityGroupIds() ? customSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDefaultSecurityGroupNames() ? defaultSecurityGroupNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPackages() ? packages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVolumeConfigurations() ? volumeConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enableAutoHealing());
        hashCode = 31 * hashCode + Objects.hashCode(autoAssignElasticIps());
        hashCode = 31 * hashCode + Objects.hashCode(autoAssignPublicIps());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRecipes());
        hashCode = 31 * hashCode + Objects.hashCode(customRecipes());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(installUpdatesOnBoot());
        hashCode = 31 * hashCode + Objects.hashCode(useEbsOptimizedInstances());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleEventConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Layer)) {
            return false;
        }
        Layer other = (Layer) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(stackId(), other.stackId())
                && Objects.equals(layerId(), other.layerId()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(shortname(), other.shortname())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributesAsStrings(), other.attributesAsStrings())
                && Objects.equals(cloudWatchLogsConfiguration(), other.cloudWatchLogsConfiguration())
                && Objects.equals(customInstanceProfileArn(), other.customInstanceProfileArn())
                && Objects.equals(customJson(), other.customJson())
                && hasCustomSecurityGroupIds() == other.hasCustomSecurityGroupIds()
                && Objects.equals(customSecurityGroupIds(), other.customSecurityGroupIds())
                && hasDefaultSecurityGroupNames() == other.hasDefaultSecurityGroupNames()
                && Objects.equals(defaultSecurityGroupNames(), other.defaultSecurityGroupNames())
                && hasPackages() == other.hasPackages() && Objects.equals(packages(), other.packages())
                && hasVolumeConfigurations() == other.hasVolumeConfigurations()
                && Objects.equals(volumeConfigurations(), other.volumeConfigurations())
                && Objects.equals(enableAutoHealing(), other.enableAutoHealing())
                && Objects.equals(autoAssignElasticIps(), other.autoAssignElasticIps())
                && Objects.equals(autoAssignPublicIps(), other.autoAssignPublicIps())
                && Objects.equals(defaultRecipes(), other.defaultRecipes())
                && Objects.equals(customRecipes(), other.customRecipes()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(installUpdatesOnBoot(), other.installUpdatesOnBoot())
                && Objects.equals(useEbsOptimizedInstances(), other.useEbsOptimizedInstances())
                && Objects.equals(lifecycleEventConfiguration(), other.lifecycleEventConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Layer").add("Arn", arn()).add("StackId", stackId()).add("LayerId", layerId())
                .add("Type", typeAsString()).add("Name", name()).add("Shortname", shortname())
                .add("Attributes", hasAttributes() ? attributesAsStrings() : null)
                .add("CloudWatchLogsConfiguration", cloudWatchLogsConfiguration())
                .add("CustomInstanceProfileArn", customInstanceProfileArn()).add("CustomJson", customJson())
                .add("CustomSecurityGroupIds", hasCustomSecurityGroupIds() ? customSecurityGroupIds() : null)
                .add("DefaultSecurityGroupNames", hasDefaultSecurityGroupNames() ? defaultSecurityGroupNames() : null)
                .add("Packages", hasPackages() ? packages() : null)
                .add("VolumeConfigurations", hasVolumeConfigurations() ? volumeConfigurations() : null)
                .add("EnableAutoHealing", enableAutoHealing()).add("AutoAssignElasticIps", autoAssignElasticIps())
                .add("AutoAssignPublicIps", autoAssignPublicIps()).add("DefaultRecipes", defaultRecipes())
                .add("CustomRecipes", customRecipes()).add("CreatedAt", createdAt())
                .add("InstallUpdatesOnBoot", installUpdatesOnBoot()).add("UseEbsOptimizedInstances", useEbsOptimizedInstances())
                .add("LifecycleEventConfiguration", lifecycleEventConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "LayerId":
            return Optional.ofNullable(clazz.cast(layerId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Shortname":
            return Optional.ofNullable(clazz.cast(shortname()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributesAsStrings()));
        case "CloudWatchLogsConfiguration":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsConfiguration()));
        case "CustomInstanceProfileArn":
            return Optional.ofNullable(clazz.cast(customInstanceProfileArn()));
        case "CustomJson":
            return Optional.ofNullable(clazz.cast(customJson()));
        case "CustomSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(customSecurityGroupIds()));
        case "DefaultSecurityGroupNames":
            return Optional.ofNullable(clazz.cast(defaultSecurityGroupNames()));
        case "Packages":
            return Optional.ofNullable(clazz.cast(packages()));
        case "VolumeConfigurations":
            return Optional.ofNullable(clazz.cast(volumeConfigurations()));
        case "EnableAutoHealing":
            return Optional.ofNullable(clazz.cast(enableAutoHealing()));
        case "AutoAssignElasticIps":
            return Optional.ofNullable(clazz.cast(autoAssignElasticIps()));
        case "AutoAssignPublicIps":
            return Optional.ofNullable(clazz.cast(autoAssignPublicIps()));
        case "DefaultRecipes":
            return Optional.ofNullable(clazz.cast(defaultRecipes()));
        case "CustomRecipes":
            return Optional.ofNullable(clazz.cast(customRecipes()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "InstallUpdatesOnBoot":
            return Optional.ofNullable(clazz.cast(installUpdatesOnBoot()));
        case "UseEbsOptimizedInstances":
            return Optional.ofNullable(clazz.cast(useEbsOptimizedInstances()));
        case "LifecycleEventConfiguration":
            return Optional.ofNullable(clazz.cast(lifecycleEventConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Layer, T> g) {
        return obj -> g.apply((Layer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Layer> {
        /**
         * <p>
         * The Amazon Resource Number (ARN) of a layer.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Number (ARN) of a layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The layer stack ID.
         * </p>
         * 
         * @param stackId
         *        The layer stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The layer ID.
         * </p>
         * 
         * @param layerId
         *        The layer ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerId(String layerId);

        /**
         * <p>
         * The layer type.
         * </p>
         * 
         * @param type
         *        The layer type.
         * @see LayerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayerType
         */
        Builder type(String type);

        /**
         * <p>
         * The layer type.
         * </p>
         * 
         * @param type
         *        The layer type.
         * @see LayerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayerType
         */
        Builder type(LayerType type);

        /**
         * <p>
         * The layer name. Layer names can be a maximum of 32 characters.
         * </p>
         * 
         * @param name
         *        The layer name. Layer names can be a maximum of 32 characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The layer short name.
         * </p>
         * 
         * @param shortname
         *        The layer short name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortname(String shortname);

        /**
         * <p>
         * The layer attributes.
         * </p>
         * <p>
         * For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and <code>GangliaPassword</code>
         * attributes, OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value
         * </p>
         * <p>
         * For an ECS Cluster layer, OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the cluster's
         * ARN.
         * </p>
         * 
         * @param attributes
         *        The layer attributes.</p>
         *        <p>
         *        For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and
         *        <code>GangliaPassword</code> attributes, OpsWorks Stacks returns <code>*****FILTERED*****</code>
         *        instead of the actual value
         *        </p>
         *        <p>
         *        For an ECS Cluster layer, OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the
         *        cluster's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesWithStrings(Map<String, String> attributes);

        /**
         * <p>
         * The layer attributes.
         * </p>
         * <p>
         * For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and <code>GangliaPassword</code>
         * attributes, OpsWorks Stacks returns <code>*****FILTERED*****</code> instead of the actual value
         * </p>
         * <p>
         * For an ECS Cluster layer, OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the cluster's
         * ARN.
         * </p>
         * 
         * @param attributes
         *        The layer attributes.</p>
         *        <p>
         *        For the <code>HaproxyStatsPassword</code>, <code>MysqlRootPassword</code>, and
         *        <code>GangliaPassword</code> attributes, OpsWorks Stacks returns <code>*****FILTERED*****</code>
         *        instead of the actual value
         *        </p>
         *        <p>
         *        For an ECS Cluster layer, OpsWorks Stacks the <code>EcsClusterArn</code> attribute is set to the
         *        cluster's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<LayerAttributesKeys, String> attributes);

        /**
         * <p>
         * The Amazon CloudWatch Logs configuration settings for the layer.
         * </p>
         * 
         * @param cloudWatchLogsConfiguration
         *        The Amazon CloudWatch Logs configuration settings for the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsConfiguration(CloudWatchLogsConfiguration cloudWatchLogsConfiguration);

        /**
         * <p>
         * The Amazon CloudWatch Logs configuration settings for the layer.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchLogsConfiguration.Builder}
         * avoiding the need to create one manually via {@link CloudWatchLogsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchLogsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudWatchLogsConfiguration(CloudWatchLogsConfiguration)}.
         * 
         * @param cloudWatchLogsConfiguration
         *        a consumer that will call methods on {@link CloudWatchLogsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogsConfiguration(CloudWatchLogsConfiguration)
         */
        default Builder cloudWatchLogsConfiguration(Consumer<CloudWatchLogsConfiguration.Builder> cloudWatchLogsConfiguration) {
            return cloudWatchLogsConfiguration(CloudWatchLogsConfiguration.builder().applyMutation(cloudWatchLogsConfiguration)
                    .build());
        }

        /**
         * <p>
         * The ARN of the default IAM profile to be used for the layer's EC2 instances. For more information about IAM
         * ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
         * Identifiers</a>.
         * </p>
         * 
         * @param customInstanceProfileArn
         *        The ARN of the default IAM profile to be used for the layer's EC2 instances. For more information
         *        about IAM ARNs, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customInstanceProfileArn(String customInstanceProfileArn);

        /**
         * <p>
         * A JSON formatted string containing the layer's custom stack configuration and deployment attributes.
         * </p>
         * 
         * @param customJson
         *        A JSON formatted string containing the layer's custom stack configuration and deployment attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customJson(String customJson);

        /**
         * <p>
         * An array containing the layer's custom security group IDs.
         * </p>
         * 
         * @param customSecurityGroupIds
         *        An array containing the layer's custom security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSecurityGroupIds(Collection<String> customSecurityGroupIds);

        /**
         * <p>
         * An array containing the layer's custom security group IDs.
         * </p>
         * 
         * @param customSecurityGroupIds
         *        An array containing the layer's custom security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSecurityGroupIds(String... customSecurityGroupIds);

        /**
         * <p>
         * An array containing the layer's security group names.
         * </p>
         * 
         * @param defaultSecurityGroupNames
         *        An array containing the layer's security group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSecurityGroupNames(Collection<String> defaultSecurityGroupNames);

        /**
         * <p>
         * An array containing the layer's security group names.
         * </p>
         * 
         * @param defaultSecurityGroupNames
         *        An array containing the layer's security group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSecurityGroupNames(String... defaultSecurityGroupNames);

        /**
         * <p>
         * An array of <code>Package</code> objects that describe the layer's packages.
         * </p>
         * 
         * @param packages
         *        An array of <code>Package</code> objects that describe the layer's packages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packages(Collection<String> packages);

        /**
         * <p>
         * An array of <code>Package</code> objects that describe the layer's packages.
         * </p>
         * 
         * @param packages
         *        An array of <code>Package</code> objects that describe the layer's packages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packages(String... packages);

        /**
         * <p>
         * A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * </p>
         * 
         * @param volumeConfigurations
         *        A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeConfigurations(Collection<VolumeConfiguration> volumeConfigurations);

        /**
         * <p>
         * A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * </p>
         * 
         * @param volumeConfigurations
         *        A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeConfigurations(VolumeConfiguration... volumeConfigurations);

        /**
         * <p>
         * A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opsworks.model.VolumeConfiguration.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.opsworks.model.VolumeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opsworks.model.VolumeConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #volumeConfigurations(List<VolumeConfiguration>)}.
         * 
         * @param volumeConfigurations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opsworks.model.VolumeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeConfigurations(java.util.Collection<VolumeConfiguration>)
         */
        Builder volumeConfigurations(Consumer<VolumeConfiguration.Builder>... volumeConfigurations);

        /**
         * <p>
         * Whether auto healing is disabled for the layer.
         * </p>
         * 
         * @param enableAutoHealing
         *        Whether auto healing is disabled for the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAutoHealing(Boolean enableAutoHealing);

        /**
         * <p>
         * Whether to automatically assign an <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
         * address</a> to the layer's instances. For more information, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
         * Layer</a>.
         * </p>
         * 
         * @param autoAssignElasticIps
         *        Whether to automatically assign an <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
         *        address</a> to the layer's instances. For more information, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to
         *        Edit a Layer</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoAssignElasticIps(Boolean autoAssignElasticIps);

        /**
         * <p>
         * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's
         * instances. For more information, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
         * Layer</a>.
         * </p>
         * 
         * @param autoAssignPublicIps
         *        For stacks that are running in a VPC, whether to automatically assign a public IP address to the
         *        layer's instances. For more information, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to
         *        Edit a Layer</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoAssignPublicIps(Boolean autoAssignPublicIps);

        /**
         * <p>
         * OpsWorks Stacks supports five lifecycle events: <b>setup</b>, <b>configuration</b>, <b>deploy</b>,
         * <b>undeploy</b>, and <b>shutdown</b>. For each layer, OpsWorks Stacks runs a set of standard recipes for each
         * event. You can also provide custom recipes for any or all layers and events. OpsWorks Stacks runs custom
         * event recipes after the standard recipes. <code>LayerCustomRecipes</code> specifies the custom recipes for a
         * particular layer to be run in response to each of the five events.
         * </p>
         * <p>
         * To specify a recipe, use the cookbook's directory name in the repository followed by two colons and the
         * recipe name, which is the recipe's file name without the <code>.rb</code> extension. For example:
         * <code>phpapp2::dbsetup</code> specifies the <code>dbsetup.rb</code> recipe in the repository's
         * <code>phpapp2</code> folder.
         * </p>
         * 
         * @param defaultRecipes
         *        OpsWorks Stacks supports five lifecycle events: <b>setup</b>, <b>configuration</b>, <b>deploy</b>,
         *        <b>undeploy</b>, and <b>shutdown</b>. For each layer, OpsWorks Stacks runs a set of standard recipes
         *        for each event. You can also provide custom recipes for any or all layers and events. OpsWorks Stacks
         *        runs custom event recipes after the standard recipes. <code>LayerCustomRecipes</code> specifies the
         *        custom recipes for a particular layer to be run in response to each of the five events.</p>
         *        <p>
         *        To specify a recipe, use the cookbook's directory name in the repository followed by two colons and
         *        the recipe name, which is the recipe's file name without the <code>.rb</code> extension. For example:
         *        <code>phpapp2::dbsetup</code> specifies the <code>dbsetup.rb</code> recipe in the repository's
         *        <code>phpapp2</code> folder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultRecipes(Recipes defaultRecipes);

        /**
         * <p>
         * OpsWorks Stacks supports five lifecycle events: <b>setup</b>, <b>configuration</b>, <b>deploy</b>,
         * <b>undeploy</b>, and <b>shutdown</b>. For each layer, OpsWorks Stacks runs a set of standard recipes for each
         * event. You can also provide custom recipes for any or all layers and events. OpsWorks Stacks runs custom
         * event recipes after the standard recipes. <code>LayerCustomRecipes</code> specifies the custom recipes for a
         * particular layer to be run in response to each of the five events.
         * </p>
         * <p>
         * To specify a recipe, use the cookbook's directory name in the repository followed by two colons and the
         * recipe name, which is the recipe's file name without the <code>.rb</code> extension. For example:
         * <code>phpapp2::dbsetup</code> specifies the <code>dbsetup.rb</code> recipe in the repository's
         * <code>phpapp2</code> folder.
         * </p>
         * This is a convenience method that creates an instance of the {@link Recipes.Builder} avoiding the need to
         * create one manually via {@link Recipes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Recipes.Builder#build()} is called immediately and its result is
         * passed to {@link #defaultRecipes(Recipes)}.
         * 
         * @param defaultRecipes
         *        a consumer that will call methods on {@link Recipes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultRecipes(Recipes)
         */
        default Builder defaultRecipes(Consumer<Recipes.Builder> defaultRecipes) {
            return defaultRecipes(Recipes.builder().applyMutation(defaultRecipes).build());
        }

        /**
         * <p>
         * A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.
         * </p>
         * 
         * @param customRecipes
         *        A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRecipes(Recipes customRecipes);

        /**
         * <p>
         * A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.
         * </p>
         * This is a convenience method that creates an instance of the {@link Recipes.Builder} avoiding the need to
         * create one manually via {@link Recipes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Recipes.Builder#build()} is called immediately and its result is
         * passed to {@link #customRecipes(Recipes)}.
         * 
         * @param customRecipes
         *        a consumer that will call methods on {@link Recipes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customRecipes(Recipes)
         */
        default Builder customRecipes(Consumer<Recipes.Builder> customRecipes) {
            return customRecipes(Recipes.builder().applyMutation(customRecipes).build());
        }

        /**
         * <p>
         * Date when the layer was created.
         * </p>
         * 
         * @param createdAt
         *        Date when the layer was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * Whether to install operating system and package updates when the instance boots. The default value is
         * <code>true</code>. If this value is set to <code>false</code>, you must then update your instances manually
         * by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or manually
         * running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
         * </p>
         * <note>
         * <p>
         * We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the
         * latest security updates.
         * </p>
         * </note>
         * 
         * @param installUpdatesOnBoot
         *        Whether to install operating system and package updates when the instance boots. The default value is
         *        <code>true</code>. If this value is set to <code>false</code>, you must then update your instances
         *        manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or
         *        manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
         *        </p> <note>
         *        <p>
         *        We strongly recommend using the default value of <code>true</code>, to ensure that your instances have
         *        the latest security updates.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot);

        /**
         * <p>
         * Whether the layer uses Amazon EBS-optimized instances.
         * </p>
         * 
         * @param useEbsOptimizedInstances
         *        Whether the layer uses Amazon EBS-optimized instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useEbsOptimizedInstances(Boolean useEbsOptimizedInstances);

        /**
         * <p>
         * A <code>LifeCycleEventConfiguration</code> object that specifies the Shutdown event configuration.
         * </p>
         * 
         * @param lifecycleEventConfiguration
         *        A <code>LifeCycleEventConfiguration</code> object that specifies the Shutdown event configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleEventConfiguration(LifecycleEventConfiguration lifecycleEventConfiguration);

        /**
         * <p>
         * A <code>LifeCycleEventConfiguration</code> object that specifies the Shutdown event configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifecycleEventConfiguration.Builder}
         * avoiding the need to create one manually via {@link LifecycleEventConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecycleEventConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #lifecycleEventConfiguration(LifecycleEventConfiguration)}.
         * 
         * @param lifecycleEventConfiguration
         *        a consumer that will call methods on {@link LifecycleEventConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycleEventConfiguration(LifecycleEventConfiguration)
         */
        default Builder lifecycleEventConfiguration(Consumer<LifecycleEventConfiguration.Builder> lifecycleEventConfiguration) {
            return lifecycleEventConfiguration(LifecycleEventConfiguration.builder().applyMutation(lifecycleEventConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String stackId;

        private String layerId;

        private String type;

        private String name;

        private String shortname;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private CloudWatchLogsConfiguration cloudWatchLogsConfiguration;

        private String customInstanceProfileArn;

        private String customJson;

        private List<String> customSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> defaultSecurityGroupNames = DefaultSdkAutoConstructList.getInstance();

        private List<String> packages = DefaultSdkAutoConstructList.getInstance();

        private List<VolumeConfiguration> volumeConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Boolean enableAutoHealing;

        private Boolean autoAssignElasticIps;

        private Boolean autoAssignPublicIps;

        private Recipes defaultRecipes;

        private Recipes customRecipes;

        private String createdAt;

        private Boolean installUpdatesOnBoot;

        private Boolean useEbsOptimizedInstances;

        private LifecycleEventConfiguration lifecycleEventConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Layer model) {
            arn(model.arn);
            stackId(model.stackId);
            layerId(model.layerId);
            type(model.type);
            name(model.name);
            shortname(model.shortname);
            attributesWithStrings(model.attributes);
            cloudWatchLogsConfiguration(model.cloudWatchLogsConfiguration);
            customInstanceProfileArn(model.customInstanceProfileArn);
            customJson(model.customJson);
            customSecurityGroupIds(model.customSecurityGroupIds);
            defaultSecurityGroupNames(model.defaultSecurityGroupNames);
            packages(model.packages);
            volumeConfigurations(model.volumeConfigurations);
            enableAutoHealing(model.enableAutoHealing);
            autoAssignElasticIps(model.autoAssignElasticIps);
            autoAssignPublicIps(model.autoAssignPublicIps);
            defaultRecipes(model.defaultRecipes);
            customRecipes(model.customRecipes);
            createdAt(model.createdAt);
            installUpdatesOnBoot(model.installUpdatesOnBoot);
            useEbsOptimizedInstances(model.useEbsOptimizedInstances);
            lifecycleEventConfiguration(model.lifecycleEventConfiguration);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getStackId() {
            return stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getLayerId() {
            return layerId;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LayerType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getShortname() {
            return shortname;
        }

        public final void setShortname(String shortname) {
            this.shortname = shortname;
        }

        @Override
        public final Builder shortname(String shortname) {
            this.shortname = shortname;
            return this;
        }

        public final Map<String, String> getAttributes() {
            if (attributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return attributes;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = LayerAttributesCopier.copy(attributes);
        }

        @Override
        public final Builder attributesWithStrings(Map<String, String> attributes) {
            this.attributes = LayerAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        public final Builder attributes(Map<LayerAttributesKeys, String> attributes) {
            this.attributes = LayerAttributesCopier.copyEnumToString(attributes);
            return this;
        }

        public final CloudWatchLogsConfiguration.Builder getCloudWatchLogsConfiguration() {
            return cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.toBuilder() : null;
        }

        public final void setCloudWatchLogsConfiguration(CloudWatchLogsConfiguration.BuilderImpl cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.build() : null;
        }

        @Override
        public final Builder cloudWatchLogsConfiguration(CloudWatchLogsConfiguration cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration;
            return this;
        }

        public final String getCustomInstanceProfileArn() {
            return customInstanceProfileArn;
        }

        public final void setCustomInstanceProfileArn(String customInstanceProfileArn) {
            this.customInstanceProfileArn = customInstanceProfileArn;
        }

        @Override
        public final Builder customInstanceProfileArn(String customInstanceProfileArn) {
            this.customInstanceProfileArn = customInstanceProfileArn;
            return this;
        }

        public final String getCustomJson() {
            return customJson;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final Collection<String> getCustomSecurityGroupIds() {
            if (customSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return customSecurityGroupIds;
        }

        public final void setCustomSecurityGroupIds(Collection<String> customSecurityGroupIds) {
            this.customSecurityGroupIds = StringsCopier.copy(customSecurityGroupIds);
        }

        @Override
        public final Builder customSecurityGroupIds(Collection<String> customSecurityGroupIds) {
            this.customSecurityGroupIds = StringsCopier.copy(customSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customSecurityGroupIds(String... customSecurityGroupIds) {
            customSecurityGroupIds(Arrays.asList(customSecurityGroupIds));
            return this;
        }

        public final Collection<String> getDefaultSecurityGroupNames() {
            if (defaultSecurityGroupNames instanceof SdkAutoConstructList) {
                return null;
            }
            return defaultSecurityGroupNames;
        }

        public final void setDefaultSecurityGroupNames(Collection<String> defaultSecurityGroupNames) {
            this.defaultSecurityGroupNames = StringsCopier.copy(defaultSecurityGroupNames);
        }

        @Override
        public final Builder defaultSecurityGroupNames(Collection<String> defaultSecurityGroupNames) {
            this.defaultSecurityGroupNames = StringsCopier.copy(defaultSecurityGroupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder defaultSecurityGroupNames(String... defaultSecurityGroupNames) {
            defaultSecurityGroupNames(Arrays.asList(defaultSecurityGroupNames));
            return this;
        }

        public final Collection<String> getPackages() {
            if (packages instanceof SdkAutoConstructList) {
                return null;
            }
            return packages;
        }

        public final void setPackages(Collection<String> packages) {
            this.packages = StringsCopier.copy(packages);
        }

        @Override
        public final Builder packages(Collection<String> packages) {
            this.packages = StringsCopier.copy(packages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packages(String... packages) {
            packages(Arrays.asList(packages));
            return this;
        }

        public final List<VolumeConfiguration.Builder> getVolumeConfigurations() {
            List<VolumeConfiguration.Builder> result = VolumeConfigurationsCopier.copyToBuilder(this.volumeConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumeConfigurations(Collection<VolumeConfiguration.BuilderImpl> volumeConfigurations) {
            this.volumeConfigurations = VolumeConfigurationsCopier.copyFromBuilder(volumeConfigurations);
        }

        @Override
        public final Builder volumeConfigurations(Collection<VolumeConfiguration> volumeConfigurations) {
            this.volumeConfigurations = VolumeConfigurationsCopier.copy(volumeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(VolumeConfiguration... volumeConfigurations) {
            volumeConfigurations(Arrays.asList(volumeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(Consumer<VolumeConfiguration.Builder>... volumeConfigurations) {
            volumeConfigurations(Stream.of(volumeConfigurations).map(c -> VolumeConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEnableAutoHealing() {
            return enableAutoHealing;
        }

        public final void setEnableAutoHealing(Boolean enableAutoHealing) {
            this.enableAutoHealing = enableAutoHealing;
        }

        @Override
        public final Builder enableAutoHealing(Boolean enableAutoHealing) {
            this.enableAutoHealing = enableAutoHealing;
            return this;
        }

        public final Boolean getAutoAssignElasticIps() {
            return autoAssignElasticIps;
        }

        public final void setAutoAssignElasticIps(Boolean autoAssignElasticIps) {
            this.autoAssignElasticIps = autoAssignElasticIps;
        }

        @Override
        public final Builder autoAssignElasticIps(Boolean autoAssignElasticIps) {
            this.autoAssignElasticIps = autoAssignElasticIps;
            return this;
        }

        public final Boolean getAutoAssignPublicIps() {
            return autoAssignPublicIps;
        }

        public final void setAutoAssignPublicIps(Boolean autoAssignPublicIps) {
            this.autoAssignPublicIps = autoAssignPublicIps;
        }

        @Override
        public final Builder autoAssignPublicIps(Boolean autoAssignPublicIps) {
            this.autoAssignPublicIps = autoAssignPublicIps;
            return this;
        }

        public final Recipes.Builder getDefaultRecipes() {
            return defaultRecipes != null ? defaultRecipes.toBuilder() : null;
        }

        public final void setDefaultRecipes(Recipes.BuilderImpl defaultRecipes) {
            this.defaultRecipes = defaultRecipes != null ? defaultRecipes.build() : null;
        }

        @Override
        public final Builder defaultRecipes(Recipes defaultRecipes) {
            this.defaultRecipes = defaultRecipes;
            return this;
        }

        public final Recipes.Builder getCustomRecipes() {
            return customRecipes != null ? customRecipes.toBuilder() : null;
        }

        public final void setCustomRecipes(Recipes.BuilderImpl customRecipes) {
            this.customRecipes = customRecipes != null ? customRecipes.build() : null;
        }

        @Override
        public final Builder customRecipes(Recipes customRecipes) {
            this.customRecipes = customRecipes;
            return this;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Boolean getInstallUpdatesOnBoot() {
            return installUpdatesOnBoot;
        }

        public final void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
        }

        @Override
        public final Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        public final Boolean getUseEbsOptimizedInstances() {
            return useEbsOptimizedInstances;
        }

        public final void setUseEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
            this.useEbsOptimizedInstances = useEbsOptimizedInstances;
        }

        @Override
        public final Builder useEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
            this.useEbsOptimizedInstances = useEbsOptimizedInstances;
            return this;
        }

        public final LifecycleEventConfiguration.Builder getLifecycleEventConfiguration() {
            return lifecycleEventConfiguration != null ? lifecycleEventConfiguration.toBuilder() : null;
        }

        public final void setLifecycleEventConfiguration(LifecycleEventConfiguration.BuilderImpl lifecycleEventConfiguration) {
            this.lifecycleEventConfiguration = lifecycleEventConfiguration != null ? lifecycleEventConfiguration.build() : null;
        }

        @Override
        public final Builder lifecycleEventConfiguration(LifecycleEventConfiguration lifecycleEventConfiguration) {
            this.lifecycleEventConfiguration = lifecycleEventConfiguration;
            return this;
        }

        @Override
        public Layer build() {
            return new Layer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
