/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.DeploymentCommand;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeploymentRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, CreateDeploymentRequest> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::stackId)).setter(CreateDeploymentRequest.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> APP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppId").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::appId)).setter(CreateDeploymentRequest.setter(Builder::appId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppId").build()}).build();
    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceIds").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::instanceIds)).setter(CreateDeploymentRequest.setter(Builder::instanceIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LAYER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LayerIds").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::layerIds)).setter(CreateDeploymentRequest.setter(Builder::layerIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<DeploymentCommand> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Command").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::command)).setter(CreateDeploymentRequest.setter(Builder::command)).constructor(DeploymentCommand::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Command").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Comment").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::comment)).setter(CreateDeploymentRequest.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()}).build();
    private static final SdkField<String> CUSTOM_JSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomJson").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::customJson)).setter(CreateDeploymentRequest.setter(Builder::customJson)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomJson").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, APP_ID_FIELD, INSTANCE_IDS_FIELD, LAYER_IDS_FIELD, COMMAND_FIELD, COMMENT_FIELD, CUSTOM_JSON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("StackId", STACK_ID_FIELD);
            this.put("AppId", APP_ID_FIELD);
            this.put("InstanceIds", INSTANCE_IDS_FIELD);
            this.put("LayerIds", LAYER_IDS_FIELD);
            this.put("Command", COMMAND_FIELD);
            this.put("Comment", COMMENT_FIELD);
            this.put("CustomJson", CUSTOM_JSON_FIELD);
        }
    });
    private final String stackId;
    private final String appId;
    private final List<String> instanceIds;
    private final List<String> layerIds;
    private final DeploymentCommand command;
    private final String comment;
    private final String customJson;

    private CreateDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.appId = builder.appId;
        this.instanceIds = builder.instanceIds;
        this.layerIds = builder.layerIds;
        this.command = builder.command;
        this.comment = builder.comment;
        this.customJson = builder.customJson;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final String appId() {
        return this.appId;
    }

    public final boolean hasInstanceIds() {
        return this.instanceIds != null && !(this.instanceIds instanceof SdkAutoConstructList);
    }

    public final List<String> instanceIds() {
        return this.instanceIds;
    }

    public final boolean hasLayerIds() {
        return this.layerIds != null && !(this.layerIds instanceof SdkAutoConstructList);
    }

    public final List<String> layerIds() {
        return this.layerIds;
    }

    public final DeploymentCommand command() {
        return this.command;
    }

    public final String comment() {
        return this.comment;
    }

    public final String customJson() {
        return this.customJson;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.appId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceIds() ? this.instanceIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLayerIds() ? this.layerIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.command());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.customJson());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.appId(), other.appId()) && this.hasInstanceIds() == other.hasInstanceIds() && Objects.equals(this.instanceIds(), other.instanceIds()) && this.hasLayerIds() == other.hasLayerIds() && Objects.equals(this.layerIds(), other.layerIds()) && Objects.equals(this.command(), other.command()) && Objects.equals(this.comment(), other.comment()) && Objects.equals(this.customJson(), other.customJson());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDeploymentRequest").add("StackId", (Object)this.stackId()).add("AppId", (Object)this.appId()).add("InstanceIds", this.hasInstanceIds() ? this.instanceIds() : null).add("LayerIds", this.hasLayerIds() ? this.layerIds() : null).add("Command", (Object)this.command()).add("Comment", (Object)this.comment()).add("CustomJson", (Object)this.customJson()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "AppId": {
                return Optional.ofNullable(clazz.cast(this.appId()));
            }
            case "InstanceIds": {
                return Optional.ofNullable(clazz.cast(this.instanceIds()));
            }
            case "LayerIds": {
                return Optional.ofNullable(clazz.cast(this.layerIds()));
            }
            case "Command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "Comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "CustomJson": {
                return Optional.ofNullable(clazz.cast(this.customJson()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentRequest, T> g) {
        return obj -> g.apply((CreateDeploymentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String stackId;
        private String appId;
        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> layerIds = DefaultSdkAutoConstructList.getInstance();
        private DeploymentCommand command;
        private String comment;
        private String customJson;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentRequest model) {
            super(model);
            this.stackId(model.stackId);
            this.appId(model.appId);
            this.instanceIds(model.instanceIds);
            this.layerIds(model.layerIds);
            this.command(model.command);
            this.comment(model.comment);
            this.customJson(model.customJson);
        }

        public final String getStackId() {
            return this.stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getAppId() {
            return this.appId;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final Collection<String> getInstanceIds() {
            if (this.instanceIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceIds;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String ... instanceIds) {
            this.instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final Collection<String> getLayerIds() {
            if (this.layerIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.layerIds;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        @Override
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerIds(String ... layerIds) {
            this.layerIds(Arrays.asList(layerIds));
            return this;
        }

        public final DeploymentCommand.Builder getCommand() {
            return this.command != null ? this.command.toBuilder() : null;
        }

        public final void setCommand(DeploymentCommand.BuilderImpl command) {
            this.command = command != null ? command.build() : null;
        }

        @Override
        public final Builder command(DeploymentCommand command) {
            this.command = command;
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getCustomJson() {
            return this.customJson;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentRequest build() {
            return new CreateDeploymentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpsWorksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeploymentRequest> {
        public Builder stackId(String var1);

        public Builder appId(String var1);

        public Builder instanceIds(Collection<String> var1);

        public Builder instanceIds(String ... var1);

        public Builder layerIds(Collection<String> var1);

        public Builder layerIds(String ... var1);

        public Builder command(DeploymentCommand var1);

        default public Builder command(Consumer<DeploymentCommand.Builder> command) {
            return this.command((DeploymentCommand)((DeploymentCommand.Builder)DeploymentCommand.builder().applyMutation(command)).build());
        }

        public Builder comment(String var1);

        public Builder customJson(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

