/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDeploymentsRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeDeploymentsRequest.Builder, DescribeDeploymentsRequest> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDeploymentsRequest::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeDeploymentsRequest::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppId").build()).build();

    private static final SdkField<List<String>> DEPLOYMENT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeDeploymentsRequest::deploymentIds))
            .setter(setter(Builder::deploymentIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, APP_ID_FIELD,
            DEPLOYMENT_IDS_FIELD));

    private final String stackId;

    private final String appId;

    private final List<String> deploymentIds;

    private DescribeDeploymentsRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.appId = builder.appId;
        this.deploymentIds = builder.deploymentIds;
    }

    /**
     * <p>
     * The stack ID. If you include this parameter, the command returns a description of the commands associated with
     * the specified stack.
     * </p>
     * 
     * @return The stack ID. If you include this parameter, the command returns a description of the commands associated
     *         with the specified stack.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The app ID. If you include this parameter, the command returns a description of the commands associated with the
     * specified app.
     * </p>
     * 
     * @return The app ID. If you include this parameter, the command returns a description of the commands associated
     *         with the specified app.
     */
    public String appId() {
        return appId;
    }

    /**
     * <p>
     * An array of deployment IDs to be described. If you include this parameter, the command returns a description of
     * the specified deployments. Otherwise, it returns a description of every deployment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of deployment IDs to be described. If you include this parameter, the command returns a
     *         description of the specified deployments. Otherwise, it returns a description of every deployment.
     */
    public List<String> deploymentIds() {
        return deploymentIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeploymentsRequest)) {
            return false;
        }
        DescribeDeploymentsRequest other = (DescribeDeploymentsRequest) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(appId(), other.appId())
                && Objects.equals(deploymentIds(), other.deploymentIds());
    }

    @Override
    public String toString() {
        return ToString.builder("DescribeDeploymentsRequest").add("StackId", stackId()).add("AppId", appId())
                .add("DeploymentIds", deploymentIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "AppId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "DeploymentIds":
            return Optional.ofNullable(clazz.cast(deploymentIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDeploymentsRequest, T> g) {
        return obj -> g.apply((DescribeDeploymentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeDeploymentsRequest> {
        /**
         * <p>
         * The stack ID. If you include this parameter, the command returns a description of the commands associated
         * with the specified stack.
         * </p>
         * 
         * @param stackId
         *        The stack ID. If you include this parameter, the command returns a description of the commands
         *        associated with the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The app ID. If you include this parameter, the command returns a description of the commands associated with
         * the specified app.
         * </p>
         * 
         * @param appId
         *        The app ID. If you include this parameter, the command returns a description of the commands
         *        associated with the specified app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * An array of deployment IDs to be described. If you include this parameter, the command returns a description
         * of the specified deployments. Otherwise, it returns a description of every deployment.
         * </p>
         * 
         * @param deploymentIds
         *        An array of deployment IDs to be described. If you include this parameter, the command returns a
         *        description of the specified deployments. Otherwise, it returns a description of every deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentIds(Collection<String> deploymentIds);

        /**
         * <p>
         * An array of deployment IDs to be described. If you include this parameter, the command returns a description
         * of the specified deployments. Otherwise, it returns a description of every deployment.
         * </p>
         * 
         * @param deploymentIds
         *        An array of deployment IDs to be described. If you include this parameter, the command returns a
         *        description of the specified deployments. Otherwise, it returns a description of every deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentIds(String... deploymentIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String stackId;

        private String appId;

        private List<String> deploymentIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeploymentsRequest model) {
            super(model);
            stackId(model.stackId);
            appId(model.appId);
            deploymentIds(model.deploymentIds);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final Collection<String> getDeploymentIds() {
            return deploymentIds;
        }

        @Override
        public final Builder deploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = StringsCopier.copy(deploymentIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deploymentIds(String... deploymentIds) {
            deploymentIds(Arrays.asList(deploymentIds));
            return this;
        }

        public final void setDeploymentIds(Collection<String> deploymentIds) {
            this.deploymentIds = StringsCopier.copy(deploymentIds);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeDeploymentsRequest build() {
            return new DescribeDeploymentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
