/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Amazon EBS volume. This data type maps directly to the Amazon EC2 <a
 * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a> data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EbsBlockDevice implements SdkPojo, Serializable, ToCopyableBuilder<EbsBlockDevice.Builder, EbsBlockDevice> {
    private static final SdkField<String> SNAPSHOT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EbsBlockDevice::snapshotId)).setter(setter(Builder::snapshotId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotId").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(EbsBlockDevice::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<Integer> VOLUME_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(EbsBlockDevice::volumeSize)).setter(setter(Builder::volumeSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSize").build()).build();

    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EbsBlockDevice::volumeTypeAsString)).setter(setter(Builder::volumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()).build();

    private static final SdkField<Boolean> DELETE_ON_TERMINATION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(EbsBlockDevice::deleteOnTermination)).setter(setter(Builder::deleteOnTermination))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteOnTermination").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_ID_FIELD, IOPS_FIELD,
            VOLUME_SIZE_FIELD, VOLUME_TYPE_FIELD, DELETE_ON_TERMINATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String snapshotId;

    private final Integer iops;

    private final Integer volumeSize;

    private final String volumeType;

    private final Boolean deleteOnTermination;

    private EbsBlockDevice(BuilderImpl builder) {
        this.snapshotId = builder.snapshotId;
        this.iops = builder.iops;
        this.volumeSize = builder.volumeSize;
        this.volumeType = builder.volumeType;
        this.deleteOnTermination = builder.deleteOnTermination;
    }

    /**
     * <p>
     * The snapshot ID.
     * </p>
     * 
     * @return The snapshot ID.
     */
    public String snapshotId() {
        return snapshotId;
    }

    /**
     * <p>
     * The number of I/O operations per second (IOPS) that the volume supports. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.
     * </p>
     * 
     * @return The number of I/O operations per second (IOPS) that the volume supports. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.
     */
    public Integer iops() {
        return iops;
    }

    /**
     * <p>
     * The volume size, in GiB. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.
     * </p>
     * 
     * @return The volume size, in GiB. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.
     */
    public Integer volumeSize() {
        return volumeSize;
    }

    /**
     * <p>
     * The volume type. <code>gp2</code> for General Purpose (SSD) volumes, <code>io1</code> for Provisioned IOPS (SSD)
     * volumes, <code>st1</code> for Throughput Optimized hard disk drives (HDD), <code>sc1</code> for Cold HDD,and
     * <code>standard</code> for Magnetic volumes.
     * </p>
     * <p>
     * If you specify the <code>io1</code> volume type, you must also specify a value for the <code>Iops</code>
     * attribute. The maximum ratio of provisioned IOPS to requested volume size (in GiB) is 50:1. AWS uses the default
     * volume size (in GiB) specified in the AMI attributes to set IOPS to 50 x (volume size).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The volume type. <code>gp2</code> for General Purpose (SSD) volumes, <code>io1</code> for Provisioned
     *         IOPS (SSD) volumes, <code>st1</code> for Throughput Optimized hard disk drives (HDD), <code>sc1</code>
     *         for Cold HDD,and <code>standard</code> for Magnetic volumes.</p>
     *         <p>
     *         If you specify the <code>io1</code> volume type, you must also specify a value for the <code>Iops</code>
     *         attribute. The maximum ratio of provisioned IOPS to requested volume size (in GiB) is 50:1. AWS uses the
     *         default volume size (in GiB) specified in the AMI attributes to set IOPS to 50 x (volume size).
     * @see VolumeType
     */
    public VolumeType volumeType() {
        return VolumeType.fromValue(volumeType);
    }

    /**
     * <p>
     * The volume type. <code>gp2</code> for General Purpose (SSD) volumes, <code>io1</code> for Provisioned IOPS (SSD)
     * volumes, <code>st1</code> for Throughput Optimized hard disk drives (HDD), <code>sc1</code> for Cold HDD,and
     * <code>standard</code> for Magnetic volumes.
     * </p>
     * <p>
     * If you specify the <code>io1</code> volume type, you must also specify a value for the <code>Iops</code>
     * attribute. The maximum ratio of provisioned IOPS to requested volume size (in GiB) is 50:1. AWS uses the default
     * volume size (in GiB) specified in the AMI attributes to set IOPS to 50 x (volume size).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #volumeType} will
     * return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #volumeTypeAsString}.
     * </p>
     * 
     * @return The volume type. <code>gp2</code> for General Purpose (SSD) volumes, <code>io1</code> for Provisioned
     *         IOPS (SSD) volumes, <code>st1</code> for Throughput Optimized hard disk drives (HDD), <code>sc1</code>
     *         for Cold HDD,and <code>standard</code> for Magnetic volumes.</p>
     *         <p>
     *         If you specify the <code>io1</code> volume type, you must also specify a value for the <code>Iops</code>
     *         attribute. The maximum ratio of provisioned IOPS to requested volume size (in GiB) is 50:1. AWS uses the
     *         default volume size (in GiB) specified in the AMI attributes to set IOPS to 50 x (volume size).
     * @see VolumeType
     */
    public String volumeTypeAsString() {
        return volumeType;
    }

    /**
     * <p>
     * Whether the volume is deleted on instance termination.
     * </p>
     * 
     * @return Whether the volume is deleted on instance termination.
     */
    public Boolean deleteOnTermination() {
        return deleteOnTermination;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(volumeSize());
        hashCode = 31 * hashCode + Objects.hashCode(volumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deleteOnTermination());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsBlockDevice)) {
            return false;
        }
        EbsBlockDevice other = (EbsBlockDevice) obj;
        return Objects.equals(snapshotId(), other.snapshotId()) && Objects.equals(iops(), other.iops())
                && Objects.equals(volumeSize(), other.volumeSize())
                && Objects.equals(volumeTypeAsString(), other.volumeTypeAsString())
                && Objects.equals(deleteOnTermination(), other.deleteOnTermination());
    }

    @Override
    public String toString() {
        return ToString.builder("EbsBlockDevice").add("SnapshotId", snapshotId()).add("Iops", iops())
                .add("VolumeSize", volumeSize()).add("VolumeType", volumeTypeAsString())
                .add("DeleteOnTermination", deleteOnTermination()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotId":
            return Optional.ofNullable(clazz.cast(snapshotId()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "VolumeSize":
            return Optional.ofNullable(clazz.cast(volumeSize()));
        case "VolumeType":
            return Optional.ofNullable(clazz.cast(volumeTypeAsString()));
        case "DeleteOnTermination":
            return Optional.ofNullable(clazz.cast(deleteOnTermination()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbsBlockDevice, T> g) {
        return obj -> g.apply((EbsBlockDevice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EbsBlockDevice> {
        /**
         * <p>
         * The snapshot ID.
         * </p>
         * 
         * @param snapshotId
         *        The snapshot ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotId(String snapshotId);

        /**
         * <p>
         * The number of I/O operations per second (IOPS) that the volume supports. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.
         * </p>
         * 
         * @param iops
         *        The number of I/O operations per second (IOPS) that the volume supports. For more information, see <a
         *        href
         *        ="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The volume size, in GiB. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html">EbsBlockDevice</a>.
         * </p>
         * 
         * @param volumeSize
         *        The volume size, in GiB. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EbsBlockDevice.html"
         *        >EbsBlockDevice</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSize(Integer volumeSize);

        /**
         * <p>
         * The volume type. <code>gp2</code> for General Purpose (SSD) volumes, <code>io1</code> for Provisioned IOPS
         * (SSD) volumes, <code>st1</code> for Throughput Optimized hard disk drives (HDD), <code>sc1</code> for Cold
         * HDD,and <code>standard</code> for Magnetic volumes.
         * </p>
         * <p>
         * If you specify the <code>io1</code> volume type, you must also specify a value for the <code>Iops</code>
         * attribute. The maximum ratio of provisioned IOPS to requested volume size (in GiB) is 50:1. AWS uses the
         * default volume size (in GiB) specified in the AMI attributes to set IOPS to 50 x (volume size).
         * </p>
         * 
         * @param volumeType
         *        The volume type. <code>gp2</code> for General Purpose (SSD) volumes, <code>io1</code> for Provisioned
         *        IOPS (SSD) volumes, <code>st1</code> for Throughput Optimized hard disk drives (HDD), <code>sc1</code>
         *        for Cold HDD,and <code>standard</code> for Magnetic volumes.</p>
         *        <p>
         *        If you specify the <code>io1</code> volume type, you must also specify a value for the
         *        <code>Iops</code> attribute. The maximum ratio of provisioned IOPS to requested volume size (in GiB)
         *        is 50:1. AWS uses the default volume size (in GiB) specified in the AMI attributes to set IOPS to 50 x
         *        (volume size).
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * The volume type. <code>gp2</code> for General Purpose (SSD) volumes, <code>io1</code> for Provisioned IOPS
         * (SSD) volumes, <code>st1</code> for Throughput Optimized hard disk drives (HDD), <code>sc1</code> for Cold
         * HDD,and <code>standard</code> for Magnetic volumes.
         * </p>
         * <p>
         * If you specify the <code>io1</code> volume type, you must also specify a value for the <code>Iops</code>
         * attribute. The maximum ratio of provisioned IOPS to requested volume size (in GiB) is 50:1. AWS uses the
         * default volume size (in GiB) specified in the AMI attributes to set IOPS to 50 x (volume size).
         * </p>
         * 
         * @param volumeType
         *        The volume type. <code>gp2</code> for General Purpose (SSD) volumes, <code>io1</code> for Provisioned
         *        IOPS (SSD) volumes, <code>st1</code> for Throughput Optimized hard disk drives (HDD), <code>sc1</code>
         *        for Cold HDD,and <code>standard</code> for Magnetic volumes.</p>
         *        <p>
         *        If you specify the <code>io1</code> volume type, you must also specify a value for the
         *        <code>Iops</code> attribute. The maximum ratio of provisioned IOPS to requested volume size (in GiB)
         *        is 50:1. AWS uses the default volume size (in GiB) specified in the AMI attributes to set IOPS to 50 x
         *        (volume size).
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(VolumeType volumeType);

        /**
         * <p>
         * Whether the volume is deleted on instance termination.
         * </p>
         * 
         * @param deleteOnTermination
         *        Whether the volume is deleted on instance termination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteOnTermination(Boolean deleteOnTermination);
    }

    static final class BuilderImpl implements Builder {
        private String snapshotId;

        private Integer iops;

        private Integer volumeSize;

        private String volumeType;

        private Boolean deleteOnTermination;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsBlockDevice model) {
            snapshotId(model.snapshotId);
            iops(model.iops);
            volumeSize(model.volumeSize);
            volumeType(model.volumeType);
            deleteOnTermination(model.deleteOnTermination);
        }

        public final String getSnapshotId() {
            return snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final Integer getVolumeSize() {
            return volumeSize;
        }

        @Override
        public final Builder volumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        public final void setVolumeSize(Integer volumeSize) {
            this.volumeSize = volumeSize;
        }

        public final String getVolumeTypeAsString() {
            return volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType.toString());
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Boolean getDeleteOnTermination() {
            return deleteOnTermination;
        }

        @Override
        public final Builder deleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        public final void setDeleteOnTermination(Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
        }

        @Override
        public EbsBlockDevice build() {
            return new EbsBlockDevice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
