/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterVolumeRequest extends OpsWorksRequest implements
        ToCopyableBuilder<RegisterVolumeRequest.Builder, RegisterVolumeRequest> {
    private static final SdkField<String> EC2_VOLUME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterVolumeRequest::ec2VolumeId)).setter(setter(Builder::ec2VolumeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2VolumeId").build()).build();

    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RegisterVolumeRequest::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_VOLUME_ID_FIELD,
            STACK_ID_FIELD));

    private final String ec2VolumeId;

    private final String stackId;

    private RegisterVolumeRequest(BuilderImpl builder) {
        super(builder);
        this.ec2VolumeId = builder.ec2VolumeId;
        this.stackId = builder.stackId;
    }

    /**
     * <p>
     * The Amazon EBS volume ID.
     * </p>
     * 
     * @return The Amazon EBS volume ID.
     */
    public String ec2VolumeId() {
        return ec2VolumeId;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ec2VolumeId());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterVolumeRequest)) {
            return false;
        }
        RegisterVolumeRequest other = (RegisterVolumeRequest) obj;
        return Objects.equals(ec2VolumeId(), other.ec2VolumeId()) && Objects.equals(stackId(), other.stackId());
    }

    @Override
    public String toString() {
        return ToString.builder("RegisterVolumeRequest").add("Ec2VolumeId", ec2VolumeId()).add("StackId", stackId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ec2VolumeId":
            return Optional.ofNullable(clazz.cast(ec2VolumeId()));
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterVolumeRequest, T> g) {
        return obj -> g.apply((RegisterVolumeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, RegisterVolumeRequest> {
        /**
         * <p>
         * The Amazon EBS volume ID.
         * </p>
         * 
         * @param ec2VolumeId
         *        The Amazon EBS volume ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2VolumeId(String ec2VolumeId);

        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String ec2VolumeId;

        private String stackId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterVolumeRequest model) {
            super(model);
            ec2VolumeId(model.ec2VolumeId);
            stackId(model.stackId);
        }

        public final String getEc2VolumeId() {
            return ec2VolumeId;
        }

        @Override
        public final Builder ec2VolumeId(String ec2VolumeId) {
            this.ec2VolumeId = ec2VolumeId;
            return this;
        }

        public final void setEc2VolumeId(String ec2VolumeId) {
            this.ec2VolumeId = ec2VolumeId;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterVolumeRequest build() {
            return new RegisterVolumeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
