/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance's time-based auto scaling configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeBasedAutoScalingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TimeBasedAutoScalingConfiguration.Builder, TimeBasedAutoScalingConfiguration> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(TimeBasedAutoScalingConfiguration::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<WeeklyAutoScalingSchedule> AUTO_SCALING_SCHEDULE_FIELD = SdkField
            .<WeeklyAutoScalingSchedule> builder(MarshallingType.SDK_POJO)
            .getter(getter(TimeBasedAutoScalingConfiguration::autoScalingSchedule)).setter(setter(Builder::autoScalingSchedule))
            .constructor(WeeklyAutoScalingSchedule::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingSchedule").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            AUTO_SCALING_SCHEDULE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceId;

    private final WeeklyAutoScalingSchedule autoScalingSchedule;

    private TimeBasedAutoScalingConfiguration(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.autoScalingSchedule = builder.autoScalingSchedule;
    }

    /**
     * <p>
     * The instance ID.
     * </p>
     * 
     * @return The instance ID.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A <code>WeeklyAutoScalingSchedule</code> object with the instance schedule.
     * </p>
     * 
     * @return A <code>WeeklyAutoScalingSchedule</code> object with the instance schedule.
     */
    public WeeklyAutoScalingSchedule autoScalingSchedule() {
        return autoScalingSchedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingSchedule());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeBasedAutoScalingConfiguration)) {
            return false;
        }
        TimeBasedAutoScalingConfiguration other = (TimeBasedAutoScalingConfiguration) obj;
        return Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(autoScalingSchedule(), other.autoScalingSchedule());
    }

    @Override
    public String toString() {
        return ToString.builder("TimeBasedAutoScalingConfiguration").add("InstanceId", instanceId())
                .add("AutoScalingSchedule", autoScalingSchedule()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "AutoScalingSchedule":
            return Optional.ofNullable(clazz.cast(autoScalingSchedule()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TimeBasedAutoScalingConfiguration, T> g) {
        return obj -> g.apply((TimeBasedAutoScalingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeBasedAutoScalingConfiguration> {
        /**
         * <p>
         * The instance ID.
         * </p>
         * 
         * @param instanceId
         *        The instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A <code>WeeklyAutoScalingSchedule</code> object with the instance schedule.
         * </p>
         * 
         * @param autoScalingSchedule
         *        A <code>WeeklyAutoScalingSchedule</code> object with the instance schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingSchedule(WeeklyAutoScalingSchedule autoScalingSchedule);

        /**
         * <p>
         * A <code>WeeklyAutoScalingSchedule</code> object with the instance schedule.
         * </p>
         * This is a convenience that creates an instance of the {@link WeeklyAutoScalingSchedule.Builder} avoiding the
         * need to create one manually via {@link WeeklyAutoScalingSchedule#builder()}.
         *
         * When the {@link Consumer} completes, {@link WeeklyAutoScalingSchedule.Builder#build()} is called immediately
         * and its result is passed to {@link #autoScalingSchedule(WeeklyAutoScalingSchedule)}.
         * 
         * @param autoScalingSchedule
         *        a consumer that will call methods on {@link WeeklyAutoScalingSchedule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #autoScalingSchedule(WeeklyAutoScalingSchedule)
         */
        default Builder autoScalingSchedule(Consumer<WeeklyAutoScalingSchedule.Builder> autoScalingSchedule) {
            return autoScalingSchedule(WeeklyAutoScalingSchedule.builder().applyMutation(autoScalingSchedule).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String instanceId;

        private WeeklyAutoScalingSchedule autoScalingSchedule;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeBasedAutoScalingConfiguration model) {
            instanceId(model.instanceId);
            autoScalingSchedule(model.autoScalingSchedule);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final WeeklyAutoScalingSchedule.Builder getAutoScalingSchedule() {
            return autoScalingSchedule != null ? autoScalingSchedule.toBuilder() : null;
        }

        @Override
        public final Builder autoScalingSchedule(WeeklyAutoScalingSchedule autoScalingSchedule) {
            this.autoScalingSchedule = autoScalingSchedule;
            return this;
        }

        public final void setAutoScalingSchedule(WeeklyAutoScalingSchedule.BuilderImpl autoScalingSchedule) {
            this.autoScalingSchedule = autoScalingSchedule != null ? autoScalingSchedule.build() : null;
        }

        @Override
        public TimeBasedAutoScalingConfiguration build() {
            return new TimeBasedAutoScalingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
