/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteInstanceRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DeleteInstanceRequest.Builder, DeleteInstanceRequest> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteInstanceRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<Boolean> DELETE_ELASTIC_IP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DeleteInstanceRequest::deleteElasticIp)).setter(setter(Builder::deleteElasticIp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteElasticIp").build()).build();

    private static final SdkField<Boolean> DELETE_VOLUMES_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DeleteInstanceRequest::deleteVolumes)).setter(setter(Builder::deleteVolumes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteVolumes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD,
            DELETE_ELASTIC_IP_FIELD, DELETE_VOLUMES_FIELD));

    private final String instanceId;

    private final Boolean deleteElasticIp;

    private final Boolean deleteVolumes;

    private DeleteInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.instanceId = builder.instanceId;
        this.deleteElasticIp = builder.deleteElasticIp;
        this.deleteVolumes = builder.deleteVolumes;
    }

    /**
     * <p>
     * The instance ID.
     * </p>
     * 
     * @return The instance ID.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Whether to delete the instance Elastic IP address.
     * </p>
     * 
     * @return Whether to delete the instance Elastic IP address.
     */
    public Boolean deleteElasticIp() {
        return deleteElasticIp;
    }

    /**
     * <p>
     * Whether to delete the instance's Amazon EBS volumes.
     * </p>
     * 
     * @return Whether to delete the instance's Amazon EBS volumes.
     */
    public Boolean deleteVolumes() {
        return deleteVolumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(deleteElasticIp());
        hashCode = 31 * hashCode + Objects.hashCode(deleteVolumes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteInstanceRequest)) {
            return false;
        }
        DeleteInstanceRequest other = (DeleteInstanceRequest) obj;
        return Objects.equals(instanceId(), other.instanceId()) && Objects.equals(deleteElasticIp(), other.deleteElasticIp())
                && Objects.equals(deleteVolumes(), other.deleteVolumes());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteInstanceRequest").add("InstanceId", instanceId())
                .add("DeleteElasticIp", deleteElasticIp()).add("DeleteVolumes", deleteVolumes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "DeleteElasticIp":
            return Optional.ofNullable(clazz.cast(deleteElasticIp()));
        case "DeleteVolumes":
            return Optional.ofNullable(clazz.cast(deleteVolumes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteInstanceRequest, T> g) {
        return obj -> g.apply((DeleteInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteInstanceRequest> {
        /**
         * <p>
         * The instance ID.
         * </p>
         * 
         * @param instanceId
         *        The instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Whether to delete the instance Elastic IP address.
         * </p>
         * 
         * @param deleteElasticIp
         *        Whether to delete the instance Elastic IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteElasticIp(Boolean deleteElasticIp);

        /**
         * <p>
         * Whether to delete the instance's Amazon EBS volumes.
         * </p>
         * 
         * @param deleteVolumes
         *        Whether to delete the instance's Amazon EBS volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteVolumes(Boolean deleteVolumes);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String instanceId;

        private Boolean deleteElasticIp;

        private Boolean deleteVolumes;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteInstanceRequest model) {
            super(model);
            instanceId(model.instanceId);
            deleteElasticIp(model.deleteElasticIp);
            deleteVolumes(model.deleteVolumes);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Boolean getDeleteElasticIp() {
            return deleteElasticIp;
        }

        @Override
        public final Builder deleteElasticIp(Boolean deleteElasticIp) {
            this.deleteElasticIp = deleteElasticIp;
            return this;
        }

        public final void setDeleteElasticIp(Boolean deleteElasticIp) {
            this.deleteElasticIp = deleteElasticIp;
        }

        public final Boolean getDeleteVolumes() {
            return deleteVolumes;
        }

        @Override
        public final Builder deleteVolumes(Boolean deleteVolumes) {
            this.deleteVolumes = deleteVolumes;
            return this;
        }

        public final void setDeleteVolumes(Boolean deleteVolumes) {
            this.deleteVolumes = deleteVolumes;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteInstanceRequest build() {
            return new DeleteInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
