/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a deployment of a stack or app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Deployment implements SdkPojo, Serializable, ToCopyableBuilder<Deployment.Builder, Deployment> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Deployment::deploymentId)).setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentId").build()).build();

    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Deployment::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Deployment::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppId").build()).build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Deployment::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<String> COMPLETED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Deployment::completedAt)).setter(setter(Builder::completedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedAt").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Deployment::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<String> IAM_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Deployment::iamUserArn)).setter(setter(Builder::iamUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamUserArn").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Deployment::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()).build();

    private static final SdkField<DeploymentCommand> COMMAND_FIELD = SdkField
            .<DeploymentCommand> builder(MarshallingType.SDK_POJO).getter(getter(Deployment::command))
            .setter(setter(Builder::command)).constructor(DeploymentCommand::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Command").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Deployment::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> CUSTOM_JSON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Deployment::customJson)).setter(setter(Builder::customJson))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomJson").build()).build();

    private static final SdkField<List<String>> INSTANCE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(Deployment::instanceIds))
            .setter(setter(Builder::instanceIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD,
            STACK_ID_FIELD, APP_ID_FIELD, CREATED_AT_FIELD, COMPLETED_AT_FIELD, DURATION_FIELD, IAM_USER_ARN_FIELD,
            COMMENT_FIELD, COMMAND_FIELD, STATUS_FIELD, CUSTOM_JSON_FIELD, INSTANCE_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deploymentId;

    private final String stackId;

    private final String appId;

    private final String createdAt;

    private final String completedAt;

    private final Integer duration;

    private final String iamUserArn;

    private final String comment;

    private final DeploymentCommand command;

    private final String status;

    private final String customJson;

    private final List<String> instanceIds;

    private Deployment(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.stackId = builder.stackId;
        this.appId = builder.appId;
        this.createdAt = builder.createdAt;
        this.completedAt = builder.completedAt;
        this.duration = builder.duration;
        this.iamUserArn = builder.iamUserArn;
        this.comment = builder.comment;
        this.command = builder.command;
        this.status = builder.status;
        this.customJson = builder.customJson;
        this.instanceIds = builder.instanceIds;
    }

    /**
     * <p>
     * The deployment ID.
     * </p>
     * 
     * @return The deployment ID.
     */
    public String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The app ID.
     * </p>
     * 
     * @return The app ID.
     */
    public String appId() {
        return appId;
    }

    /**
     * <p>
     * Date when the deployment was created.
     * </p>
     * 
     * @return Date when the deployment was created.
     */
    public String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Date when the deployment completed.
     * </p>
     * 
     * @return Date when the deployment completed.
     */
    public String completedAt() {
        return completedAt;
    }

    /**
     * <p>
     * The deployment duration.
     * </p>
     * 
     * @return The deployment duration.
     */
    public Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The user's IAM ARN.
     * </p>
     * 
     * @return The user's IAM ARN.
     */
    public String iamUserArn() {
        return iamUserArn;
    }

    /**
     * <p>
     * A user-defined comment.
     * </p>
     * 
     * @return A user-defined comment.
     */
    public String comment() {
        return comment;
    }

    /**
     * Returns the value of the Command property for this object.
     * 
     * @return The value of the Command property for this object.
     */
    public DeploymentCommand command() {
        return command;
    }

    /**
     * <p>
     * The deployment status:
     * </p>
     * <ul>
     * <li>
     * <p>
     * running
     * </p>
     * </li>
     * <li>
     * <p>
     * successful
     * </p>
     * </li>
     * <li>
     * <p>
     * failed
     * </p>
     * </li>
     * </ul>
     * 
     * @return The deployment status:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         running
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         successful
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         failed
     *         </p>
     *         </li>
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * A string that contains user-defined custom JSON. It can be used to override the corresponding default stack
     * configuration attribute values for stack or to pass data to recipes. The string should be in the following
     * format:
     * </p>
     * <p>
     * <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
     * </p>
     * <p>
     * For more information on custom JSON, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the
     * Stack Configuration Attributes</a>.
     * </p>
     * 
     * @return A string that contains user-defined custom JSON. It can be used to override the corresponding default
     *         stack configuration attribute values for stack or to pass data to recipes. The string should be in the
     *         following format:</p>
     *         <p>
     *         <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
     *         </p>
     *         <p>
     *         For more information on custom JSON, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
     *         Modify the Stack Configuration Attributes</a>.
     */
    public String customJson() {
        return customJson;
    }

    /**
     * <p>
     * The IDs of the target instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the target instances.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(command());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(customJson());
        hashCode = 31 * hashCode + Objects.hashCode(instanceIds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment) obj;
        return Objects.equals(deploymentId(), other.deploymentId()) && Objects.equals(stackId(), other.stackId())
                && Objects.equals(appId(), other.appId()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(completedAt(), other.completedAt()) && Objects.equals(duration(), other.duration())
                && Objects.equals(iamUserArn(), other.iamUserArn()) && Objects.equals(comment(), other.comment())
                && Objects.equals(command(), other.command()) && Objects.equals(status(), other.status())
                && Objects.equals(customJson(), other.customJson()) && Objects.equals(instanceIds(), other.instanceIds());
    }

    @Override
    public String toString() {
        return ToString.builder("Deployment").add("DeploymentId", deploymentId()).add("StackId", stackId()).add("AppId", appId())
                .add("CreatedAt", createdAt()).add("CompletedAt", completedAt()).add("Duration", duration())
                .add("IamUserArn", iamUserArn()).add("Comment", comment()).add("Command", command()).add("Status", status())
                .add("CustomJson", customJson()).add("InstanceIds", instanceIds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "AppId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "CompletedAt":
            return Optional.ofNullable(clazz.cast(completedAt()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "IamUserArn":
            return Optional.ofNullable(clazz.cast(iamUserArn()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "Command":
            return Optional.ofNullable(clazz.cast(command()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "CustomJson":
            return Optional.ofNullable(clazz.cast(customJson()));
        case "InstanceIds":
            return Optional.ofNullable(clazz.cast(instanceIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Deployment, T> g) {
        return obj -> g.apply((Deployment) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Deployment> {
        /**
         * <p>
         * The deployment ID.
         * </p>
         * 
         * @param deploymentId
         *        The deployment ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The app ID.
         * </p>
         * 
         * @param appId
         *        The app ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * Date when the deployment was created.
         * </p>
         * 
         * @param createdAt
         *        Date when the deployment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * Date when the deployment completed.
         * </p>
         * 
         * @param completedAt
         *        Date when the deployment completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedAt(String completedAt);

        /**
         * <p>
         * The deployment duration.
         * </p>
         * 
         * @param duration
         *        The deployment duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The user's IAM ARN.
         * </p>
         * 
         * @param iamUserArn
         *        The user's IAM ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArn(String iamUserArn);

        /**
         * <p>
         * A user-defined comment.
         * </p>
         * 
         * @param comment
         *        A user-defined comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * Sets the value of the Command property for this object.
         *
         * @param command
         *        The new value for the Command property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(DeploymentCommand command);

        /**
         * Sets the value of the Command property for this object.
         *
         * This is a convenience that creates an instance of the {@link DeploymentCommand.Builder} avoiding the need to
         * create one manually via {@link DeploymentCommand#builder()}.
         *
         * When the {@link Consumer} completes, {@link DeploymentCommand.Builder#build()} is called immediately and its
         * result is passed to {@link #command(DeploymentCommand)}.
         * 
         * @param command
         *        a consumer that will call methods on {@link DeploymentCommand.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #command(DeploymentCommand)
         */
        default Builder command(Consumer<DeploymentCommand.Builder> command) {
            return command(DeploymentCommand.builder().applyMutation(command).build());
        }

        /**
         * <p>
         * The deployment status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * running
         * </p>
         * </li>
         * <li>
         * <p>
         * successful
         * </p>
         * </li>
         * <li>
         * <p>
         * failed
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The deployment status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        running
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        successful
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        failed
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A string that contains user-defined custom JSON. It can be used to override the corresponding default stack
         * configuration attribute values for stack or to pass data to recipes. The string should be in the following
         * format:
         * </p>
         * <p>
         * <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
         * </p>
         * <p>
         * For more information on custom JSON, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify
         * the Stack Configuration Attributes</a>.
         * </p>
         * 
         * @param customJson
         *        A string that contains user-defined custom JSON. It can be used to override the corresponding default
         *        stack configuration attribute values for stack or to pass data to recipes. The string should be in the
         *        following format:</p>
         *        <p>
         *        <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
         *        </p>
         *        <p>
         *        For more information on custom JSON, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
         *        Modify the Stack Configuration Attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customJson(String customJson);

        /**
         * <p>
         * The IDs of the target instances.
         * </p>
         * 
         * @param instanceIds
         *        The IDs of the target instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * The IDs of the target instances.
         * </p>
         * 
         * @param instanceIds
         *        The IDs of the target instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentId;

        private String stackId;

        private String appId;

        private String createdAt;

        private String completedAt;

        private Integer duration;

        private String iamUserArn;

        private String comment;

        private DeploymentCommand command;

        private String status;

        private String customJson;

        private List<String> instanceIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Deployment model) {
            deploymentId(model.deploymentId);
            stackId(model.stackId);
            appId(model.appId);
            createdAt(model.createdAt);
            completedAt(model.completedAt);
            duration(model.duration);
            iamUserArn(model.iamUserArn);
            comment(model.comment);
            command(model.command);
            status(model.status);
            customJson(model.customJson);
            instanceIds(model.instanceIds);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getCompletedAt() {
            return completedAt;
        }

        @Override
        public final Builder completedAt(String completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final void setCompletedAt(String completedAt) {
            this.completedAt = completedAt;
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final String getIamUserArn() {
            return iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final DeploymentCommand.Builder getCommand() {
            return command != null ? command.toBuilder() : null;
        }

        @Override
        public final Builder command(DeploymentCommand command) {
            this.command = command;
            return this;
        }

        public final void setCommand(DeploymentCommand.BuilderImpl command) {
            this.command = command != null ? command.build() : null;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCustomJson() {
            return customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        public final Collection<String> getInstanceIds() {
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
        }

        @Override
        public Deployment build() {
            return new Deployment(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
