/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an AWS OpsWorks Stacks service error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceError implements SdkPojo, Serializable, ToCopyableBuilder<ServiceError.Builder, ServiceError> {
    private static final SdkField<String> SERVICE_ERROR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceError::serviceErrorId)).setter(setter(Builder::serviceErrorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceErrorId").build()).build();

    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceError::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceError::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceError::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceError::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ERROR_ID_FIELD,
            STACK_ID_FIELD, INSTANCE_ID_FIELD, TYPE_FIELD, MESSAGE_FIELD, CREATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceErrorId;

    private final String stackId;

    private final String instanceId;

    private final String type;

    private final String message;

    private final String createdAt;

    private ServiceError(BuilderImpl builder) {
        this.serviceErrorId = builder.serviceErrorId;
        this.stackId = builder.stackId;
        this.instanceId = builder.instanceId;
        this.type = builder.type;
        this.message = builder.message;
        this.createdAt = builder.createdAt;
    }

    /**
     * <p>
     * The error ID.
     * </p>
     * 
     * @return The error ID.
     */
    public String serviceErrorId() {
        return serviceErrorId;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The instance ID.
     * </p>
     * 
     * @return The instance ID.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The error type.
     * </p>
     * 
     * @return The error type.
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * A message that describes the error.
     * </p>
     * 
     * @return A message that describes the error.
     */
    public String message() {
        return message;
    }

    /**
     * <p>
     * When the error occurred.
     * </p>
     * 
     * @return When the error occurred.
     */
    public String createdAt() {
        return createdAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceErrorId());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceError)) {
            return false;
        }
        ServiceError other = (ServiceError) obj;
        return Objects.equals(serviceErrorId(), other.serviceErrorId()) && Objects.equals(stackId(), other.stackId())
                && Objects.equals(instanceId(), other.instanceId()) && Objects.equals(type(), other.type())
                && Objects.equals(message(), other.message()) && Objects.equals(createdAt(), other.createdAt());
    }

    @Override
    public String toString() {
        return ToString.builder("ServiceError").add("ServiceErrorId", serviceErrorId()).add("StackId", stackId())
                .add("InstanceId", instanceId()).add("Type", type()).add("Message", message()).add("CreatedAt", createdAt())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceErrorId":
            return Optional.ofNullable(clazz.cast(serviceErrorId()));
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceError, T> g) {
        return obj -> g.apply((ServiceError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceError> {
        /**
         * <p>
         * The error ID.
         * </p>
         * 
         * @param serviceErrorId
         *        The error ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceErrorId(String serviceErrorId);

        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The instance ID.
         * </p>
         * 
         * @param instanceId
         *        The instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The error type.
         * </p>
         * 
         * @param type
         *        The error type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * A message that describes the error.
         * </p>
         * 
         * @param message
         *        A message that describes the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * When the error occurred.
         * </p>
         * 
         * @param createdAt
         *        When the error occurred.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);
    }

    static final class BuilderImpl implements Builder {
        private String serviceErrorId;

        private String stackId;

        private String instanceId;

        private String type;

        private String message;

        private String createdAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceError model) {
            serviceErrorId(model.serviceErrorId);
            stackId(model.stackId);
            instanceId(model.instanceId);
            type(model.type);
            message(model.message);
            createdAt(model.createdAt);
        }

        public final String getServiceErrorId() {
            return serviceErrorId;
        }

        @Override
        public final Builder serviceErrorId(String serviceErrorId) {
            this.serviceErrorId = serviceErrorId;
            return this;
        }

        public final void setServiceErrorId(String serviceErrorId) {
            this.serviceErrorId = serviceErrorId;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public ServiceError build() {
            return new ServiceError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
