/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCommandsRequest extends OpsWorksRequest implements
        ToCopyableBuilder<DescribeCommandsRequest.Builder, DescribeCommandsRequest> {
    private static final SdkField<String> DEPLOYMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeploymentId").getter(getter(DescribeCommandsRequest::deploymentId))
            .setter(setter(Builder::deploymentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(DescribeCommandsRequest::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<List<String>> COMMAND_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CommandIds")
            .getter(getter(DescribeCommandsRequest::commandIds))
            .setter(setter(Builder::commandIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommandIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_ID_FIELD,
            INSTANCE_ID_FIELD, COMMAND_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String deploymentId;

    private final String instanceId;

    private final List<String> commandIds;

    private DescribeCommandsRequest(BuilderImpl builder) {
        super(builder);
        this.deploymentId = builder.deploymentId;
        this.instanceId = builder.instanceId;
        this.commandIds = builder.commandIds;
    }

    /**
     * <p>
     * The deployment ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the
     * commands associated with the specified deployment.
     * </p>
     * 
     * @return The deployment ID. If you include this parameter, <code>DescribeCommands</code> returns a description of
     *         the commands associated with the specified deployment.
     */
    public final String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The instance ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the
     * commands associated with the specified instance.
     * </p>
     * 
     * @return The instance ID. If you include this parameter, <code>DescribeCommands</code> returns a description of
     *         the commands associated with the specified instance.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the CommandIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCommandIds() {
        return commandIds != null && !(commandIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a description of
     * the specified commands. Otherwise, it returns a description of every command.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCommandIds} method.
     * </p>
     * 
     * @return An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a
     *         description of the specified commands. Otherwise, it returns a description of every command.
     */
    public final List<String> commandIds() {
        return commandIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deploymentId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(hasCommandIds() ? commandIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommandsRequest)) {
            return false;
        }
        DescribeCommandsRequest other = (DescribeCommandsRequest) obj;
        return Objects.equals(deploymentId(), other.deploymentId()) && Objects.equals(instanceId(), other.instanceId())
                && hasCommandIds() == other.hasCommandIds() && Objects.equals(commandIds(), other.commandIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCommandsRequest").add("DeploymentId", deploymentId()).add("InstanceId", instanceId())
                .add("CommandIds", hasCommandIds() ? commandIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeploymentId":
            return Optional.ofNullable(clazz.cast(deploymentId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "CommandIds":
            return Optional.ofNullable(clazz.cast(commandIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeploymentId", DEPLOYMENT_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("CommandIds", COMMAND_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCommandsRequest, T> g) {
        return obj -> g.apply((DescribeCommandsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeCommandsRequest> {
        /**
         * <p>
         * The deployment ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the
         * commands associated with the specified deployment.
         * </p>
         * 
         * @param deploymentId
         *        The deployment ID. If you include this parameter, <code>DescribeCommands</code> returns a description
         *        of the commands associated with the specified deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The instance ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the
         * commands associated with the specified instance.
         * </p>
         * 
         * @param instanceId
         *        The instance ID. If you include this parameter, <code>DescribeCommands</code> returns a description of
         *        the commands associated with the specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a description
         * of the specified commands. Otherwise, it returns a description of every command.
         * </p>
         * 
         * @param commandIds
         *        An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a
         *        description of the specified commands. Otherwise, it returns a description of every command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandIds(Collection<String> commandIds);

        /**
         * <p>
         * An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a description
         * of the specified commands. Otherwise, it returns a description of every command.
         * </p>
         * 
         * @param commandIds
         *        An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a
         *        description of the specified commands. Otherwise, it returns a description of every command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandIds(String... commandIds);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String deploymentId;

        private String instanceId;

        private List<String> commandIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommandsRequest model) {
            super(model);
            deploymentId(model.deploymentId);
            instanceId(model.instanceId);
            commandIds(model.commandIds);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Collection<String> getCommandIds() {
            if (commandIds instanceof SdkAutoConstructList) {
                return null;
            }
            return commandIds;
        }

        public final void setCommandIds(Collection<String> commandIds) {
            this.commandIds = StringsCopier.copy(commandIds);
        }

        @Override
        public final Builder commandIds(Collection<String> commandIds) {
            this.commandIds = StringsCopier.copy(commandIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandIds(String... commandIds) {
            commandIds(Arrays.asList(commandIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeCommandsRequest build() {
            return new DescribeCommandsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
