/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateInstanceRequest extends OpsWorksRequest implements
        ToCopyableBuilder<CreateInstanceRequest.Builder, CreateInstanceRequest> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackId").getter(getter(CreateInstanceRequest::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<List<String>> LAYER_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LayerIds")
            .getter(getter(CreateInstanceRequest::layerIds))
            .setter(setter(Builder::layerIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(CreateInstanceRequest::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> AUTO_SCALING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AutoScalingType").getter(getter(CreateInstanceRequest::autoScalingTypeAsString))
            .setter(setter(Builder::autoScalingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoScalingType").build()).build();

    private static final SdkField<String> HOSTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Hostname").getter(getter(CreateInstanceRequest::hostname)).setter(setter(Builder::hostname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hostname").build()).build();

    private static final SdkField<String> OS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Os")
            .getter(getter(CreateInstanceRequest::os)).setter(setter(Builder::os))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Os").build()).build();

    private static final SdkField<String> AMI_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("AmiId")
            .getter(getter(CreateInstanceRequest::amiId)).setter(setter(Builder::amiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AmiId").build()).build();

    private static final SdkField<String> SSH_KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SshKeyName").getter(getter(CreateInstanceRequest::sshKeyName)).setter(setter(Builder::sshKeyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SshKeyName").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(CreateInstanceRequest::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> VIRTUALIZATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VirtualizationType").getter(getter(CreateInstanceRequest::virtualizationType))
            .setter(setter(Builder::virtualizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualizationType").build())
            .build();

    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubnetId").getter(getter(CreateInstanceRequest::subnetId)).setter(setter(Builder::subnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").build()).build();

    private static final SdkField<String> ARCHITECTURE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Architecture").getter(getter(CreateInstanceRequest::architectureAsString))
            .setter(setter(Builder::architecture))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Architecture").build()).build();

    private static final SdkField<String> ROOT_DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RootDeviceType").getter(getter(CreateInstanceRequest::rootDeviceTypeAsString))
            .setter(setter(Builder::rootDeviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootDeviceType").build()).build();

    private static final SdkField<List<BlockDeviceMapping>> BLOCK_DEVICE_MAPPINGS_FIELD = SdkField
            .<List<BlockDeviceMapping>> builder(MarshallingType.LIST)
            .memberName("BlockDeviceMappings")
            .getter(getter(CreateInstanceRequest::blockDeviceMappings))
            .setter(setter(Builder::blockDeviceMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockDeviceMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<BlockDeviceMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(BlockDeviceMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> INSTALL_UPDATES_ON_BOOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("InstallUpdatesOnBoot").getter(getter(CreateInstanceRequest::installUpdatesOnBoot))
            .setter(setter(Builder::installUpdatesOnBoot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstallUpdatesOnBoot").build())
            .build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimized").getter(getter(CreateInstanceRequest::ebsOptimized)).setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").build()).build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AgentVersion").getter(getter(CreateInstanceRequest::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersion").build()).build();

    private static final SdkField<String> TENANCY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Tenancy")
            .getter(getter(CreateInstanceRequest::tenancy)).setter(setter(Builder::tenancy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tenancy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD,
            LAYER_IDS_FIELD, INSTANCE_TYPE_FIELD, AUTO_SCALING_TYPE_FIELD, HOSTNAME_FIELD, OS_FIELD, AMI_ID_FIELD,
            SSH_KEY_NAME_FIELD, AVAILABILITY_ZONE_FIELD, VIRTUALIZATION_TYPE_FIELD, SUBNET_ID_FIELD, ARCHITECTURE_FIELD,
            ROOT_DEVICE_TYPE_FIELD, BLOCK_DEVICE_MAPPINGS_FIELD, INSTALL_UPDATES_ON_BOOT_FIELD, EBS_OPTIMIZED_FIELD,
            AGENT_VERSION_FIELD, TENANCY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String stackId;

    private final List<String> layerIds;

    private final String instanceType;

    private final String autoScalingType;

    private final String hostname;

    private final String os;

    private final String amiId;

    private final String sshKeyName;

    private final String availabilityZone;

    private final String virtualizationType;

    private final String subnetId;

    private final String architecture;

    private final String rootDeviceType;

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final Boolean installUpdatesOnBoot;

    private final Boolean ebsOptimized;

    private final String agentVersion;

    private final String tenancy;

    private CreateInstanceRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.layerIds = builder.layerIds;
        this.instanceType = builder.instanceType;
        this.autoScalingType = builder.autoScalingType;
        this.hostname = builder.hostname;
        this.os = builder.os;
        this.amiId = builder.amiId;
        this.sshKeyName = builder.sshKeyName;
        this.availabilityZone = builder.availabilityZone;
        this.virtualizationType = builder.virtualizationType;
        this.subnetId = builder.subnetId;
        this.architecture = builder.architecture;
        this.rootDeviceType = builder.rootDeviceType;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
        this.ebsOptimized = builder.ebsOptimized;
        this.agentVersion = builder.agentVersion;
        this.tenancy = builder.tenancy;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public final String stackId() {
        return stackId;
    }

    /**
     * For responses, this returns true if the service returned a value for the LayerIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasLayerIds() {
        return layerIds != null && !(layerIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains the instance's layer IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLayerIds} method.
     * </p>
     * 
     * @return An array that contains the instance's layer IDs.
     */
    public final List<String> layerIds() {
        return layerIds;
    }

    /**
     * <p>
     * The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the stack in the
     * console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list contains the currently
     * supported types. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>.
     * The parameter values that you use to specify the various types are in the <b>API Name</b> column of the
     * <b>Available Instance Types</b> table.
     * </p>
     * 
     * @return The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the stack
     *         in the console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list contains the
     *         currently supported types. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
     *         Types</a>. The parameter values that you use to specify the various types are in the <b>API Name</b>
     *         column of the <b>Available Instance Types</b> table.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoScalingType}
     * will return {@link AutoScalingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoScalingTypeAsString}.
     * </p>
     * 
     * @return For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
     * @see AutoScalingType
     */
    public final AutoScalingType autoScalingType() {
        return AutoScalingType.fromValue(autoScalingType);
    }

    /**
     * <p>
     * For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #autoScalingType}
     * will return {@link AutoScalingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #autoScalingTypeAsString}.
     * </p>
     * 
     * @return For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
     * @see AutoScalingType
     */
    public final String autoScalingTypeAsString() {
        return autoScalingType;
    }

    /**
     * <p>
     * The instance host name. The following are character limits for instance host names.
     * </p>
     * <ul>
     * <li>
     * <p>
     * Linux-based instances: 63 characters
     * </p>
     * </li>
     * <li>
     * <p>
     * Windows-based instances: 15 characters
     * </p>
     * </li>
     * </ul>
     * 
     * @return The instance host name. The following are character limits for instance host names.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Linux-based instances: 63 characters
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Windows-based instances: 15 characters
     *         </p>
     *         </li>
     */
    public final String hostname() {
        return hostname;
    }

    /**
     * <p>
     * The instance's operating system, which must be set to one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2</code>,
     * <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>,
     * <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or
     * <code>Amazon Linux 2015.03</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * A supported Ubuntu operating system, such as <code>Ubuntu 18.04 LTS</code>, <code>Ubuntu 16.04 LTS</code>,
     * <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CentOS Linux 7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Red Hat Enterprise Linux 7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
     * <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
     * <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
     * <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * A custom AMI: <code>Custom</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Not all operating systems are supported with all versions of Chef. For more information about the supported
     * operating systems, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">OpsWorks Stacks Operating
     * Systems</a>.
     * </p>
     * <p>
     * The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code>, you
     * must use the <a>CreateInstance</a> action's AmiId parameter to specify the custom AMI that you want to use. Block
     * device mappings are not supported if the value is <code>Custom</code>. For more information about how to use
     * custom AMIs with OpsWorks Stacks, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom
     * AMIs</a>.
     * </p>
     * 
     * @return The instance's operating system, which must be set to one of the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2</code>,
     *         <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>,
     *         <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>,
     *         or <code>Amazon Linux 2015.03</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A supported Ubuntu operating system, such as <code>Ubuntu 18.04 LTS</code>, <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CentOS Linux 7</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Red Hat Enterprise Linux 7</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
     *         <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
     *         <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
     *         <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A custom AMI: <code>Custom</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Not all operating systems are supported with all versions of Chef. For more information about the
     *         supported operating systems, see <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">OpsWorks Stacks
     *         Operating Systems</a>.
     *         </p>
     *         <p>
     *         The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code>,
     *         you must use the <a>CreateInstance</a> action's AmiId parameter to specify the custom AMI that you want
     *         to use. Block device mappings are not supported if the value is <code>Custom</code>. For more information
     *         about how to use custom AMIs with OpsWorks Stacks, see <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using
     *         Custom AMIs</a>.
     */
    public final String os() {
        return os;
    }

    /**
     * <p>
     * A custom AMI ID to be used to create the instance. The AMI should be based on one of the supported operating
     * systems. For more information, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom
     * AMIs</a>.
     * </p>
     * <note>
     * <p>
     * If you specify a custom AMI, you must set <code>Os</code> to <code>Custom</code>.
     * </p>
     * </note>
     * 
     * @return A custom AMI ID to be used to create the instance. The AMI should be based on one of the supported
     *         operating systems. For more information, see <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using
     *         Custom AMIs</a>.</p> <note>
     *         <p>
     *         If you specify a custom AMI, you must set <code>Os</code> to <code>Custom</code>.
     *         </p>
     */
    public final String amiId() {
        return amiId;
    }

    /**
     * <p>
     * The instance's Amazon EC2 key-pair name.
     * </p>
     * 
     * @return The instance's Amazon EC2 key-pair name.
     */
    public final String sshKeyName() {
        return sshKeyName;
    }

    /**
     * <p>
     * The instance Availability Zone. For more information, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     * </p>
     * 
     * @return The instance Availability Zone. For more information, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The instance's virtualization type, <code>paravirtual</code> or <code>hvm</code>.
     * </p>
     * 
     * @return The instance's virtualization type, <code>paravirtual</code> or <code>hvm</code>.
     */
    public final String virtualizationType() {
        return virtualizationType;
    }

    /**
     * <p>
     * The ID of the instance's subnet. If the stack is running in a VPC, you can use this parameter to override the
     * stack's default subnet ID value and direct OpsWorks Stacks to launch the instance in a different subnet.
     * </p>
     * 
     * @return The ID of the instance's subnet. If the stack is running in a VPC, you can use this parameter to override
     *         the stack's default subnet ID value and direct OpsWorks Stacks to launch the instance in a different
     *         subnet.
     */
    public final String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The instance architecture. The default option is <code>x86_64</code>. Instance types do not necessarily support
     * both architectures. For a list of the architectures that are supported by the different instance types, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The instance architecture. The default option is <code>x86_64</code>. Instance types do not necessarily
     *         support both architectures. For a list of the architectures that are supported by the different instance
     *         types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance
     *         Families and Types</a>.
     * @see Architecture
     */
    public final Architecture architecture() {
        return Architecture.fromValue(architecture);
    }

    /**
     * <p>
     * The instance architecture. The default option is <code>x86_64</code>. Instance types do not necessarily support
     * both architectures. For a list of the architectures that are supported by the different instance types, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and Types</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #architecture} will
     * return {@link Architecture#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #architectureAsString}.
     * </p>
     * 
     * @return The instance architecture. The default option is <code>x86_64</code>. Instance types do not necessarily
     *         support both architectures. For a list of the architectures that are supported by the different instance
     *         types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance
     *         Families and Types</a>.
     * @see Architecture
     */
    public final String architectureAsString() {
        return architecture;
    }

    /**
     * <p>
     * The instance root device type. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
     * >Storage for the Root Device</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootDeviceType}
     * will return {@link RootDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rootDeviceTypeAsString}.
     * </p>
     * 
     * @return The instance root device type. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
     *         >Storage for the Root Device</a>.
     * @see RootDeviceType
     */
    public final RootDeviceType rootDeviceType() {
        return RootDeviceType.fromValue(rootDeviceType);
    }

    /**
     * <p>
     * The instance root device type. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
     * >Storage for the Root Device</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #rootDeviceType}
     * will return {@link RootDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #rootDeviceTypeAsString}.
     * </p>
     * 
     * @return The instance root device type. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
     *         >Storage for the Root Device</a>.
     * @see RootDeviceType
     */
    public final String rootDeviceTypeAsString() {
        return rootDeviceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the BlockDeviceMappings property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBlockDeviceMappings() {
        return blockDeviceMappings != null && !(blockDeviceMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>BlockDeviceMapping</code> objects that specify the instance's block devices. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device
     * Mapping</a>. Note that block device mappings are not supported for custom AMIs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBlockDeviceMappings} method.
     * </p>
     * 
     * @return An array of <code>BlockDeviceMapping</code> objects that specify the instance's block devices. For more
     *         information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block
     *         Device Mapping</a>. Note that block device mappings are not supported for custom AMIs.
     */
    public final List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * Whether to install operating system and package updates when the instance boots. The default value is
     * <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then
     * update your instances manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack
     * command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
     * </p>
     * <note>
     * <p>
     * We strongly recommend using the default value of <code>true</code> to ensure that your instances have the latest
     * security updates.
     * </p>
     * </note>
     * 
     * @return Whether to install operating system and package updates when the instance boots. The default value is
     *         <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must
     *         then update your instances manually by using <a>CreateDeployment</a> to run the
     *         <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or
     *         <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
     *         <p>
     *         We strongly recommend using the default value of <code>true</code> to ensure that your instances have the
     *         latest security updates.
     *         </p>
     */
    public final Boolean installUpdatesOnBoot() {
        return installUpdatesOnBoot;
    }

    /**
     * <p>
     * Whether to create an Amazon EBS-optimized instance.
     * </p>
     * 
     * @return Whether to create an Amazon EBS-optimized instance.
     */
    public final Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The default OpsWorks Stacks agent version. You have the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>INHERIT</code> - Use the stack's default agent version setting.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>version_number</i> - Use the specified agent version. This value overrides the stack's default setting. To
     * update the agent version, edit the instance configuration and specify a new version. OpsWorks Stacks installs
     * that version on the instance.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete version
     * number, not the abbreviated number shown on the console. For a list of available agent version numbers, call
     * <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.
     * </p>
     * 
     * @return The default OpsWorks Stacks agent version. You have the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>INHERIT</code> - Use the stack's default agent version setting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>version_number</i> - Use the specified agent version. This value overrides the stack's default
     *         setting. To update the agent version, edit the instance configuration and specify a new version. OpsWorks
     *         Stacks installs that version on the instance.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete
     *         version number, not the abbreviated number shown on the console. For a list of available agent version
     *         numbers, call <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.
     */
    public final String agentVersion() {
        return agentVersion;
    }

    /**
     * <p>
     * The instance's tenancy option. The default option is no tenancy, or if the instance is running in a VPC, inherit
     * tenancy settings from the VPC. The following are valid values for this parameter: <code>dedicated</code>,
     * <code>default</code>, or <code>host</code>. Because there are costs associated with changes in tenancy options,
     * we recommend that you research tenancy options before choosing them for your instances. For more information
     * about dedicated hosts, see <a href="http://aws.amazon.com/ec2/dedicated-hosts/">Dedicated Hosts Overview</a> and
     * <a href="http://aws.amazon.com/ec2/dedicated-hosts/">Amazon EC2 Dedicated Hosts</a>. For more information about
     * dedicated instances, see <a
     * href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a> and
     * <a href="http://aws.amazon.com/ec2/purchasing-options/dedicated-instances/">Amazon EC2 Dedicated Instances</a>.
     * </p>
     * 
     * @return The instance's tenancy option. The default option is no tenancy, or if the instance is running in a VPC,
     *         inherit tenancy settings from the VPC. The following are valid values for this parameter:
     *         <code>dedicated</code>, <code>default</code>, or <code>host</code>. Because there are costs associated
     *         with changes in tenancy options, we recommend that you research tenancy options before choosing them for
     *         your instances. For more information about dedicated hosts, see <a
     *         href="http://aws.amazon.com/ec2/dedicated-hosts/">Dedicated Hosts Overview</a> and <a
     *         href="http://aws.amazon.com/ec2/dedicated-hosts/">Amazon EC2 Dedicated Hosts</a>. For more information
     *         about dedicated instances, see <a
     *         href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/dedicated-instance.html">Dedicated
     *         Instances</a> and <a href="http://aws.amazon.com/ec2/purchasing-options/dedicated-instances/">Amazon EC2
     *         Dedicated Instances</a>.
     */
    public final String tenancy() {
        return tenancy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(hasLayerIds() ? layerIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(autoScalingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hostname());
        hashCode = 31 * hashCode + Objects.hashCode(os());
        hashCode = 31 * hashCode + Objects.hashCode(amiId());
        hashCode = 31 * hashCode + Objects.hashCode(sshKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(virtualizationType());
        hashCode = 31 * hashCode + Objects.hashCode(subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(architectureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rootDeviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasBlockDeviceMappings() ? blockDeviceMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(installUpdatesOnBoot());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(tenancy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInstanceRequest)) {
            return false;
        }
        CreateInstanceRequest other = (CreateInstanceRequest) obj;
        return Objects.equals(stackId(), other.stackId()) && hasLayerIds() == other.hasLayerIds()
                && Objects.equals(layerIds(), other.layerIds()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(autoScalingTypeAsString(), other.autoScalingTypeAsString())
                && Objects.equals(hostname(), other.hostname()) && Objects.equals(os(), other.os())
                && Objects.equals(amiId(), other.amiId()) && Objects.equals(sshKeyName(), other.sshKeyName())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(virtualizationType(), other.virtualizationType())
                && Objects.equals(subnetId(), other.subnetId())
                && Objects.equals(architectureAsString(), other.architectureAsString())
                && Objects.equals(rootDeviceTypeAsString(), other.rootDeviceTypeAsString())
                && hasBlockDeviceMappings() == other.hasBlockDeviceMappings()
                && Objects.equals(blockDeviceMappings(), other.blockDeviceMappings())
                && Objects.equals(installUpdatesOnBoot(), other.installUpdatesOnBoot())
                && Objects.equals(ebsOptimized(), other.ebsOptimized()) && Objects.equals(agentVersion(), other.agentVersion())
                && Objects.equals(tenancy(), other.tenancy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateInstanceRequest").add("StackId", stackId())
                .add("LayerIds", hasLayerIds() ? layerIds() : null).add("InstanceType", instanceType())
                .add("AutoScalingType", autoScalingTypeAsString()).add("Hostname", hostname()).add("Os", os())
                .add("AmiId", amiId()).add("SshKeyName", sshKeyName()).add("AvailabilityZone", availabilityZone())
                .add("VirtualizationType", virtualizationType()).add("SubnetId", subnetId())
                .add("Architecture", architectureAsString()).add("RootDeviceType", rootDeviceTypeAsString())
                .add("BlockDeviceMappings", hasBlockDeviceMappings() ? blockDeviceMappings() : null)
                .add("InstallUpdatesOnBoot", installUpdatesOnBoot()).add("EbsOptimized", ebsOptimized())
                .add("AgentVersion", agentVersion()).add("Tenancy", tenancy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "LayerIds":
            return Optional.ofNullable(clazz.cast(layerIds()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "AutoScalingType":
            return Optional.ofNullable(clazz.cast(autoScalingTypeAsString()));
        case "Hostname":
            return Optional.ofNullable(clazz.cast(hostname()));
        case "Os":
            return Optional.ofNullable(clazz.cast(os()));
        case "AmiId":
            return Optional.ofNullable(clazz.cast(amiId()));
        case "SshKeyName":
            return Optional.ofNullable(clazz.cast(sshKeyName()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "VirtualizationType":
            return Optional.ofNullable(clazz.cast(virtualizationType()));
        case "SubnetId":
            return Optional.ofNullable(clazz.cast(subnetId()));
        case "Architecture":
            return Optional.ofNullable(clazz.cast(architectureAsString()));
        case "RootDeviceType":
            return Optional.ofNullable(clazz.cast(rootDeviceTypeAsString()));
        case "BlockDeviceMappings":
            return Optional.ofNullable(clazz.cast(blockDeviceMappings()));
        case "InstallUpdatesOnBoot":
            return Optional.ofNullable(clazz.cast(installUpdatesOnBoot()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "AgentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        case "Tenancy":
            return Optional.ofNullable(clazz.cast(tenancy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackId", STACK_ID_FIELD);
        map.put("LayerIds", LAYER_IDS_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("AutoScalingType", AUTO_SCALING_TYPE_FIELD);
        map.put("Hostname", HOSTNAME_FIELD);
        map.put("Os", OS_FIELD);
        map.put("AmiId", AMI_ID_FIELD);
        map.put("SshKeyName", SSH_KEY_NAME_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("VirtualizationType", VIRTUALIZATION_TYPE_FIELD);
        map.put("SubnetId", SUBNET_ID_FIELD);
        map.put("Architecture", ARCHITECTURE_FIELD);
        map.put("RootDeviceType", ROOT_DEVICE_TYPE_FIELD);
        map.put("BlockDeviceMappings", BLOCK_DEVICE_MAPPINGS_FIELD);
        map.put("InstallUpdatesOnBoot", INSTALL_UPDATES_ON_BOOT_FIELD);
        map.put("EbsOptimized", EBS_OPTIMIZED_FIELD);
        map.put("AgentVersion", AGENT_VERSION_FIELD);
        map.put("Tenancy", TENANCY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInstanceRequest, T> g) {
        return obj -> g.apply((CreateInstanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateInstanceRequest> {
        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * An array that contains the instance's layer IDs.
         * </p>
         * 
         * @param layerIds
         *        An array that contains the instance's layer IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerIds(Collection<String> layerIds);

        /**
         * <p>
         * An array that contains the instance's layer IDs.
         * </p>
         * 
         * @param layerIds
         *        An array that contains the instance's layer IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerIds(String... layerIds);

        /**
         * <p>
         * The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the stack in
         * the console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list contains the
         * currently supported types. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
         * Types</a>. The parameter values that you use to specify the various types are in the <b>API Name</b> column
         * of the <b>Available Instance Types</b> table.
         * </p>
         * 
         * @param instanceType
         *        The instance type, such as <code>t2.micro</code>. For a list of supported instance types, open the
         *        stack in the console, choose <b>Instances</b>, and choose <b>+ Instance</b>. The <b>Size</b> list
         *        contains the currently supported types. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
         *        Types</a>. The parameter values that you use to specify the various types are in the <b>API Name</b>
         *        column of the <b>Available Instance Types</b> table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
         * </p>
         * 
         * @param autoScalingType
         *        For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
         * @see AutoScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingType
         */
        Builder autoScalingType(String autoScalingType);

        /**
         * <p>
         * For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
         * </p>
         * 
         * @param autoScalingType
         *        For load-based or time-based instances, the type. Windows stacks can use only time-based instances.
         * @see AutoScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingType
         */
        Builder autoScalingType(AutoScalingType autoScalingType);

        /**
         * <p>
         * The instance host name. The following are character limits for instance host names.
         * </p>
         * <ul>
         * <li>
         * <p>
         * Linux-based instances: 63 characters
         * </p>
         * </li>
         * <li>
         * <p>
         * Windows-based instances: 15 characters
         * </p>
         * </li>
         * </ul>
         * 
         * @param hostname
         *        The instance host name. The following are character limits for instance host names.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Linux-based instances: 63 characters
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Windows-based instances: 15 characters
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * The instance's operating system, which must be set to one of the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2</code>,
         * <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>,
         * <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or
         * <code>Amazon Linux 2015.03</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A supported Ubuntu operating system, such as <code>Ubuntu 18.04 LTS</code>, <code>Ubuntu 16.04 LTS</code>,
         * <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CentOS Linux 7</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Red Hat Enterprise Linux 7</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
         * <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
         * <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
         * <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A custom AMI: <code>Custom</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Not all operating systems are supported with all versions of Chef. For more information about the supported
         * operating systems, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">OpsWorks Stacks
         * Operating Systems</a>.
         * </p>
         * <p>
         * The default option is the current Amazon Linux version. If you set this parameter to <code>Custom</code>, you
         * must use the <a>CreateInstance</a> action's AmiId parameter to specify the custom AMI that you want to use.
         * Block device mappings are not supported if the value is <code>Custom</code>. For more information about how
         * to use custom AMIs with OpsWorks Stacks, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom
         * AMIs</a>.
         * </p>
         * 
         * @param os
         *        The instance's operating system, which must be set to one of the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2</code>,
         *        <code>Amazon Linux 2018.03</code>, <code>Amazon Linux 2017.09</code>,
         *        <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>,
         *        <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or
         *        <code>Amazon Linux 2015.03</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A supported Ubuntu operating system, such as <code>Ubuntu 18.04 LTS</code>,
         *        <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CentOS Linux 7</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Red Hat Enterprise Linux 7</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A supported Windows operating system, such as <code>Microsoft Windows Server 2012 R2 Base</code>,
         *        <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
         *        <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
         *        <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A custom AMI: <code>Custom</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Not all operating systems are supported with all versions of Chef. For more information about the
         *        supported operating systems, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">OpsWorks Stacks
         *        Operating Systems</a>.
         *        </p>
         *        <p>
         *        The default option is the current Amazon Linux version. If you set this parameter to
         *        <code>Custom</code>, you must use the <a>CreateInstance</a> action's AmiId parameter to specify the
         *        custom AMI that you want to use. Block device mappings are not supported if the value is
         *        <code>Custom</code>. For more information about how to use custom AMIs with OpsWorks Stacks, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using
         *        Custom AMIs</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder os(String os);

        /**
         * <p>
         * A custom AMI ID to be used to create the instance. The AMI should be based on one of the supported operating
         * systems. For more information, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom
         * AMIs</a>.
         * </p>
         * <note>
         * <p>
         * If you specify a custom AMI, you must set <code>Os</code> to <code>Custom</code>.
         * </p>
         * </note>
         * 
         * @param amiId
         *        A custom AMI ID to be used to create the instance. The AMI should be based on one of the supported
         *        operating systems. For more information, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using
         *        Custom AMIs</a>.</p> <note>
         *        <p>
         *        If you specify a custom AMI, you must set <code>Os</code> to <code>Custom</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiId(String amiId);

        /**
         * <p>
         * The instance's Amazon EC2 key-pair name.
         * </p>
         * 
         * @param sshKeyName
         *        The instance's Amazon EC2 key-pair name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshKeyName(String sshKeyName);

        /**
         * <p>
         * The instance Availability Zone. For more information, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * </p>
         * 
         * @param availabilityZone
         *        The instance Availability Zone. For more information, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The instance's virtualization type, <code>paravirtual</code> or <code>hvm</code>.
         * </p>
         * 
         * @param virtualizationType
         *        The instance's virtualization type, <code>paravirtual</code> or <code>hvm</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualizationType(String virtualizationType);

        /**
         * <p>
         * The ID of the instance's subnet. If the stack is running in a VPC, you can use this parameter to override the
         * stack's default subnet ID value and direct OpsWorks Stacks to launch the instance in a different subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the instance's subnet. If the stack is running in a VPC, you can use this parameter to
         *        override the stack's default subnet ID value and direct OpsWorks Stacks to launch the instance in a
         *        different subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The instance architecture. The default option is <code>x86_64</code>. Instance types do not necessarily
         * support both architectures. For a list of the architectures that are supported by the different instance
         * types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance
         * Families and Types</a>.
         * </p>
         * 
         * @param architecture
         *        The instance architecture. The default option is <code>x86_64</code>. Instance types do not
         *        necessarily support both architectures. For a list of the architectures that are supported by the
         *        different instance types, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
         *        Types</a>.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The instance architecture. The default option is <code>x86_64</code>. Instance types do not necessarily
         * support both architectures. For a list of the architectures that are supported by the different instance
         * types, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance
         * Families and Types</a>.
         * </p>
         * 
         * @param architecture
         *        The instance architecture. The default option is <code>x86_64</code>. Instance types do not
         *        necessarily support both architectures. For a list of the architectures that are supported by the
         *        different instance types, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html">Instance Families and
         *        Types</a>.
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(Architecture architecture);

        /**
         * <p>
         * The instance root device type. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         * >Storage for the Root Device</a>.
         * </p>
         * 
         * @param rootDeviceType
         *        The instance root device type. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         *        >Storage for the Root Device</a>.
         * @see RootDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootDeviceType
         */
        Builder rootDeviceType(String rootDeviceType);

        /**
         * <p>
         * The instance root device type. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         * >Storage for the Root Device</a>.
         * </p>
         * 
         * @param rootDeviceType
         *        The instance root device type. For more information, see <a href=
         *        "https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         *        >Storage for the Root Device</a>.
         * @see RootDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootDeviceType
         */
        Builder rootDeviceType(RootDeviceType rootDeviceType);

        /**
         * <p>
         * An array of <code>BlockDeviceMapping</code> objects that specify the instance's block devices. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device
         * Mapping</a>. Note that block device mappings are not supported for custom AMIs.
         * </p>
         * 
         * @param blockDeviceMappings
         *        An array of <code>BlockDeviceMapping</code> objects that specify the instance's block devices. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block
         *        Device Mapping</a>. Note that block device mappings are not supported for custom AMIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * An array of <code>BlockDeviceMapping</code> objects that specify the instance's block devices. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device
         * Mapping</a>. Note that block device mappings are not supported for custom AMIs.
         * </p>
         * 
         * @param blockDeviceMappings
         *        An array of <code>BlockDeviceMapping</code> objects that specify the instance's block devices. For
         *        more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block
         *        Device Mapping</a>. Note that block device mappings are not supported for custom AMIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * An array of <code>BlockDeviceMapping</code> objects that specify the instance's block devices. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">Block Device
         * Mapping</a>. Note that block device mappings are not supported for custom AMIs.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opsworks.model.BlockDeviceMapping.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.opsworks.model.BlockDeviceMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opsworks.model.BlockDeviceMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #blockDeviceMappings(List<BlockDeviceMapping>)}.
         * 
         * @param blockDeviceMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opsworks.model.BlockDeviceMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockDeviceMappings(java.util.Collection<BlockDeviceMapping>)
         */
        Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings);

        /**
         * <p>
         * Whether to install operating system and package updates when the instance boots. The default value is
         * <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then
         * update your instances manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code>
         * stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the
         * instances.
         * </p>
         * <note>
         * <p>
         * We strongly recommend using the default value of <code>true</code> to ensure that your instances have the
         * latest security updates.
         * </p>
         * </note>
         * 
         * @param installUpdatesOnBoot
         *        Whether to install operating system and package updates when the instance boots. The default value is
         *        <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You
         *        must then update your instances manually by using <a>CreateDeployment</a> to run the
         *        <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux)
         *        or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
         *        <p>
         *        We strongly recommend using the default value of <code>true</code> to ensure that your instances have
         *        the latest security updates.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot);

        /**
         * <p>
         * Whether to create an Amazon EBS-optimized instance.
         * </p>
         * 
         * @param ebsOptimized
         *        Whether to create an Amazon EBS-optimized instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The default OpsWorks Stacks agent version. You have the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>INHERIT</code> - Use the stack's default agent version setting.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>version_number</i> - Use the specified agent version. This value overrides the stack's default setting. To
         * update the agent version, edit the instance configuration and specify a new version. OpsWorks Stacks installs
         * that version on the instance.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete version
         * number, not the abbreviated number shown on the console. For a list of available agent version numbers, call
         * <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.
         * </p>
         * 
         * @param agentVersion
         *        The default OpsWorks Stacks agent version. You have the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>INHERIT</code> - Use the stack's default agent version setting.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>version_number</i> - Use the specified agent version. This value overrides the stack's default
         *        setting. To update the agent version, edit the instance configuration and specify a new version.
         *        OpsWorks Stacks installs that version on the instance.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default setting is <code>INHERIT</code>. To specify an agent version, you must use the complete
         *        version number, not the abbreviated number shown on the console. For a list of available agent version
         *        numbers, call <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * The instance's tenancy option. The default option is no tenancy, or if the instance is running in a VPC,
         * inherit tenancy settings from the VPC. The following are valid values for this parameter:
         * <code>dedicated</code>, <code>default</code>, or <code>host</code>. Because there are costs associated with
         * changes in tenancy options, we recommend that you research tenancy options before choosing them for your
         * instances. For more information about dedicated hosts, see <a
         * href="http://aws.amazon.com/ec2/dedicated-hosts/">Dedicated Hosts Overview</a> and <a
         * href="http://aws.amazon.com/ec2/dedicated-hosts/">Amazon EC2 Dedicated Hosts</a>. For more information about
         * dedicated instances, see <a
         * href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/dedicated-instance.html">Dedicated Instances</a>
         * and <a href="http://aws.amazon.com/ec2/purchasing-options/dedicated-instances/">Amazon EC2 Dedicated
         * Instances</a>.
         * </p>
         * 
         * @param tenancy
         *        The instance's tenancy option. The default option is no tenancy, or if the instance is running in a
         *        VPC, inherit tenancy settings from the VPC. The following are valid values for this parameter:
         *        <code>dedicated</code>, <code>default</code>, or <code>host</code>. Because there are costs associated
         *        with changes in tenancy options, we recommend that you research tenancy options before choosing them
         *        for your instances. For more information about dedicated hosts, see <a
         *        href="http://aws.amazon.com/ec2/dedicated-hosts/">Dedicated Hosts Overview</a> and <a
         *        href="http://aws.amazon.com/ec2/dedicated-hosts/">Amazon EC2 Dedicated Hosts</a>. For more information
         *        about dedicated instances, see <a
         *        href="https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/dedicated-instance.html">Dedicated
         *        Instances</a> and <a href="http://aws.amazon.com/ec2/purchasing-options/dedicated-instances/">Amazon
         *        EC2 Dedicated Instances</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenancy(String tenancy);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String stackId;

        private List<String> layerIds = DefaultSdkAutoConstructList.getInstance();

        private String instanceType;

        private String autoScalingType;

        private String hostname;

        private String os;

        private String amiId;

        private String sshKeyName;

        private String availabilityZone;

        private String virtualizationType;

        private String subnetId;

        private String architecture;

        private String rootDeviceType;

        private List<BlockDeviceMapping> blockDeviceMappings = DefaultSdkAutoConstructList.getInstance();

        private Boolean installUpdatesOnBoot;

        private Boolean ebsOptimized;

        private String agentVersion;

        private String tenancy;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInstanceRequest model) {
            super(model);
            stackId(model.stackId);
            layerIds(model.layerIds);
            instanceType(model.instanceType);
            autoScalingType(model.autoScalingType);
            hostname(model.hostname);
            os(model.os);
            amiId(model.amiId);
            sshKeyName(model.sshKeyName);
            availabilityZone(model.availabilityZone);
            virtualizationType(model.virtualizationType);
            subnetId(model.subnetId);
            architecture(model.architecture);
            rootDeviceType(model.rootDeviceType);
            blockDeviceMappings(model.blockDeviceMappings);
            installUpdatesOnBoot(model.installUpdatesOnBoot);
            ebsOptimized(model.ebsOptimized);
            agentVersion(model.agentVersion);
            tenancy(model.tenancy);
        }

        public final String getStackId() {
            return stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final Collection<String> getLayerIds() {
            if (layerIds instanceof SdkAutoConstructList) {
                return null;
            }
            return layerIds;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        @Override
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerIds(String... layerIds) {
            layerIds(Arrays.asList(layerIds));
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getAutoScalingType() {
            return autoScalingType;
        }

        public final void setAutoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
        }

        @Override
        public final Builder autoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
            return this;
        }

        @Override
        public final Builder autoScalingType(AutoScalingType autoScalingType) {
            this.autoScalingType(autoScalingType == null ? null : autoScalingType.toString());
            return this;
        }

        public final String getHostname() {
            return hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getOs() {
            return os;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        @Override
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        public final String getAmiId() {
            return amiId;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final String getSshKeyName() {
            return sshKeyName;
        }

        public final void setSshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
        }

        @Override
        public final Builder sshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getVirtualizationType() {
            return virtualizationType;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final String getArchitecture() {
            return architecture;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture == null ? null : architecture.toString());
            return this;
        }

        public final String getRootDeviceType() {
            return rootDeviceType;
        }

        public final void setRootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
        }

        @Override
        public final Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        @Override
        public final Builder rootDeviceType(RootDeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType == null ? null : rootDeviceType.toString());
            return this;
        }

        public final List<BlockDeviceMapping.Builder> getBlockDeviceMappings() {
            List<BlockDeviceMapping.Builder> result = BlockDeviceMappingsCopier.copyToBuilder(this.blockDeviceMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping.BuilderImpl> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copyFromBuilder(blockDeviceMappings);
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(Consumer<BlockDeviceMapping.Builder>... blockDeviceMappings) {
            blockDeviceMappings(Stream.of(blockDeviceMappings).map(c -> BlockDeviceMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getInstallUpdatesOnBoot() {
            return installUpdatesOnBoot;
        }

        public final void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
        }

        @Override
        public final Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final String getTenancy() {
            return tenancy;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInstanceRequest build() {
            return new CreateInstanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
