/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opsworks.model.OpsWorksRequest;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeServiceErrorsRequest
extends OpsWorksRequest
implements ToCopyableBuilder<Builder, DescribeServiceErrorsRequest> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StackId").getter(DescribeServiceErrorsRequest.getter(DescribeServiceErrorsRequest::stackId)).setter(DescribeServiceErrorsRequest.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(DescribeServiceErrorsRequest.getter(DescribeServiceErrorsRequest::instanceId)).setter(DescribeServiceErrorsRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<List<String>> SERVICE_ERROR_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ServiceErrorIds").getter(DescribeServiceErrorsRequest.getter(DescribeServiceErrorsRequest::serviceErrorIds)).setter(DescribeServiceErrorsRequest.setter(Builder::serviceErrorIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceErrorIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD, INSTANCE_ID_FIELD, SERVICE_ERROR_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeServiceErrorsRequest.memberNameToFieldInitializer();
    private final String stackId;
    private final String instanceId;
    private final List<String> serviceErrorIds;

    private DescribeServiceErrorsRequest(BuilderImpl builder) {
        super(builder);
        this.stackId = builder.stackId;
        this.instanceId = builder.instanceId;
        this.serviceErrorIds = builder.serviceErrorIds;
    }

    public final String stackId() {
        return this.stackId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final boolean hasServiceErrorIds() {
        return this.serviceErrorIds != null && !(this.serviceErrorIds instanceof SdkAutoConstructList);
    }

    public final List<String> serviceErrorIds() {
        return this.serviceErrorIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceErrorIds() ? this.serviceErrorIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceErrorsRequest)) {
            return false;
        }
        DescribeServiceErrorsRequest other = (DescribeServiceErrorsRequest)((Object)obj);
        return Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.instanceId(), other.instanceId()) && this.hasServiceErrorIds() == other.hasServiceErrorIds() && Objects.equals(this.serviceErrorIds(), other.serviceErrorIds());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeServiceErrorsRequest").add("StackId", (Object)this.stackId()).add("InstanceId", (Object)this.instanceId()).add("ServiceErrorIds", this.hasServiceErrorIds() ? this.serviceErrorIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ServiceErrorIds": {
                return Optional.ofNullable(clazz.cast(this.serviceErrorIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StackId", STACK_ID_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("ServiceErrorIds", SERVICE_ERROR_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeServiceErrorsRequest, T> g) {
        return obj -> g.apply((DescribeServiceErrorsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpsWorksRequest.BuilderImpl
    implements Builder {
        private String stackId;
        private String instanceId;
        private List<String> serviceErrorIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceErrorsRequest model) {
            super(model);
            this.stackId(model.stackId);
            this.instanceId(model.instanceId);
            this.serviceErrorIds(model.serviceErrorIds);
        }

        public final String getStackId() {
            return this.stackId;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final Collection<String> getServiceErrorIds() {
            if (this.serviceErrorIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceErrorIds;
        }

        public final void setServiceErrorIds(Collection<String> serviceErrorIds) {
            this.serviceErrorIds = StringsCopier.copy(serviceErrorIds);
        }

        @Override
        public final Builder serviceErrorIds(Collection<String> serviceErrorIds) {
            this.serviceErrorIds = StringsCopier.copy(serviceErrorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceErrorIds(String ... serviceErrorIds) {
            this.serviceErrorIds(Arrays.asList(serviceErrorIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeServiceErrorsRequest build() {
            return new DescribeServiceErrorsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OpsWorksRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeServiceErrorsRequest> {
        public Builder stackId(String var1);

        public Builder instanceId(String var1);

        public Builder serviceErrorIds(Collection<String> var1);

        public Builder serviceErrorIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

