/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloneStackRequest extends OpsWorksRequest implements
        ToCopyableBuilder<CloneStackRequest.Builder, CloneStackRequest> {
    private static final SdkField<String> SOURCE_STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloneStackRequest::sourceStackId)).setter(setter(Builder::sourceStackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceStackId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloneStackRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloneStackRequest::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloneStackRequest::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CloneStackRequest::attributesAsStrings))
            .setter(setter(Builder::attributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloneStackRequest::serviceRoleArn)).setter(setter(Builder::serviceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()).build();

    private static final SdkField<String> DEFAULT_INSTANCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloneStackRequest::defaultInstanceProfileArn)).setter(setter(Builder::defaultInstanceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultInstanceProfileArn").build())
            .build();

    private static final SdkField<String> DEFAULT_OS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloneStackRequest::defaultOs)).setter(setter(Builder::defaultOs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultOs").build()).build();

    private static final SdkField<String> HOSTNAME_THEME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloneStackRequest::hostnameTheme)).setter(setter(Builder::hostnameTheme))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HostnameTheme").build()).build();

    private static final SdkField<String> DEFAULT_AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloneStackRequest::defaultAvailabilityZone)).setter(setter(Builder::defaultAvailabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultAvailabilityZone").build())
            .build();

    private static final SdkField<String> DEFAULT_SUBNET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloneStackRequest::defaultSubnetId)).setter(setter(Builder::defaultSubnetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSubnetId").build()).build();

    private static final SdkField<String> CUSTOM_JSON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloneStackRequest::customJson)).setter(setter(Builder::customJson))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomJson").build()).build();

    private static final SdkField<StackConfigurationManager> CONFIGURATION_MANAGER_FIELD = SdkField
            .<StackConfigurationManager> builder(MarshallingType.SDK_POJO)
            .getter(getter(CloneStackRequest::configurationManager)).setter(setter(Builder::configurationManager))
            .constructor(StackConfigurationManager::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationManager").build())
            .build();

    private static final SdkField<ChefConfiguration> CHEF_CONFIGURATION_FIELD = SdkField
            .<ChefConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(CloneStackRequest::chefConfiguration))
            .setter(setter(Builder::chefConfiguration)).constructor(ChefConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChefConfiguration").build()).build();

    private static final SdkField<Boolean> USE_CUSTOM_COOKBOOKS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CloneStackRequest::useCustomCookbooks)).setter(setter(Builder::useCustomCookbooks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCustomCookbooks").build())
            .build();

    private static final SdkField<Boolean> USE_OPSWORKS_SECURITY_GROUPS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(CloneStackRequest::useOpsworksSecurityGroups))
            .setter(setter(Builder::useOpsworksSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseOpsworksSecurityGroups").build())
            .build();

    private static final SdkField<Source> CUSTOM_COOKBOOKS_SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO)
            .getter(getter(CloneStackRequest::customCookbooksSource)).setter(setter(Builder::customCookbooksSource))
            .constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomCookbooksSource").build())
            .build();

    private static final SdkField<String> DEFAULT_SSH_KEY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloneStackRequest::defaultSshKeyName)).setter(setter(Builder::defaultSshKeyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultSshKeyName").build()).build();

    private static final SdkField<Boolean> CLONE_PERMISSIONS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CloneStackRequest::clonePermissions)).setter(setter(Builder::clonePermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClonePermissions").build()).build();

    private static final SdkField<List<String>> CLONE_APP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CloneStackRequest::cloneAppIds))
            .setter(setter(Builder::cloneAppIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloneAppIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_ROOT_DEVICE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloneStackRequest::defaultRootDeviceTypeAsString)).setter(setter(Builder::defaultRootDeviceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRootDeviceType").build())
            .build();

    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CloneStackRequest::agentVersion)).setter(setter(Builder::agentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AgentVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_STACK_ID_FIELD,
            NAME_FIELD, REGION_FIELD, VPC_ID_FIELD, ATTRIBUTES_FIELD, SERVICE_ROLE_ARN_FIELD, DEFAULT_INSTANCE_PROFILE_ARN_FIELD,
            DEFAULT_OS_FIELD, HOSTNAME_THEME_FIELD, DEFAULT_AVAILABILITY_ZONE_FIELD, DEFAULT_SUBNET_ID_FIELD, CUSTOM_JSON_FIELD,
            CONFIGURATION_MANAGER_FIELD, CHEF_CONFIGURATION_FIELD, USE_CUSTOM_COOKBOOKS_FIELD,
            USE_OPSWORKS_SECURITY_GROUPS_FIELD, CUSTOM_COOKBOOKS_SOURCE_FIELD, DEFAULT_SSH_KEY_NAME_FIELD,
            CLONE_PERMISSIONS_FIELD, CLONE_APP_IDS_FIELD, DEFAULT_ROOT_DEVICE_TYPE_FIELD, AGENT_VERSION_FIELD));

    private final String sourceStackId;

    private final String name;

    private final String region;

    private final String vpcId;

    private final Map<String, String> attributes;

    private final String serviceRoleArn;

    private final String defaultInstanceProfileArn;

    private final String defaultOs;

    private final String hostnameTheme;

    private final String defaultAvailabilityZone;

    private final String defaultSubnetId;

    private final String customJson;

    private final StackConfigurationManager configurationManager;

    private final ChefConfiguration chefConfiguration;

    private final Boolean useCustomCookbooks;

    private final Boolean useOpsworksSecurityGroups;

    private final Source customCookbooksSource;

    private final String defaultSshKeyName;

    private final Boolean clonePermissions;

    private final List<String> cloneAppIds;

    private final String defaultRootDeviceType;

    private final String agentVersion;

    private CloneStackRequest(BuilderImpl builder) {
        super(builder);
        this.sourceStackId = builder.sourceStackId;
        this.name = builder.name;
        this.region = builder.region;
        this.vpcId = builder.vpcId;
        this.attributes = builder.attributes;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.defaultInstanceProfileArn = builder.defaultInstanceProfileArn;
        this.defaultOs = builder.defaultOs;
        this.hostnameTheme = builder.hostnameTheme;
        this.defaultAvailabilityZone = builder.defaultAvailabilityZone;
        this.defaultSubnetId = builder.defaultSubnetId;
        this.customJson = builder.customJson;
        this.configurationManager = builder.configurationManager;
        this.chefConfiguration = builder.chefConfiguration;
        this.useCustomCookbooks = builder.useCustomCookbooks;
        this.useOpsworksSecurityGroups = builder.useOpsworksSecurityGroups;
        this.customCookbooksSource = builder.customCookbooksSource;
        this.defaultSshKeyName = builder.defaultSshKeyName;
        this.clonePermissions = builder.clonePermissions;
        this.cloneAppIds = builder.cloneAppIds;
        this.defaultRootDeviceType = builder.defaultRootDeviceType;
        this.agentVersion = builder.agentVersion;
    }

    /**
     * <p>
     * The source stack ID.
     * </p>
     * 
     * @return The source stack ID.
     */
    public String sourceStackId() {
        return sourceStackId;
    }

    /**
     * <p>
     * The cloned stack name.
     * </p>
     * 
     * @return The cloned stack name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The cloned stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     * </p>
     * 
     * @return The cloned stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * The ID of the VPC that the cloned stack is to be launched into. It must be in the specified region. All instances
     * are launched into this VPC, and you cannot change the ID later.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If your account supports EC2 Classic, the default value is no VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * If your account does not support EC2 Classic, the default value is the default VPC for the specified region.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the VPC ID corresponds to a default VPC and you have specified either the <code>DefaultAvailabilityZone</code>
     * or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks Stacks infers the value of the other parameter.
     * If you specify neither parameter, AWS OpsWorks Stacks sets these parameters to the first valid Availability Zone
     * for the specified region and the corresponding default VPC subnet ID, respectively.
     * </p>
     * <p>
     * If you specify a nondefault VPC ID, note the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It must belong to a VPC in your account that is in the specified region.
     * </p>
     * </li>
     * <li>
     * <p>
     * You must specify a value for <code>DefaultSubnetId</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about how to use AWS OpsWorks Stacks with a VPC, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a VPC</a>.
     * For more information about default VPC and EC2 Classic, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported Platforms</a>.
     * </p>
     * 
     * @return The ID of the VPC that the cloned stack is to be launched into. It must be in the specified region. All
     *         instances are launched into this VPC, and you cannot change the ID later.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         If your account supports EC2 Classic, the default value is no VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If your account does not support EC2 Classic, the default value is the default VPC for the specified
     *         region.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         If the VPC ID corresponds to a default VPC and you have specified either the
     *         <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks
     *         Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks
     *         sets these parameters to the first valid Availability Zone for the specified region and the corresponding
     *         default VPC subnet ID, respectively.
     *         </p>
     *         <p>
     *         If you specify a nondefault VPC ID, note the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         It must belong to a VPC in your account that is in the specified region.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         You must specify a value for <code>DefaultSubnetId</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about how to use AWS OpsWorks Stacks with a VPC, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a
     *         VPC</a>. For more information about default VPC and EC2 Classic, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
     *         Platforms</a>.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * A list of stack attributes and values as key/value pairs to be added to the cloned stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of stack attributes and values as key/value pairs to be added to the cloned stack.
     */
    public Map<StackAttributesKeys, String> attributes() {
        return TypeConverter.convert(attributes, StackAttributesKeys::fromValue, Function.identity(),
                (k, v) -> !Objects.equals(k, StackAttributesKeys.UNKNOWN_TO_SDK_VERSION));
    }

    /**
     * <p>
     * A list of stack attributes and values as key/value pairs to be added to the cloned stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of stack attributes and values as key/value pairs to be added to the cloned stack.
     */
    public Map<String, String> attributesAsStrings() {
        return attributes;
    }

    /**
     * <p>
     * The stack AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with AWS
     * resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM role.
     * If you create a stack by using the AWS OpsWorks Stacks console, it creates the role for you. You can obtain an
     * existing stack's IAM ARN programmatically by calling <a>DescribePermissions</a>. For more information about IAM
     * ARNs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     * </p>
     * <note>
     * <p>
     * You must set this parameter to a valid service role ARN or the action will fail; there is no default value. You
     * can specify the source stack's service role ARN, if you prefer, but you must do so explicitly.
     * </p>
     * </note>
     * 
     * @return The stack AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with
     *         AWS resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an
     *         existing IAM role. If you create a stack by using the AWS OpsWorks Stacks console, it creates the role
     *         for you. You can obtain an existing stack's IAM ARN programmatically by calling
     *         <a>DescribePermissions</a>. For more information about IAM ARNs, see <a
     *         href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.</p>
     *         <note>
     *         <p>
     *         You must set this parameter to a valid service role ARN or the action will fail; there is no default
     *         value. You can specify the source stack's service role ARN, if you prefer, but you must do so explicitly.
     *         </p>
     */
    public String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2
     * instances. For more information about IAM ARNs, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2
     *         instances. For more information about IAM ARNs, see <a
     *         href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     */
    public String defaultInstanceProfileArn() {
        return defaultInstanceProfileArn;
    }

    /**
     * <p>
     * The stack's operating system, which must be set to one of the following.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2017.09</code>,
     * <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>,
     * <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or
     * <code>Ubuntu 12.04 LTS</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CentOS Linux 7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Red Hat Enterprise Linux 7</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Microsoft Windows Server 2012 R2 Base</code>,
     * <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
     * <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
     * <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For more
     * information about how to use custom AMIs with OpsWorks, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom
     * AMIs</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default option is the parent stack's operating system. For more information about supported operating
     * systems, see <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks
     * Stacks Operating Systems</a>.
     * </p>
     * <note>
     * <p>
     * You can specify a different Linux operating system for the cloned stack, but you cannot change from Linux to
     * Windows or Windows to Linux.
     * </p>
     * </note>
     * 
     * @return The stack's operating system, which must be set to one of the following.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2017.09</code>,
     *         <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>,
     *         <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>
     *         , or <code>Ubuntu 12.04 LTS</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CentOS Linux 7</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Red Hat Enterprise Linux 7</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Microsoft Windows Server 2012 R2 Base</code>,
     *         <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
     *         <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
     *         <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances.
     *         For more information about how to use custom AMIs with OpsWorks, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom
     *         AMIs</a>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default option is the parent stack's operating system. For more information about supported operating
     *         systems, see <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS
     *         OpsWorks Stacks Operating Systems</a>.
     *         </p>
     *         <note>
     *         <p>
     *         You can specify a different Linux operating system for the cloned stack, but you cannot change from Linux
     *         to Windows or Windows to Linux.
     *         </p>
     */
    public String defaultOs() {
        return defaultOs;
    }

    /**
     * <p>
     * The stack's host name theme, with spaces are replaced by underscores. The theme is used to generate host names
     * for the stack's instances. By default, <code>HostnameTheme</code> is set to <code>Layer_Dependent</code>, which
     * creates host names by appending integers to the layer's short name. The other themes are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Baked_Goods</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Clouds</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Europe_Cities</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Fruits</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Greek_Deities</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Legendary_creatures_from_Japan</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Planets_and_Moons</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Roman_Deities</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Scottish_Islands</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>US_Cities</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Wild_Cats</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on the
     * current theme.
     * </p>
     * 
     * @return The stack's host name theme, with spaces are replaced by underscores. The theme is used to generate host
     *         names for the stack's instances. By default, <code>HostnameTheme</code> is set to
     *         <code>Layer_Dependent</code>, which creates host names by appending integers to the layer's short name.
     *         The other themes are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Baked_Goods</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Clouds</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Europe_Cities</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Fruits</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Greek_Deities</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Legendary_creatures_from_Japan</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Planets_and_Moons</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Roman_Deities</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Scottish_Islands</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>US_Cities</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Wild_Cats</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based
     *         on the current theme.
     */
    public String hostnameTheme() {
        return hostnameTheme;
    }

    /**
     * <p>
     * The cloned stack's default Availability Zone, which must be in the specified region. For more information, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also specify a
     * value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information, see the
     * <code>VpcId</code> parameter description.
     * </p>
     * 
     * @return The cloned stack's default Availability Zone, which must be in the specified region. For more
     *         information, see <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and
     *         Endpoints</a>. If you also specify a value for <code>DefaultSubnetId</code>, the subnet must be in the
     *         same zone. For more information, see the <code>VpcId</code> parameter description.
     */
    public String defaultAvailabilityZone() {
        return defaultAvailabilityZone;
    }

    /**
     * <p>
     * The stack's default VPC subnet ID. This parameter is required if you specify a value for the <code>VpcId</code>
     * parameter. All instances are launched into this subnet unless you specify otherwise when you create the instance.
     * If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet must be in that zone. For
     * information on default values and when this parameter is required, see the <code>VpcId</code> parameter
     * description.
     * </p>
     * 
     * @return The stack's default VPC subnet ID. This parameter is required if you specify a value for the
     *         <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise
     *         when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the
     *         subnet must be in that zone. For information on default values and when this parameter is required, see
     *         the <code>VpcId</code> parameter description.
     */
    public String defaultSubnetId() {
        return defaultSubnetId;
    }

    /**
     * <p>
     * A string that contains user-defined, custom JSON. It is used to override the corresponding default stack
     * configuration JSON values. The string should be in the following format:
     * </p>
     * <p>
     * <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
     * </p>
     * <p>
     * For more information about custom JSON, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the
     * Stack Configuration Attributes</a>
     * </p>
     * 
     * @return A string that contains user-defined, custom JSON. It is used to override the corresponding default stack
     *         configuration JSON values. The string should be in the following format:</p>
     *         <p>
     *         <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
     *         </p>
     *         <p>
     *         For more information about custom JSON, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
     *         Modify the Stack Configuration Attributes</a>
     */
    public String customJson() {
        return customJson;
    }

    /**
     * <p>
     * The configuration manager. When you clone a stack we recommend that you use the configuration manager to specify
     * the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value for Linux
     * stacks is currently 12.
     * </p>
     * 
     * @return The configuration manager. When you clone a stack we recommend that you use the configuration manager to
     *         specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default
     *         value for Linux stacks is currently 12.
     */
    public StackConfigurationManager configurationManager() {
        return configurationManager;
    }

    /**
     * <p>
     * A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version on
     * Chef 11.10 stacks. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.
     * </p>
     * 
     * @return A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf
     *         version on Chef 11.10 stacks. For more information, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
     *         Stack</a>.
     */
    public ChefConfiguration chefConfiguration() {
        return chefConfiguration;
    }

    /**
     * <p>
     * Whether to use custom cookbooks.
     * </p>
     * 
     * @return Whether to use custom cookbooks.
     */
    public Boolean useCustomCookbooks() {
        return useCustomCookbooks;
    }

    /**
     * <p>
     * Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.
     * </p>
     * <p>
     * AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are associated
     * with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your own custom
     * security groups. <code>UseOpsworksSecurityGroups</code> has the following settings:
     * </p>
     * <ul>
     * <li>
     * <p>
     * True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer
     * (default setting). You can associate additional security groups with a layer after you create it but you cannot
     * delete the built-in security group.
     * </p>
     * </li>
     * <li>
     * <p>
     * False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create appropriate
     * Amazon Elastic Compute Cloud (Amazon EC2) security groups and associate a security group with each layer that you
     * create. However, you can still manually associate a built-in security group with a layer on creation; custom
     * security groups are required only for those layers that need custom settings.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New Stack</a>.
     * </p>
     * 
     * @return Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
     *         <p>
     *         AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are
     *         associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide
     *         your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each
     *         layer (default setting). You can associate additional security groups with a layer after you create it
     *         but you cannot delete the built-in security group.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create
     *         appropriate Amazon Elastic Compute Cloud (Amazon EC2) security groups and associate a security group with
     *         each layer that you create. However, you can still manually associate a built-in security group with a
     *         layer on creation; custom security groups are required only for those layers that need custom settings.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
     *         Stack</a>.
     */
    public Boolean useOpsworksSecurityGroups() {
        return useOpsworksSecurityGroups;
    }

    /**
     * Returns the value of the CustomCookbooksSource property for this object.
     * 
     * @return The value of the CustomCookbooksSource property for this object.
     */
    public Source customCookbooksSource() {
        return customCookbooksSource;
    }

    /**
     * <p>
     * A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS OpsWorks
     * installs the public key on the instance and you can use the private key with an SSH client to log in to the
     * instance. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to Communicate
     * with an Instance</a> and <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html">
     * Managing SSH Access</a>. You can override this setting by specifying a different key pair, or no key pair, when
     * you <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an
     * instance</a>.
     * </p>
     * 
     * @return A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS
     *         OpsWorks installs the public key on the instance and you can use the private key with an SSH client to
     *         log in to the instance. For more information, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to
     *         Communicate with an Instance</a> and <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH
     *         Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an
     *         instance</a>.
     */
    public String defaultSshKeyName() {
        return defaultSshKeyName;
    }

    /**
     * <p>
     * Whether to clone the source stack's permissions.
     * </p>
     * 
     * @return Whether to clone the source stack's permissions.
     */
    public Boolean clonePermissions() {
        return clonePermissions;
    }

    /**
     * <p>
     * A list of source stack app IDs to be included in the cloned stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of source stack app IDs to be included in the cloned stack.
     */
    public List<String> cloneAppIds() {
        return cloneAppIds;
    }

    /**
     * <p>
     * The default root device type. This value is used by default for all instances in the cloned stack, but you can
     * override it when you create an instance. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage
     * for the Root Device</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRootDeviceType} will return {@link RootDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #defaultRootDeviceTypeAsString}.
     * </p>
     * 
     * @return The default root device type. This value is used by default for all instances in the cloned stack, but
     *         you can override it when you create an instance. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
     *         >Storage for the Root Device</a>.
     * @see RootDeviceType
     */
    public RootDeviceType defaultRootDeviceType() {
        return RootDeviceType.fromValue(defaultRootDeviceType);
    }

    /**
     * <p>
     * The default root device type. This value is used by default for all instances in the cloned stack, but you can
     * override it when you create an instance. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage
     * for the Root Device</a>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #defaultRootDeviceType} will return {@link RootDeviceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #defaultRootDeviceTypeAsString}.
     * </p>
     * 
     * @return The default root device type. This value is used by default for all instances in the cloned stack, but
     *         you can override it when you create an instance. For more information, see <a href=
     *         "http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
     *         >Storage for the Root Device</a>.
     * @see RootDeviceType
     */
    public String defaultRootDeviceTypeAsString() {
        return defaultRootDeviceType;
    }

    /**
     * <p>
     * The default AWS OpsWorks Stacks agent version. You have the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new agent
     * versions on the stack's instances as soon as they are available.
     * </p>
     * </li>
     * <li>
     * <p>
     * Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must edit
     * the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that version
     * on the stack's instances.
     * </p>
     * </li>
     * </ul>
     * <p>
     * The default setting is <code>LATEST</code>. To specify an agent version, you must use the complete version
     * number, not the abbreviated number shown on the console. For a list of available agent version numbers, call
     * <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.
     * </p>
     * <note>
     * <p>
     * You can also specify an agent version when you create or update an instance, which overrides the stack's default
     * setting.
     * </p>
     * </note>
     * 
     * @return The default AWS OpsWorks Stacks agent version. You have the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new
     *         agent versions on the stack's instances as soon as they are available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must
     *         edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs
     *         that version on the stack's instances.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         The default setting is <code>LATEST</code>. To specify an agent version, you must use the complete
     *         version number, not the abbreviated number shown on the console. For a list of available agent version
     *         numbers, call <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.
     *         </p>
     *         <note>
     *         <p>
     *         You can also specify an agent version when you create or update an instance, which overrides the stack's
     *         default setting.
     *         </p>
     */
    public String agentVersion() {
        return agentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceStackId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(attributesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(defaultInstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(defaultOs());
        hashCode = 31 * hashCode + Objects.hashCode(hostnameTheme());
        hashCode = 31 * hashCode + Objects.hashCode(defaultAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSubnetId());
        hashCode = 31 * hashCode + Objects.hashCode(customJson());
        hashCode = 31 * hashCode + Objects.hashCode(configurationManager());
        hashCode = 31 * hashCode + Objects.hashCode(chefConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(useCustomCookbooks());
        hashCode = 31 * hashCode + Objects.hashCode(useOpsworksSecurityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(customCookbooksSource());
        hashCode = 31 * hashCode + Objects.hashCode(defaultSshKeyName());
        hashCode = 31 * hashCode + Objects.hashCode(clonePermissions());
        hashCode = 31 * hashCode + Objects.hashCode(cloneAppIds());
        hashCode = 31 * hashCode + Objects.hashCode(defaultRootDeviceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(agentVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloneStackRequest)) {
            return false;
        }
        CloneStackRequest other = (CloneStackRequest) obj;
        return Objects.equals(sourceStackId(), other.sourceStackId()) && Objects.equals(name(), other.name())
                && Objects.equals(region(), other.region()) && Objects.equals(vpcId(), other.vpcId())
                && Objects.equals(attributesAsStrings(), other.attributesAsStrings())
                && Objects.equals(serviceRoleArn(), other.serviceRoleArn())
                && Objects.equals(defaultInstanceProfileArn(), other.defaultInstanceProfileArn())
                && Objects.equals(defaultOs(), other.defaultOs()) && Objects.equals(hostnameTheme(), other.hostnameTheme())
                && Objects.equals(defaultAvailabilityZone(), other.defaultAvailabilityZone())
                && Objects.equals(defaultSubnetId(), other.defaultSubnetId()) && Objects.equals(customJson(), other.customJson())
                && Objects.equals(configurationManager(), other.configurationManager())
                && Objects.equals(chefConfiguration(), other.chefConfiguration())
                && Objects.equals(useCustomCookbooks(), other.useCustomCookbooks())
                && Objects.equals(useOpsworksSecurityGroups(), other.useOpsworksSecurityGroups())
                && Objects.equals(customCookbooksSource(), other.customCookbooksSource())
                && Objects.equals(defaultSshKeyName(), other.defaultSshKeyName())
                && Objects.equals(clonePermissions(), other.clonePermissions())
                && Objects.equals(cloneAppIds(), other.cloneAppIds())
                && Objects.equals(defaultRootDeviceTypeAsString(), other.defaultRootDeviceTypeAsString())
                && Objects.equals(agentVersion(), other.agentVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CloneStackRequest").add("SourceStackId", sourceStackId()).add("Name", name())
                .add("Region", region()).add("VpcId", vpcId()).add("Attributes", attributesAsStrings())
                .add("ServiceRoleArn", serviceRoleArn()).add("DefaultInstanceProfileArn", defaultInstanceProfileArn())
                .add("DefaultOs", defaultOs()).add("HostnameTheme", hostnameTheme())
                .add("DefaultAvailabilityZone", defaultAvailabilityZone()).add("DefaultSubnetId", defaultSubnetId())
                .add("CustomJson", customJson()).add("ConfigurationManager", configurationManager())
                .add("ChefConfiguration", chefConfiguration()).add("UseCustomCookbooks", useCustomCookbooks())
                .add("UseOpsworksSecurityGroups", useOpsworksSecurityGroups())
                .add("CustomCookbooksSource", customCookbooksSource()).add("DefaultSshKeyName", defaultSshKeyName())
                .add("ClonePermissions", clonePermissions()).add("CloneAppIds", cloneAppIds())
                .add("DefaultRootDeviceType", defaultRootDeviceTypeAsString()).add("AgentVersion", agentVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceStackId":
            return Optional.ofNullable(clazz.cast(sourceStackId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributesAsStrings()));
        case "ServiceRoleArn":
            return Optional.ofNullable(clazz.cast(serviceRoleArn()));
        case "DefaultInstanceProfileArn":
            return Optional.ofNullable(clazz.cast(defaultInstanceProfileArn()));
        case "DefaultOs":
            return Optional.ofNullable(clazz.cast(defaultOs()));
        case "HostnameTheme":
            return Optional.ofNullable(clazz.cast(hostnameTheme()));
        case "DefaultAvailabilityZone":
            return Optional.ofNullable(clazz.cast(defaultAvailabilityZone()));
        case "DefaultSubnetId":
            return Optional.ofNullable(clazz.cast(defaultSubnetId()));
        case "CustomJson":
            return Optional.ofNullable(clazz.cast(customJson()));
        case "ConfigurationManager":
            return Optional.ofNullable(clazz.cast(configurationManager()));
        case "ChefConfiguration":
            return Optional.ofNullable(clazz.cast(chefConfiguration()));
        case "UseCustomCookbooks":
            return Optional.ofNullable(clazz.cast(useCustomCookbooks()));
        case "UseOpsworksSecurityGroups":
            return Optional.ofNullable(clazz.cast(useOpsworksSecurityGroups()));
        case "CustomCookbooksSource":
            return Optional.ofNullable(clazz.cast(customCookbooksSource()));
        case "DefaultSshKeyName":
            return Optional.ofNullable(clazz.cast(defaultSshKeyName()));
        case "ClonePermissions":
            return Optional.ofNullable(clazz.cast(clonePermissions()));
        case "CloneAppIds":
            return Optional.ofNullable(clazz.cast(cloneAppIds()));
        case "DefaultRootDeviceType":
            return Optional.ofNullable(clazz.cast(defaultRootDeviceTypeAsString()));
        case "AgentVersion":
            return Optional.ofNullable(clazz.cast(agentVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloneStackRequest, T> g) {
        return obj -> g.apply((CloneStackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, CloneStackRequest> {
        /**
         * <p>
         * The source stack ID.
         * </p>
         * 
         * @param sourceStackId
         *        The source stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceStackId(String sourceStackId);

        /**
         * <p>
         * The cloned stack name.
         * </p>
         * 
         * @param name
         *        The cloned stack name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The cloned stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see <a
         * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * </p>
         * 
         * @param region
         *        The cloned stack AWS region, such as "ap-northeast-2". For more information about AWS regions, see <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The ID of the VPC that the cloned stack is to be launched into. It must be in the specified region. All
         * instances are launched into this VPC, and you cannot change the ID later.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If your account supports EC2 Classic, the default value is no VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * If your account does not support EC2 Classic, the default value is the default VPC for the specified region.
         * </p>
         * </li>
         * </ul>
         * <p>
         * If the VPC ID corresponds to a default VPC and you have specified either the
         * <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks Stacks
         * infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks sets these
         * parameters to the first valid Availability Zone for the specified region and the corresponding default VPC
         * subnet ID, respectively.
         * </p>
         * <p>
         * If you specify a nondefault VPC ID, note the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * It must belong to a VPC in your account that is in the specified region.
         * </p>
         * </li>
         * <li>
         * <p>
         * You must specify a value for <code>DefaultSubnetId</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about how to use AWS OpsWorks Stacks with a VPC, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in a
         * VPC</a>. For more information about default VPC and EC2 Classic, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
         * Platforms</a>.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC that the cloned stack is to be launched into. It must be in the specified region.
         *        All instances are launched into this VPC, and you cannot change the ID later.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        If your account supports EC2 Classic, the default value is no VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If your account does not support EC2 Classic, the default value is the default VPC for the specified
         *        region.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        If the VPC ID corresponds to a default VPC and you have specified either the
         *        <code>DefaultAvailabilityZone</code> or the <code>DefaultSubnetId</code> parameter only, AWS OpsWorks
         *        Stacks infers the value of the other parameter. If you specify neither parameter, AWS OpsWorks Stacks
         *        sets these parameters to the first valid Availability Zone for the specified region and the
         *        corresponding default VPC subnet ID, respectively.
         *        </p>
         *        <p>
         *        If you specify a nondefault VPC ID, note the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        It must belong to a VPC in your account that is in the specified region.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        You must specify a value for <code>DefaultSubnetId</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about how to use AWS OpsWorks Stacks with a VPC, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-vpc.html">Running a Stack in
         *        a VPC</a>. For more information about default VPC and EC2 Classic, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html">Supported
         *        Platforms</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * A list of stack attributes and values as key/value pairs to be added to the cloned stack.
         * </p>
         * 
         * @param attributes
         *        A list of stack attributes and values as key/value pairs to be added to the cloned stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesWithStrings(Map<String, String> attributes);

        /**
         * <p>
         * A list of stack attributes and values as key/value pairs to be added to the cloned stack.
         * </p>
         * 
         * @param attributes
         *        A list of stack attributes and values as key/value pairs to be added to the cloned stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<StackAttributesKeys, String> attributes);

        /**
         * <p>
         * The stack AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with AWS
         * resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an existing IAM
         * role. If you create a stack by using the AWS OpsWorks Stacks console, it creates the role for you. You can
         * obtain an existing stack's IAM ARN programmatically by calling <a>DescribePermissions</a>. For more
         * information about IAM ARNs, see <a
         * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * </p>
         * <note>
         * <p>
         * You must set this parameter to a valid service role ARN or the action will fail; there is no default value.
         * You can specify the source stack's service role ARN, if you prefer, but you must do so explicitly.
         * </p>
         * </note>
         * 
         * @param serviceRoleArn
         *        The stack AWS Identity and Access Management (IAM) role, which allows AWS OpsWorks Stacks to work with
         *        AWS resources on your behalf. You must set this parameter to the Amazon Resource Name (ARN) for an
         *        existing IAM role. If you create a stack by using the AWS OpsWorks Stacks console, it creates the role
         *        for you. You can obtain an existing stack's IAM ARN programmatically by calling
         *        <a>DescribePermissions</a>. For more information about IAM ARNs, see <a
         *        href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
         *        Identifiers</a>.</p> <note>
         *        <p>
         *        You must set this parameter to a valid service role ARN or the action will fail; there is no default
         *        value. You can specify the source stack's service role ARN, if you prefer, but you must do so
         *        explicitly.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's EC2
         * instances. For more information about IAM ARNs, see <a
         * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * </p>
         * 
         * @param defaultInstanceProfileArn
         *        The Amazon Resource Name (ARN) of an IAM profile that is the default profile for all of the stack's
         *        EC2 instances. For more information about IAM ARNs, see <a
         *        href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultInstanceProfileArn(String defaultInstanceProfileArn);

        /**
         * <p>
         * The stack's operating system, which must be set to one of the following.
         * </p>
         * <ul>
         * <li>
         * <p>
         * A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2017.09</code>,
         * <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>, <code>Amazon Linux 2016.03</code>,
         * <code>Amazon Linux 2015.09</code>, or <code>Amazon Linux 2015.03</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>, <code>Ubuntu 14.04 LTS</code>, or
         * <code>Ubuntu 12.04 LTS</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CentOS Linux 7</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Red Hat Enterprise Linux 7</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Microsoft Windows Server 2012 R2 Base</code>,
         * <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
         * <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
         * <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create instances. For
         * more information about how to use custom AMIs with OpsWorks, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using Custom
         * AMIs</a>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default option is the parent stack's operating system. For more information about supported operating
         * systems, see <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS
         * OpsWorks Stacks Operating Systems</a>.
         * </p>
         * <note>
         * <p>
         * You can specify a different Linux operating system for the cloned stack, but you cannot change from Linux to
         * Windows or Windows to Linux.
         * </p>
         * </note>
         * 
         * @param defaultOs
         *        The stack's operating system, which must be set to one of the following.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        A supported Linux operating system: An Amazon Linux version, such as <code>Amazon Linux 2017.09</code>, <code>Amazon Linux 2017.03</code>, <code>Amazon Linux 2016.09</code>,
         *        <code>Amazon Linux 2016.03</code>, <code>Amazon Linux 2015.09</code>, or
         *        <code>Amazon Linux 2015.03</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A supported Ubuntu operating system, such as <code>Ubuntu 16.04 LTS</code>,
         *        <code>Ubuntu 14.04 LTS</code>, or <code>Ubuntu 12.04 LTS</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CentOS Linux 7</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Red Hat Enterprise Linux 7</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Microsoft Windows Server 2012 R2 Base</code>,
         *        <code>Microsoft Windows Server 2012 R2 with SQL Server Express</code>,
         *        <code>Microsoft Windows Server 2012 R2 with SQL Server Standard</code>, or
         *        <code>Microsoft Windows Server 2012 R2 with SQL Server Web</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        A custom AMI: <code>Custom</code>. You specify the custom AMI you want to use when you create
         *        instances. For more information about how to use custom AMIs with OpsWorks, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Using
         *        Custom AMIs</a>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default option is the parent stack's operating system. For more information about supported
         *        operating systems, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-os.html">AWS OpsWorks
         *        Stacks Operating Systems</a>.
         *        </p>
         *        <note>
         *        <p>
         *        You can specify a different Linux operating system for the cloned stack, but you cannot change from
         *        Linux to Windows or Windows to Linux.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultOs(String defaultOs);

        /**
         * <p>
         * The stack's host name theme, with spaces are replaced by underscores. The theme is used to generate host
         * names for the stack's instances. By default, <code>HostnameTheme</code> is set to
         * <code>Layer_Dependent</code>, which creates host names by appending integers to the layer's short name. The
         * other themes are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Baked_Goods</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Clouds</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Europe_Cities</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Fruits</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Greek_Deities</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Legendary_creatures_from_Japan</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Planets_and_Moons</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Roman_Deities</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Scottish_Islands</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>US_Cities</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Wild_Cats</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name based on
         * the current theme.
         * </p>
         * 
         * @param hostnameTheme
         *        The stack's host name theme, with spaces are replaced by underscores. The theme is used to generate
         *        host names for the stack's instances. By default, <code>HostnameTheme</code> is set to
         *        <code>Layer_Dependent</code>, which creates host names by appending integers to the layer's short
         *        name. The other themes are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Baked_Goods</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Clouds</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Europe_Cities</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Fruits</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Greek_Deities</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Legendary_creatures_from_Japan</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Planets_and_Moons</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Roman_Deities</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Scottish_Islands</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>US_Cities</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Wild_Cats</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        To obtain a generated host name, call <code>GetHostNameSuggestion</code>, which returns a host name
         *        based on the current theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostnameTheme(String hostnameTheme);

        /**
         * <p>
         * The cloned stack's default Availability Zone, which must be in the specified region. For more information,
         * see <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>. If you also
         * specify a value for <code>DefaultSubnetId</code>, the subnet must be in the same zone. For more information,
         * see the <code>VpcId</code> parameter description.
         * </p>
         * 
         * @param defaultAvailabilityZone
         *        The cloned stack's default Availability Zone, which must be in the specified region. For more
         *        information, see <a href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and
         *        Endpoints</a>. If you also specify a value for <code>DefaultSubnetId</code>, the subnet must be in the
         *        same zone. For more information, see the <code>VpcId</code> parameter description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultAvailabilityZone(String defaultAvailabilityZone);

        /**
         * <p>
         * The stack's default VPC subnet ID. This parameter is required if you specify a value for the
         * <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise when
         * you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>, the subnet
         * must be in that zone. For information on default values and when this parameter is required, see the
         * <code>VpcId</code> parameter description.
         * </p>
         * 
         * @param defaultSubnetId
         *        The stack's default VPC subnet ID. This parameter is required if you specify a value for the
         *        <code>VpcId</code> parameter. All instances are launched into this subnet unless you specify otherwise
         *        when you create the instance. If you also specify a value for <code>DefaultAvailabilityZone</code>,
         *        the subnet must be in that zone. For information on default values and when this parameter is
         *        required, see the <code>VpcId</code> parameter description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSubnetId(String defaultSubnetId);

        /**
         * <p>
         * A string that contains user-defined, custom JSON. It is used to override the corresponding default stack
         * configuration JSON values. The string should be in the following format:
         * </p>
         * <p>
         * <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
         * </p>
         * <p>
         * For more information about custom JSON, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify
         * the Stack Configuration Attributes</a>
         * </p>
         * 
         * @param customJson
         *        A string that contains user-defined, custom JSON. It is used to override the corresponding default
         *        stack configuration JSON values. The string should be in the following format:</p>
         *        <p>
         *        <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
         *        </p>
         *        <p>
         *        For more information about custom JSON, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
         *        Modify the Stack Configuration Attributes</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customJson(String customJson);

        /**
         * <p>
         * The configuration manager. When you clone a stack we recommend that you use the configuration manager to
         * specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value
         * for Linux stacks is currently 12.
         * </p>
         * 
         * @param configurationManager
         *        The configuration manager. When you clone a stack we recommend that you use the configuration manager
         *        to specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The
         *        default value for Linux stacks is currently 12.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationManager(StackConfigurationManager configurationManager);

        /**
         * <p>
         * The configuration manager. When you clone a stack we recommend that you use the configuration manager to
         * specify the Chef version: 12, 11.10, or 11.4 for Linux stacks, or 12.2 for Windows stacks. The default value
         * for Linux stacks is currently 12.
         * </p>
         * This is a convenience that creates an instance of the {@link StackConfigurationManager.Builder} avoiding the
         * need to create one manually via {@link StackConfigurationManager#builder()}.
         *
         * When the {@link Consumer} completes, {@link StackConfigurationManager.Builder#build()} is called immediately
         * and its result is passed to {@link #configurationManager(StackConfigurationManager)}.
         * 
         * @param configurationManager
         *        a consumer that will call methods on {@link StackConfigurationManager.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationManager(StackConfigurationManager)
         */
        default Builder configurationManager(Consumer<StackConfigurationManager.Builder> configurationManager) {
            return configurationManager(StackConfigurationManager.builder().applyMutation(configurationManager).build());
        }

        /**
         * <p>
         * A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version
         * on Chef 11.10 stacks. For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
         * Stack</a>.
         * </p>
         * 
         * @param chefConfiguration
         *        A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf
         *        version on Chef 11.10 stacks. For more information, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
         *        Stack</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chefConfiguration(ChefConfiguration chefConfiguration);

        /**
         * <p>
         * A <code>ChefConfiguration</code> object that specifies whether to enable Berkshelf and the Berkshelf version
         * on Chef 11.10 stacks. For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
         * Stack</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link ChefConfiguration.Builder} avoiding the need to
         * create one manually via {@link ChefConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link ChefConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #chefConfiguration(ChefConfiguration)}.
         * 
         * @param chefConfiguration
         *        a consumer that will call methods on {@link ChefConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #chefConfiguration(ChefConfiguration)
         */
        default Builder chefConfiguration(Consumer<ChefConfiguration.Builder> chefConfiguration) {
            return chefConfiguration(ChefConfiguration.builder().applyMutation(chefConfiguration).build());
        }

        /**
         * <p>
         * Whether to use custom cookbooks.
         * </p>
         * 
         * @param useCustomCookbooks
         *        Whether to use custom cookbooks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useCustomCookbooks(Boolean useCustomCookbooks);

        /**
         * <p>
         * Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.
         * </p>
         * <p>
         * AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are
         * associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide your
         * own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings:
         * </p>
         * <ul>
         * <li>
         * <p>
         * True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each layer
         * (default setting). You can associate additional security groups with a layer after you create it but you
         * cannot delete the built-in security group.
         * </p>
         * </li>
         * <li>
         * <p>
         * False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create
         * appropriate Amazon Elastic Compute Cloud (Amazon EC2) security groups and associate a security group with
         * each layer that you create. However, you can still manually associate a built-in security group with a layer
         * on creation; custom security groups are required only for those layers that need custom settings.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
         * Stack</a>.
         * </p>
         * 
         * @param useOpsworksSecurityGroups
         *        Whether to associate the AWS OpsWorks Stacks built-in security groups with the stack's layers.</p>
         *        <p>
         *        AWS OpsWorks Stacks provides a standard set of built-in security groups, one for each layer, which are
         *        associated with layers by default. With <code>UseOpsworksSecurityGroups</code> you can instead provide
         *        your own custom security groups. <code>UseOpsworksSecurityGroups</code> has the following settings:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        True - AWS OpsWorks Stacks automatically associates the appropriate built-in security group with each
         *        layer (default setting). You can associate additional security groups with a layer after you create it
         *        but you cannot delete the built-in security group.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        False - AWS OpsWorks Stacks does not associate built-in security groups with layers. You must create
         *        appropriate Amazon Elastic Compute Cloud (Amazon EC2) security groups and associate a security group
         *        with each layer that you create. However, you can still manually associate a built-in security group
         *        with a layer on creation; custom security groups are required only for those layers that need custom
         *        settings.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-creating.html">Create a New
         *        Stack</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups);

        /**
         * Sets the value of the CustomCookbooksSource property for this object.
         *
         * @param customCookbooksSource
         *        The new value for the CustomCookbooksSource property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customCookbooksSource(Source customCookbooksSource);

        /**
         * Sets the value of the CustomCookbooksSource property for this object.
         *
         * This is a convenience that creates an instance of the {@link Source.Builder} avoiding the need to create one
         * manually via {@link Source#builder()}.
         *
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #customCookbooksSource(Source)}.
         * 
         * @param customCookbooksSource
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customCookbooksSource(Source)
         */
        default Builder customCookbooksSource(Consumer<Source.Builder> customCookbooksSource) {
            return customCookbooksSource(Source.builder().applyMutation(customCookbooksSource).build());
        }

        /**
         * <p>
         * A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS OpsWorks
         * installs the public key on the instance and you can use the private key with an SSH client to log in to the
         * instance. For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to
         * Communicate with an Instance</a> and <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH
         * Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an
         * instance</a>.
         * </p>
         * 
         * @param defaultSshKeyName
         *        A default Amazon EC2 key pair name. The default value is none. If you specify a key pair name, AWS
         *        OpsWorks installs the public key on the instance and you can use the private key with an SSH client to
         *        log in to the instance. For more information, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-ssh.html"> Using SSH to
         *        Communicate with an Instance</a> and <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/security-ssh-access.html"> Managing SSH
         *        Access</a>. You can override this setting by specifying a different key pair, or no key pair, when you
         *        <a href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-add.html"> create an
         *        instance</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultSshKeyName(String defaultSshKeyName);

        /**
         * <p>
         * Whether to clone the source stack's permissions.
         * </p>
         * 
         * @param clonePermissions
         *        Whether to clone the source stack's permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clonePermissions(Boolean clonePermissions);

        /**
         * <p>
         * A list of source stack app IDs to be included in the cloned stack.
         * </p>
         * 
         * @param cloneAppIds
         *        A list of source stack app IDs to be included in the cloned stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloneAppIds(Collection<String> cloneAppIds);

        /**
         * <p>
         * A list of source stack app IDs to be included in the cloned stack.
         * </p>
         * 
         * @param cloneAppIds
         *        A list of source stack app IDs to be included in the cloned stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloneAppIds(String... cloneAppIds);

        /**
         * <p>
         * The default root device type. This value is used by default for all instances in the cloned stack, but you
         * can override it when you create an instance. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         * >Storage for the Root Device</a>.
         * </p>
         * 
         * @param defaultRootDeviceType
         *        The default root device type. This value is used by default for all instances in the cloned stack, but
         *        you can override it when you create an instance. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         *        >Storage for the Root Device</a>.
         * @see RootDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootDeviceType
         */
        Builder defaultRootDeviceType(String defaultRootDeviceType);

        /**
         * <p>
         * The default root device type. This value is used by default for all instances in the cloned stack, but you
         * can override it when you create an instance. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         * >Storage for the Root Device</a>.
         * </p>
         * 
         * @param defaultRootDeviceType
         *        The default root device type. This value is used by default for all instances in the cloned stack, but
         *        you can override it when you create an instance. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         *        >Storage for the Root Device</a>.
         * @see RootDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootDeviceType
         */
        Builder defaultRootDeviceType(RootDeviceType defaultRootDeviceType);

        /**
         * <p>
         * The default AWS OpsWorks Stacks agent version. You have the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs new agent
         * versions on the stack's instances as soon as they are available.
         * </p>
         * </li>
         * <li>
         * <p>
         * Fixed version - Set this parameter to your preferred agent version. To update the agent version, you must
         * edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically installs that
         * version on the stack's instances.
         * </p>
         * </li>
         * </ul>
         * <p>
         * The default setting is <code>LATEST</code>. To specify an agent version, you must use the complete version
         * number, not the abbreviated number shown on the console. For a list of available agent version numbers, call
         * <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.
         * </p>
         * <note>
         * <p>
         * You can also specify an agent version when you create or update an instance, which overrides the stack's
         * default setting.
         * </p>
         * </note>
         * 
         * @param agentVersion
         *        The default AWS OpsWorks Stacks agent version. You have the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Auto-update - Set this parameter to <code>LATEST</code>. AWS OpsWorks Stacks automatically installs
         *        new agent versions on the stack's instances as soon as they are available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Fixed version - Set this parameter to your preferred agent version. To update the agent version, you
         *        must edit the stack configuration and specify a new version. AWS OpsWorks Stacks then automatically
         *        installs that version on the stack's instances.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        The default setting is <code>LATEST</code>. To specify an agent version, you must use the complete
         *        version number, not the abbreviated number shown on the console. For a list of available agent version
         *        numbers, call <a>DescribeAgentVersions</a>. AgentVersion cannot be set to Chef 12.2.
         *        </p>
         *        <note>
         *        <p>
         *        You can also specify an agent version when you create or update an instance, which overrides the
         *        stack's default setting.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String sourceStackId;

        private String name;

        private String region;

        private String vpcId;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String serviceRoleArn;

        private String defaultInstanceProfileArn;

        private String defaultOs;

        private String hostnameTheme;

        private String defaultAvailabilityZone;

        private String defaultSubnetId;

        private String customJson;

        private StackConfigurationManager configurationManager;

        private ChefConfiguration chefConfiguration;

        private Boolean useCustomCookbooks;

        private Boolean useOpsworksSecurityGroups;

        private Source customCookbooksSource;

        private String defaultSshKeyName;

        private Boolean clonePermissions;

        private List<String> cloneAppIds = DefaultSdkAutoConstructList.getInstance();

        private String defaultRootDeviceType;

        private String agentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(CloneStackRequest model) {
            super(model);
            sourceStackId(model.sourceStackId);
            name(model.name);
            region(model.region);
            vpcId(model.vpcId);
            attributesWithStrings(model.attributes);
            serviceRoleArn(model.serviceRoleArn);
            defaultInstanceProfileArn(model.defaultInstanceProfileArn);
            defaultOs(model.defaultOs);
            hostnameTheme(model.hostnameTheme);
            defaultAvailabilityZone(model.defaultAvailabilityZone);
            defaultSubnetId(model.defaultSubnetId);
            customJson(model.customJson);
            configurationManager(model.configurationManager);
            chefConfiguration(model.chefConfiguration);
            useCustomCookbooks(model.useCustomCookbooks);
            useOpsworksSecurityGroups(model.useOpsworksSecurityGroups);
            customCookbooksSource(model.customCookbooksSource);
            defaultSshKeyName(model.defaultSshKeyName);
            clonePermissions(model.clonePermissions);
            cloneAppIds(model.cloneAppIds);
            defaultRootDeviceType(model.defaultRootDeviceType);
            agentVersion(model.agentVersion);
        }

        public final String getSourceStackId() {
            return sourceStackId;
        }

        @Override
        public final Builder sourceStackId(String sourceStackId) {
            this.sourceStackId = sourceStackId;
            return this;
        }

        public final void setSourceStackId(String sourceStackId) {
            this.sourceStackId = sourceStackId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Map<String, String> getAttributesAsStrings() {
            return attributes;
        }

        @Override
        public final Builder attributesWithStrings(Map<String, String> attributes) {
            this.attributes = StackAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        public final Builder attributes(Map<StackAttributesKeys, String> attributes) {
            this.attributes = StackAttributesCopier.copyEnumToString(attributes);
            return this;
        }

        public final void setAttributesWithStrings(Map<String, String> attributes) {
            this.attributes = StackAttributesCopier.copy(attributes);
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final String getDefaultInstanceProfileArn() {
            return defaultInstanceProfileArn;
        }

        @Override
        public final Builder defaultInstanceProfileArn(String defaultInstanceProfileArn) {
            this.defaultInstanceProfileArn = defaultInstanceProfileArn;
            return this;
        }

        public final void setDefaultInstanceProfileArn(String defaultInstanceProfileArn) {
            this.defaultInstanceProfileArn = defaultInstanceProfileArn;
        }

        public final String getDefaultOs() {
            return defaultOs;
        }

        @Override
        public final Builder defaultOs(String defaultOs) {
            this.defaultOs = defaultOs;
            return this;
        }

        public final void setDefaultOs(String defaultOs) {
            this.defaultOs = defaultOs;
        }

        public final String getHostnameTheme() {
            return hostnameTheme;
        }

        @Override
        public final Builder hostnameTheme(String hostnameTheme) {
            this.hostnameTheme = hostnameTheme;
            return this;
        }

        public final void setHostnameTheme(String hostnameTheme) {
            this.hostnameTheme = hostnameTheme;
        }

        public final String getDefaultAvailabilityZone() {
            return defaultAvailabilityZone;
        }

        @Override
        public final Builder defaultAvailabilityZone(String defaultAvailabilityZone) {
            this.defaultAvailabilityZone = defaultAvailabilityZone;
            return this;
        }

        public final void setDefaultAvailabilityZone(String defaultAvailabilityZone) {
            this.defaultAvailabilityZone = defaultAvailabilityZone;
        }

        public final String getDefaultSubnetId() {
            return defaultSubnetId;
        }

        @Override
        public final Builder defaultSubnetId(String defaultSubnetId) {
            this.defaultSubnetId = defaultSubnetId;
            return this;
        }

        public final void setDefaultSubnetId(String defaultSubnetId) {
            this.defaultSubnetId = defaultSubnetId;
        }

        public final String getCustomJson() {
            return customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        public final StackConfigurationManager.Builder getConfigurationManager() {
            return configurationManager != null ? configurationManager.toBuilder() : null;
        }

        @Override
        public final Builder configurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        public final void setConfigurationManager(StackConfigurationManager.BuilderImpl configurationManager) {
            this.configurationManager = configurationManager != null ? configurationManager.build() : null;
        }

        public final ChefConfiguration.Builder getChefConfiguration() {
            return chefConfiguration != null ? chefConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder chefConfiguration(ChefConfiguration chefConfiguration) {
            this.chefConfiguration = chefConfiguration;
            return this;
        }

        public final void setChefConfiguration(ChefConfiguration.BuilderImpl chefConfiguration) {
            this.chefConfiguration = chefConfiguration != null ? chefConfiguration.build() : null;
        }

        public final Boolean getUseCustomCookbooks() {
            return useCustomCookbooks;
        }

        @Override
        public final Builder useCustomCookbooks(Boolean useCustomCookbooks) {
            this.useCustomCookbooks = useCustomCookbooks;
            return this;
        }

        public final void setUseCustomCookbooks(Boolean useCustomCookbooks) {
            this.useCustomCookbooks = useCustomCookbooks;
        }

        public final Boolean getUseOpsworksSecurityGroups() {
            return useOpsworksSecurityGroups;
        }

        @Override
        public final Builder useOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups) {
            this.useOpsworksSecurityGroups = useOpsworksSecurityGroups;
            return this;
        }

        public final void setUseOpsworksSecurityGroups(Boolean useOpsworksSecurityGroups) {
            this.useOpsworksSecurityGroups = useOpsworksSecurityGroups;
        }

        public final Source.Builder getCustomCookbooksSource() {
            return customCookbooksSource != null ? customCookbooksSource.toBuilder() : null;
        }

        @Override
        public final Builder customCookbooksSource(Source customCookbooksSource) {
            this.customCookbooksSource = customCookbooksSource;
            return this;
        }

        public final void setCustomCookbooksSource(Source.BuilderImpl customCookbooksSource) {
            this.customCookbooksSource = customCookbooksSource != null ? customCookbooksSource.build() : null;
        }

        public final String getDefaultSshKeyName() {
            return defaultSshKeyName;
        }

        @Override
        public final Builder defaultSshKeyName(String defaultSshKeyName) {
            this.defaultSshKeyName = defaultSshKeyName;
            return this;
        }

        public final void setDefaultSshKeyName(String defaultSshKeyName) {
            this.defaultSshKeyName = defaultSshKeyName;
        }

        public final Boolean getClonePermissions() {
            return clonePermissions;
        }

        @Override
        public final Builder clonePermissions(Boolean clonePermissions) {
            this.clonePermissions = clonePermissions;
            return this;
        }

        public final void setClonePermissions(Boolean clonePermissions) {
            this.clonePermissions = clonePermissions;
        }

        public final Collection<String> getCloneAppIds() {
            return cloneAppIds;
        }

        @Override
        public final Builder cloneAppIds(Collection<String> cloneAppIds) {
            this.cloneAppIds = StringsCopier.copy(cloneAppIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cloneAppIds(String... cloneAppIds) {
            cloneAppIds(Arrays.asList(cloneAppIds));
            return this;
        }

        public final void setCloneAppIds(Collection<String> cloneAppIds) {
            this.cloneAppIds = StringsCopier.copy(cloneAppIds);
        }

        public final String getDefaultRootDeviceTypeAsString() {
            return defaultRootDeviceType;
        }

        @Override
        public final Builder defaultRootDeviceType(String defaultRootDeviceType) {
            this.defaultRootDeviceType = defaultRootDeviceType;
            return this;
        }

        @Override
        public final Builder defaultRootDeviceType(RootDeviceType defaultRootDeviceType) {
            this.defaultRootDeviceType(defaultRootDeviceType.toString());
            return this;
        }

        public final void setDefaultRootDeviceType(String defaultRootDeviceType) {
            this.defaultRootDeviceType = defaultRootDeviceType;
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CloneStackRequest build() {
            return new CloneStackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
