/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A description of the app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class App implements SdkPojo, Serializable, ToCopyableBuilder<App.Builder, App> {
    private static final SdkField<String> APP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(App::appId)).setter(setter(Builder::appId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppId").build()).build();

    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(App::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> SHORTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(App::shortname)).setter(setter(Builder::shortname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Shortname").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(App::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(App::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<DataSource>> DATA_SOURCES_FIELD = SdkField
            .<List<DataSource>> builder(MarshallingType.LIST)
            .getter(getter(App::dataSources))
            .setter(setter(Builder::dataSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(App::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Source> APP_SOURCE_FIELD = SdkField.<Source> builder(MarshallingType.SDK_POJO)
            .getter(getter(App::appSource)).setter(setter(Builder::appSource)).constructor(Source::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppSource").build()).build();

    private static final SdkField<List<String>> DOMAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(App::domains))
            .setter(setter(Builder::domains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_SSL_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(App::enableSsl)).setter(setter(Builder::enableSsl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableSsl").build()).build();

    private static final SdkField<SslConfiguration> SSL_CONFIGURATION_FIELD = SdkField
            .<SslConfiguration> builder(MarshallingType.SDK_POJO).getter(getter(App::sslConfiguration))
            .setter(setter(Builder::sslConfiguration)).constructor(SslConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslConfiguration").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(App::attributesAsStrings))
            .setter(setter(Builder::attributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CREATED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(App::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<List<EnvironmentVariable>> ENVIRONMENT_FIELD = SdkField
            .<List<EnvironmentVariable>> builder(MarshallingType.LIST)
            .getter(getter(App::environment))
            .setter(setter(Builder::environment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentVariable> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentVariable::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_ID_FIELD, STACK_ID_FIELD,
            SHORTNAME_FIELD, NAME_FIELD, DESCRIPTION_FIELD, DATA_SOURCES_FIELD, TYPE_FIELD, APP_SOURCE_FIELD, DOMAINS_FIELD,
            ENABLE_SSL_FIELD, SSL_CONFIGURATION_FIELD, ATTRIBUTES_FIELD, CREATED_AT_FIELD, ENVIRONMENT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String appId;

    private final String stackId;

    private final String shortname;

    private final String name;

    private final String description;

    private final List<DataSource> dataSources;

    private final String type;

    private final Source appSource;

    private final List<String> domains;

    private final Boolean enableSsl;

    private final SslConfiguration sslConfiguration;

    private final Map<String, String> attributes;

    private final String createdAt;

    private final List<EnvironmentVariable> environment;

    private App(BuilderImpl builder) {
        this.appId = builder.appId;
        this.stackId = builder.stackId;
        this.shortname = builder.shortname;
        this.name = builder.name;
        this.description = builder.description;
        this.dataSources = builder.dataSources;
        this.type = builder.type;
        this.appSource = builder.appSource;
        this.domains = builder.domains;
        this.enableSsl = builder.enableSsl;
        this.sslConfiguration = builder.sslConfiguration;
        this.attributes = builder.attributes;
        this.createdAt = builder.createdAt;
        this.environment = builder.environment;
    }

    /**
     * <p>
     * The app ID.
     * </p>
     * 
     * @return The app ID.
     */
    public String appId() {
        return appId;
    }

    /**
     * <p>
     * The app stack ID.
     * </p>
     * 
     * @return The app stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The app's short name.
     * </p>
     * 
     * @return The app's short name.
     */
    public String shortname() {
        return shortname;
    }

    /**
     * <p>
     * The app name.
     * </p>
     * 
     * @return The app name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the app.
     * </p>
     * 
     * @return A description of the app.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The app's data sources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The app's data sources.
     */
    public List<DataSource> dataSources() {
        return dataSources;
    }

    /**
     * <p>
     * The app type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The app type.
     * @see AppType
     */
    public AppType type() {
        return AppType.fromValue(type);
    }

    /**
     * <p>
     * The app type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The app type.
     * @see AppType
     */
    public String typeAsString() {
        return type;
    }

    /**
     * <p>
     * A <code>Source</code> object that describes the app repository.
     * </p>
     * 
     * @return A <code>Source</code> object that describes the app repository.
     */
    public Source appSource() {
        return appSource;
    }

    /**
     * <p>
     * The app vhost settings with multiple domains separated by commas. For example:
     * <code>'www.example.com, example.com'</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The app vhost settings with multiple domains separated by commas. For example:
     *         <code>'www.example.com, example.com'</code>
     */
    public List<String> domains() {
        return domains;
    }

    /**
     * <p>
     * Whether to enable SSL for the app.
     * </p>
     * 
     * @return Whether to enable SSL for the app.
     */
    public Boolean enableSsl() {
        return enableSsl;
    }

    /**
     * <p>
     * An <code>SslConfiguration</code> object with the SSL configuration.
     * </p>
     * 
     * @return An <code>SslConfiguration</code> object with the SSL configuration.
     */
    public SslConfiguration sslConfiguration() {
        return sslConfiguration;
    }

    /**
     * <p>
     * The stack attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The stack attributes.
     */
    public Map<AppAttributesKeys, String> attributes() {
        return AppAttributesCopier.copyStringToEnum(attributes);
    }

    /**
     * <p>
     * The stack attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The stack attributes.
     */
    public Map<String, String> attributesAsStrings() {
        return attributes;
    }

    /**
     * <p>
     * When the app was created.
     * </p>
     * 
     * @return When the app was created.
     */
    public String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with the
     * app. After you deploy the app, these variables are defined on the associated app server instances. For more
     * information, see <a href=
     * "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
     * > Environment Variables</a>.
     * </p>
     * <note>
     * <p>
     * There is no specific limit on the number of environment variables. However, the size of the associated data
     * structure - which includes the variable names, values, and protected flag values - cannot exceed 10 KB (10240
     * Bytes). This limit should accommodate most if not all use cases, but if you do exceed it, you will cause an
     * exception (API) with an "Environment: is too large (maximum is 10KB)" message.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated
     *         with the app. After you deploy the app, these variables are defined on the associated app server
     *         instances. For more information, see <a href=
     *         "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
     *         > Environment Variables</a>. </p> <note>
     *         <p>
     *         There is no specific limit on the number of environment variables. However, the size of the associated
     *         data structure - which includes the variable names, values, and protected flag values - cannot exceed 10
     *         KB (10240 Bytes). This limit should accommodate most if not all use cases, but if you do exceed it, you
     *         will cause an exception (API) with an "Environment: is too large (maximum is 10KB)" message.
     *         </p>
     */
    public List<EnvironmentVariable> environment() {
        return environment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(appId());
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(shortname());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dataSources());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(appSource());
        hashCode = 31 * hashCode + Objects.hashCode(domains());
        hashCode = 31 * hashCode + Objects.hashCode(enableSsl());
        hashCode = 31 * hashCode + Objects.hashCode(sslConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(attributesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(environment());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof App)) {
            return false;
        }
        App other = (App) obj;
        return Objects.equals(appId(), other.appId()) && Objects.equals(stackId(), other.stackId())
                && Objects.equals(shortname(), other.shortname()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(dataSources(), other.dataSources())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(appSource(), other.appSource())
                && Objects.equals(domains(), other.domains()) && Objects.equals(enableSsl(), other.enableSsl())
                && Objects.equals(sslConfiguration(), other.sslConfiguration())
                && Objects.equals(attributesAsStrings(), other.attributesAsStrings())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(environment(), other.environment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("App").add("AppId", appId()).add("StackId", stackId()).add("Shortname", shortname())
                .add("Name", name()).add("Description", description()).add("DataSources", dataSources())
                .add("Type", typeAsString()).add("AppSource", appSource()).add("Domains", domains())
                .add("EnableSsl", enableSsl()).add("SslConfiguration", sslConfiguration())
                .add("Attributes", attributesAsStrings()).add("CreatedAt", createdAt()).add("Environment", environment()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppId":
            return Optional.ofNullable(clazz.cast(appId()));
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "Shortname":
            return Optional.ofNullable(clazz.cast(shortname()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "AppSource":
            return Optional.ofNullable(clazz.cast(appSource()));
        case "Domains":
            return Optional.ofNullable(clazz.cast(domains()));
        case "EnableSsl":
            return Optional.ofNullable(clazz.cast(enableSsl()));
        case "SslConfiguration":
            return Optional.ofNullable(clazz.cast(sslConfiguration()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributesAsStrings()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "Environment":
            return Optional.ofNullable(clazz.cast(environment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<App, T> g) {
        return obj -> g.apply((App) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, App> {
        /**
         * <p>
         * The app ID.
         * </p>
         * 
         * @param appId
         *        The app ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The app stack ID.
         * </p>
         * 
         * @param stackId
         *        The app stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The app's short name.
         * </p>
         * 
         * @param shortname
         *        The app's short name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortname(String shortname);

        /**
         * <p>
         * The app name.
         * </p>
         * 
         * @param name
         *        The app name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the app.
         * </p>
         * 
         * @param description
         *        A description of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The app's data sources.
         * </p>
         * 
         * @param dataSources
         *        The app's data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(Collection<DataSource> dataSources);

        /**
         * <p>
         * The app's data sources.
         * </p>
         * 
         * @param dataSources
         *        The app's data sources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(DataSource... dataSources);

        /**
         * <p>
         * The app's data sources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataSource>.Builder} avoiding the need to
         * create one manually via {@link List<DataSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataSource>.Builder#build()} is called immediately and its
         * result is passed to {@link #dataSources(List<DataSource>)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on {@link List<DataSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(List<DataSource>)
         */
        Builder dataSources(Consumer<DataSource.Builder>... dataSources);

        /**
         * <p>
         * The app type.
         * </p>
         * 
         * @param type
         *        The app type.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder type(String type);

        /**
         * <p>
         * The app type.
         * </p>
         * 
         * @param type
         *        The app type.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder type(AppType type);

        /**
         * <p>
         * A <code>Source</code> object that describes the app repository.
         * </p>
         * 
         * @param appSource
         *        A <code>Source</code> object that describes the app repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appSource(Source appSource);

        /**
         * <p>
         * A <code>Source</code> object that describes the app repository.
         * </p>
         * This is a convenience that creates an instance of the {@link Source.Builder} avoiding the need to create one
         * manually via {@link Source#builder()}.
         *
         * When the {@link Consumer} completes, {@link Source.Builder#build()} is called immediately and its result is
         * passed to {@link #appSource(Source)}.
         * 
         * @param appSource
         *        a consumer that will call methods on {@link Source.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appSource(Source)
         */
        default Builder appSource(Consumer<Source.Builder> appSource) {
            return appSource(Source.builder().applyMutation(appSource).build());
        }

        /**
         * <p>
         * The app vhost settings with multiple domains separated by commas. For example:
         * <code>'www.example.com, example.com'</code>
         * </p>
         * 
         * @param domains
         *        The app vhost settings with multiple domains separated by commas. For example:
         *        <code>'www.example.com, example.com'</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(Collection<String> domains);

        /**
         * <p>
         * The app vhost settings with multiple domains separated by commas. For example:
         * <code>'www.example.com, example.com'</code>
         * </p>
         * 
         * @param domains
         *        The app vhost settings with multiple domains separated by commas. For example:
         *        <code>'www.example.com, example.com'</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(String... domains);

        /**
         * <p>
         * Whether to enable SSL for the app.
         * </p>
         * 
         * @param enableSsl
         *        Whether to enable SSL for the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableSsl(Boolean enableSsl);

        /**
         * <p>
         * An <code>SslConfiguration</code> object with the SSL configuration.
         * </p>
         * 
         * @param sslConfiguration
         *        An <code>SslConfiguration</code> object with the SSL configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslConfiguration(SslConfiguration sslConfiguration);

        /**
         * <p>
         * An <code>SslConfiguration</code> object with the SSL configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link SslConfiguration.Builder} avoiding the need to
         * create one manually via {@link SslConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link SslConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #sslConfiguration(SslConfiguration)}.
         * 
         * @param sslConfiguration
         *        a consumer that will call methods on {@link SslConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sslConfiguration(SslConfiguration)
         */
        default Builder sslConfiguration(Consumer<SslConfiguration.Builder> sslConfiguration) {
            return sslConfiguration(SslConfiguration.builder().applyMutation(sslConfiguration).build());
        }

        /**
         * <p>
         * The stack attributes.
         * </p>
         * 
         * @param attributes
         *        The stack attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesWithStrings(Map<String, String> attributes);

        /**
         * <p>
         * The stack attributes.
         * </p>
         * 
         * @param attributes
         *        The stack attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<AppAttributesKeys, String> attributes);

        /**
         * <p>
         * When the app was created.
         * </p>
         * 
         * @param createdAt
         *        When the app was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with
         * the app. After you deploy the app, these variables are defined on the associated app server instances. For
         * more information, see <a href=
         * "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
         * > Environment Variables</a>.
         * </p>
         * <note>
         * <p>
         * There is no specific limit on the number of environment variables. However, the size of the associated data
         * structure - which includes the variable names, values, and protected flag values - cannot exceed 10 KB (10240
         * Bytes). This limit should accommodate most if not all use cases, but if you do exceed it, you will cause an
         * exception (API) with an "Environment: is too large (maximum is 10KB)" message.
         * </p>
         * </note>
         * 
         * @param environment
         *        An array of <code>EnvironmentVariable</code> objects that specify environment variables to be
         *        associated with the app. After you deploy the app, these variables are defined on the associated app
         *        server instances. For more information, see <a href=
         *        "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
         *        > Environment Variables</a>. </p> <note>
         *        <p>
         *        There is no specific limit on the number of environment variables. However, the size of the associated
         *        data structure - which includes the variable names, values, and protected flag values - cannot exceed
         *        10 KB (10240 Bytes). This limit should accommodate most if not all use cases, but if you do exceed it,
         *        you will cause an exception (API) with an "Environment: is too large (maximum is 10KB)" message.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Collection<EnvironmentVariable> environment);

        /**
         * <p>
         * An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with
         * the app. After you deploy the app, these variables are defined on the associated app server instances. For
         * more information, see <a href=
         * "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
         * > Environment Variables</a>.
         * </p>
         * <note>
         * <p>
         * There is no specific limit on the number of environment variables. However, the size of the associated data
         * structure - which includes the variable names, values, and protected flag values - cannot exceed 10 KB (10240
         * Bytes). This limit should accommodate most if not all use cases, but if you do exceed it, you will cause an
         * exception (API) with an "Environment: is too large (maximum is 10KB)" message.
         * </p>
         * </note>
         * 
         * @param environment
         *        An array of <code>EnvironmentVariable</code> objects that specify environment variables to be
         *        associated with the app. After you deploy the app, these variables are defined on the associated app
         *        server instances. For more information, see <a href=
         *        "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
         *        > Environment Variables</a>. </p> <note>
         *        <p>
         *        There is no specific limit on the number of environment variables. However, the size of the associated
         *        data structure - which includes the variable names, values, and protected flag values - cannot exceed
         *        10 KB (10240 Bytes). This limit should accommodate most if not all use cases, but if you do exceed it,
         *        you will cause an exception (API) with an "Environment: is too large (maximum is 10KB)" message.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(EnvironmentVariable... environment);

        /**
         * <p>
         * An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with
         * the app. After you deploy the app, these variables are defined on the associated app server instances. For
         * more information, see <a href=
         * "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
         * > Environment Variables</a>.
         * </p>
         * <note>
         * <p>
         * There is no specific limit on the number of environment variables. However, the size of the associated data
         * structure - which includes the variable names, values, and protected flag values - cannot exceed 10 KB (10240
         * Bytes). This limit should accommodate most if not all use cases, but if you do exceed it, you will cause an
         * exception (API) with an "Environment: is too large (maximum is 10KB)" message.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<EnvironmentVariable>.Builder}
         * avoiding the need to create one manually via {@link List<EnvironmentVariable>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EnvironmentVariable>.Builder#build()} is called immediately
         * and its result is passed to {@link #environment(List<EnvironmentVariable>)}.
         * 
         * @param environment
         *        a consumer that will call methods on {@link List<EnvironmentVariable>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #environment(List<EnvironmentVariable>)
         */
        Builder environment(Consumer<EnvironmentVariable.Builder>... environment);
    }

    static final class BuilderImpl implements Builder {
        private String appId;

        private String stackId;

        private String shortname;

        private String name;

        private String description;

        private List<DataSource> dataSources = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private Source appSource;

        private List<String> domains = DefaultSdkAutoConstructList.getInstance();

        private Boolean enableSsl;

        private SslConfiguration sslConfiguration;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private String createdAt;

        private List<EnvironmentVariable> environment = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(App model) {
            appId(model.appId);
            stackId(model.stackId);
            shortname(model.shortname);
            name(model.name);
            description(model.description);
            dataSources(model.dataSources);
            type(model.type);
            appSource(model.appSource);
            domains(model.domains);
            enableSsl(model.enableSsl);
            sslConfiguration(model.sslConfiguration);
            attributesWithStrings(model.attributes);
            createdAt(model.createdAt);
            environment(model.environment);
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getShortname() {
            return shortname;
        }

        @Override
        public final Builder shortname(String shortname) {
            this.shortname = shortname;
            return this;
        }

        public final void setShortname(String shortname) {
            this.shortname = shortname;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<DataSource.Builder> getDataSources() {
            return dataSources != null ? dataSources.stream().map(DataSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSource... dataSources) {
            dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(Consumer<DataSource.Builder>... dataSources) {
            dataSources(Stream.of(dataSources).map(c -> DataSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDataSources(Collection<DataSource.BuilderImpl> dataSources) {
            this.dataSources = DataSourcesCopier.copyFromBuilder(dataSources);
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AppType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Source.Builder getAppSource() {
            return appSource != null ? appSource.toBuilder() : null;
        }

        @Override
        public final Builder appSource(Source appSource) {
            this.appSource = appSource;
            return this;
        }

        public final void setAppSource(Source.BuilderImpl appSource) {
            this.appSource = appSource != null ? appSource.build() : null;
        }

        public final Collection<String> getDomains() {
            return domains;
        }

        @Override
        public final Builder domains(Collection<String> domains) {
            this.domains = StringsCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(String... domains) {
            domains(Arrays.asList(domains));
            return this;
        }

        public final void setDomains(Collection<String> domains) {
            this.domains = StringsCopier.copy(domains);
        }

        public final Boolean getEnableSsl() {
            return enableSsl;
        }

        @Override
        public final Builder enableSsl(Boolean enableSsl) {
            this.enableSsl = enableSsl;
            return this;
        }

        public final void setEnableSsl(Boolean enableSsl) {
            this.enableSsl = enableSsl;
        }

        public final SslConfiguration.Builder getSslConfiguration() {
            return sslConfiguration != null ? sslConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder sslConfiguration(SslConfiguration sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            return this;
        }

        public final void setSslConfiguration(SslConfiguration.BuilderImpl sslConfiguration) {
            this.sslConfiguration = sslConfiguration != null ? sslConfiguration.build() : null;
        }

        public final Map<String, String> getAttributesAsStrings() {
            return attributes;
        }

        @Override
        public final Builder attributesWithStrings(Map<String, String> attributes) {
            this.attributes = AppAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        public final Builder attributes(Map<AppAttributesKeys, String> attributes) {
            this.attributes = AppAttributesCopier.copyEnumToString(attributes);
            return this;
        }

        public final void setAttributesWithStrings(Map<String, String> attributes) {
            this.attributes = AppAttributesCopier.copy(attributes);
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final Collection<EnvironmentVariable.Builder> getEnvironment() {
            return environment != null ? environment.stream().map(EnvironmentVariable::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder environment(Collection<EnvironmentVariable> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(EnvironmentVariable... environment) {
            environment(Arrays.asList(environment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(Consumer<EnvironmentVariable.Builder>... environment) {
            environment(Stream.of(environment).map(c -> EnvironmentVariable.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setEnvironment(Collection<EnvironmentVariable.BuilderImpl> environment) {
            this.environment = EnvironmentVariablesCopier.copyFromBuilder(environment);
        }

        @Override
        public App build() {
            return new App(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
