/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes supported operating systems in AWS OpsWorks Stacks.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OperatingSystem implements SdkPojo, Serializable, ToCopyableBuilder<OperatingSystem.Builder, OperatingSystem> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OperatingSystem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OperatingSystem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OperatingSystem::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<List<OperatingSystemConfigurationManager>> CONFIGURATION_MANAGERS_FIELD = SdkField
            .<List<OperatingSystemConfigurationManager>> builder(MarshallingType.LIST)
            .getter(getter(OperatingSystem::configurationManagers))
            .setter(setter(Builder::configurationManagers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationManagers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OperatingSystemConfigurationManager> builder(MarshallingType.SDK_POJO)
                                            .constructor(OperatingSystemConfigurationManager::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REPORTED_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OperatingSystem::reportedName)).setter(setter(Builder::reportedName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportedName").build()).build();

    private static final SdkField<String> REPORTED_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(OperatingSystem::reportedVersion)).setter(setter(Builder::reportedVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportedVersion").build()).build();

    private static final SdkField<Boolean> SUPPORTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(OperatingSystem::supported)).setter(setter(Builder::supported))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Supported").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ID_FIELD,
            TYPE_FIELD, CONFIGURATION_MANAGERS_FIELD, REPORTED_NAME_FIELD, REPORTED_VERSION_FIELD, SUPPORTED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String id;

    private final String type;

    private final List<OperatingSystemConfigurationManager> configurationManagers;

    private final String reportedName;

    private final String reportedVersion;

    private final Boolean supported;

    private OperatingSystem(BuilderImpl builder) {
        this.name = builder.name;
        this.id = builder.id;
        this.type = builder.type;
        this.configurationManagers = builder.configurationManagers;
        this.reportedName = builder.reportedName;
        this.reportedVersion = builder.reportedVersion;
        this.supported = builder.supported;
    }

    /**
     * <p>
     * The name of the operating system, such as <code>Amazon Linux 2017.09</code>.
     * </p>
     * 
     * @return The name of the operating system, such as <code>Amazon Linux 2017.09</code>.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The ID of a supported operating system, such as <code>Amazon Linux 2017.09</code>.
     * </p>
     * 
     * @return The ID of a supported operating system, such as <code>Amazon Linux 2017.09</code>.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The type of a supported operating system, either <code>Linux</code> or <code>Windows</code>.
     * </p>
     * 
     * @return The type of a supported operating system, either <code>Linux</code> or <code>Windows</code>.
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * Supported configuration manager name and versions for an AWS OpsWorks Stacks operating system.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Supported configuration manager name and versions for an AWS OpsWorks Stacks operating system.
     */
    public List<OperatingSystemConfigurationManager> configurationManagers() {
        return configurationManagers;
    }

    /**
     * <p>
     * A short name for the operating system manufacturer.
     * </p>
     * 
     * @return A short name for the operating system manufacturer.
     */
    public String reportedName() {
        return reportedName;
    }

    /**
     * <p>
     * The version of the operating system, including the release and edition, if applicable.
     * </p>
     * 
     * @return The version of the operating system, including the release and edition, if applicable.
     */
    public String reportedVersion() {
        return reportedVersion;
    }

    /**
     * <p>
     * Indicates that an operating system is not supported for new instances.
     * </p>
     * 
     * @return Indicates that an operating system is not supported for new instances.
     */
    public Boolean supported() {
        return supported;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(configurationManagers());
        hashCode = 31 * hashCode + Objects.hashCode(reportedName());
        hashCode = 31 * hashCode + Objects.hashCode(reportedVersion());
        hashCode = 31 * hashCode + Objects.hashCode(supported());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperatingSystem)) {
            return false;
        }
        OperatingSystem other = (OperatingSystem) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(id(), other.id()) && Objects.equals(type(), other.type())
                && Objects.equals(configurationManagers(), other.configurationManagers())
                && Objects.equals(reportedName(), other.reportedName())
                && Objects.equals(reportedVersion(), other.reportedVersion()) && Objects.equals(supported(), other.supported());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OperatingSystem").add("Name", name()).add("Id", id()).add("Type", type())
                .add("ConfigurationManagers", configurationManagers()).add("ReportedName", reportedName())
                .add("ReportedVersion", reportedVersion()).add("Supported", supported()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "ConfigurationManagers":
            return Optional.ofNullable(clazz.cast(configurationManagers()));
        case "ReportedName":
            return Optional.ofNullable(clazz.cast(reportedName()));
        case "ReportedVersion":
            return Optional.ofNullable(clazz.cast(reportedVersion()));
        case "Supported":
            return Optional.ofNullable(clazz.cast(supported()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OperatingSystem, T> g) {
        return obj -> g.apply((OperatingSystem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OperatingSystem> {
        /**
         * <p>
         * The name of the operating system, such as <code>Amazon Linux 2017.09</code>.
         * </p>
         * 
         * @param name
         *        The name of the operating system, such as <code>Amazon Linux 2017.09</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of a supported operating system, such as <code>Amazon Linux 2017.09</code>.
         * </p>
         * 
         * @param id
         *        The ID of a supported operating system, such as <code>Amazon Linux 2017.09</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of a supported operating system, either <code>Linux</code> or <code>Windows</code>.
         * </p>
         * 
         * @param type
         *        The type of a supported operating system, either <code>Linux</code> or <code>Windows</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * Supported configuration manager name and versions for an AWS OpsWorks Stacks operating system.
         * </p>
         * 
         * @param configurationManagers
         *        Supported configuration manager name and versions for an AWS OpsWorks Stacks operating system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationManagers(Collection<OperatingSystemConfigurationManager> configurationManagers);

        /**
         * <p>
         * Supported configuration manager name and versions for an AWS OpsWorks Stacks operating system.
         * </p>
         * 
         * @param configurationManagers
         *        Supported configuration manager name and versions for an AWS OpsWorks Stacks operating system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationManagers(OperatingSystemConfigurationManager... configurationManagers);

        /**
         * <p>
         * Supported configuration manager name and versions for an AWS OpsWorks Stacks operating system.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <OperatingSystemConfigurationManager>.Builder} avoiding the need to create one manually via {@link List
         * <OperatingSystemConfigurationManager>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OperatingSystemConfigurationManager>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #configurationManagers(List<OperatingSystemConfigurationManager>)}.
         * 
         * @param configurationManagers
         *        a consumer that will call methods on {@link List<OperatingSystemConfigurationManager>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationManagers(List<OperatingSystemConfigurationManager>)
         */
        Builder configurationManagers(Consumer<OperatingSystemConfigurationManager.Builder>... configurationManagers);

        /**
         * <p>
         * A short name for the operating system manufacturer.
         * </p>
         * 
         * @param reportedName
         *        A short name for the operating system manufacturer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportedName(String reportedName);

        /**
         * <p>
         * The version of the operating system, including the release and edition, if applicable.
         * </p>
         * 
         * @param reportedVersion
         *        The version of the operating system, including the release and edition, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportedVersion(String reportedVersion);

        /**
         * <p>
         * Indicates that an operating system is not supported for new instances.
         * </p>
         * 
         * @param supported
         *        Indicates that an operating system is not supported for new instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supported(Boolean supported);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String id;

        private String type;

        private List<OperatingSystemConfigurationManager> configurationManagers = DefaultSdkAutoConstructList.getInstance();

        private String reportedName;

        private String reportedVersion;

        private Boolean supported;

        private BuilderImpl() {
        }

        private BuilderImpl(OperatingSystem model) {
            name(model.name);
            id(model.id);
            type(model.type);
            configurationManagers(model.configurationManagers);
            reportedName(model.reportedName);
            reportedVersion(model.reportedVersion);
            supported(model.supported);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Collection<OperatingSystemConfigurationManager.Builder> getConfigurationManagers() {
            return configurationManagers != null ? configurationManagers.stream()
                    .map(OperatingSystemConfigurationManager::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder configurationManagers(Collection<OperatingSystemConfigurationManager> configurationManagers) {
            this.configurationManagers = OperatingSystemConfigurationManagersCopier.copy(configurationManagers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationManagers(OperatingSystemConfigurationManager... configurationManagers) {
            configurationManagers(Arrays.asList(configurationManagers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationManagers(Consumer<OperatingSystemConfigurationManager.Builder>... configurationManagers) {
            configurationManagers(Stream.of(configurationManagers)
                    .map(c -> OperatingSystemConfigurationManager.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setConfigurationManagers(
                Collection<OperatingSystemConfigurationManager.BuilderImpl> configurationManagers) {
            this.configurationManagers = OperatingSystemConfigurationManagersCopier.copyFromBuilder(configurationManagers);
        }

        public final String getReportedName() {
            return reportedName;
        }

        @Override
        public final Builder reportedName(String reportedName) {
            this.reportedName = reportedName;
            return this;
        }

        public final void setReportedName(String reportedName) {
            this.reportedName = reportedName;
        }

        public final String getReportedVersion() {
            return reportedVersion;
        }

        @Override
        public final Builder reportedVersion(String reportedVersion) {
            this.reportedVersion = reportedVersion;
            return this;
        }

        public final void setReportedVersion(String reportedVersion) {
            this.reportedVersion = reportedVersion;
        }

        public final Boolean getSupported() {
            return supported;
        }

        @Override
        public final Builder supported(Boolean supported) {
            this.supported = supported;
            return this;
        }

        public final void setSupported(Boolean supported) {
            this.supported = supported;
        }

        @Override
        public OperatingSystem build() {
            return new OperatingSystem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
