/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeLoadBasedAutoScaling</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeLoadBasedAutoScalingResponse extends OpsWorksResponse implements
        ToCopyableBuilder<DescribeLoadBasedAutoScalingResponse.Builder, DescribeLoadBasedAutoScalingResponse> {
    private static final SdkField<List<LoadBasedAutoScalingConfiguration>> LOAD_BASED_AUTO_SCALING_CONFIGURATIONS_FIELD = SdkField
            .<List<LoadBasedAutoScalingConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(DescribeLoadBasedAutoScalingResponse::loadBasedAutoScalingConfigurations))
            .setter(setter(Builder::loadBasedAutoScalingConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBasedAutoScalingConfigurations")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<LoadBasedAutoScalingConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(LoadBasedAutoScalingConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(LOAD_BASED_AUTO_SCALING_CONFIGURATIONS_FIELD));

    private final List<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations;

    private DescribeLoadBasedAutoScalingResponse(BuilderImpl builder) {
        super(builder);
        this.loadBasedAutoScalingConfigurations = builder.loadBasedAutoScalingConfigurations;
    }

    /**
     * <p>
     * An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer's configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer's
     *         configuration.
     */
    public List<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations() {
        return loadBasedAutoScalingConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(loadBasedAutoScalingConfigurations());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoadBasedAutoScalingResponse)) {
            return false;
        }
        DescribeLoadBasedAutoScalingResponse other = (DescribeLoadBasedAutoScalingResponse) obj;
        return Objects.equals(loadBasedAutoScalingConfigurations(), other.loadBasedAutoScalingConfigurations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeLoadBasedAutoScalingResponse")
                .add("LoadBasedAutoScalingConfigurations", loadBasedAutoScalingConfigurations()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoadBasedAutoScalingConfigurations":
            return Optional.ofNullable(clazz.cast(loadBasedAutoScalingConfigurations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoadBasedAutoScalingResponse, T> g) {
        return obj -> g.apply((DescribeLoadBasedAutoScalingResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeLoadBasedAutoScalingResponse> {
        /**
         * <p>
         * An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer's configuration.
         * </p>
         * 
         * @param loadBasedAutoScalingConfigurations
         *        An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer's
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBasedAutoScalingConfigurations(
                Collection<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations);

        /**
         * <p>
         * An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer's configuration.
         * </p>
         * 
         * @param loadBasedAutoScalingConfigurations
         *        An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer's
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBasedAutoScalingConfigurations(LoadBasedAutoScalingConfiguration... loadBasedAutoScalingConfigurations);

        /**
         * <p>
         * An array of <code>LoadBasedAutoScalingConfiguration</code> objects that describe each layer's configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link List<LoadBasedAutoScalingConfiguration>.Builder}
         * avoiding the need to create one manually via {@link List<LoadBasedAutoScalingConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<LoadBasedAutoScalingConfiguration>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #loadBasedAutoScalingConfigurations(List<LoadBasedAutoScalingConfiguration>)}.
         * 
         * @param loadBasedAutoScalingConfigurations
         *        a consumer that will call methods on {@link List<LoadBasedAutoScalingConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBasedAutoScalingConfigurations(List<LoadBasedAutoScalingConfiguration>)
         */
        Builder loadBasedAutoScalingConfigurations(
                Consumer<LoadBasedAutoScalingConfiguration.Builder>... loadBasedAutoScalingConfigurations);
    }

    static final class BuilderImpl extends OpsWorksResponse.BuilderImpl implements Builder {
        private List<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoadBasedAutoScalingResponse model) {
            super(model);
            loadBasedAutoScalingConfigurations(model.loadBasedAutoScalingConfigurations);
        }

        public final Collection<LoadBasedAutoScalingConfiguration.Builder> getLoadBasedAutoScalingConfigurations() {
            return loadBasedAutoScalingConfigurations != null ? loadBasedAutoScalingConfigurations.stream()
                    .map(LoadBasedAutoScalingConfiguration::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder loadBasedAutoScalingConfigurations(
                Collection<LoadBasedAutoScalingConfiguration> loadBasedAutoScalingConfigurations) {
            this.loadBasedAutoScalingConfigurations = LoadBasedAutoScalingConfigurationsCopier
                    .copy(loadBasedAutoScalingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBasedAutoScalingConfigurations(
                LoadBasedAutoScalingConfiguration... loadBasedAutoScalingConfigurations) {
            loadBasedAutoScalingConfigurations(Arrays.asList(loadBasedAutoScalingConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBasedAutoScalingConfigurations(
                Consumer<LoadBasedAutoScalingConfiguration.Builder>... loadBasedAutoScalingConfigurations) {
            loadBasedAutoScalingConfigurations(Stream.of(loadBasedAutoScalingConfigurations)
                    .map(c -> LoadBasedAutoScalingConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLoadBasedAutoScalingConfigurations(
                Collection<LoadBasedAutoScalingConfiguration.BuilderImpl> loadBasedAutoScalingConfigurations) {
            this.loadBasedAutoScalingConfigurations = LoadBasedAutoScalingConfigurationsCopier
                    .copyFromBuilder(loadBasedAutoScalingConfigurations);
        }

        @Override
        public DescribeLoadBasedAutoScalingResponse build() {
            return new DescribeLoadBasedAutoScalingResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
