/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateLayerRequest extends OpsWorksRequest implements
        ToCopyableBuilder<UpdateLayerRequest.Builder, UpdateLayerRequest> {
    private static final SdkField<String> LAYER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateLayerRequest::layerId)).setter(setter(Builder::layerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LayerId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateLayerRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> SHORTNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateLayerRequest::shortname)).setter(setter(Builder::shortname))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Shortname").build()).build();

    private static final SdkField<Map<String, String>> ATTRIBUTES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(UpdateLayerRequest::attributesAsStrings))
            .setter(setter(Builder::attributesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attributes").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<CloudWatchLogsConfiguration> CLOUD_WATCH_LOGS_CONFIGURATION_FIELD = SdkField
            .<CloudWatchLogsConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateLayerRequest::cloudWatchLogsConfiguration))
            .setter(setter(Builder::cloudWatchLogsConfiguration))
            .constructor(CloudWatchLogsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsConfiguration")
                    .build()).build();

    private static final SdkField<String> CUSTOM_INSTANCE_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateLayerRequest::customInstanceProfileArn)).setter(setter(Builder::customInstanceProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomInstanceProfileArn").build())
            .build();

    private static final SdkField<String> CUSTOM_JSON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateLayerRequest::customJson)).setter(setter(Builder::customJson))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomJson").build()).build();

    private static final SdkField<List<String>> CUSTOM_SECURITY_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateLayerRequest::customSecurityGroupIds))
            .setter(setter(Builder::customSecurityGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomSecurityGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PACKAGES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateLayerRequest::packages))
            .setter(setter(Builder::packages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Packages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<VolumeConfiguration>> VOLUME_CONFIGURATIONS_FIELD = SdkField
            .<List<VolumeConfiguration>> builder(MarshallingType.LIST)
            .getter(getter(UpdateLayerRequest::volumeConfigurations))
            .setter(setter(Builder::volumeConfigurations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeConfigurations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VolumeConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(VolumeConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_AUTO_HEALING_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateLayerRequest::enableAutoHealing)).setter(setter(Builder::enableAutoHealing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableAutoHealing").build()).build();

    private static final SdkField<Boolean> AUTO_ASSIGN_ELASTIC_IPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateLayerRequest::autoAssignElasticIps)).setter(setter(Builder::autoAssignElasticIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAssignElasticIps").build())
            .build();

    private static final SdkField<Boolean> AUTO_ASSIGN_PUBLIC_IPS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateLayerRequest::autoAssignPublicIps)).setter(setter(Builder::autoAssignPublicIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoAssignPublicIps").build())
            .build();

    private static final SdkField<Recipes> CUSTOM_RECIPES_FIELD = SdkField.<Recipes> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateLayerRequest::customRecipes)).setter(setter(Builder::customRecipes))
            .constructor(Recipes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomRecipes").build()).build();

    private static final SdkField<Boolean> INSTALL_UPDATES_ON_BOOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(UpdateLayerRequest::installUpdatesOnBoot)).setter(setter(Builder::installUpdatesOnBoot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstallUpdatesOnBoot").build())
            .build();

    private static final SdkField<Boolean> USE_EBS_OPTIMIZED_INSTANCES_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).getter(getter(UpdateLayerRequest::useEbsOptimizedInstances))
            .setter(setter(Builder::useEbsOptimizedInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseEbsOptimizedInstances").build())
            .build();

    private static final SdkField<LifecycleEventConfiguration> LIFECYCLE_EVENT_CONFIGURATION_FIELD = SdkField
            .<LifecycleEventConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateLayerRequest::lifecycleEventConfiguration))
            .setter(setter(Builder::lifecycleEventConfiguration))
            .constructor(LifecycleEventConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecycleEventConfiguration")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYER_ID_FIELD, NAME_FIELD,
            SHORTNAME_FIELD, ATTRIBUTES_FIELD, CLOUD_WATCH_LOGS_CONFIGURATION_FIELD, CUSTOM_INSTANCE_PROFILE_ARN_FIELD,
            CUSTOM_JSON_FIELD, CUSTOM_SECURITY_GROUP_IDS_FIELD, PACKAGES_FIELD, VOLUME_CONFIGURATIONS_FIELD,
            ENABLE_AUTO_HEALING_FIELD, AUTO_ASSIGN_ELASTIC_IPS_FIELD, AUTO_ASSIGN_PUBLIC_IPS_FIELD, CUSTOM_RECIPES_FIELD,
            INSTALL_UPDATES_ON_BOOT_FIELD, USE_EBS_OPTIMIZED_INSTANCES_FIELD, LIFECYCLE_EVENT_CONFIGURATION_FIELD));

    private final String layerId;

    private final String name;

    private final String shortname;

    private final Map<String, String> attributes;

    private final CloudWatchLogsConfiguration cloudWatchLogsConfiguration;

    private final String customInstanceProfileArn;

    private final String customJson;

    private final List<String> customSecurityGroupIds;

    private final List<String> packages;

    private final List<VolumeConfiguration> volumeConfigurations;

    private final Boolean enableAutoHealing;

    private final Boolean autoAssignElasticIps;

    private final Boolean autoAssignPublicIps;

    private final Recipes customRecipes;

    private final Boolean installUpdatesOnBoot;

    private final Boolean useEbsOptimizedInstances;

    private final LifecycleEventConfiguration lifecycleEventConfiguration;

    private UpdateLayerRequest(BuilderImpl builder) {
        super(builder);
        this.layerId = builder.layerId;
        this.name = builder.name;
        this.shortname = builder.shortname;
        this.attributes = builder.attributes;
        this.cloudWatchLogsConfiguration = builder.cloudWatchLogsConfiguration;
        this.customInstanceProfileArn = builder.customInstanceProfileArn;
        this.customJson = builder.customJson;
        this.customSecurityGroupIds = builder.customSecurityGroupIds;
        this.packages = builder.packages;
        this.volumeConfigurations = builder.volumeConfigurations;
        this.enableAutoHealing = builder.enableAutoHealing;
        this.autoAssignElasticIps = builder.autoAssignElasticIps;
        this.autoAssignPublicIps = builder.autoAssignPublicIps;
        this.customRecipes = builder.customRecipes;
        this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
        this.useEbsOptimizedInstances = builder.useEbsOptimizedInstances;
        this.lifecycleEventConfiguration = builder.lifecycleEventConfiguration;
    }

    /**
     * <p>
     * The layer ID.
     * </p>
     * 
     * @return The layer ID.
     */
    public String layerId() {
        return layerId;
    }

    /**
     * <p>
     * The layer name, which is used by the console.
     * </p>
     * 
     * @return The layer name, which is used by the console.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS
     * OpsWorks Stacks and by Chef. The short name is also used as the name for the directory where your app files are
     * installed. It can have a maximum of 200 characters and must be in the following format: /\A[a-z0-9\-\_\.]+\Z/.
     * </p>
     * <p>
     * The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a>
     * </p>
     * 
     * @return For custom layers only, use this parameter to specify the layer's short name, which is used internally by
     *         AWS OpsWorks Stacks and by Chef. The short name is also used as the name for the directory where your app
     *         files are installed. It can have a maximum of 200 characters and must be in the following format:
     *         /\A[a-z0-9\-\_\.]+\Z/.</p>
     *         <p>
     *         The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a>
     */
    public String shortname() {
        return shortname;
    }

    /**
     * <p>
     * One or more user-defined key/value pairs to be added to the stack attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more user-defined key/value pairs to be added to the stack attributes.
     */
    public Map<LayerAttributesKeys, String> attributes() {
        return LayerAttributesCopier.copyStringToEnum(attributes);
    }

    /**
     * <p>
     * One or more user-defined key/value pairs to be added to the stack attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more user-defined key/value pairs to be added to the stack attributes.
     */
    public Map<String, String> attributesAsStrings() {
        return attributes;
    }

    /**
     * <p>
     * Specifies CloudWatch Logs configuration options for the layer. For more information, see
     * <a>CloudWatchLogsLogStream</a>.
     * </p>
     * 
     * @return Specifies CloudWatch Logs configuration options for the layer. For more information, see
     *         <a>CloudWatchLogsLogStream</a>.
     */
    public CloudWatchLogsConfiguration cloudWatchLogsConfiguration() {
        return cloudWatchLogsConfiguration;
    }

    /**
     * <p>
     * The ARN of an IAM profile to be used for all of the layer's EC2 instances. For more information about IAM ARNs,
     * see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     * </p>
     * 
     * @return The ARN of an IAM profile to be used for all of the layer's EC2 instances. For more information about IAM
     *         ARNs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
     *         Identifiers</a>.
     */
    public String customInstanceProfileArn() {
        return customInstanceProfileArn;
    }

    /**
     * <p>
     * A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the
     * layer's instances. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html"> Using Custom
     * JSON</a>.
     * </p>
     * 
     * @return A JSON-formatted string containing custom stack configuration and deployment attributes to be installed
     *         on the layer's instances. For more information, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html"> Using
     *         Custom JSON</a>.
     */
    public String customJson() {
        return customJson;
    }

    /**
     * <p>
     * An array containing the layer's custom security group IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array containing the layer's custom security group IDs.
     */
    public List<String> customSecurityGroupIds() {
        return customSecurityGroupIds;
    }

    /**
     * <p>
     * An array of <code>Package</code> objects that describe the layer's packages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>Package</code> objects that describe the layer's packages.
     */
    public List<String> packages() {
        return packages;
    }

    /**
     * <p>
     * A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
     */
    public List<VolumeConfiguration> volumeConfigurations() {
        return volumeConfigurations;
    }

    /**
     * <p>
     * Whether to disable auto healing for the layer.
     * </p>
     * 
     * @return Whether to disable auto healing for the layer.
     */
    public Boolean enableAutoHealing() {
        return enableAutoHealing;
    }

    /**
     * <p>
     * Whether to automatically assign an <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address</a> to
     * the layer's instances. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     * Layer</a>.
     * </p>
     * 
     * @return Whether to automatically assign an <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
     *         address</a> to the layer's instances. For more information, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     *         Layer</a>.
     */
    public Boolean autoAssignElasticIps() {
        return autoAssignElasticIps;
    }

    /**
     * <p>
     * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's
     * instances. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     * Layer</a>.
     * </p>
     * 
     * @return For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's
     *         instances. For more information, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     *         Layer</a>.
     */
    public Boolean autoAssignPublicIps() {
        return autoAssignPublicIps;
    }

    /**
     * <p>
     * A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.
     * </p>
     * 
     * @return A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.
     */
    public Recipes customRecipes() {
        return customRecipes;
    }

    /**
     * <p>
     * Whether to install operating system and package updates when the instance boots. The default value is
     * <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then
     * update your instances manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack
     * command or manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
     * </p>
     * <note>
     * <p>
     * We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the latest
     * security updates.
     * </p>
     * </note>
     * 
     * @return Whether to install operating system and package updates when the instance boots. The default value is
     *         <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must
     *         then update your instances manually by using <a>CreateDeployment</a> to run the
     *         <code>update_dependencies</code> stack command or manually running <code>yum</code> (Amazon Linux) or
     *         <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
     *         <p>
     *         We strongly recommend using the default value of <code>true</code>, to ensure that your instances have
     *         the latest security updates.
     *         </p>
     */
    public Boolean installUpdatesOnBoot() {
        return installUpdatesOnBoot;
    }

    /**
     * <p>
     * Whether to use Amazon EBS-optimized instances.
     * </p>
     * 
     * @return Whether to use Amazon EBS-optimized instances.
     */
    public Boolean useEbsOptimizedInstances() {
        return useEbsOptimizedInstances;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public LifecycleEventConfiguration lifecycleEventConfiguration() {
        return lifecycleEventConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(layerId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(shortname());
        hashCode = 31 * hashCode + Objects.hashCode(attributesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(customInstanceProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(customJson());
        hashCode = 31 * hashCode + Objects.hashCode(customSecurityGroupIds());
        hashCode = 31 * hashCode + Objects.hashCode(packages());
        hashCode = 31 * hashCode + Objects.hashCode(volumeConfigurations());
        hashCode = 31 * hashCode + Objects.hashCode(enableAutoHealing());
        hashCode = 31 * hashCode + Objects.hashCode(autoAssignElasticIps());
        hashCode = 31 * hashCode + Objects.hashCode(autoAssignPublicIps());
        hashCode = 31 * hashCode + Objects.hashCode(customRecipes());
        hashCode = 31 * hashCode + Objects.hashCode(installUpdatesOnBoot());
        hashCode = 31 * hashCode + Objects.hashCode(useEbsOptimizedInstances());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleEventConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateLayerRequest)) {
            return false;
        }
        UpdateLayerRequest other = (UpdateLayerRequest) obj;
        return Objects.equals(layerId(), other.layerId()) && Objects.equals(name(), other.name())
                && Objects.equals(shortname(), other.shortname())
                && Objects.equals(attributesAsStrings(), other.attributesAsStrings())
                && Objects.equals(cloudWatchLogsConfiguration(), other.cloudWatchLogsConfiguration())
                && Objects.equals(customInstanceProfileArn(), other.customInstanceProfileArn())
                && Objects.equals(customJson(), other.customJson())
                && Objects.equals(customSecurityGroupIds(), other.customSecurityGroupIds())
                && Objects.equals(packages(), other.packages())
                && Objects.equals(volumeConfigurations(), other.volumeConfigurations())
                && Objects.equals(enableAutoHealing(), other.enableAutoHealing())
                && Objects.equals(autoAssignElasticIps(), other.autoAssignElasticIps())
                && Objects.equals(autoAssignPublicIps(), other.autoAssignPublicIps())
                && Objects.equals(customRecipes(), other.customRecipes())
                && Objects.equals(installUpdatesOnBoot(), other.installUpdatesOnBoot())
                && Objects.equals(useEbsOptimizedInstances(), other.useEbsOptimizedInstances())
                && Objects.equals(lifecycleEventConfiguration(), other.lifecycleEventConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateLayerRequest").add("LayerId", layerId()).add("Name", name()).add("Shortname", shortname())
                .add("Attributes", attributesAsStrings()).add("CloudWatchLogsConfiguration", cloudWatchLogsConfiguration())
                .add("CustomInstanceProfileArn", customInstanceProfileArn()).add("CustomJson", customJson())
                .add("CustomSecurityGroupIds", customSecurityGroupIds()).add("Packages", packages())
                .add("VolumeConfigurations", volumeConfigurations()).add("EnableAutoHealing", enableAutoHealing())
                .add("AutoAssignElasticIps", autoAssignElasticIps()).add("AutoAssignPublicIps", autoAssignPublicIps())
                .add("CustomRecipes", customRecipes()).add("InstallUpdatesOnBoot", installUpdatesOnBoot())
                .add("UseEbsOptimizedInstances", useEbsOptimizedInstances())
                .add("LifecycleEventConfiguration", lifecycleEventConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LayerId":
            return Optional.ofNullable(clazz.cast(layerId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Shortname":
            return Optional.ofNullable(clazz.cast(shortname()));
        case "Attributes":
            return Optional.ofNullable(clazz.cast(attributesAsStrings()));
        case "CloudWatchLogsConfiguration":
            return Optional.ofNullable(clazz.cast(cloudWatchLogsConfiguration()));
        case "CustomInstanceProfileArn":
            return Optional.ofNullable(clazz.cast(customInstanceProfileArn()));
        case "CustomJson":
            return Optional.ofNullable(clazz.cast(customJson()));
        case "CustomSecurityGroupIds":
            return Optional.ofNullable(clazz.cast(customSecurityGroupIds()));
        case "Packages":
            return Optional.ofNullable(clazz.cast(packages()));
        case "VolumeConfigurations":
            return Optional.ofNullable(clazz.cast(volumeConfigurations()));
        case "EnableAutoHealing":
            return Optional.ofNullable(clazz.cast(enableAutoHealing()));
        case "AutoAssignElasticIps":
            return Optional.ofNullable(clazz.cast(autoAssignElasticIps()));
        case "AutoAssignPublicIps":
            return Optional.ofNullable(clazz.cast(autoAssignPublicIps()));
        case "CustomRecipes":
            return Optional.ofNullable(clazz.cast(customRecipes()));
        case "InstallUpdatesOnBoot":
            return Optional.ofNullable(clazz.cast(installUpdatesOnBoot()));
        case "UseEbsOptimizedInstances":
            return Optional.ofNullable(clazz.cast(useEbsOptimizedInstances()));
        case "LifecycleEventConfiguration":
            return Optional.ofNullable(clazz.cast(lifecycleEventConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateLayerRequest, T> g) {
        return obj -> g.apply((UpdateLayerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpsWorksRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateLayerRequest> {
        /**
         * <p>
         * The layer ID.
         * </p>
         * 
         * @param layerId
         *        The layer ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerId(String layerId);

        /**
         * <p>
         * The layer name, which is used by the console.
         * </p>
         * 
         * @param name
         *        The layer name, which is used by the console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS
         * OpsWorks Stacks and by Chef. The short name is also used as the name for the directory where your app files
         * are installed. It can have a maximum of 200 characters and must be in the following format:
         * /\A[a-z0-9\-\_\.]+\Z/.
         * </p>
         * <p>
         * The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a>
         * </p>
         * 
         * @param shortname
         *        For custom layers only, use this parameter to specify the layer's short name, which is used internally
         *        by AWS OpsWorks Stacks and by Chef. The short name is also used as the name for the directory where
         *        your app files are installed. It can have a maximum of 200 characters and must be in the following
         *        format: /\A[a-z0-9\-\_\.]+\Z/.</p>
         *        <p>
         *        The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortname(String shortname);

        /**
         * <p>
         * One or more user-defined key/value pairs to be added to the stack attributes.
         * </p>
         * 
         * @param attributes
         *        One or more user-defined key/value pairs to be added to the stack attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesWithStrings(Map<String, String> attributes);

        /**
         * <p>
         * One or more user-defined key/value pairs to be added to the stack attributes.
         * </p>
         * 
         * @param attributes
         *        One or more user-defined key/value pairs to be added to the stack attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<LayerAttributesKeys, String> attributes);

        /**
         * <p>
         * Specifies CloudWatch Logs configuration options for the layer. For more information, see
         * <a>CloudWatchLogsLogStream</a>.
         * </p>
         * 
         * @param cloudWatchLogsConfiguration
         *        Specifies CloudWatch Logs configuration options for the layer. For more information, see
         *        <a>CloudWatchLogsLogStream</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsConfiguration(CloudWatchLogsConfiguration cloudWatchLogsConfiguration);

        /**
         * <p>
         * Specifies CloudWatch Logs configuration options for the layer. For more information, see
         * <a>CloudWatchLogsLogStream</a>.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchLogsConfiguration.Builder} avoiding
         * the need to create one manually via {@link CloudWatchLogsConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchLogsConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudWatchLogsConfiguration(CloudWatchLogsConfiguration)}.
         * 
         * @param cloudWatchLogsConfiguration
         *        a consumer that will call methods on {@link CloudWatchLogsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLogsConfiguration(CloudWatchLogsConfiguration)
         */
        default Builder cloudWatchLogsConfiguration(Consumer<CloudWatchLogsConfiguration.Builder> cloudWatchLogsConfiguration) {
            return cloudWatchLogsConfiguration(CloudWatchLogsConfiguration.builder().applyMutation(cloudWatchLogsConfiguration)
                    .build());
        }

        /**
         * <p>
         * The ARN of an IAM profile to be used for all of the layer's EC2 instances. For more information about IAM
         * ARNs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
         * Identifiers</a>.
         * </p>
         * 
         * @param customInstanceProfileArn
         *        The ARN of an IAM profile to be used for all of the layer's EC2 instances. For more information about
         *        IAM ARNs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
         *        Identifiers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customInstanceProfileArn(String customInstanceProfileArn);

        /**
         * <p>
         * A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on
         * the layer's instances. For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html"> Using Custom
         * JSON</a>.
         * </p>
         * 
         * @param customJson
         *        A JSON-formatted string containing custom stack configuration and deployment attributes to be
         *        installed on the layer's instances. For more information, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html"> Using
         *        Custom JSON</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customJson(String customJson);

        /**
         * <p>
         * An array containing the layer's custom security group IDs.
         * </p>
         * 
         * @param customSecurityGroupIds
         *        An array containing the layer's custom security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSecurityGroupIds(Collection<String> customSecurityGroupIds);

        /**
         * <p>
         * An array containing the layer's custom security group IDs.
         * </p>
         * 
         * @param customSecurityGroupIds
         *        An array containing the layer's custom security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSecurityGroupIds(String... customSecurityGroupIds);

        /**
         * <p>
         * An array of <code>Package</code> objects that describe the layer's packages.
         * </p>
         * 
         * @param packages
         *        An array of <code>Package</code> objects that describe the layer's packages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packages(Collection<String> packages);

        /**
         * <p>
         * An array of <code>Package</code> objects that describe the layer's packages.
         * </p>
         * 
         * @param packages
         *        An array of <code>Package</code> objects that describe the layer's packages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packages(String... packages);

        /**
         * <p>
         * A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * </p>
         * 
         * @param volumeConfigurations
         *        A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeConfigurations(Collection<VolumeConfiguration> volumeConfigurations);

        /**
         * <p>
         * A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * </p>
         * 
         * @param volumeConfigurations
         *        A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeConfigurations(VolumeConfiguration... volumeConfigurations);

        /**
         * <p>
         * A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VolumeConfiguration>.Builder} avoiding the
         * need to create one manually via {@link List<VolumeConfiguration>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VolumeConfiguration>.Builder#build()} is called immediately
         * and its result is passed to {@link #volumeConfigurations(List<VolumeConfiguration>)}.
         * 
         * @param volumeConfigurations
         *        a consumer that will call methods on {@link List<VolumeConfiguration>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeConfigurations(List<VolumeConfiguration>)
         */
        Builder volumeConfigurations(Consumer<VolumeConfiguration.Builder>... volumeConfigurations);

        /**
         * <p>
         * Whether to disable auto healing for the layer.
         * </p>
         * 
         * @param enableAutoHealing
         *        Whether to disable auto healing for the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAutoHealing(Boolean enableAutoHealing);

        /**
         * <p>
         * Whether to automatically assign an <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
         * address</a> to the layer's instances. For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
         * Layer</a>.
         * </p>
         * 
         * @param autoAssignElasticIps
         *        Whether to automatically assign an <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
         *        address</a> to the layer's instances. For more information, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit
         *        a Layer</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoAssignElasticIps(Boolean autoAssignElasticIps);

        /**
         * <p>
         * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's
         * instances. For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
         * Layer</a>.
         * </p>
         * 
         * @param autoAssignPublicIps
         *        For stacks that are running in a VPC, whether to automatically assign a public IP address to the
         *        layer's instances. For more information, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit
         *        a Layer</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoAssignPublicIps(Boolean autoAssignPublicIps);

        /**
         * <p>
         * A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.
         * </p>
         * 
         * @param customRecipes
         *        A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRecipes(Recipes customRecipes);

        /**
         * <p>
         * A <code>LayerCustomRecipes</code> object that specifies the layer's custom recipes.
         * </p>
         * This is a convenience that creates an instance of the {@link Recipes.Builder} avoiding the need to create one
         * manually via {@link Recipes#builder()}.
         *
         * When the {@link Consumer} completes, {@link Recipes.Builder#build()} is called immediately and its result is
         * passed to {@link #customRecipes(Recipes)}.
         * 
         * @param customRecipes
         *        a consumer that will call methods on {@link Recipes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customRecipes(Recipes)
         */
        default Builder customRecipes(Consumer<Recipes.Builder> customRecipes) {
            return customRecipes(Recipes.builder().applyMutation(customRecipes).build());
        }

        /**
         * <p>
         * Whether to install operating system and package updates when the instance boots. The default value is
         * <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then
         * update your instances manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code>
         * stack command or manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the
         * instances.
         * </p>
         * <note>
         * <p>
         * We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the
         * latest security updates.
         * </p>
         * </note>
         * 
         * @param installUpdatesOnBoot
         *        Whether to install operating system and package updates when the instance boots. The default value is
         *        <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You
         *        must then update your instances manually by using <a>CreateDeployment</a> to run the
         *        <code>update_dependencies</code> stack command or manually running <code>yum</code> (Amazon Linux) or
         *        <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
         *        <p>
         *        We strongly recommend using the default value of <code>true</code>, to ensure that your instances have
         *        the latest security updates.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot);

        /**
         * <p>
         * Whether to use Amazon EBS-optimized instances.
         * </p>
         * 
         * @param useEbsOptimizedInstances
         *        Whether to use Amazon EBS-optimized instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useEbsOptimizedInstances(Boolean useEbsOptimizedInstances);

        /**
         * <p/>
         * 
         * @param lifecycleEventConfiguration
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleEventConfiguration(LifecycleEventConfiguration lifecycleEventConfiguration);

        /**
         * <p/>
         * This is a convenience that creates an instance of the {@link LifecycleEventConfiguration.Builder} avoiding
         * the need to create one manually via {@link LifecycleEventConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link LifecycleEventConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #lifecycleEventConfiguration(LifecycleEventConfiguration)}.
         * 
         * @param lifecycleEventConfiguration
         *        a consumer that will call methods on {@link LifecycleEventConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycleEventConfiguration(LifecycleEventConfiguration)
         */
        default Builder lifecycleEventConfiguration(Consumer<LifecycleEventConfiguration.Builder> lifecycleEventConfiguration) {
            return lifecycleEventConfiguration(LifecycleEventConfiguration.builder().applyMutation(lifecycleEventConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpsWorksRequest.BuilderImpl implements Builder {
        private String layerId;

        private String name;

        private String shortname;

        private Map<String, String> attributes = DefaultSdkAutoConstructMap.getInstance();

        private CloudWatchLogsConfiguration cloudWatchLogsConfiguration;

        private String customInstanceProfileArn;

        private String customJson;

        private List<String> customSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> packages = DefaultSdkAutoConstructList.getInstance();

        private List<VolumeConfiguration> volumeConfigurations = DefaultSdkAutoConstructList.getInstance();

        private Boolean enableAutoHealing;

        private Boolean autoAssignElasticIps;

        private Boolean autoAssignPublicIps;

        private Recipes customRecipes;

        private Boolean installUpdatesOnBoot;

        private Boolean useEbsOptimizedInstances;

        private LifecycleEventConfiguration lifecycleEventConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateLayerRequest model) {
            super(model);
            layerId(model.layerId);
            name(model.name);
            shortname(model.shortname);
            attributesWithStrings(model.attributes);
            cloudWatchLogsConfiguration(model.cloudWatchLogsConfiguration);
            customInstanceProfileArn(model.customInstanceProfileArn);
            customJson(model.customJson);
            customSecurityGroupIds(model.customSecurityGroupIds);
            packages(model.packages);
            volumeConfigurations(model.volumeConfigurations);
            enableAutoHealing(model.enableAutoHealing);
            autoAssignElasticIps(model.autoAssignElasticIps);
            autoAssignPublicIps(model.autoAssignPublicIps);
            customRecipes(model.customRecipes);
            installUpdatesOnBoot(model.installUpdatesOnBoot);
            useEbsOptimizedInstances(model.useEbsOptimizedInstances);
            lifecycleEventConfiguration(model.lifecycleEventConfiguration);
        }

        public final String getLayerId() {
            return layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getShortname() {
            return shortname;
        }

        @Override
        public final Builder shortname(String shortname) {
            this.shortname = shortname;
            return this;
        }

        public final void setShortname(String shortname) {
            this.shortname = shortname;
        }

        public final Map<String, String> getAttributesAsStrings() {
            return attributes;
        }

        @Override
        public final Builder attributesWithStrings(Map<String, String> attributes) {
            this.attributes = LayerAttributesCopier.copy(attributes);
            return this;
        }

        @Override
        public final Builder attributes(Map<LayerAttributesKeys, String> attributes) {
            this.attributes = LayerAttributesCopier.copyEnumToString(attributes);
            return this;
        }

        public final void setAttributesWithStrings(Map<String, String> attributes) {
            this.attributes = LayerAttributesCopier.copy(attributes);
        }

        public final CloudWatchLogsConfiguration.Builder getCloudWatchLogsConfiguration() {
            return cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLogsConfiguration(CloudWatchLogsConfiguration cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration;
            return this;
        }

        public final void setCloudWatchLogsConfiguration(CloudWatchLogsConfiguration.BuilderImpl cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.build() : null;
        }

        public final String getCustomInstanceProfileArn() {
            return customInstanceProfileArn;
        }

        @Override
        public final Builder customInstanceProfileArn(String customInstanceProfileArn) {
            this.customInstanceProfileArn = customInstanceProfileArn;
            return this;
        }

        public final void setCustomInstanceProfileArn(String customInstanceProfileArn) {
            this.customInstanceProfileArn = customInstanceProfileArn;
        }

        public final String getCustomJson() {
            return customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        public final Collection<String> getCustomSecurityGroupIds() {
            return customSecurityGroupIds;
        }

        @Override
        public final Builder customSecurityGroupIds(Collection<String> customSecurityGroupIds) {
            this.customSecurityGroupIds = StringsCopier.copy(customSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customSecurityGroupIds(String... customSecurityGroupIds) {
            customSecurityGroupIds(Arrays.asList(customSecurityGroupIds));
            return this;
        }

        public final void setCustomSecurityGroupIds(Collection<String> customSecurityGroupIds) {
            this.customSecurityGroupIds = StringsCopier.copy(customSecurityGroupIds);
        }

        public final Collection<String> getPackages() {
            return packages;
        }

        @Override
        public final Builder packages(Collection<String> packages) {
            this.packages = StringsCopier.copy(packages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packages(String... packages) {
            packages(Arrays.asList(packages));
            return this;
        }

        public final void setPackages(Collection<String> packages) {
            this.packages = StringsCopier.copy(packages);
        }

        public final Collection<VolumeConfiguration.Builder> getVolumeConfigurations() {
            return volumeConfigurations != null ? volumeConfigurations.stream().map(VolumeConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumeConfigurations(Collection<VolumeConfiguration> volumeConfigurations) {
            this.volumeConfigurations = VolumeConfigurationsCopier.copy(volumeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(VolumeConfiguration... volumeConfigurations) {
            volumeConfigurations(Arrays.asList(volumeConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(Consumer<VolumeConfiguration.Builder>... volumeConfigurations) {
            volumeConfigurations(Stream.of(volumeConfigurations).map(c -> VolumeConfiguration.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVolumeConfigurations(Collection<VolumeConfiguration.BuilderImpl> volumeConfigurations) {
            this.volumeConfigurations = VolumeConfigurationsCopier.copyFromBuilder(volumeConfigurations);
        }

        public final Boolean getEnableAutoHealing() {
            return enableAutoHealing;
        }

        @Override
        public final Builder enableAutoHealing(Boolean enableAutoHealing) {
            this.enableAutoHealing = enableAutoHealing;
            return this;
        }

        public final void setEnableAutoHealing(Boolean enableAutoHealing) {
            this.enableAutoHealing = enableAutoHealing;
        }

        public final Boolean getAutoAssignElasticIps() {
            return autoAssignElasticIps;
        }

        @Override
        public final Builder autoAssignElasticIps(Boolean autoAssignElasticIps) {
            this.autoAssignElasticIps = autoAssignElasticIps;
            return this;
        }

        public final void setAutoAssignElasticIps(Boolean autoAssignElasticIps) {
            this.autoAssignElasticIps = autoAssignElasticIps;
        }

        public final Boolean getAutoAssignPublicIps() {
            return autoAssignPublicIps;
        }

        @Override
        public final Builder autoAssignPublicIps(Boolean autoAssignPublicIps) {
            this.autoAssignPublicIps = autoAssignPublicIps;
            return this;
        }

        public final void setAutoAssignPublicIps(Boolean autoAssignPublicIps) {
            this.autoAssignPublicIps = autoAssignPublicIps;
        }

        public final Recipes.Builder getCustomRecipes() {
            return customRecipes != null ? customRecipes.toBuilder() : null;
        }

        @Override
        public final Builder customRecipes(Recipes customRecipes) {
            this.customRecipes = customRecipes;
            return this;
        }

        public final void setCustomRecipes(Recipes.BuilderImpl customRecipes) {
            this.customRecipes = customRecipes != null ? customRecipes.build() : null;
        }

        public final Boolean getInstallUpdatesOnBoot() {
            return installUpdatesOnBoot;
        }

        @Override
        public final Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        public final void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
        }

        public final Boolean getUseEbsOptimizedInstances() {
            return useEbsOptimizedInstances;
        }

        @Override
        public final Builder useEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
            this.useEbsOptimizedInstances = useEbsOptimizedInstances;
            return this;
        }

        public final void setUseEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
            this.useEbsOptimizedInstances = useEbsOptimizedInstances;
        }

        public final LifecycleEventConfiguration.Builder getLifecycleEventConfiguration() {
            return lifecycleEventConfiguration != null ? lifecycleEventConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder lifecycleEventConfiguration(LifecycleEventConfiguration lifecycleEventConfiguration) {
            this.lifecycleEventConfiguration = lifecycleEventConfiguration;
            return this;
        }

        public final void setLifecycleEventConfiguration(LifecycleEventConfiguration.BuilderImpl lifecycleEventConfiguration) {
            this.lifecycleEventConfiguration = lifecycleEventConfiguration != null ? lifecycleEventConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateLayerRequest build() {
            return new UpdateLayerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
