/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EcsCluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EcsCluster> {
    private static final SdkField<String> ECS_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EcsCluster.getter(EcsCluster::ecsClusterArn)).setter(EcsCluster.setter(Builder::ecsClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EcsClusterArn").build()}).build();
    private static final SdkField<String> ECS_CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EcsCluster.getter(EcsCluster::ecsClusterName)).setter(EcsCluster.setter(Builder::ecsClusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EcsClusterName").build()}).build();
    private static final SdkField<String> STACK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EcsCluster.getter(EcsCluster::stackId)).setter(EcsCluster.setter(Builder::stackId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()}).build();
    private static final SdkField<String> REGISTERED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EcsCluster.getter(EcsCluster::registeredAt)).setter(EcsCluster.setter(Builder::registeredAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECS_CLUSTER_ARN_FIELD, ECS_CLUSTER_NAME_FIELD, STACK_ID_FIELD, REGISTERED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String ecsClusterArn;
    private final String ecsClusterName;
    private final String stackId;
    private final String registeredAt;

    private EcsCluster(BuilderImpl builder) {
        this.ecsClusterArn = builder.ecsClusterArn;
        this.ecsClusterName = builder.ecsClusterName;
        this.stackId = builder.stackId;
        this.registeredAt = builder.registeredAt;
    }

    public String ecsClusterArn() {
        return this.ecsClusterArn;
    }

    public String ecsClusterName() {
        return this.ecsClusterName;
    }

    public String stackId() {
        return this.stackId;
    }

    public String registeredAt() {
        return this.registeredAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsClusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stackId());
        hashCode = 31 * hashCode + Objects.hashCode(this.registeredAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsCluster)) {
            return false;
        }
        EcsCluster other = (EcsCluster)obj;
        return Objects.equals(this.ecsClusterArn(), other.ecsClusterArn()) && Objects.equals(this.ecsClusterName(), other.ecsClusterName()) && Objects.equals(this.stackId(), other.stackId()) && Objects.equals(this.registeredAt(), other.registeredAt());
    }

    public String toString() {
        return ToString.builder((String)"EcsCluster").add("EcsClusterArn", (Object)this.ecsClusterArn()).add("EcsClusterName", (Object)this.ecsClusterName()).add("StackId", (Object)this.stackId()).add("RegisteredAt", (Object)this.registeredAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EcsClusterArn": {
                return Optional.ofNullable(clazz.cast(this.ecsClusterArn()));
            }
            case "EcsClusterName": {
                return Optional.ofNullable(clazz.cast(this.ecsClusterName()));
            }
            case "StackId": {
                return Optional.ofNullable(clazz.cast(this.stackId()));
            }
            case "RegisteredAt": {
                return Optional.ofNullable(clazz.cast(this.registeredAt()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EcsCluster, T> g) {
        return obj -> g.apply((EcsCluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ecsClusterArn;
        private String ecsClusterName;
        private String stackId;
        private String registeredAt;

        private BuilderImpl() {
        }

        private BuilderImpl(EcsCluster model) {
            this.ecsClusterArn(model.ecsClusterArn);
            this.ecsClusterName(model.ecsClusterName);
            this.stackId(model.stackId);
            this.registeredAt(model.registeredAt);
        }

        public final String getEcsClusterArn() {
            return this.ecsClusterArn;
        }

        @Override
        public final Builder ecsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
            return this;
        }

        public final void setEcsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
        }

        public final String getEcsClusterName() {
            return this.ecsClusterName;
        }

        @Override
        public final Builder ecsClusterName(String ecsClusterName) {
            this.ecsClusterName = ecsClusterName;
            return this;
        }

        public final void setEcsClusterName(String ecsClusterName) {
            this.ecsClusterName = ecsClusterName;
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getRegisteredAt() {
            return this.registeredAt;
        }

        @Override
        public final Builder registeredAt(String registeredAt) {
            this.registeredAt = registeredAt;
            return this;
        }

        public final void setRegisteredAt(String registeredAt) {
            this.registeredAt = registeredAt;
        }

        public EcsCluster build() {
            return new EcsCluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EcsCluster> {
        public Builder ecsClusterArn(String var1);

        public Builder ecsClusterName(String var1);

        public Builder stackId(String var1);

        public Builder registeredAt(String var1);
    }
}

