/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes stack or user permissions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Permission implements SdkPojo, Serializable, ToCopyableBuilder<Permission.Builder, Permission> {
    private static final SdkField<String> STACK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Permission::stackId)).setter(setter(Builder::stackId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackId").build()).build();

    private static final SdkField<String> IAM_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Permission::iamUserArn)).setter(setter(Builder::iamUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamUserArn").build()).build();

    private static final SdkField<Boolean> ALLOW_SSH_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Permission::allowSsh)).setter(setter(Builder::allowSsh))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowSsh").build()).build();

    private static final SdkField<Boolean> ALLOW_SUDO_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Permission::allowSudo)).setter(setter(Builder::allowSudo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowSudo").build()).build();

    private static final SdkField<String> LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Permission::level)).setter(setter(Builder::level))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Level").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_ID_FIELD,
            IAM_USER_ARN_FIELD, ALLOW_SSH_FIELD, ALLOW_SUDO_FIELD, LEVEL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String stackId;

    private final String iamUserArn;

    private final Boolean allowSsh;

    private final Boolean allowSudo;

    private final String level;

    private Permission(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.iamUserArn = builder.iamUserArn;
        this.allowSsh = builder.allowSsh;
        this.allowSudo = builder.allowSudo;
        this.level = builder.level;
    }

    /**
     * <p>
     * A stack ID.
     * </p>
     * 
     * @return A stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for an AWS Identity and Access Management (IAM) role. For more information about
     * IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
     * Identifiers</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for an AWS Identity and Access Management (IAM) role. For more information
     *         about IAM ARNs, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     */
    public String iamUserArn() {
        return iamUserArn;
    }

    /**
     * <p>
     * Whether the user can use SSH.
     * </p>
     * 
     * @return Whether the user can use SSH.
     */
    public Boolean allowSsh() {
        return allowSsh;
    }

    /**
     * <p>
     * Whether the user can use <b>sudo</b>.
     * </p>
     * 
     * @return Whether the user can use <b>sudo</b>.
     */
    public Boolean allowSudo() {
        return allowSudo;
    }

    /**
     * <p>
     * The user's permission level, which must be the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deny</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>show</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deploy</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>manage</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>iam_only</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information on the permissions associated with these levels, see <a
     * href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     * Permissions</a>
     * </p>
     * 
     * @return The user's permission level, which must be the following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>deny</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>show</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deploy</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>manage</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>iam_only</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information on the permissions associated with these levels, see <a
     *         href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
     *         Permissions</a>
     */
    public String level() {
        return level;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stackId());
        hashCode = 31 * hashCode + Objects.hashCode(iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(allowSsh());
        hashCode = 31 * hashCode + Objects.hashCode(allowSudo());
        hashCode = 31 * hashCode + Objects.hashCode(level());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Permission)) {
            return false;
        }
        Permission other = (Permission) obj;
        return Objects.equals(stackId(), other.stackId()) && Objects.equals(iamUserArn(), other.iamUserArn())
                && Objects.equals(allowSsh(), other.allowSsh()) && Objects.equals(allowSudo(), other.allowSudo())
                && Objects.equals(level(), other.level());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Permission").add("StackId", stackId()).add("IamUserArn", iamUserArn())
                .add("AllowSsh", allowSsh()).add("AllowSudo", allowSudo()).add("Level", level()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.ofNullable(clazz.cast(stackId()));
        case "IamUserArn":
            return Optional.ofNullable(clazz.cast(iamUserArn()));
        case "AllowSsh":
            return Optional.ofNullable(clazz.cast(allowSsh()));
        case "AllowSudo":
            return Optional.ofNullable(clazz.cast(allowSudo()));
        case "Level":
            return Optional.ofNullable(clazz.cast(level()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Permission, T> g) {
        return obj -> g.apply((Permission) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Permission> {
        /**
         * <p>
         * A stack ID.
         * </p>
         * 
         * @param stackId
         *        A stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for an AWS Identity and Access Management (IAM) role. For more information
         * about IAM ARNs, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
         * Identifiers</a>.
         * </p>
         * 
         * @param iamUserArn
         *        The Amazon Resource Name (ARN) for an AWS Identity and Access Management (IAM) role. For more
         *        information about IAM ARNs, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArn(String iamUserArn);

        /**
         * <p>
         * Whether the user can use SSH.
         * </p>
         * 
         * @param allowSsh
         *        Whether the user can use SSH.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowSsh(Boolean allowSsh);

        /**
         * <p>
         * Whether the user can use <b>sudo</b>.
         * </p>
         * 
         * @param allowSudo
         *        Whether the user can use <b>sudo</b>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowSudo(Boolean allowSudo);

        /**
         * <p>
         * The user's permission level, which must be the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deny</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>show</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deploy</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>manage</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>iam_only</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information on the permissions associated with these levels, see <a
         * href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing User
         * Permissions</a>
         * </p>
         * 
         * @param level
         *        The user's permission level, which must be the following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>deny</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>show</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deploy</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>manage</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>iam_only</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information on the permissions associated with these levels, see <a
         *        href="https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html">Managing
         *        User Permissions</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder level(String level);
    }

    static final class BuilderImpl implements Builder {
        private String stackId;

        private String iamUserArn;

        private Boolean allowSsh;

        private Boolean allowSudo;

        private String level;

        private BuilderImpl() {
        }

        private BuilderImpl(Permission model) {
            stackId(model.stackId);
            iamUserArn(model.iamUserArn);
            allowSsh(model.allowSsh);
            allowSudo(model.allowSudo);
            level(model.level);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getIamUserArn() {
            return iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final Boolean getAllowSsh() {
            return allowSsh;
        }

        @Override
        public final Builder allowSsh(Boolean allowSsh) {
            this.allowSsh = allowSsh;
            return this;
        }

        public final void setAllowSsh(Boolean allowSsh) {
            this.allowSsh = allowSsh;
        }

        public final Boolean getAllowSudo() {
            return allowSudo;
        }

        @Override
        public final Builder allowSudo(Boolean allowSudo) {
            this.allowSudo = allowSudo;
            return this;
        }

        public final void setAllowSudo(Boolean allowSudo) {
            this.allowSudo = allowSudo;
        }

        public final String getLevel() {
            return level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public Permission build() {
            return new Permission(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
