/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a block device mapping. This data type maps directly to the Amazon EC2 <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html">BlockDeviceMapping</a> data
 * type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlockDeviceMapping implements SdkPojo, Serializable,
        ToCopyableBuilder<BlockDeviceMapping.Builder, BlockDeviceMapping> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BlockDeviceMapping::deviceName)).setter(setter(Builder::deviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()).build();

    private static final SdkField<String> NO_DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BlockDeviceMapping::noDevice)).setter(setter(Builder::noDevice))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NoDevice").build()).build();

    private static final SdkField<String> VIRTUAL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(BlockDeviceMapping::virtualName)).setter(setter(Builder::virtualName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualName").build()).build();

    private static final SdkField<EbsBlockDevice> EBS_FIELD = SdkField.<EbsBlockDevice> builder(MarshallingType.SDK_POJO)
            .getter(getter(BlockDeviceMapping::ebs)).setter(setter(Builder::ebs)).constructor(EbsBlockDevice::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ebs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD,
            NO_DEVICE_FIELD, VIRTUAL_NAME_FIELD, EBS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String deviceName;

    private final String noDevice;

    private final String virtualName;

    private final EbsBlockDevice ebs;

    private BlockDeviceMapping(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.noDevice = builder.noDevice;
        this.virtualName = builder.virtualName;
        this.ebs = builder.ebs;
    }

    /**
     * <p>
     * The device name that is exposed to the instance, such as <code>/dev/sdh</code>. For the root device, you can use
     * the explicit device name or you can set this parameter to <code>ROOT_DEVICE</code> and AWS OpsWorks Stacks will
     * provide the correct device name.
     * </p>
     * 
     * @return The device name that is exposed to the instance, such as <code>/dev/sdh</code>. For the root device, you
     *         can use the explicit device name or you can set this parameter to <code>ROOT_DEVICE</code> and AWS
     *         OpsWorks Stacks will provide the correct device name.
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * Suppresses the specified device included in the AMI's block device mapping.
     * </p>
     * 
     * @return Suppresses the specified device included in the AMI's block device mapping.
     */
    public String noDevice() {
        return noDevice;
    }

    /**
     * <p>
     * The virtual device name. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html">BlockDeviceMapping</a>.
     * </p>
     * 
     * @return The virtual device name. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html"
     *         >BlockDeviceMapping</a>.
     */
    public String virtualName() {
        return virtualName;
    }

    /**
     * <p>
     * An <code>EBSBlockDevice</code> that defines how to configure an Amazon EBS volume when the instance is launched.
     * </p>
     * 
     * @return An <code>EBSBlockDevice</code> that defines how to configure an Amazon EBS volume when the instance is
     *         launched.
     */
    public EbsBlockDevice ebs() {
        return ebs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(noDevice());
        hashCode = 31 * hashCode + Objects.hashCode(virtualName());
        hashCode = 31 * hashCode + Objects.hashCode(ebs());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockDeviceMapping)) {
            return false;
        }
        BlockDeviceMapping other = (BlockDeviceMapping) obj;
        return Objects.equals(deviceName(), other.deviceName()) && Objects.equals(noDevice(), other.noDevice())
                && Objects.equals(virtualName(), other.virtualName()) && Objects.equals(ebs(), other.ebs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BlockDeviceMapping").add("DeviceName", deviceName()).add("NoDevice", noDevice())
                .add("VirtualName", virtualName()).add("Ebs", ebs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceName":
            return Optional.ofNullable(clazz.cast(deviceName()));
        case "NoDevice":
            return Optional.ofNullable(clazz.cast(noDevice()));
        case "VirtualName":
            return Optional.ofNullable(clazz.cast(virtualName()));
        case "Ebs":
            return Optional.ofNullable(clazz.cast(ebs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlockDeviceMapping, T> g) {
        return obj -> g.apply((BlockDeviceMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlockDeviceMapping> {
        /**
         * <p>
         * The device name that is exposed to the instance, such as <code>/dev/sdh</code>. For the root device, you can
         * use the explicit device name or you can set this parameter to <code>ROOT_DEVICE</code> and AWS OpsWorks
         * Stacks will provide the correct device name.
         * </p>
         * 
         * @param deviceName
         *        The device name that is exposed to the instance, such as <code>/dev/sdh</code>. For the root device,
         *        you can use the explicit device name or you can set this parameter to <code>ROOT_DEVICE</code> and AWS
         *        OpsWorks Stacks will provide the correct device name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * Suppresses the specified device included in the AMI's block device mapping.
         * </p>
         * 
         * @param noDevice
         *        Suppresses the specified device included in the AMI's block device mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noDevice(String noDevice);

        /**
         * <p>
         * The virtual device name. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html"
         * >BlockDeviceMapping</a>.
         * </p>
         * 
         * @param virtualName
         *        The virtual device name. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html"
         *        >BlockDeviceMapping</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualName(String virtualName);

        /**
         * <p>
         * An <code>EBSBlockDevice</code> that defines how to configure an Amazon EBS volume when the instance is
         * launched.
         * </p>
         * 
         * @param ebs
         *        An <code>EBSBlockDevice</code> that defines how to configure an Amazon EBS volume when the instance is
         *        launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebs(EbsBlockDevice ebs);

        /**
         * <p>
         * An <code>EBSBlockDevice</code> that defines how to configure an Amazon EBS volume when the instance is
         * launched.
         * </p>
         * This is a convenience that creates an instance of the {@link EbsBlockDevice.Builder} avoiding the need to
         * create one manually via {@link EbsBlockDevice#builder()}.
         *
         * When the {@link Consumer} completes, {@link EbsBlockDevice.Builder#build()} is called immediately and its
         * result is passed to {@link #ebs(EbsBlockDevice)}.
         * 
         * @param ebs
         *        a consumer that will call methods on {@link EbsBlockDevice.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebs(EbsBlockDevice)
         */
        default Builder ebs(Consumer<EbsBlockDevice.Builder> ebs) {
            return ebs(EbsBlockDevice.builder().applyMutation(ebs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String deviceName;

        private String noDevice;

        private String virtualName;

        private EbsBlockDevice ebs;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockDeviceMapping model) {
            deviceName(model.deviceName);
            noDevice(model.noDevice);
            virtualName(model.virtualName);
            ebs(model.ebs);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getNoDevice() {
            return noDevice;
        }

        @Override
        public final Builder noDevice(String noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final void setNoDevice(String noDevice) {
            this.noDevice = noDevice;
        }

        public final String getVirtualName() {
            return virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        public final EbsBlockDevice.Builder getEbs() {
            return ebs != null ? ebs.toBuilder() : null;
        }

        @Override
        public final Builder ebs(EbsBlockDevice ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(EbsBlockDevice.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        @Override
        public BlockDeviceMapping build() {
            return new BlockDeviceMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
